/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.Metal3Data;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.Metal3DataBuilder;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.Metal3DataFluent;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.Metal3DataList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class Metal3DataListFluent<A extends Metal3DataListFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String apiVersion;
    private ArrayList<Metal3DataBuilder> items = new ArrayList();
    private String kind;
    private ListMeta metadata;

    public Metal3DataListFluent() {
    }

    public Metal3DataListFluent(Metal3DataList instance) {
        this.copyInstance(instance);
    }

    public A addAllToItems(Collection<Metal3Data> items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (Metal3Data item : items) {
            Metal3DataBuilder builder = new Metal3DataBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    public ItemsNested<A> addNewItem() {
        return new ItemsNested(-1, null);
    }

    public ItemsNested<A> addNewItemLike(Metal3Data item) {
        return new ItemsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToItems(Metal3Data ... items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (Metal3Data item : items) {
            Metal3DataBuilder builder = new Metal3DataBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    public A addToItems(int index, Metal3Data item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        Metal3DataBuilder builder = new Metal3DataBuilder(item);
        if (index < 0 || index >= this.items.size()) {
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        } else {
            this._visitables.get("items").add(builder);
            this.items.add(index, builder);
        }
        return (A)this;
    }

    public Metal3Data buildFirstItem() {
        return this.items.get(0).build();
    }

    public Metal3Data buildItem(int index) {
        return this.items.get(index).build();
    }

    public List<Metal3Data> buildItems() {
        return this.items != null ? Metal3DataListFluent.build(this.items) : null;
    }

    public Metal3Data buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    public Metal3Data buildMatchingItem(Predicate<Metal3DataBuilder> predicate) {
        for (Metal3DataBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    protected void copyInstance(Metal3DataList instance) {
        Metal3DataList metal3DataList = instance = instance != null ? instance : new Metal3DataList();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withItems(instance.getItems());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "items"));
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    public ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "items"));
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    public ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "items"));
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    public ItemsNested<A> editMatchingItem(Predicate<Metal3DataBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "items"));
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Metal3DataListFluent that = (Metal3DataListFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.items, that.items)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getKind() {
        return this.kind;
    }

    public ListMeta getMetadata() {
        return this.metadata;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public boolean hasMatchingItem(Predicate<Metal3DataBuilder> predicate) {
        for (Metal3DataBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.items, this.kind, this.metadata, this.additionalProperties);
    }

    public A removeAllFromItems(Collection<Metal3Data> items) {
        if (this.items == null) {
            return (A)this;
        }
        for (Metal3Data item : items) {
            Metal3DataBuilder builder = new Metal3DataBuilder(item);
            this._visitables.get("items").remove(builder);
            this.items.remove(builder);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public A removeFromItems(Metal3Data ... items) {
        if (this.items == null) {
            return (A)this;
        }
        for (Metal3Data item : items) {
            Metal3DataBuilder builder = new Metal3DataBuilder(item);
            this._visitables.get("items").remove(builder);
            this.items.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromItems(Predicate<Metal3DataBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<Metal3DataBuilder> each = this.items.iterator();
        Object visitables = this._visitables.get("items");
        while (each.hasNext()) {
            Metal3DataBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public ItemsNested<A> setNewItemLike(int index, Metal3Data item) {
        return new ItemsNested(index, item);
    }

    public A setToItems(int index, Metal3Data item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        Metal3DataBuilder builder = new Metal3DataBuilder(item);
        if (index < 0 || index >= this.items.size()) {
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        } else {
            this._visitables.get("items").add(builder);
            this.items.set(index, builder);
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion);
            sb.append(",");
        }
        if (this.items != null && !this.items.isEmpty()) {
            sb.append("items:");
            sb.append(this.items);
            sb.append(",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind);
            sb.append(",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public A withItems(List<Metal3Data> items) {
        if (this.items != null) {
            this._visitables.get("items").clear();
        }
        if (items != null) {
            this.items = new ArrayList();
            for (Metal3Data item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    public A withItems(Metal3Data ... items) {
        if (this.items != null) {
            this.items.clear();
            this._visitables.remove("items");
        }
        if (items != null) {
            for (Metal3Data item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public A withMetadata(ListMeta metadata) {
        this.metadata = metadata;
        return (A)this;
    }

    public A withNewMetadata(String _continue, Long remainingItemCount, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public class ItemsNested<N>
    extends Metal3DataFluent<ItemsNested<N>>
    implements Nested<N> {
        Metal3DataBuilder builder;
        int index;

        ItemsNested(int index, Metal3Data item) {
            this.index = index;
            this.builder = new Metal3DataBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)Metal3DataListFluent.this.setToItems(this.index, this.builder.build());
        }

        public N endItem() {
            return this.and();
        }
    }
}

