/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.helm.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.config.v1.ConfigMapNameReference;
import io.fabric8.openshift.api.model.config.v1.SecretNameReference;
import io.fabric8.openshift.api.model.miscellaneous.helm.v1beta1.ConnectionConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class ConnectionConfigFluent<A extends ConnectionConfigFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ConfigMapNameReference ca;
    private SecretNameReference tlsClientConfig;
    private String url;

    public ConnectionConfigFluent() {
    }

    public ConnectionConfigFluent(ConnectionConfig instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    protected void copyInstance(ConnectionConfig instance) {
        ConnectionConfig connectionConfig = instance = instance != null ? instance : new ConnectionConfig();
        if (instance != null) {
            this.withCa(instance.getCa());
            this.withTlsClientConfig(instance.getTlsClientConfig());
            this.withUrl(instance.getUrl());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConnectionConfigFluent that = (ConnectionConfigFluent)o;
        if (!Objects.equals(this.ca, that.ca)) {
            return false;
        }
        if (!Objects.equals(this.tlsClientConfig, that.tlsClientConfig)) {
            return false;
        }
        if (!Objects.equals(this.url, that.url)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public ConfigMapNameReference getCa() {
        return this.ca;
    }

    public SecretNameReference getTlsClientConfig() {
        return this.tlsClientConfig;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasCa() {
        return this.ca != null;
    }

    public boolean hasTlsClientConfig() {
        return this.tlsClientConfig != null;
    }

    public boolean hasUrl() {
        return this.url != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.ca, this.tlsClientConfig, this.url, this.additionalProperties);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ca != null) {
            sb.append("ca:");
            sb.append(this.ca);
            sb.append(",");
        }
        if (this.tlsClientConfig != null) {
            sb.append("tlsClientConfig:");
            sb.append(this.tlsClientConfig);
            sb.append(",");
        }
        if (this.url != null) {
            sb.append("url:");
            sb.append(this.url);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withCa(ConfigMapNameReference ca) {
        this.ca = ca;
        return (A)this;
    }

    public A withNewCa(String name) {
        return this.withCa(new ConfigMapNameReference(name));
    }

    public A withNewTlsClientConfig(String name) {
        return this.withTlsClientConfig(new SecretNameReference(name));
    }

    public A withTlsClientConfig(SecretNameReference tlsClientConfig) {
        this.tlsClientConfig = tlsClientConfig;
        return (A)this;
    }

    public A withUrl(String url) {
        this.url = url;
        return (A)this;
    }
}

