/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.AccessPolicy;
import io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.AccessPolicyBuilder;
import io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.AccessPolicyFluent;
import io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.IBMCloudPowerVSProviderSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class IBMCloudPowerVSProviderSpecFluent<A extends IBMCloudPowerVSProviderSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String apiVersion;
    private String kind;
    private ArrayList<AccessPolicyBuilder> policies = new ArrayList();

    public IBMCloudPowerVSProviderSpecFluent() {
    }

    public IBMCloudPowerVSProviderSpecFluent(IBMCloudPowerVSProviderSpec instance) {
        this.copyInstance(instance);
    }

    public A addAllToPolicies(Collection<AccessPolicy> items) {
        if (this.policies == null) {
            this.policies = new ArrayList();
        }
        for (AccessPolicy item : items) {
            AccessPolicyBuilder builder = new AccessPolicyBuilder(item);
            this._visitables.get("policies").add(builder);
            this.policies.add(builder);
        }
        return (A)this;
    }

    public PoliciesNested<A> addNewPolicy() {
        return new PoliciesNested(-1, null);
    }

    public PoliciesNested<A> addNewPolicyLike(AccessPolicy item) {
        return new PoliciesNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToPolicies(AccessPolicy ... items) {
        if (this.policies == null) {
            this.policies = new ArrayList();
        }
        for (AccessPolicy item : items) {
            AccessPolicyBuilder builder = new AccessPolicyBuilder(item);
            this._visitables.get("policies").add(builder);
            this.policies.add(builder);
        }
        return (A)this;
    }

    public A addToPolicies(int index, AccessPolicy item) {
        if (this.policies == null) {
            this.policies = new ArrayList();
        }
        AccessPolicyBuilder builder = new AccessPolicyBuilder(item);
        if (index < 0 || index >= this.policies.size()) {
            this._visitables.get("policies").add(builder);
            this.policies.add(builder);
        } else {
            this._visitables.get("policies").add(builder);
            this.policies.add(index, builder);
        }
        return (A)this;
    }

    public AccessPolicy buildFirstPolicy() {
        return this.policies.get(0).build();
    }

    public AccessPolicy buildLastPolicy() {
        return this.policies.get(this.policies.size() - 1).build();
    }

    public AccessPolicy buildMatchingPolicy(Predicate<AccessPolicyBuilder> predicate) {
        for (AccessPolicyBuilder item : this.policies) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public List<AccessPolicy> buildPolicies() {
        return this.policies != null ? IBMCloudPowerVSProviderSpecFluent.build(this.policies) : null;
    }

    public AccessPolicy buildPolicy(int index) {
        return this.policies.get(index).build();
    }

    protected void copyInstance(IBMCloudPowerVSProviderSpec instance) {
        IBMCloudPowerVSProviderSpec iBMCloudPowerVSProviderSpec = instance = instance != null ? instance : new IBMCloudPowerVSProviderSpec();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withPolicies(instance.getPolicies());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public PoliciesNested<A> editFirstPolicy() {
        if (this.policies.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "policies"));
        }
        return this.setNewPolicyLike(0, this.buildPolicy(0));
    }

    public PoliciesNested<A> editLastPolicy() {
        int index = this.policies.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "policies"));
        }
        return this.setNewPolicyLike(index, this.buildPolicy(index));
    }

    public PoliciesNested<A> editMatchingPolicy(Predicate<AccessPolicyBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.policies.size(); ++i) {
            if (!predicate.test(this.policies.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "policies"));
        }
        return this.setNewPolicyLike(index, this.buildPolicy(index));
    }

    public PoliciesNested<A> editPolicy(int index) {
        if (this.policies.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "policies"));
        }
        return this.setNewPolicyLike(index, this.buildPolicy(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IBMCloudPowerVSProviderSpecFluent that = (IBMCloudPowerVSProviderSpecFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.policies, that.policies)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getKind() {
        return this.kind;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public boolean hasMatchingPolicy(Predicate<AccessPolicyBuilder> predicate) {
        for (AccessPolicyBuilder item : this.policies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPolicies() {
        return this.policies != null && !this.policies.isEmpty();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.policies, this.additionalProperties);
    }

    public A removeAllFromPolicies(Collection<AccessPolicy> items) {
        if (this.policies == null) {
            return (A)this;
        }
        for (AccessPolicy item : items) {
            AccessPolicyBuilder builder = new AccessPolicyBuilder(item);
            this._visitables.get("policies").remove(builder);
            this.policies.remove(builder);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public A removeFromPolicies(AccessPolicy ... items) {
        if (this.policies == null) {
            return (A)this;
        }
        for (AccessPolicy item : items) {
            AccessPolicyBuilder builder = new AccessPolicyBuilder(item);
            this._visitables.get("policies").remove(builder);
            this.policies.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromPolicies(Predicate<AccessPolicyBuilder> predicate) {
        if (this.policies == null) {
            return (A)this;
        }
        Iterator<AccessPolicyBuilder> each = this.policies.iterator();
        Object visitables = this._visitables.get("policies");
        while (each.hasNext()) {
            AccessPolicyBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public PoliciesNested<A> setNewPolicyLike(int index, AccessPolicy item) {
        return new PoliciesNested(index, item);
    }

    public A setToPolicies(int index, AccessPolicy item) {
        if (this.policies == null) {
            this.policies = new ArrayList();
        }
        AccessPolicyBuilder builder = new AccessPolicyBuilder(item);
        if (index < 0 || index >= this.policies.size()) {
            this._visitables.get("policies").add(builder);
            this.policies.add(builder);
        } else {
            this._visitables.get("policies").add(builder);
            this.policies.set(index, builder);
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion);
            sb.append(",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind);
            sb.append(",");
        }
        if (this.policies != null && !this.policies.isEmpty()) {
            sb.append("policies:");
            sb.append(this.policies);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public A withPolicies(List<AccessPolicy> policies) {
        if (this.policies != null) {
            this._visitables.get("policies").clear();
        }
        if (policies != null) {
            this.policies = new ArrayList();
            for (AccessPolicy item : policies) {
                this.addToPolicies(item);
            }
        } else {
            this.policies = null;
        }
        return (A)this;
    }

    public A withPolicies(AccessPolicy ... policies) {
        if (this.policies != null) {
            this.policies.clear();
            this._visitables.remove("policies");
        }
        if (policies != null) {
            for (AccessPolicy item : policies) {
                this.addToPolicies(item);
            }
        }
        return (A)this;
    }

    public class PoliciesNested<N>
    extends AccessPolicyFluent<PoliciesNested<N>>
    implements Nested<N> {
        AccessPolicyBuilder builder;
        int index;

        PoliciesNested(int index, AccessPolicy item) {
            this.index = index;
            this.builder = new AccessPolicyBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)IBMCloudPowerVSProviderSpecFluent.this.setToPolicies(this.index, this.builder.build());
        }

        public N endPolicy() {
            return this.and();
        }
    }
}

