/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machineconfiguration.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.PinnedImageRef;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.PinnedImageRefBuilder;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.PinnedImageRefFluent;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.PinnedImageSetSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class PinnedImageSetSpecFluent<A extends PinnedImageSetSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ArrayList<PinnedImageRefBuilder> pinnedImages = new ArrayList();

    public PinnedImageSetSpecFluent() {
    }

    public PinnedImageSetSpecFluent(PinnedImageSetSpec instance) {
        this.copyInstance(instance);
    }

    public A addAllToPinnedImages(Collection<PinnedImageRef> items) {
        if (this.pinnedImages == null) {
            this.pinnedImages = new ArrayList();
        }
        for (PinnedImageRef item : items) {
            PinnedImageRefBuilder builder = new PinnedImageRefBuilder(item);
            this._visitables.get("pinnedImages").add(builder);
            this.pinnedImages.add(builder);
        }
        return (A)this;
    }

    public PinnedImagesNested<A> addNewPinnedImage() {
        return new PinnedImagesNested(-1, null);
    }

    public A addNewPinnedImage(String name) {
        return this.addToPinnedImages(new PinnedImageRef(name));
    }

    public PinnedImagesNested<A> addNewPinnedImageLike(PinnedImageRef item) {
        return new PinnedImagesNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToPinnedImages(PinnedImageRef ... items) {
        if (this.pinnedImages == null) {
            this.pinnedImages = new ArrayList();
        }
        for (PinnedImageRef item : items) {
            PinnedImageRefBuilder builder = new PinnedImageRefBuilder(item);
            this._visitables.get("pinnedImages").add(builder);
            this.pinnedImages.add(builder);
        }
        return (A)this;
    }

    public A addToPinnedImages(int index, PinnedImageRef item) {
        if (this.pinnedImages == null) {
            this.pinnedImages = new ArrayList();
        }
        PinnedImageRefBuilder builder = new PinnedImageRefBuilder(item);
        if (index < 0 || index >= this.pinnedImages.size()) {
            this._visitables.get("pinnedImages").add(builder);
            this.pinnedImages.add(builder);
        } else {
            this._visitables.get("pinnedImages").add(builder);
            this.pinnedImages.add(index, builder);
        }
        return (A)this;
    }

    public PinnedImageRef buildFirstPinnedImage() {
        return this.pinnedImages.get(0).build();
    }

    public PinnedImageRef buildLastPinnedImage() {
        return this.pinnedImages.get(this.pinnedImages.size() - 1).build();
    }

    public PinnedImageRef buildMatchingPinnedImage(Predicate<PinnedImageRefBuilder> predicate) {
        for (PinnedImageRefBuilder item : this.pinnedImages) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public PinnedImageRef buildPinnedImage(int index) {
        return this.pinnedImages.get(index).build();
    }

    public List<PinnedImageRef> buildPinnedImages() {
        return this.pinnedImages != null ? PinnedImageSetSpecFluent.build(this.pinnedImages) : null;
    }

    protected void copyInstance(PinnedImageSetSpec instance) {
        PinnedImageSetSpec pinnedImageSetSpec = instance = instance != null ? instance : new PinnedImageSetSpec();
        if (instance != null) {
            this.withPinnedImages(instance.getPinnedImages());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public PinnedImagesNested<A> editFirstPinnedImage() {
        if (this.pinnedImages.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "pinnedImages"));
        }
        return this.setNewPinnedImageLike(0, this.buildPinnedImage(0));
    }

    public PinnedImagesNested<A> editLastPinnedImage() {
        int index = this.pinnedImages.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "pinnedImages"));
        }
        return this.setNewPinnedImageLike(index, this.buildPinnedImage(index));
    }

    public PinnedImagesNested<A> editMatchingPinnedImage(Predicate<PinnedImageRefBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.pinnedImages.size(); ++i) {
            if (!predicate.test(this.pinnedImages.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "pinnedImages"));
        }
        return this.setNewPinnedImageLike(index, this.buildPinnedImage(index));
    }

    public PinnedImagesNested<A> editPinnedImage(int index) {
        if (this.pinnedImages.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "pinnedImages"));
        }
        return this.setNewPinnedImageLike(index, this.buildPinnedImage(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PinnedImageSetSpecFluent that = (PinnedImageSetSpecFluent)o;
        if (!Objects.equals(this.pinnedImages, that.pinnedImages)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasMatchingPinnedImage(Predicate<PinnedImageRefBuilder> predicate) {
        for (PinnedImageRefBuilder item : this.pinnedImages) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPinnedImages() {
        return this.pinnedImages != null && !this.pinnedImages.isEmpty();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.pinnedImages, this.additionalProperties);
    }

    public A removeAllFromPinnedImages(Collection<PinnedImageRef> items) {
        if (this.pinnedImages == null) {
            return (A)this;
        }
        for (PinnedImageRef item : items) {
            PinnedImageRefBuilder builder = new PinnedImageRefBuilder(item);
            this._visitables.get("pinnedImages").remove(builder);
            this.pinnedImages.remove(builder);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public A removeFromPinnedImages(PinnedImageRef ... items) {
        if (this.pinnedImages == null) {
            return (A)this;
        }
        for (PinnedImageRef item : items) {
            PinnedImageRefBuilder builder = new PinnedImageRefBuilder(item);
            this._visitables.get("pinnedImages").remove(builder);
            this.pinnedImages.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromPinnedImages(Predicate<PinnedImageRefBuilder> predicate) {
        if (this.pinnedImages == null) {
            return (A)this;
        }
        Iterator<PinnedImageRefBuilder> each = this.pinnedImages.iterator();
        Object visitables = this._visitables.get("pinnedImages");
        while (each.hasNext()) {
            PinnedImageRefBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public PinnedImagesNested<A> setNewPinnedImageLike(int index, PinnedImageRef item) {
        return new PinnedImagesNested(index, item);
    }

    public A setToPinnedImages(int index, PinnedImageRef item) {
        if (this.pinnedImages == null) {
            this.pinnedImages = new ArrayList();
        }
        PinnedImageRefBuilder builder = new PinnedImageRefBuilder(item);
        if (index < 0 || index >= this.pinnedImages.size()) {
            this._visitables.get("pinnedImages").add(builder);
            this.pinnedImages.add(builder);
        } else {
            this._visitables.get("pinnedImages").add(builder);
            this.pinnedImages.set(index, builder);
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.pinnedImages != null && !this.pinnedImages.isEmpty()) {
            sb.append("pinnedImages:");
            sb.append(this.pinnedImages);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withPinnedImages(List<PinnedImageRef> pinnedImages) {
        if (this.pinnedImages != null) {
            this._visitables.get("pinnedImages").clear();
        }
        if (pinnedImages != null) {
            this.pinnedImages = new ArrayList();
            for (PinnedImageRef item : pinnedImages) {
                this.addToPinnedImages(item);
            }
        } else {
            this.pinnedImages = null;
        }
        return (A)this;
    }

    public A withPinnedImages(PinnedImageRef ... pinnedImages) {
        if (this.pinnedImages != null) {
            this.pinnedImages.clear();
            this._visitables.remove("pinnedImages");
        }
        if (pinnedImages != null) {
            for (PinnedImageRef item : pinnedImages) {
                this.addToPinnedImages(item);
            }
        }
        return (A)this;
    }

    public class PinnedImagesNested<N>
    extends PinnedImageRefFluent<PinnedImagesNested<N>>
    implements Nested<N> {
        PinnedImageRefBuilder builder;
        int index;

        PinnedImagesNested(int index, PinnedImageRef item) {
            this.index = index;
            this.builder = new PinnedImageRefBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PinnedImageSetSpecFluent.this.setToPinnedImages(this.index, this.builder.build());
        }

        public N endPinnedImage() {
            return this.and();
        }
    }
}

