/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machineconfiguration.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.MachineConfigNodeStatus;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.MachineConfigNodeStatusMachineConfigVersion;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.MachineConfigNodeStatusMachineConfigVersionBuilder;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.MachineConfigNodeStatusMachineConfigVersionFluent;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.MachineConfigNodeStatusPinnedImageSet;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.MachineConfigNodeStatusPinnedImageSetBuilder;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.MachineConfigNodeStatusPinnedImageSetFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class MachineConfigNodeStatusFluent<A extends MachineConfigNodeStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private List<Condition> conditions = new ArrayList<Condition>();
    private MachineConfigNodeStatusMachineConfigVersionBuilder configVersion;
    private Long observedGeneration;
    private ArrayList<MachineConfigNodeStatusPinnedImageSetBuilder> pinnedImageSets = new ArrayList();

    public MachineConfigNodeStatusFluent() {
    }

    public MachineConfigNodeStatusFluent(MachineConfigNodeStatus instance) {
        this.copyInstance(instance);
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    public A addAllToPinnedImageSets(Collection<MachineConfigNodeStatusPinnedImageSet> items) {
        if (this.pinnedImageSets == null) {
            this.pinnedImageSets = new ArrayList();
        }
        for (MachineConfigNodeStatusPinnedImageSet item : items) {
            MachineConfigNodeStatusPinnedImageSetBuilder builder = new MachineConfigNodeStatusPinnedImageSetBuilder(item);
            this._visitables.get("pinnedImageSets").add(builder);
            this.pinnedImageSets.add(builder);
        }
        return (A)this;
    }

    public PinnedImageSetsNested<A> addNewPinnedImageSet() {
        return new PinnedImageSetsNested(-1, null);
    }

    public A addNewPinnedImageSet(Integer currentGeneration, Integer desiredGeneration, Integer lastFailedGeneration, String lastFailedGenerationError, String name) {
        return this.addToPinnedImageSets(new MachineConfigNodeStatusPinnedImageSet(currentGeneration, desiredGeneration, lastFailedGeneration, lastFailedGenerationError, name));
    }

    public PinnedImageSetsNested<A> addNewPinnedImageSetLike(MachineConfigNodeStatusPinnedImageSet item) {
        return new PinnedImageSetsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)this;
    }

    public A addToPinnedImageSets(MachineConfigNodeStatusPinnedImageSet ... items) {
        if (this.pinnedImageSets == null) {
            this.pinnedImageSets = new ArrayList();
        }
        for (MachineConfigNodeStatusPinnedImageSet item : items) {
            MachineConfigNodeStatusPinnedImageSetBuilder builder = new MachineConfigNodeStatusPinnedImageSetBuilder(item);
            this._visitables.get("pinnedImageSets").add(builder);
            this.pinnedImageSets.add(builder);
        }
        return (A)this;
    }

    public A addToPinnedImageSets(int index, MachineConfigNodeStatusPinnedImageSet item) {
        if (this.pinnedImageSets == null) {
            this.pinnedImageSets = new ArrayList();
        }
        MachineConfigNodeStatusPinnedImageSetBuilder builder = new MachineConfigNodeStatusPinnedImageSetBuilder(item);
        if (index < 0 || index >= this.pinnedImageSets.size()) {
            this._visitables.get("pinnedImageSets").add(builder);
            this.pinnedImageSets.add(builder);
        } else {
            this._visitables.get("pinnedImageSets").add(builder);
            this.pinnedImageSets.add(index, builder);
        }
        return (A)this;
    }

    public MachineConfigNodeStatusMachineConfigVersion buildConfigVersion() {
        return this.configVersion != null ? this.configVersion.build() : null;
    }

    public MachineConfigNodeStatusPinnedImageSet buildFirstPinnedImageSet() {
        return this.pinnedImageSets.get(0).build();
    }

    public MachineConfigNodeStatusPinnedImageSet buildLastPinnedImageSet() {
        return this.pinnedImageSets.get(this.pinnedImageSets.size() - 1).build();
    }

    public MachineConfigNodeStatusPinnedImageSet buildMatchingPinnedImageSet(Predicate<MachineConfigNodeStatusPinnedImageSetBuilder> predicate) {
        for (MachineConfigNodeStatusPinnedImageSetBuilder item : this.pinnedImageSets) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public MachineConfigNodeStatusPinnedImageSet buildPinnedImageSet(int index) {
        return this.pinnedImageSets.get(index).build();
    }

    public List<MachineConfigNodeStatusPinnedImageSet> buildPinnedImageSets() {
        return this.pinnedImageSets != null ? MachineConfigNodeStatusFluent.build(this.pinnedImageSets) : null;
    }

    protected void copyInstance(MachineConfigNodeStatus instance) {
        MachineConfigNodeStatus machineConfigNodeStatus = instance = instance != null ? instance : new MachineConfigNodeStatus();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withConfigVersion(instance.getConfigVersion());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withPinnedImageSets(instance.getPinnedImageSets());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ConfigVersionNested<A> editConfigVersion() {
        return this.withNewConfigVersionLike(Optional.ofNullable(this.buildConfigVersion()).orElse(null));
    }

    public PinnedImageSetsNested<A> editFirstPinnedImageSet() {
        if (this.pinnedImageSets.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "pinnedImageSets"));
        }
        return this.setNewPinnedImageSetLike(0, this.buildPinnedImageSet(0));
    }

    public PinnedImageSetsNested<A> editLastPinnedImageSet() {
        int index = this.pinnedImageSets.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "pinnedImageSets"));
        }
        return this.setNewPinnedImageSetLike(index, this.buildPinnedImageSet(index));
    }

    public PinnedImageSetsNested<A> editMatchingPinnedImageSet(Predicate<MachineConfigNodeStatusPinnedImageSetBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.pinnedImageSets.size(); ++i) {
            if (!predicate.test(this.pinnedImageSets.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "pinnedImageSets"));
        }
        return this.setNewPinnedImageSetLike(index, this.buildPinnedImageSet(index));
    }

    public ConfigVersionNested<A> editOrNewConfigVersion() {
        return this.withNewConfigVersionLike(Optional.ofNullable(this.buildConfigVersion()).orElse(new MachineConfigNodeStatusMachineConfigVersionBuilder().build()));
    }

    public ConfigVersionNested<A> editOrNewConfigVersionLike(MachineConfigNodeStatusMachineConfigVersion item) {
        return this.withNewConfigVersionLike(Optional.ofNullable(this.buildConfigVersion()).orElse(item));
    }

    public PinnedImageSetsNested<A> editPinnedImageSet(int index) {
        if (this.pinnedImageSets.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "pinnedImageSets"));
        }
        return this.setNewPinnedImageSetLike(index, this.buildPinnedImageSet(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachineConfigNodeStatusFluent that = (MachineConfigNodeStatusFluent)o;
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.configVersion, that.configVersion)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        if (!Objects.equals(this.pinnedImageSets, that.pinnedImageSets)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Condition getCondition(int index) {
        return this.conditions.get(index);
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public boolean hasConfigVersion() {
        return this.configVersion != null;
    }

    public boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingPinnedImageSet(Predicate<MachineConfigNodeStatusPinnedImageSetBuilder> predicate) {
        for (MachineConfigNodeStatusPinnedImageSetBuilder item : this.pinnedImageSets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public boolean hasPinnedImageSets() {
        return this.pinnedImageSets != null && !this.pinnedImageSets.isEmpty();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.conditions, this.configVersion, this.observedGeneration, this.pinnedImageSets, this.additionalProperties);
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromPinnedImageSets(Collection<MachineConfigNodeStatusPinnedImageSet> items) {
        if (this.pinnedImageSets == null) {
            return (A)this;
        }
        for (MachineConfigNodeStatusPinnedImageSet item : items) {
            MachineConfigNodeStatusPinnedImageSetBuilder builder = new MachineConfigNodeStatusPinnedImageSetBuilder(item);
            this._visitables.get("pinnedImageSets").remove(builder);
            this.pinnedImageSets.remove(builder);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)this;
    }

    public A removeFromPinnedImageSets(MachineConfigNodeStatusPinnedImageSet ... items) {
        if (this.pinnedImageSets == null) {
            return (A)this;
        }
        for (MachineConfigNodeStatusPinnedImageSet item : items) {
            MachineConfigNodeStatusPinnedImageSetBuilder builder = new MachineConfigNodeStatusPinnedImageSetBuilder(item);
            this._visitables.get("pinnedImageSets").remove(builder);
            this.pinnedImageSets.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromPinnedImageSets(Predicate<MachineConfigNodeStatusPinnedImageSetBuilder> predicate) {
        if (this.pinnedImageSets == null) {
            return (A)this;
        }
        Iterator<MachineConfigNodeStatusPinnedImageSetBuilder> each = this.pinnedImageSets.iterator();
        Object visitables = this._visitables.get("pinnedImageSets");
        while (each.hasNext()) {
            MachineConfigNodeStatusPinnedImageSetBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public PinnedImageSetsNested<A> setNewPinnedImageSetLike(int index, MachineConfigNodeStatusPinnedImageSet item) {
        return new PinnedImageSetsNested(index, item);
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)this;
    }

    public A setToPinnedImageSets(int index, MachineConfigNodeStatusPinnedImageSet item) {
        if (this.pinnedImageSets == null) {
            this.pinnedImageSets = new ArrayList();
        }
        MachineConfigNodeStatusPinnedImageSetBuilder builder = new MachineConfigNodeStatusPinnedImageSetBuilder(item);
        if (index < 0 || index >= this.pinnedImageSets.size()) {
            this._visitables.get("pinnedImageSets").add(builder);
            this.pinnedImageSets.add(builder);
        } else {
            this._visitables.get("pinnedImageSets").add(builder);
            this.pinnedImageSets.set(index, builder);
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions);
            sb.append(",");
        }
        if (this.configVersion != null) {
            sb.append("configVersion:");
            sb.append(this.configVersion);
            sb.append(",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration);
            sb.append(",");
        }
        if (this.pinnedImageSets != null && !this.pinnedImageSets.isEmpty()) {
            sb.append("pinnedImageSets:");
            sb.append(this.pinnedImageSets);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public A withConfigVersion(MachineConfigNodeStatusMachineConfigVersion configVersion) {
        this._visitables.remove("configVersion");
        if (configVersion != null) {
            this.configVersion = new MachineConfigNodeStatusMachineConfigVersionBuilder(configVersion);
            this._visitables.get("configVersion").add(this.configVersion);
        } else {
            this.configVersion = null;
            this._visitables.get("configVersion").remove(this.configVersion);
        }
        return (A)this;
    }

    public ConfigVersionNested<A> withNewConfigVersion() {
        return new ConfigVersionNested(null);
    }

    public A withNewConfigVersion(String current, String desired) {
        return this.withConfigVersion(new MachineConfigNodeStatusMachineConfigVersion(current, desired));
    }

    public ConfigVersionNested<A> withNewConfigVersionLike(MachineConfigNodeStatusMachineConfigVersion item) {
        return new ConfigVersionNested(item);
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    public A withPinnedImageSets(List<MachineConfigNodeStatusPinnedImageSet> pinnedImageSets) {
        if (this.pinnedImageSets != null) {
            this._visitables.get("pinnedImageSets").clear();
        }
        if (pinnedImageSets != null) {
            this.pinnedImageSets = new ArrayList();
            for (MachineConfigNodeStatusPinnedImageSet item : pinnedImageSets) {
                this.addToPinnedImageSets(item);
            }
        } else {
            this.pinnedImageSets = null;
        }
        return (A)this;
    }

    public A withPinnedImageSets(MachineConfigNodeStatusPinnedImageSet ... pinnedImageSets) {
        if (this.pinnedImageSets != null) {
            this.pinnedImageSets.clear();
            this._visitables.remove("pinnedImageSets");
        }
        if (pinnedImageSets != null) {
            for (MachineConfigNodeStatusPinnedImageSet item : pinnedImageSets) {
                this.addToPinnedImageSets(item);
            }
        }
        return (A)this;
    }

    public class PinnedImageSetsNested<N>
    extends MachineConfigNodeStatusPinnedImageSetFluent<PinnedImageSetsNested<N>>
    implements Nested<N> {
        MachineConfigNodeStatusPinnedImageSetBuilder builder;
        int index;

        PinnedImageSetsNested(int index, MachineConfigNodeStatusPinnedImageSet item) {
            this.index = index;
            this.builder = new MachineConfigNodeStatusPinnedImageSetBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)MachineConfigNodeStatusFluent.this.setToPinnedImageSets(this.index, this.builder.build());
        }

        public N endPinnedImageSet() {
            return this.and();
        }
    }

    public class ConfigVersionNested<N>
    extends MachineConfigNodeStatusMachineConfigVersionFluent<ConfigVersionNested<N>>
    implements Nested<N> {
        MachineConfigNodeStatusMachineConfigVersionBuilder builder;

        ConfigVersionNested(MachineConfigNodeStatusMachineConfigVersion item) {
            this.builder = new MachineConfigNodeStatusMachineConfigVersionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)MachineConfigNodeStatusFluent.this.withConfigVersion(this.builder.build());
        }

        public N endConfigVersion() {
            return this.and();
        }
    }
}

