/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machineconfiguration.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.openshift.api.model.machineconfiguration.v1.MachineOSBuildStatus;
import io.fabric8.openshift.api.model.machineconfiguration.v1.MachineOSBuilderReference;
import io.fabric8.openshift.api.model.machineconfiguration.v1.MachineOSBuilderReferenceBuilder;
import io.fabric8.openshift.api.model.machineconfiguration.v1.MachineOSBuilderReferenceFluent;
import io.fabric8.openshift.api.model.machineconfiguration.v1.ObjectReference;
import io.fabric8.openshift.api.model.machineconfiguration.v1.ObjectReferenceBuilder;
import io.fabric8.openshift.api.model.machineconfiguration.v1.ObjectReferenceFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class MachineOSBuildStatusFluent<A extends MachineOSBuildStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String buildEnd;
    private String buildStart;
    private MachineOSBuilderReferenceBuilder builder;
    private List<Condition> conditions = new ArrayList<Condition>();
    private String digestedImagePushSpec;
    private ArrayList<ObjectReferenceBuilder> relatedObjects = new ArrayList();

    public MachineOSBuildStatusFluent() {
    }

    public MachineOSBuildStatusFluent(MachineOSBuildStatus instance) {
        this.copyInstance(instance);
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    public A addAllToRelatedObjects(Collection<ObjectReference> items) {
        if (this.relatedObjects == null) {
            this.relatedObjects = new ArrayList();
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get("relatedObjects").add(builder);
            this.relatedObjects.add(builder);
        }
        return (A)this;
    }

    public RelatedObjectsNested<A> addNewRelatedObject() {
        return new RelatedObjectsNested(-1, null);
    }

    public A addNewRelatedObject(String group, String name, String namespace, String resource) {
        return this.addToRelatedObjects(new ObjectReference(group, name, namespace, resource));
    }

    public RelatedObjectsNested<A> addNewRelatedObjectLike(ObjectReference item) {
        return new RelatedObjectsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)this;
    }

    public A addToRelatedObjects(ObjectReference ... items) {
        if (this.relatedObjects == null) {
            this.relatedObjects = new ArrayList();
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get("relatedObjects").add(builder);
            this.relatedObjects.add(builder);
        }
        return (A)this;
    }

    public A addToRelatedObjects(int index, ObjectReference item) {
        if (this.relatedObjects == null) {
            this.relatedObjects = new ArrayList();
        }
        ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
        if (index < 0 || index >= this.relatedObjects.size()) {
            this._visitables.get("relatedObjects").add(builder);
            this.relatedObjects.add(builder);
        } else {
            this._visitables.get("relatedObjects").add(builder);
            this.relatedObjects.add(index, builder);
        }
        return (A)this;
    }

    public MachineOSBuilderReference buildBuilder() {
        return this.builder != null ? this.builder.build() : null;
    }

    public ObjectReference buildFirstRelatedObject() {
        return this.relatedObjects.get(0).build();
    }

    public ObjectReference buildLastRelatedObject() {
        return this.relatedObjects.get(this.relatedObjects.size() - 1).build();
    }

    public ObjectReference buildMatchingRelatedObject(Predicate<ObjectReferenceBuilder> predicate) {
        for (ObjectReferenceBuilder item : this.relatedObjects) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public ObjectReference buildRelatedObject(int index) {
        return this.relatedObjects.get(index).build();
    }

    public List<ObjectReference> buildRelatedObjects() {
        return this.relatedObjects != null ? MachineOSBuildStatusFluent.build(this.relatedObjects) : null;
    }

    protected void copyInstance(MachineOSBuildStatus instance) {
        MachineOSBuildStatus machineOSBuildStatus = instance = instance != null ? instance : new MachineOSBuildStatus();
        if (instance != null) {
            this.withBuildEnd(instance.getBuildEnd());
            this.withBuildStart(instance.getBuildStart());
            this.withBuilder(instance.getBuilder());
            this.withConditions(instance.getConditions());
            this.withDigestedImagePushSpec(instance.getDigestedImagePushSpec());
            this.withRelatedObjects(instance.getRelatedObjects());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public BuilderNested<A> editBuilder() {
        return this.withNewBuilderLike(Optional.ofNullable(this.buildBuilder()).orElse(null));
    }

    public RelatedObjectsNested<A> editFirstRelatedObject() {
        if (this.relatedObjects.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "relatedObjects"));
        }
        return this.setNewRelatedObjectLike(0, this.buildRelatedObject(0));
    }

    public RelatedObjectsNested<A> editLastRelatedObject() {
        int index = this.relatedObjects.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "relatedObjects"));
        }
        return this.setNewRelatedObjectLike(index, this.buildRelatedObject(index));
    }

    public RelatedObjectsNested<A> editMatchingRelatedObject(Predicate<ObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.relatedObjects.size(); ++i) {
            if (!predicate.test(this.relatedObjects.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "relatedObjects"));
        }
        return this.setNewRelatedObjectLike(index, this.buildRelatedObject(index));
    }

    public BuilderNested<A> editOrNewBuilder() {
        return this.withNewBuilderLike(Optional.ofNullable(this.buildBuilder()).orElse(new MachineOSBuilderReferenceBuilder().build()));
    }

    public BuilderNested<A> editOrNewBuilderLike(MachineOSBuilderReference item) {
        return this.withNewBuilderLike(Optional.ofNullable(this.buildBuilder()).orElse(item));
    }

    public RelatedObjectsNested<A> editRelatedObject(int index) {
        if (this.relatedObjects.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "relatedObjects"));
        }
        return this.setNewRelatedObjectLike(index, this.buildRelatedObject(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachineOSBuildStatusFluent that = (MachineOSBuildStatusFluent)o;
        if (!Objects.equals(this.buildEnd, that.buildEnd)) {
            return false;
        }
        if (!Objects.equals(this.buildStart, that.buildStart)) {
            return false;
        }
        if (!Objects.equals(this.builder, that.builder)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.digestedImagePushSpec, that.digestedImagePushSpec)) {
            return false;
        }
        if (!Objects.equals(this.relatedObjects, that.relatedObjects)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getBuildEnd() {
        return this.buildEnd;
    }

    public String getBuildStart() {
        return this.buildStart;
    }

    public Condition getCondition(int index) {
        return this.conditions.get(index);
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public String getDigestedImagePushSpec() {
        return this.digestedImagePushSpec;
    }

    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasBuildEnd() {
        return this.buildEnd != null;
    }

    public boolean hasBuildStart() {
        return this.buildStart != null;
    }

    public boolean hasBuilder() {
        return this.builder != null;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public boolean hasDigestedImagePushSpec() {
        return this.digestedImagePushSpec != null;
    }

    public boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingRelatedObject(Predicate<ObjectReferenceBuilder> predicate) {
        for (ObjectReferenceBuilder item : this.relatedObjects) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRelatedObjects() {
        return this.relatedObjects != null && !this.relatedObjects.isEmpty();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.buildEnd, this.buildStart, this.builder, this.conditions, this.digestedImagePushSpec, this.relatedObjects, this.additionalProperties);
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromRelatedObjects(Collection<ObjectReference> items) {
        if (this.relatedObjects == null) {
            return (A)this;
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get("relatedObjects").remove(builder);
            this.relatedObjects.remove(builder);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)this;
    }

    public A removeFromRelatedObjects(ObjectReference ... items) {
        if (this.relatedObjects == null) {
            return (A)this;
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get("relatedObjects").remove(builder);
            this.relatedObjects.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromRelatedObjects(Predicate<ObjectReferenceBuilder> predicate) {
        if (this.relatedObjects == null) {
            return (A)this;
        }
        Iterator<ObjectReferenceBuilder> each = this.relatedObjects.iterator();
        Object visitables = this._visitables.get("relatedObjects");
        while (each.hasNext()) {
            ObjectReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public RelatedObjectsNested<A> setNewRelatedObjectLike(int index, ObjectReference item) {
        return new RelatedObjectsNested(index, item);
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)this;
    }

    public A setToRelatedObjects(int index, ObjectReference item) {
        if (this.relatedObjects == null) {
            this.relatedObjects = new ArrayList();
        }
        ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
        if (index < 0 || index >= this.relatedObjects.size()) {
            this._visitables.get("relatedObjects").add(builder);
            this.relatedObjects.add(builder);
        } else {
            this._visitables.get("relatedObjects").add(builder);
            this.relatedObjects.set(index, builder);
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.buildEnd != null) {
            sb.append("buildEnd:");
            sb.append(this.buildEnd);
            sb.append(",");
        }
        if (this.buildStart != null) {
            sb.append("buildStart:");
            sb.append(this.buildStart);
            sb.append(",");
        }
        if (this.builder != null) {
            sb.append("builder:");
            sb.append(this.builder);
            sb.append(",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions);
            sb.append(",");
        }
        if (this.digestedImagePushSpec != null) {
            sb.append("digestedImagePushSpec:");
            sb.append(this.digestedImagePushSpec);
            sb.append(",");
        }
        if (this.relatedObjects != null && !this.relatedObjects.isEmpty()) {
            sb.append("relatedObjects:");
            sb.append(this.relatedObjects);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withBuildEnd(String buildEnd) {
        this.buildEnd = buildEnd;
        return (A)this;
    }

    public A withBuildStart(String buildStart) {
        this.buildStart = buildStart;
        return (A)this;
    }

    public A withBuilder(MachineOSBuilderReference builder) {
        this._visitables.remove("builder");
        if (builder != null) {
            this.builder = new MachineOSBuilderReferenceBuilder(builder);
            this._visitables.get("builder").add(this.builder);
        } else {
            this.builder = null;
            this._visitables.get("builder").remove(this.builder);
        }
        return (A)this;
    }

    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public A withDigestedImagePushSpec(String digestedImagePushSpec) {
        this.digestedImagePushSpec = digestedImagePushSpec;
        return (A)this;
    }

    public BuilderNested<A> withNewBuilder() {
        return new BuilderNested(null);
    }

    public BuilderNested<A> withNewBuilderLike(MachineOSBuilderReference item) {
        return new BuilderNested(item);
    }

    public A withRelatedObjects(List<ObjectReference> relatedObjects) {
        if (this.relatedObjects != null) {
            this._visitables.get("relatedObjects").clear();
        }
        if (relatedObjects != null) {
            this.relatedObjects = new ArrayList();
            for (ObjectReference item : relatedObjects) {
                this.addToRelatedObjects(item);
            }
        } else {
            this.relatedObjects = null;
        }
        return (A)this;
    }

    public A withRelatedObjects(ObjectReference ... relatedObjects) {
        if (this.relatedObjects != null) {
            this.relatedObjects.clear();
            this._visitables.remove("relatedObjects");
        }
        if (relatedObjects != null) {
            for (ObjectReference item : relatedObjects) {
                this.addToRelatedObjects(item);
            }
        }
        return (A)this;
    }

    public class RelatedObjectsNested<N>
    extends ObjectReferenceFluent<RelatedObjectsNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;
        int index;

        RelatedObjectsNested(int index, ObjectReference item) {
            this.index = index;
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)MachineOSBuildStatusFluent.this.setToRelatedObjects(this.index, this.builder.build());
        }

        public N endRelatedObject() {
            return this.and();
        }
    }

    public class BuilderNested<N>
    extends MachineOSBuilderReferenceFluent<BuilderNested<N>>
    implements Nested<N> {
        MachineOSBuilderReferenceBuilder builder;

        BuilderNested(MachineOSBuilderReference item) {
            this.builder = new MachineOSBuilderReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)MachineOSBuildStatusFluent.this.withBuilder(this.builder.build());
        }

        public N endBuilder() {
            return this.and();
        }
    }
}

