/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.machine.v1beta1.DiskSettings;
import io.fabric8.openshift.api.model.machine.v1beta1.DiskSettingsBuilder;
import io.fabric8.openshift.api.model.machine.v1beta1.DiskSettingsFluent;
import io.fabric8.openshift.api.model.machine.v1beta1.OSDisk;
import io.fabric8.openshift.api.model.machine.v1beta1.OSDiskManagedDiskParameters;
import io.fabric8.openshift.api.model.machine.v1beta1.OSDiskManagedDiskParametersBuilder;
import io.fabric8.openshift.api.model.machine.v1beta1.OSDiskManagedDiskParametersFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class OSDiskFluent<A extends OSDiskFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String cachingType;
    private DiskSettingsBuilder diskSettings;
    private Integer diskSizeGB;
    private OSDiskManagedDiskParametersBuilder managedDisk;
    private String osType;

    public OSDiskFluent() {
    }

    public OSDiskFluent(OSDisk instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public DiskSettings buildDiskSettings() {
        return this.diskSettings != null ? this.diskSettings.build() : null;
    }

    public OSDiskManagedDiskParameters buildManagedDisk() {
        return this.managedDisk != null ? this.managedDisk.build() : null;
    }

    protected void copyInstance(OSDisk instance) {
        OSDisk oSDisk = instance = instance != null ? instance : new OSDisk();
        if (instance != null) {
            this.withCachingType(instance.getCachingType());
            this.withDiskSettings(instance.getDiskSettings());
            this.withDiskSizeGB(instance.getDiskSizeGB());
            this.withManagedDisk(instance.getManagedDisk());
            this.withOsType(instance.getOsType());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public DiskSettingsNested<A> editDiskSettings() {
        return this.withNewDiskSettingsLike(Optional.ofNullable(this.buildDiskSettings()).orElse(null));
    }

    public ManagedDiskNested<A> editManagedDisk() {
        return this.withNewManagedDiskLike(Optional.ofNullable(this.buildManagedDisk()).orElse(null));
    }

    public DiskSettingsNested<A> editOrNewDiskSettings() {
        return this.withNewDiskSettingsLike(Optional.ofNullable(this.buildDiskSettings()).orElse(new DiskSettingsBuilder().build()));
    }

    public DiskSettingsNested<A> editOrNewDiskSettingsLike(DiskSettings item) {
        return this.withNewDiskSettingsLike(Optional.ofNullable(this.buildDiskSettings()).orElse(item));
    }

    public ManagedDiskNested<A> editOrNewManagedDisk() {
        return this.withNewManagedDiskLike(Optional.ofNullable(this.buildManagedDisk()).orElse(new OSDiskManagedDiskParametersBuilder().build()));
    }

    public ManagedDiskNested<A> editOrNewManagedDiskLike(OSDiskManagedDiskParameters item) {
        return this.withNewManagedDiskLike(Optional.ofNullable(this.buildManagedDisk()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OSDiskFluent that = (OSDiskFluent)o;
        if (!Objects.equals(this.cachingType, that.cachingType)) {
            return false;
        }
        if (!Objects.equals(this.diskSettings, that.diskSettings)) {
            return false;
        }
        if (!Objects.equals(this.diskSizeGB, that.diskSizeGB)) {
            return false;
        }
        if (!Objects.equals(this.managedDisk, that.managedDisk)) {
            return false;
        }
        if (!Objects.equals(this.osType, that.osType)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getCachingType() {
        return this.cachingType;
    }

    public Integer getDiskSizeGB() {
        return this.diskSizeGB;
    }

    public String getOsType() {
        return this.osType;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasCachingType() {
        return this.cachingType != null;
    }

    public boolean hasDiskSettings() {
        return this.diskSettings != null;
    }

    public boolean hasDiskSizeGB() {
        return this.diskSizeGB != null;
    }

    public boolean hasManagedDisk() {
        return this.managedDisk != null;
    }

    public boolean hasOsType() {
        return this.osType != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.cachingType, this.diskSettings, this.diskSizeGB, this.managedDisk, this.osType, this.additionalProperties);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cachingType != null) {
            sb.append("cachingType:");
            sb.append(this.cachingType);
            sb.append(",");
        }
        if (this.diskSettings != null) {
            sb.append("diskSettings:");
            sb.append(this.diskSettings);
            sb.append(",");
        }
        if (this.diskSizeGB != null) {
            sb.append("diskSizeGB:");
            sb.append(this.diskSizeGB);
            sb.append(",");
        }
        if (this.managedDisk != null) {
            sb.append("managedDisk:");
            sb.append(this.managedDisk);
            sb.append(",");
        }
        if (this.osType != null) {
            sb.append("osType:");
            sb.append(this.osType);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withCachingType(String cachingType) {
        this.cachingType = cachingType;
        return (A)this;
    }

    public A withDiskSettings(DiskSettings diskSettings) {
        this._visitables.remove("diskSettings");
        if (diskSettings != null) {
            this.diskSettings = new DiskSettingsBuilder(diskSettings);
            this._visitables.get("diskSettings").add(this.diskSettings);
        } else {
            this.diskSettings = null;
            this._visitables.get("diskSettings").remove(this.diskSettings);
        }
        return (A)this;
    }

    public A withDiskSizeGB(Integer diskSizeGB) {
        this.diskSizeGB = diskSizeGB;
        return (A)this;
    }

    public A withManagedDisk(OSDiskManagedDiskParameters managedDisk) {
        this._visitables.remove("managedDisk");
        if (managedDisk != null) {
            this.managedDisk = new OSDiskManagedDiskParametersBuilder(managedDisk);
            this._visitables.get("managedDisk").add(this.managedDisk);
        } else {
            this.managedDisk = null;
            this._visitables.get("managedDisk").remove(this.managedDisk);
        }
        return (A)this;
    }

    public DiskSettingsNested<A> withNewDiskSettings() {
        return new DiskSettingsNested(null);
    }

    public A withNewDiskSettings(String ephemeralStorageLocation) {
        return this.withDiskSettings(new DiskSettings(ephemeralStorageLocation));
    }

    public DiskSettingsNested<A> withNewDiskSettingsLike(DiskSettings item) {
        return new DiskSettingsNested(item);
    }

    public ManagedDiskNested<A> withNewManagedDisk() {
        return new ManagedDiskNested(null);
    }

    public ManagedDiskNested<A> withNewManagedDiskLike(OSDiskManagedDiskParameters item) {
        return new ManagedDiskNested(item);
    }

    public A withOsType(String osType) {
        this.osType = osType;
        return (A)this;
    }

    public class ManagedDiskNested<N>
    extends OSDiskManagedDiskParametersFluent<ManagedDiskNested<N>>
    implements Nested<N> {
        OSDiskManagedDiskParametersBuilder builder;

        ManagedDiskNested(OSDiskManagedDiskParameters item) {
            this.builder = new OSDiskManagedDiskParametersBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)OSDiskFluent.this.withManagedDisk(this.builder.build());
        }

        public N endManagedDisk() {
            return this.and();
        }
    }

    public class DiskSettingsNested<N>
    extends DiskSettingsFluent<DiskSettingsNested<N>>
    implements Nested<N> {
        DiskSettingsBuilder builder;

        DiskSettingsNested(DiskSettings item) {
            this.builder = new DiskSettingsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)OSDiskFluent.this.withDiskSettings(this.builder.build());
        }

        public N endDiskSettings() {
            return this.and();
        }
    }
}

