/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.machine.v1beta1.DataDisk;
import io.fabric8.openshift.api.model.machine.v1beta1.DataDiskManagedDiskParameters;
import io.fabric8.openshift.api.model.machine.v1beta1.DataDiskManagedDiskParametersBuilder;
import io.fabric8.openshift.api.model.machine.v1beta1.DataDiskManagedDiskParametersFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DataDiskFluent<A extends DataDiskFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String cachingType;
    private String deletionPolicy;
    private Integer diskSizeGB;
    private Integer lun;
    private DataDiskManagedDiskParametersBuilder managedDisk;
    private String nameSuffix;

    public DataDiskFluent() {
    }

    public DataDiskFluent(DataDisk instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public DataDiskManagedDiskParameters buildManagedDisk() {
        return this.managedDisk != null ? this.managedDisk.build() : null;
    }

    protected void copyInstance(DataDisk instance) {
        DataDisk dataDisk = instance = instance != null ? instance : new DataDisk();
        if (instance != null) {
            this.withCachingType(instance.getCachingType());
            this.withDeletionPolicy(instance.getDeletionPolicy());
            this.withDiskSizeGB(instance.getDiskSizeGB());
            this.withLun(instance.getLun());
            this.withManagedDisk(instance.getManagedDisk());
            this.withNameSuffix(instance.getNameSuffix());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ManagedDiskNested<A> editManagedDisk() {
        return this.withNewManagedDiskLike(Optional.ofNullable(this.buildManagedDisk()).orElse(null));
    }

    public ManagedDiskNested<A> editOrNewManagedDisk() {
        return this.withNewManagedDiskLike(Optional.ofNullable(this.buildManagedDisk()).orElse(new DataDiskManagedDiskParametersBuilder().build()));
    }

    public ManagedDiskNested<A> editOrNewManagedDiskLike(DataDiskManagedDiskParameters item) {
        return this.withNewManagedDiskLike(Optional.ofNullable(this.buildManagedDisk()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DataDiskFluent that = (DataDiskFluent)o;
        if (!Objects.equals(this.cachingType, that.cachingType)) {
            return false;
        }
        if (!Objects.equals(this.deletionPolicy, that.deletionPolicy)) {
            return false;
        }
        if (!Objects.equals(this.diskSizeGB, that.diskSizeGB)) {
            return false;
        }
        if (!Objects.equals(this.lun, that.lun)) {
            return false;
        }
        if (!Objects.equals(this.managedDisk, that.managedDisk)) {
            return false;
        }
        if (!Objects.equals(this.nameSuffix, that.nameSuffix)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getCachingType() {
        return this.cachingType;
    }

    public String getDeletionPolicy() {
        return this.deletionPolicy;
    }

    public Integer getDiskSizeGB() {
        return this.diskSizeGB;
    }

    public Integer getLun() {
        return this.lun;
    }

    public String getNameSuffix() {
        return this.nameSuffix;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasCachingType() {
        return this.cachingType != null;
    }

    public boolean hasDeletionPolicy() {
        return this.deletionPolicy != null;
    }

    public boolean hasDiskSizeGB() {
        return this.diskSizeGB != null;
    }

    public boolean hasLun() {
        return this.lun != null;
    }

    public boolean hasManagedDisk() {
        return this.managedDisk != null;
    }

    public boolean hasNameSuffix() {
        return this.nameSuffix != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.cachingType, this.deletionPolicy, this.diskSizeGB, this.lun, this.managedDisk, this.nameSuffix, this.additionalProperties);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cachingType != null) {
            sb.append("cachingType:");
            sb.append(this.cachingType);
            sb.append(",");
        }
        if (this.deletionPolicy != null) {
            sb.append("deletionPolicy:");
            sb.append(this.deletionPolicy);
            sb.append(",");
        }
        if (this.diskSizeGB != null) {
            sb.append("diskSizeGB:");
            sb.append(this.diskSizeGB);
            sb.append(",");
        }
        if (this.lun != null) {
            sb.append("lun:");
            sb.append(this.lun);
            sb.append(",");
        }
        if (this.managedDisk != null) {
            sb.append("managedDisk:");
            sb.append(this.managedDisk);
            sb.append(",");
        }
        if (this.nameSuffix != null) {
            sb.append("nameSuffix:");
            sb.append(this.nameSuffix);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withCachingType(String cachingType) {
        this.cachingType = cachingType;
        return (A)this;
    }

    public A withDeletionPolicy(String deletionPolicy) {
        this.deletionPolicy = deletionPolicy;
        return (A)this;
    }

    public A withDiskSizeGB(Integer diskSizeGB) {
        this.diskSizeGB = diskSizeGB;
        return (A)this;
    }

    public A withLun(Integer lun) {
        this.lun = lun;
        return (A)this;
    }

    public A withManagedDisk(DataDiskManagedDiskParameters managedDisk) {
        this._visitables.remove("managedDisk");
        if (managedDisk != null) {
            this.managedDisk = new DataDiskManagedDiskParametersBuilder(managedDisk);
            this._visitables.get("managedDisk").add(this.managedDisk);
        } else {
            this.managedDisk = null;
            this._visitables.get("managedDisk").remove(this.managedDisk);
        }
        return (A)this;
    }

    public A withNameSuffix(String nameSuffix) {
        this.nameSuffix = nameSuffix;
        return (A)this;
    }

    public ManagedDiskNested<A> withNewManagedDisk() {
        return new ManagedDiskNested(null);
    }

    public ManagedDiskNested<A> withNewManagedDiskLike(DataDiskManagedDiskParameters item) {
        return new ManagedDiskNested(item);
    }

    public class ManagedDiskNested<N>
    extends DataDiskManagedDiskParametersFluent<ManagedDiskNested<N>>
    implements Nested<N> {
        DataDiskManagedDiskParametersBuilder builder;

        ManagedDiskNested(DataDiskManagedDiskParameters item) {
            this.builder = new DataDiskManagedDiskParametersBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)DataDiskFluent.this.withManagedDisk(this.builder.build());
        }

        public N endManagedDisk() {
            return this.and();
        }
    }
}

