/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machine.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.machine.v1.AWSFailureDomain;
import io.fabric8.openshift.api.model.machine.v1.AWSFailureDomainBuilder;
import io.fabric8.openshift.api.model.machine.v1.AWSFailureDomainFluent;
import io.fabric8.openshift.api.model.machine.v1.AzureFailureDomain;
import io.fabric8.openshift.api.model.machine.v1.AzureFailureDomainBuilder;
import io.fabric8.openshift.api.model.machine.v1.AzureFailureDomainFluent;
import io.fabric8.openshift.api.model.machine.v1.FailureDomains;
import io.fabric8.openshift.api.model.machine.v1.GCPFailureDomain;
import io.fabric8.openshift.api.model.machine.v1.GCPFailureDomainBuilder;
import io.fabric8.openshift.api.model.machine.v1.GCPFailureDomainFluent;
import io.fabric8.openshift.api.model.machine.v1.NutanixFailureDomainReference;
import io.fabric8.openshift.api.model.machine.v1.NutanixFailureDomainReferenceBuilder;
import io.fabric8.openshift.api.model.machine.v1.NutanixFailureDomainReferenceFluent;
import io.fabric8.openshift.api.model.machine.v1.OpenStackFailureDomain;
import io.fabric8.openshift.api.model.machine.v1.OpenStackFailureDomainBuilder;
import io.fabric8.openshift.api.model.machine.v1.OpenStackFailureDomainFluent;
import io.fabric8.openshift.api.model.machine.v1.VSphereFailureDomain;
import io.fabric8.openshift.api.model.machine.v1.VSphereFailureDomainBuilder;
import io.fabric8.openshift.api.model.machine.v1.VSphereFailureDomainFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class FailureDomainsFluent<A extends FailureDomainsFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ArrayList<AWSFailureDomainBuilder> aws = new ArrayList();
    private ArrayList<AzureFailureDomainBuilder> azure = new ArrayList();
    private ArrayList<GCPFailureDomainBuilder> gcp = new ArrayList();
    private ArrayList<NutanixFailureDomainReferenceBuilder> nutanix = new ArrayList();
    private ArrayList<OpenStackFailureDomainBuilder> openstack = new ArrayList();
    private String platform;
    private ArrayList<VSphereFailureDomainBuilder> vsphere = new ArrayList();

    public FailureDomainsFluent() {
    }

    public FailureDomainsFluent(FailureDomains instance) {
        this.copyInstance(instance);
    }

    public A addAllToAws(Collection<AWSFailureDomain> items) {
        if (this.aws == null) {
            this.aws = new ArrayList();
        }
        for (AWSFailureDomain item : items) {
            AWSFailureDomainBuilder builder = new AWSFailureDomainBuilder(item);
            this._visitables.get("aws").add(builder);
            this.aws.add(builder);
        }
        return (A)this;
    }

    public A addAllToAzure(Collection<AzureFailureDomain> items) {
        if (this.azure == null) {
            this.azure = new ArrayList();
        }
        for (AzureFailureDomain item : items) {
            AzureFailureDomainBuilder builder = new AzureFailureDomainBuilder(item);
            this._visitables.get("azure").add(builder);
            this.azure.add(builder);
        }
        return (A)this;
    }

    public A addAllToGcp(Collection<GCPFailureDomain> items) {
        if (this.gcp == null) {
            this.gcp = new ArrayList();
        }
        for (GCPFailureDomain item : items) {
            GCPFailureDomainBuilder builder = new GCPFailureDomainBuilder(item);
            this._visitables.get("gcp").add(builder);
            this.gcp.add(builder);
        }
        return (A)this;
    }

    public A addAllToNutanix(Collection<NutanixFailureDomainReference> items) {
        if (this.nutanix == null) {
            this.nutanix = new ArrayList();
        }
        for (NutanixFailureDomainReference item : items) {
            NutanixFailureDomainReferenceBuilder builder = new NutanixFailureDomainReferenceBuilder(item);
            this._visitables.get("nutanix").add(builder);
            this.nutanix.add(builder);
        }
        return (A)this;
    }

    public A addAllToOpenstack(Collection<OpenStackFailureDomain> items) {
        if (this.openstack == null) {
            this.openstack = new ArrayList();
        }
        for (OpenStackFailureDomain item : items) {
            OpenStackFailureDomainBuilder builder = new OpenStackFailureDomainBuilder(item);
            this._visitables.get("openstack").add(builder);
            this.openstack.add(builder);
        }
        return (A)this;
    }

    public A addAllToVsphere(Collection<VSphereFailureDomain> items) {
        if (this.vsphere == null) {
            this.vsphere = new ArrayList();
        }
        for (VSphereFailureDomain item : items) {
            VSphereFailureDomainBuilder builder = new VSphereFailureDomainBuilder(item);
            this._visitables.get("vsphere").add(builder);
            this.vsphere.add(builder);
        }
        return (A)this;
    }

    public AwsNested<A> addNewAw() {
        return new AwsNested(-1, null);
    }

    public AwsNested<A> addNewAwLike(AWSFailureDomain item) {
        return new AwsNested(-1, item);
    }

    public AzureNested<A> addNewAzure() {
        return new AzureNested(-1, null);
    }

    public A addNewAzure(String subnet, String zone) {
        return this.addToAzure(new AzureFailureDomain(subnet, zone));
    }

    public AzureNested<A> addNewAzureLike(AzureFailureDomain item) {
        return new AzureNested(-1, item);
    }

    public GcpNested<A> addNewGcp() {
        return new GcpNested(-1, null);
    }

    public A addNewGcp(String zone) {
        return this.addToGcp(new GCPFailureDomain(zone));
    }

    public GcpNested<A> addNewGcpLike(GCPFailureDomain item) {
        return new GcpNested(-1, item);
    }

    public NutanixNested<A> addNewNutanix() {
        return new NutanixNested(-1, null);
    }

    public A addNewNutanix(String name) {
        return this.addToNutanix(new NutanixFailureDomainReference(name));
    }

    public NutanixNested<A> addNewNutanixLike(NutanixFailureDomainReference item) {
        return new NutanixNested(-1, item);
    }

    public OpenstackNested<A> addNewOpenstack() {
        return new OpenstackNested(-1, null);
    }

    public OpenstackNested<A> addNewOpenstackLike(OpenStackFailureDomain item) {
        return new OpenstackNested(-1, item);
    }

    public VsphereNested<A> addNewVsphere() {
        return new VsphereNested(-1, null);
    }

    public A addNewVsphere(String name) {
        return this.addToVsphere(new VSphereFailureDomain(name));
    }

    public VsphereNested<A> addNewVsphereLike(VSphereFailureDomain item) {
        return new VsphereNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAws(AWSFailureDomain ... items) {
        if (this.aws == null) {
            this.aws = new ArrayList();
        }
        for (AWSFailureDomain item : items) {
            AWSFailureDomainBuilder builder = new AWSFailureDomainBuilder(item);
            this._visitables.get("aws").add(builder);
            this.aws.add(builder);
        }
        return (A)this;
    }

    public A addToAws(int index, AWSFailureDomain item) {
        if (this.aws == null) {
            this.aws = new ArrayList();
        }
        AWSFailureDomainBuilder builder = new AWSFailureDomainBuilder(item);
        if (index < 0 || index >= this.aws.size()) {
            this._visitables.get("aws").add(builder);
            this.aws.add(builder);
        } else {
            this._visitables.get("aws").add(builder);
            this.aws.add(index, builder);
        }
        return (A)this;
    }

    public A addToAzure(AzureFailureDomain ... items) {
        if (this.azure == null) {
            this.azure = new ArrayList();
        }
        for (AzureFailureDomain item : items) {
            AzureFailureDomainBuilder builder = new AzureFailureDomainBuilder(item);
            this._visitables.get("azure").add(builder);
            this.azure.add(builder);
        }
        return (A)this;
    }

    public A addToAzure(int index, AzureFailureDomain item) {
        if (this.azure == null) {
            this.azure = new ArrayList();
        }
        AzureFailureDomainBuilder builder = new AzureFailureDomainBuilder(item);
        if (index < 0 || index >= this.azure.size()) {
            this._visitables.get("azure").add(builder);
            this.azure.add(builder);
        } else {
            this._visitables.get("azure").add(builder);
            this.azure.add(index, builder);
        }
        return (A)this;
    }

    public A addToGcp(GCPFailureDomain ... items) {
        if (this.gcp == null) {
            this.gcp = new ArrayList();
        }
        for (GCPFailureDomain item : items) {
            GCPFailureDomainBuilder builder = new GCPFailureDomainBuilder(item);
            this._visitables.get("gcp").add(builder);
            this.gcp.add(builder);
        }
        return (A)this;
    }

    public A addToGcp(int index, GCPFailureDomain item) {
        if (this.gcp == null) {
            this.gcp = new ArrayList();
        }
        GCPFailureDomainBuilder builder = new GCPFailureDomainBuilder(item);
        if (index < 0 || index >= this.gcp.size()) {
            this._visitables.get("gcp").add(builder);
            this.gcp.add(builder);
        } else {
            this._visitables.get("gcp").add(builder);
            this.gcp.add(index, builder);
        }
        return (A)this;
    }

    public A addToNutanix(NutanixFailureDomainReference ... items) {
        if (this.nutanix == null) {
            this.nutanix = new ArrayList();
        }
        for (NutanixFailureDomainReference item : items) {
            NutanixFailureDomainReferenceBuilder builder = new NutanixFailureDomainReferenceBuilder(item);
            this._visitables.get("nutanix").add(builder);
            this.nutanix.add(builder);
        }
        return (A)this;
    }

    public A addToNutanix(int index, NutanixFailureDomainReference item) {
        if (this.nutanix == null) {
            this.nutanix = new ArrayList();
        }
        NutanixFailureDomainReferenceBuilder builder = new NutanixFailureDomainReferenceBuilder(item);
        if (index < 0 || index >= this.nutanix.size()) {
            this._visitables.get("nutanix").add(builder);
            this.nutanix.add(builder);
        } else {
            this._visitables.get("nutanix").add(builder);
            this.nutanix.add(index, builder);
        }
        return (A)this;
    }

    public A addToOpenstack(OpenStackFailureDomain ... items) {
        if (this.openstack == null) {
            this.openstack = new ArrayList();
        }
        for (OpenStackFailureDomain item : items) {
            OpenStackFailureDomainBuilder builder = new OpenStackFailureDomainBuilder(item);
            this._visitables.get("openstack").add(builder);
            this.openstack.add(builder);
        }
        return (A)this;
    }

    public A addToOpenstack(int index, OpenStackFailureDomain item) {
        if (this.openstack == null) {
            this.openstack = new ArrayList();
        }
        OpenStackFailureDomainBuilder builder = new OpenStackFailureDomainBuilder(item);
        if (index < 0 || index >= this.openstack.size()) {
            this._visitables.get("openstack").add(builder);
            this.openstack.add(builder);
        } else {
            this._visitables.get("openstack").add(builder);
            this.openstack.add(index, builder);
        }
        return (A)this;
    }

    public A addToVsphere(VSphereFailureDomain ... items) {
        if (this.vsphere == null) {
            this.vsphere = new ArrayList();
        }
        for (VSphereFailureDomain item : items) {
            VSphereFailureDomainBuilder builder = new VSphereFailureDomainBuilder(item);
            this._visitables.get("vsphere").add(builder);
            this.vsphere.add(builder);
        }
        return (A)this;
    }

    public A addToVsphere(int index, VSphereFailureDomain item) {
        if (this.vsphere == null) {
            this.vsphere = new ArrayList();
        }
        VSphereFailureDomainBuilder builder = new VSphereFailureDomainBuilder(item);
        if (index < 0 || index >= this.vsphere.size()) {
            this._visitables.get("vsphere").add(builder);
            this.vsphere.add(builder);
        } else {
            this._visitables.get("vsphere").add(builder);
            this.vsphere.add(index, builder);
        }
        return (A)this;
    }

    public AWSFailureDomain buildAw(int index) {
        return this.aws.get(index).build();
    }

    public List<AWSFailureDomain> buildAws() {
        return this.aws != null ? FailureDomainsFluent.build(this.aws) : null;
    }

    public List<AzureFailureDomain> buildAzure() {
        return this.azure != null ? FailureDomainsFluent.build(this.azure) : null;
    }

    public AzureFailureDomain buildAzure(int index) {
        return this.azure.get(index).build();
    }

    public AWSFailureDomain buildFirstAw() {
        return this.aws.get(0).build();
    }

    public AzureFailureDomain buildFirstAzure() {
        return this.azure.get(0).build();
    }

    public GCPFailureDomain buildFirstGcp() {
        return this.gcp.get(0).build();
    }

    public NutanixFailureDomainReference buildFirstNutanix() {
        return this.nutanix.get(0).build();
    }

    public OpenStackFailureDomain buildFirstOpenstack() {
        return this.openstack.get(0).build();
    }

    public VSphereFailureDomain buildFirstVsphere() {
        return this.vsphere.get(0).build();
    }

    public List<GCPFailureDomain> buildGcp() {
        return this.gcp != null ? FailureDomainsFluent.build(this.gcp) : null;
    }

    public GCPFailureDomain buildGcp(int index) {
        return this.gcp.get(index).build();
    }

    public AWSFailureDomain buildLastAw() {
        return this.aws.get(this.aws.size() - 1).build();
    }

    public AzureFailureDomain buildLastAzure() {
        return this.azure.get(this.azure.size() - 1).build();
    }

    public GCPFailureDomain buildLastGcp() {
        return this.gcp.get(this.gcp.size() - 1).build();
    }

    public NutanixFailureDomainReference buildLastNutanix() {
        return this.nutanix.get(this.nutanix.size() - 1).build();
    }

    public OpenStackFailureDomain buildLastOpenstack() {
        return this.openstack.get(this.openstack.size() - 1).build();
    }

    public VSphereFailureDomain buildLastVsphere() {
        return this.vsphere.get(this.vsphere.size() - 1).build();
    }

    public AWSFailureDomain buildMatchingAw(Predicate<AWSFailureDomainBuilder> predicate) {
        for (AWSFailureDomainBuilder item : this.aws) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public AzureFailureDomain buildMatchingAzure(Predicate<AzureFailureDomainBuilder> predicate) {
        for (AzureFailureDomainBuilder item : this.azure) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public GCPFailureDomain buildMatchingGcp(Predicate<GCPFailureDomainBuilder> predicate) {
        for (GCPFailureDomainBuilder item : this.gcp) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public NutanixFailureDomainReference buildMatchingNutanix(Predicate<NutanixFailureDomainReferenceBuilder> predicate) {
        for (NutanixFailureDomainReferenceBuilder item : this.nutanix) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public OpenStackFailureDomain buildMatchingOpenstack(Predicate<OpenStackFailureDomainBuilder> predicate) {
        for (OpenStackFailureDomainBuilder item : this.openstack) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public VSphereFailureDomain buildMatchingVsphere(Predicate<VSphereFailureDomainBuilder> predicate) {
        for (VSphereFailureDomainBuilder item : this.vsphere) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public List<NutanixFailureDomainReference> buildNutanix() {
        return this.nutanix != null ? FailureDomainsFluent.build(this.nutanix) : null;
    }

    public NutanixFailureDomainReference buildNutanix(int index) {
        return this.nutanix.get(index).build();
    }

    public List<OpenStackFailureDomain> buildOpenstack() {
        return this.openstack != null ? FailureDomainsFluent.build(this.openstack) : null;
    }

    public OpenStackFailureDomain buildOpenstack(int index) {
        return this.openstack.get(index).build();
    }

    public List<VSphereFailureDomain> buildVsphere() {
        return this.vsphere != null ? FailureDomainsFluent.build(this.vsphere) : null;
    }

    public VSphereFailureDomain buildVsphere(int index) {
        return this.vsphere.get(index).build();
    }

    protected void copyInstance(FailureDomains instance) {
        FailureDomains failureDomains = instance = instance != null ? instance : new FailureDomains();
        if (instance != null) {
            this.withAws(instance.getAws());
            this.withAzure(instance.getAzure());
            this.withGcp(instance.getGcp());
            this.withNutanix(instance.getNutanix());
            this.withOpenstack(instance.getOpenstack());
            this.withPlatform(instance.getPlatform());
            this.withVsphere(instance.getVsphere());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public AwsNested<A> editAw(int index) {
        if (this.aws.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "aws"));
        }
        return this.setNewAwLike(index, this.buildAw(index));
    }

    public AzureNested<A> editAzure(int index) {
        if (this.azure.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "azure"));
        }
        return this.setNewAzureLike(index, this.buildAzure(index));
    }

    public AwsNested<A> editFirstAw() {
        if (this.aws.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "aws"));
        }
        return this.setNewAwLike(0, this.buildAw(0));
    }

    public AzureNested<A> editFirstAzure() {
        if (this.azure.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "azure"));
        }
        return this.setNewAzureLike(0, this.buildAzure(0));
    }

    public GcpNested<A> editFirstGcp() {
        if (this.gcp.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "gcp"));
        }
        return this.setNewGcpLike(0, this.buildGcp(0));
    }

    public NutanixNested<A> editFirstNutanix() {
        if (this.nutanix.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "nutanix"));
        }
        return this.setNewNutanixLike(0, this.buildNutanix(0));
    }

    public OpenstackNested<A> editFirstOpenstack() {
        if (this.openstack.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "openstack"));
        }
        return this.setNewOpenstackLike(0, this.buildOpenstack(0));
    }

    public VsphereNested<A> editFirstVsphere() {
        if (this.vsphere.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "vsphere"));
        }
        return this.setNewVsphereLike(0, this.buildVsphere(0));
    }

    public GcpNested<A> editGcp(int index) {
        if (this.gcp.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "gcp"));
        }
        return this.setNewGcpLike(index, this.buildGcp(index));
    }

    public AwsNested<A> editLastAw() {
        int index = this.aws.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "aws"));
        }
        return this.setNewAwLike(index, this.buildAw(index));
    }

    public AzureNested<A> editLastAzure() {
        int index = this.azure.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "azure"));
        }
        return this.setNewAzureLike(index, this.buildAzure(index));
    }

    public GcpNested<A> editLastGcp() {
        int index = this.gcp.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "gcp"));
        }
        return this.setNewGcpLike(index, this.buildGcp(index));
    }

    public NutanixNested<A> editLastNutanix() {
        int index = this.nutanix.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "nutanix"));
        }
        return this.setNewNutanixLike(index, this.buildNutanix(index));
    }

    public OpenstackNested<A> editLastOpenstack() {
        int index = this.openstack.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "openstack"));
        }
        return this.setNewOpenstackLike(index, this.buildOpenstack(index));
    }

    public VsphereNested<A> editLastVsphere() {
        int index = this.vsphere.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "vsphere"));
        }
        return this.setNewVsphereLike(index, this.buildVsphere(index));
    }

    public AwsNested<A> editMatchingAw(Predicate<AWSFailureDomainBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.aws.size(); ++i) {
            if (!predicate.test(this.aws.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "aws"));
        }
        return this.setNewAwLike(index, this.buildAw(index));
    }

    public AzureNested<A> editMatchingAzure(Predicate<AzureFailureDomainBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.azure.size(); ++i) {
            if (!predicate.test(this.azure.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "azure"));
        }
        return this.setNewAzureLike(index, this.buildAzure(index));
    }

    public GcpNested<A> editMatchingGcp(Predicate<GCPFailureDomainBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.gcp.size(); ++i) {
            if (!predicate.test(this.gcp.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "gcp"));
        }
        return this.setNewGcpLike(index, this.buildGcp(index));
    }

    public NutanixNested<A> editMatchingNutanix(Predicate<NutanixFailureDomainReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.nutanix.size(); ++i) {
            if (!predicate.test(this.nutanix.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "nutanix"));
        }
        return this.setNewNutanixLike(index, this.buildNutanix(index));
    }

    public OpenstackNested<A> editMatchingOpenstack(Predicate<OpenStackFailureDomainBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.openstack.size(); ++i) {
            if (!predicate.test(this.openstack.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "openstack"));
        }
        return this.setNewOpenstackLike(index, this.buildOpenstack(index));
    }

    public VsphereNested<A> editMatchingVsphere(Predicate<VSphereFailureDomainBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.vsphere.size(); ++i) {
            if (!predicate.test(this.vsphere.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "vsphere"));
        }
        return this.setNewVsphereLike(index, this.buildVsphere(index));
    }

    public NutanixNested<A> editNutanix(int index) {
        if (this.nutanix.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "nutanix"));
        }
        return this.setNewNutanixLike(index, this.buildNutanix(index));
    }

    public OpenstackNested<A> editOpenstack(int index) {
        if (this.openstack.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "openstack"));
        }
        return this.setNewOpenstackLike(index, this.buildOpenstack(index));
    }

    public VsphereNested<A> editVsphere(int index) {
        if (this.vsphere.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "vsphere"));
        }
        return this.setNewVsphereLike(index, this.buildVsphere(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FailureDomainsFluent that = (FailureDomainsFluent)o;
        if (!Objects.equals(this.aws, that.aws)) {
            return false;
        }
        if (!Objects.equals(this.azure, that.azure)) {
            return false;
        }
        if (!Objects.equals(this.gcp, that.gcp)) {
            return false;
        }
        if (!Objects.equals(this.nutanix, that.nutanix)) {
            return false;
        }
        if (!Objects.equals(this.openstack, that.openstack)) {
            return false;
        }
        if (!Objects.equals(this.platform, that.platform)) {
            return false;
        }
        if (!Objects.equals(this.vsphere, that.vsphere)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getPlatform() {
        return this.platform;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAws() {
        return this.aws != null && !this.aws.isEmpty();
    }

    public boolean hasAzure() {
        return this.azure != null && !this.azure.isEmpty();
    }

    public boolean hasGcp() {
        return this.gcp != null && !this.gcp.isEmpty();
    }

    public boolean hasMatchingAw(Predicate<AWSFailureDomainBuilder> predicate) {
        for (AWSFailureDomainBuilder item : this.aws) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingAzure(Predicate<AzureFailureDomainBuilder> predicate) {
        for (AzureFailureDomainBuilder item : this.azure) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingGcp(Predicate<GCPFailureDomainBuilder> predicate) {
        for (GCPFailureDomainBuilder item : this.gcp) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingNutanix(Predicate<NutanixFailureDomainReferenceBuilder> predicate) {
        for (NutanixFailureDomainReferenceBuilder item : this.nutanix) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingOpenstack(Predicate<OpenStackFailureDomainBuilder> predicate) {
        for (OpenStackFailureDomainBuilder item : this.openstack) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingVsphere(Predicate<VSphereFailureDomainBuilder> predicate) {
        for (VSphereFailureDomainBuilder item : this.vsphere) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNutanix() {
        return this.nutanix != null && !this.nutanix.isEmpty();
    }

    public boolean hasOpenstack() {
        return this.openstack != null && !this.openstack.isEmpty();
    }

    public boolean hasPlatform() {
        return this.platform != null;
    }

    public boolean hasVsphere() {
        return this.vsphere != null && !this.vsphere.isEmpty();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.aws, this.azure, this.gcp, this.nutanix, this.openstack, this.platform, this.vsphere, this.additionalProperties);
    }

    public A removeAllFromAws(Collection<AWSFailureDomain> items) {
        if (this.aws == null) {
            return (A)this;
        }
        for (AWSFailureDomain item : items) {
            AWSFailureDomainBuilder builder = new AWSFailureDomainBuilder(item);
            this._visitables.get("aws").remove(builder);
            this.aws.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromAzure(Collection<AzureFailureDomain> items) {
        if (this.azure == null) {
            return (A)this;
        }
        for (AzureFailureDomain item : items) {
            AzureFailureDomainBuilder builder = new AzureFailureDomainBuilder(item);
            this._visitables.get("azure").remove(builder);
            this.azure.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromGcp(Collection<GCPFailureDomain> items) {
        if (this.gcp == null) {
            return (A)this;
        }
        for (GCPFailureDomain item : items) {
            GCPFailureDomainBuilder builder = new GCPFailureDomainBuilder(item);
            this._visitables.get("gcp").remove(builder);
            this.gcp.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromNutanix(Collection<NutanixFailureDomainReference> items) {
        if (this.nutanix == null) {
            return (A)this;
        }
        for (NutanixFailureDomainReference item : items) {
            NutanixFailureDomainReferenceBuilder builder = new NutanixFailureDomainReferenceBuilder(item);
            this._visitables.get("nutanix").remove(builder);
            this.nutanix.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromOpenstack(Collection<OpenStackFailureDomain> items) {
        if (this.openstack == null) {
            return (A)this;
        }
        for (OpenStackFailureDomain item : items) {
            OpenStackFailureDomainBuilder builder = new OpenStackFailureDomainBuilder(item);
            this._visitables.get("openstack").remove(builder);
            this.openstack.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromVsphere(Collection<VSphereFailureDomain> items) {
        if (this.vsphere == null) {
            return (A)this;
        }
        for (VSphereFailureDomain item : items) {
            VSphereFailureDomainBuilder builder = new VSphereFailureDomainBuilder(item);
            this._visitables.get("vsphere").remove(builder);
            this.vsphere.remove(builder);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public A removeFromAws(AWSFailureDomain ... items) {
        if (this.aws == null) {
            return (A)this;
        }
        for (AWSFailureDomain item : items) {
            AWSFailureDomainBuilder builder = new AWSFailureDomainBuilder(item);
            this._visitables.get("aws").remove(builder);
            this.aws.remove(builder);
        }
        return (A)this;
    }

    public A removeFromAzure(AzureFailureDomain ... items) {
        if (this.azure == null) {
            return (A)this;
        }
        for (AzureFailureDomain item : items) {
            AzureFailureDomainBuilder builder = new AzureFailureDomainBuilder(item);
            this._visitables.get("azure").remove(builder);
            this.azure.remove(builder);
        }
        return (A)this;
    }

    public A removeFromGcp(GCPFailureDomain ... items) {
        if (this.gcp == null) {
            return (A)this;
        }
        for (GCPFailureDomain item : items) {
            GCPFailureDomainBuilder builder = new GCPFailureDomainBuilder(item);
            this._visitables.get("gcp").remove(builder);
            this.gcp.remove(builder);
        }
        return (A)this;
    }

    public A removeFromNutanix(NutanixFailureDomainReference ... items) {
        if (this.nutanix == null) {
            return (A)this;
        }
        for (NutanixFailureDomainReference item : items) {
            NutanixFailureDomainReferenceBuilder builder = new NutanixFailureDomainReferenceBuilder(item);
            this._visitables.get("nutanix").remove(builder);
            this.nutanix.remove(builder);
        }
        return (A)this;
    }

    public A removeFromOpenstack(OpenStackFailureDomain ... items) {
        if (this.openstack == null) {
            return (A)this;
        }
        for (OpenStackFailureDomain item : items) {
            OpenStackFailureDomainBuilder builder = new OpenStackFailureDomainBuilder(item);
            this._visitables.get("openstack").remove(builder);
            this.openstack.remove(builder);
        }
        return (A)this;
    }

    public A removeFromVsphere(VSphereFailureDomain ... items) {
        if (this.vsphere == null) {
            return (A)this;
        }
        for (VSphereFailureDomain item : items) {
            VSphereFailureDomainBuilder builder = new VSphereFailureDomainBuilder(item);
            this._visitables.get("vsphere").remove(builder);
            this.vsphere.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromAws(Predicate<AWSFailureDomainBuilder> predicate) {
        if (this.aws == null) {
            return (A)this;
        }
        Iterator<AWSFailureDomainBuilder> each = this.aws.iterator();
        Object visitables = this._visitables.get("aws");
        while (each.hasNext()) {
            AWSFailureDomainBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public A removeMatchingFromAzure(Predicate<AzureFailureDomainBuilder> predicate) {
        if (this.azure == null) {
            return (A)this;
        }
        Iterator<AzureFailureDomainBuilder> each = this.azure.iterator();
        Object visitables = this._visitables.get("azure");
        while (each.hasNext()) {
            AzureFailureDomainBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public A removeMatchingFromGcp(Predicate<GCPFailureDomainBuilder> predicate) {
        if (this.gcp == null) {
            return (A)this;
        }
        Iterator<GCPFailureDomainBuilder> each = this.gcp.iterator();
        Object visitables = this._visitables.get("gcp");
        while (each.hasNext()) {
            GCPFailureDomainBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public A removeMatchingFromNutanix(Predicate<NutanixFailureDomainReferenceBuilder> predicate) {
        if (this.nutanix == null) {
            return (A)this;
        }
        Iterator<NutanixFailureDomainReferenceBuilder> each = this.nutanix.iterator();
        Object visitables = this._visitables.get("nutanix");
        while (each.hasNext()) {
            NutanixFailureDomainReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public A removeMatchingFromOpenstack(Predicate<OpenStackFailureDomainBuilder> predicate) {
        if (this.openstack == null) {
            return (A)this;
        }
        Iterator<OpenStackFailureDomainBuilder> each = this.openstack.iterator();
        Object visitables = this._visitables.get("openstack");
        while (each.hasNext()) {
            OpenStackFailureDomainBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public A removeMatchingFromVsphere(Predicate<VSphereFailureDomainBuilder> predicate) {
        if (this.vsphere == null) {
            return (A)this;
        }
        Iterator<VSphereFailureDomainBuilder> each = this.vsphere.iterator();
        Object visitables = this._visitables.get("vsphere");
        while (each.hasNext()) {
            VSphereFailureDomainBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public AwsNested<A> setNewAwLike(int index, AWSFailureDomain item) {
        return new AwsNested(index, item);
    }

    public AzureNested<A> setNewAzureLike(int index, AzureFailureDomain item) {
        return new AzureNested(index, item);
    }

    public GcpNested<A> setNewGcpLike(int index, GCPFailureDomain item) {
        return new GcpNested(index, item);
    }

    public NutanixNested<A> setNewNutanixLike(int index, NutanixFailureDomainReference item) {
        return new NutanixNested(index, item);
    }

    public OpenstackNested<A> setNewOpenstackLike(int index, OpenStackFailureDomain item) {
        return new OpenstackNested(index, item);
    }

    public VsphereNested<A> setNewVsphereLike(int index, VSphereFailureDomain item) {
        return new VsphereNested(index, item);
    }

    public A setToAws(int index, AWSFailureDomain item) {
        if (this.aws == null) {
            this.aws = new ArrayList();
        }
        AWSFailureDomainBuilder builder = new AWSFailureDomainBuilder(item);
        if (index < 0 || index >= this.aws.size()) {
            this._visitables.get("aws").add(builder);
            this.aws.add(builder);
        } else {
            this._visitables.get("aws").add(builder);
            this.aws.set(index, builder);
        }
        return (A)this;
    }

    public A setToAzure(int index, AzureFailureDomain item) {
        if (this.azure == null) {
            this.azure = new ArrayList();
        }
        AzureFailureDomainBuilder builder = new AzureFailureDomainBuilder(item);
        if (index < 0 || index >= this.azure.size()) {
            this._visitables.get("azure").add(builder);
            this.azure.add(builder);
        } else {
            this._visitables.get("azure").add(builder);
            this.azure.set(index, builder);
        }
        return (A)this;
    }

    public A setToGcp(int index, GCPFailureDomain item) {
        if (this.gcp == null) {
            this.gcp = new ArrayList();
        }
        GCPFailureDomainBuilder builder = new GCPFailureDomainBuilder(item);
        if (index < 0 || index >= this.gcp.size()) {
            this._visitables.get("gcp").add(builder);
            this.gcp.add(builder);
        } else {
            this._visitables.get("gcp").add(builder);
            this.gcp.set(index, builder);
        }
        return (A)this;
    }

    public A setToNutanix(int index, NutanixFailureDomainReference item) {
        if (this.nutanix == null) {
            this.nutanix = new ArrayList();
        }
        NutanixFailureDomainReferenceBuilder builder = new NutanixFailureDomainReferenceBuilder(item);
        if (index < 0 || index >= this.nutanix.size()) {
            this._visitables.get("nutanix").add(builder);
            this.nutanix.add(builder);
        } else {
            this._visitables.get("nutanix").add(builder);
            this.nutanix.set(index, builder);
        }
        return (A)this;
    }

    public A setToOpenstack(int index, OpenStackFailureDomain item) {
        if (this.openstack == null) {
            this.openstack = new ArrayList();
        }
        OpenStackFailureDomainBuilder builder = new OpenStackFailureDomainBuilder(item);
        if (index < 0 || index >= this.openstack.size()) {
            this._visitables.get("openstack").add(builder);
            this.openstack.add(builder);
        } else {
            this._visitables.get("openstack").add(builder);
            this.openstack.set(index, builder);
        }
        return (A)this;
    }

    public A setToVsphere(int index, VSphereFailureDomain item) {
        if (this.vsphere == null) {
            this.vsphere = new ArrayList();
        }
        VSphereFailureDomainBuilder builder = new VSphereFailureDomainBuilder(item);
        if (index < 0 || index >= this.vsphere.size()) {
            this._visitables.get("vsphere").add(builder);
            this.vsphere.add(builder);
        } else {
            this._visitables.get("vsphere").add(builder);
            this.vsphere.set(index, builder);
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.aws != null && !this.aws.isEmpty()) {
            sb.append("aws:");
            sb.append(this.aws);
            sb.append(",");
        }
        if (this.azure != null && !this.azure.isEmpty()) {
            sb.append("azure:");
            sb.append(this.azure);
            sb.append(",");
        }
        if (this.gcp != null && !this.gcp.isEmpty()) {
            sb.append("gcp:");
            sb.append(this.gcp);
            sb.append(",");
        }
        if (this.nutanix != null && !this.nutanix.isEmpty()) {
            sb.append("nutanix:");
            sb.append(this.nutanix);
            sb.append(",");
        }
        if (this.openstack != null && !this.openstack.isEmpty()) {
            sb.append("openstack:");
            sb.append(this.openstack);
            sb.append(",");
        }
        if (this.platform != null) {
            sb.append("platform:");
            sb.append(this.platform);
            sb.append(",");
        }
        if (this.vsphere != null && !this.vsphere.isEmpty()) {
            sb.append("vsphere:");
            sb.append(this.vsphere);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withAws(List<AWSFailureDomain> aws) {
        if (this.aws != null) {
            this._visitables.get("aws").clear();
        }
        if (aws != null) {
            this.aws = new ArrayList();
            for (AWSFailureDomain item : aws) {
                this.addToAws(item);
            }
        } else {
            this.aws = null;
        }
        return (A)this;
    }

    public A withAws(AWSFailureDomain ... aws) {
        if (this.aws != null) {
            this.aws.clear();
            this._visitables.remove("aws");
        }
        if (aws != null) {
            for (AWSFailureDomain item : aws) {
                this.addToAws(item);
            }
        }
        return (A)this;
    }

    public A withAzure(List<AzureFailureDomain> azure) {
        if (this.azure != null) {
            this._visitables.get("azure").clear();
        }
        if (azure != null) {
            this.azure = new ArrayList();
            for (AzureFailureDomain item : azure) {
                this.addToAzure(item);
            }
        } else {
            this.azure = null;
        }
        return (A)this;
    }

    public A withAzure(AzureFailureDomain ... azure) {
        if (this.azure != null) {
            this.azure.clear();
            this._visitables.remove("azure");
        }
        if (azure != null) {
            for (AzureFailureDomain item : azure) {
                this.addToAzure(item);
            }
        }
        return (A)this;
    }

    public A withGcp(List<GCPFailureDomain> gcp) {
        if (this.gcp != null) {
            this._visitables.get("gcp").clear();
        }
        if (gcp != null) {
            this.gcp = new ArrayList();
            for (GCPFailureDomain item : gcp) {
                this.addToGcp(item);
            }
        } else {
            this.gcp = null;
        }
        return (A)this;
    }

    public A withGcp(GCPFailureDomain ... gcp) {
        if (this.gcp != null) {
            this.gcp.clear();
            this._visitables.remove("gcp");
        }
        if (gcp != null) {
            for (GCPFailureDomain item : gcp) {
                this.addToGcp(item);
            }
        }
        return (A)this;
    }

    public A withNutanix(List<NutanixFailureDomainReference> nutanix) {
        if (this.nutanix != null) {
            this._visitables.get("nutanix").clear();
        }
        if (nutanix != null) {
            this.nutanix = new ArrayList();
            for (NutanixFailureDomainReference item : nutanix) {
                this.addToNutanix(item);
            }
        } else {
            this.nutanix = null;
        }
        return (A)this;
    }

    public A withNutanix(NutanixFailureDomainReference ... nutanix) {
        if (this.nutanix != null) {
            this.nutanix.clear();
            this._visitables.remove("nutanix");
        }
        if (nutanix != null) {
            for (NutanixFailureDomainReference item : nutanix) {
                this.addToNutanix(item);
            }
        }
        return (A)this;
    }

    public A withOpenstack(List<OpenStackFailureDomain> openstack) {
        if (this.openstack != null) {
            this._visitables.get("openstack").clear();
        }
        if (openstack != null) {
            this.openstack = new ArrayList();
            for (OpenStackFailureDomain item : openstack) {
                this.addToOpenstack(item);
            }
        } else {
            this.openstack = null;
        }
        return (A)this;
    }

    public A withOpenstack(OpenStackFailureDomain ... openstack) {
        if (this.openstack != null) {
            this.openstack.clear();
            this._visitables.remove("openstack");
        }
        if (openstack != null) {
            for (OpenStackFailureDomain item : openstack) {
                this.addToOpenstack(item);
            }
        }
        return (A)this;
    }

    public A withPlatform(String platform) {
        this.platform = platform;
        return (A)this;
    }

    public A withVsphere(List<VSphereFailureDomain> vsphere) {
        if (this.vsphere != null) {
            this._visitables.get("vsphere").clear();
        }
        if (vsphere != null) {
            this.vsphere = new ArrayList();
            for (VSphereFailureDomain item : vsphere) {
                this.addToVsphere(item);
            }
        } else {
            this.vsphere = null;
        }
        return (A)this;
    }

    public A withVsphere(VSphereFailureDomain ... vsphere) {
        if (this.vsphere != null) {
            this.vsphere.clear();
            this._visitables.remove("vsphere");
        }
        if (vsphere != null) {
            for (VSphereFailureDomain item : vsphere) {
                this.addToVsphere(item);
            }
        }
        return (A)this;
    }

    public class VsphereNested<N>
    extends VSphereFailureDomainFluent<VsphereNested<N>>
    implements Nested<N> {
        VSphereFailureDomainBuilder builder;
        int index;

        VsphereNested(int index, VSphereFailureDomain item) {
            this.index = index;
            this.builder = new VSphereFailureDomainBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)FailureDomainsFluent.this.setToVsphere(this.index, this.builder.build());
        }

        public N endVsphere() {
            return this.and();
        }
    }

    public class OpenstackNested<N>
    extends OpenStackFailureDomainFluent<OpenstackNested<N>>
    implements Nested<N> {
        OpenStackFailureDomainBuilder builder;
        int index;

        OpenstackNested(int index, OpenStackFailureDomain item) {
            this.index = index;
            this.builder = new OpenStackFailureDomainBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)FailureDomainsFluent.this.setToOpenstack(this.index, this.builder.build());
        }

        public N endOpenstack() {
            return this.and();
        }
    }

    public class NutanixNested<N>
    extends NutanixFailureDomainReferenceFluent<NutanixNested<N>>
    implements Nested<N> {
        NutanixFailureDomainReferenceBuilder builder;
        int index;

        NutanixNested(int index, NutanixFailureDomainReference item) {
            this.index = index;
            this.builder = new NutanixFailureDomainReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)FailureDomainsFluent.this.setToNutanix(this.index, this.builder.build());
        }

        public N endNutanix() {
            return this.and();
        }
    }

    public class GcpNested<N>
    extends GCPFailureDomainFluent<GcpNested<N>>
    implements Nested<N> {
        GCPFailureDomainBuilder builder;
        int index;

        GcpNested(int index, GCPFailureDomain item) {
            this.index = index;
            this.builder = new GCPFailureDomainBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)FailureDomainsFluent.this.setToGcp(this.index, this.builder.build());
        }

        public N endGcp() {
            return this.and();
        }
    }

    public class AzureNested<N>
    extends AzureFailureDomainFluent<AzureNested<N>>
    implements Nested<N> {
        AzureFailureDomainBuilder builder;
        int index;

        AzureNested(int index, AzureFailureDomain item) {
            this.index = index;
            this.builder = new AzureFailureDomainBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)FailureDomainsFluent.this.setToAzure(this.index, this.builder.build());
        }

        public N endAzure() {
            return this.and();
        }
    }

    public class AwsNested<N>
    extends AWSFailureDomainFluent<AwsNested<N>>
    implements Nested<N> {
        AWSFailureDomainBuilder builder;
        int index;

        AwsNested(int index, AWSFailureDomain item) {
            this.index = index;
            this.builder = new AWSFailureDomainBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)FailureDomainsFluent.this.setToAws(this.index, this.builder.build());
        }

        public N endAw() {
            return this.and();
        }
    }
}

