/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.vsphere.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.installer.vsphere.v1.VCenter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class VCenterFluent<A extends VCenterFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private List<String> datacenters = new ArrayList<String>();
    private String password;
    private Integer port;
    private String server;
    private String user;

    public VCenterFluent() {
    }

    public VCenterFluent(VCenter instance) {
        this.copyInstance(instance);
    }

    public A addAllToDatacenters(Collection<String> items) {
        if (this.datacenters == null) {
            this.datacenters = new ArrayList<String>();
        }
        for (String item : items) {
            this.datacenters.add(item);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToDatacenters(String ... items) {
        if (this.datacenters == null) {
            this.datacenters = new ArrayList<String>();
        }
        for (String item : items) {
            this.datacenters.add(item);
        }
        return (A)this;
    }

    public A addToDatacenters(int index, String item) {
        if (this.datacenters == null) {
            this.datacenters = new ArrayList<String>();
        }
        this.datacenters.add(index, item);
        return (A)this;
    }

    protected void copyInstance(VCenter instance) {
        VCenter vCenter = instance = instance != null ? instance : new VCenter();
        if (instance != null) {
            this.withDatacenters(instance.getDatacenters());
            this.withPassword(instance.getPassword());
            this.withPort(instance.getPort());
            this.withServer(instance.getServer());
            this.withUser(instance.getUser());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VCenterFluent that = (VCenterFluent)o;
        if (!Objects.equals(this.datacenters, that.datacenters)) {
            return false;
        }
        if (!Objects.equals(this.password, that.password)) {
            return false;
        }
        if (!Objects.equals(this.port, that.port)) {
            return false;
        }
        if (!Objects.equals(this.server, that.server)) {
            return false;
        }
        if (!Objects.equals(this.user, that.user)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getDatacenter(int index) {
        return this.datacenters.get(index);
    }

    public List<String> getDatacenters() {
        return this.datacenters;
    }

    public String getFirstDatacenter() {
        return this.datacenters.get(0);
    }

    public String getLastDatacenter() {
        return this.datacenters.get(this.datacenters.size() - 1);
    }

    public String getMatchingDatacenter(Predicate<String> predicate) {
        for (String item : this.datacenters) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getPassword() {
        return this.password;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getServer() {
        return this.server;
    }

    public String getUser() {
        return this.user;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasDatacenters() {
        return this.datacenters != null && !this.datacenters.isEmpty();
    }

    public boolean hasMatchingDatacenter(Predicate<String> predicate) {
        for (String item : this.datacenters) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPassword() {
        return this.password != null;
    }

    public boolean hasPort() {
        return this.port != null;
    }

    public boolean hasServer() {
        return this.server != null;
    }

    public boolean hasUser() {
        return this.user != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.datacenters, this.password, this.port, this.server, this.user, this.additionalProperties);
    }

    public A removeAllFromDatacenters(Collection<String> items) {
        if (this.datacenters == null) {
            return (A)this;
        }
        for (String item : items) {
            this.datacenters.remove(item);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public A removeFromDatacenters(String ... items) {
        if (this.datacenters == null) {
            return (A)this;
        }
        for (String item : items) {
            this.datacenters.remove(item);
        }
        return (A)this;
    }

    public A setToDatacenters(int index, String item) {
        if (this.datacenters == null) {
            this.datacenters = new ArrayList<String>();
        }
        this.datacenters.set(index, item);
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.datacenters != null && !this.datacenters.isEmpty()) {
            sb.append("datacenters:");
            sb.append(this.datacenters);
            sb.append(",");
        }
        if (this.password != null) {
            sb.append("password:");
            sb.append(this.password);
            sb.append(",");
        }
        if (this.port != null) {
            sb.append("port:");
            sb.append(this.port);
            sb.append(",");
        }
        if (this.server != null) {
            sb.append("server:");
            sb.append(this.server);
            sb.append(",");
        }
        if (this.user != null) {
            sb.append("user:");
            sb.append(this.user);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withDatacenters(List<String> datacenters) {
        if (datacenters != null) {
            this.datacenters = new ArrayList<String>();
            for (String item : datacenters) {
                this.addToDatacenters(item);
            }
        } else {
            this.datacenters = null;
        }
        return (A)this;
    }

    public A withDatacenters(String ... datacenters) {
        if (this.datacenters != null) {
            this.datacenters.clear();
            this._visitables.remove("datacenters");
        }
        if (datacenters != null) {
            for (String item : datacenters) {
                this.addToDatacenters(item);
            }
        }
        return (A)this;
    }

    public A withPassword(String password) {
        this.password = password;
        return (A)this;
    }

    public A withPort(Integer port) {
        this.port = port;
        return (A)this;
    }

    public A withServer(String server) {
        this.server = server;
        return (A)this;
    }

    public A withUser(String user) {
        this.user = user;
        return (A)this;
    }
}

