/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.vsphere.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.installer.vsphere.v1.DataDisk;
import io.fabric8.openshift.api.model.installer.vsphere.v1.DataDiskBuilder;
import io.fabric8.openshift.api.model.installer.vsphere.v1.DataDiskFluent;
import io.fabric8.openshift.api.model.installer.vsphere.v1.MachinePool;
import io.fabric8.openshift.api.model.installer.vsphere.v1.OSDisk;
import io.fabric8.openshift.api.model.installer.vsphere.v1.OSDiskBuilder;
import io.fabric8.openshift.api.model.installer.vsphere.v1.OSDiskFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class MachinePoolFluent<A extends MachinePoolFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private Integer coresPerSocket;
    private Integer cpus;
    private ArrayList<DataDiskBuilder> dataDisks = new ArrayList();
    private Long memoryMB;
    private OSDiskBuilder osDisk;
    private List<String> zones = new ArrayList<String>();

    public MachinePoolFluent() {
    }

    public MachinePoolFluent(MachinePool instance) {
        this.copyInstance(instance);
    }

    public A addAllToDataDisks(Collection<DataDisk> items) {
        if (this.dataDisks == null) {
            this.dataDisks = new ArrayList();
        }
        for (DataDisk item : items) {
            DataDiskBuilder builder = new DataDiskBuilder(item);
            this._visitables.get("dataDisks").add(builder);
            this.dataDisks.add(builder);
        }
        return (A)this;
    }

    public A addAllToZones(Collection<String> items) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        for (String item : items) {
            this.zones.add(item);
        }
        return (A)this;
    }

    public DataDisksNested<A> addNewDataDisk() {
        return new DataDisksNested(-1, null);
    }

    public A addNewDataDisk(String name, String provisioningMode, Integer sizeGiB) {
        return this.addToDataDisks(new DataDisk(name, provisioningMode, sizeGiB));
    }

    public DataDisksNested<A> addNewDataDiskLike(DataDisk item) {
        return new DataDisksNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToDataDisks(DataDisk ... items) {
        if (this.dataDisks == null) {
            this.dataDisks = new ArrayList();
        }
        for (DataDisk item : items) {
            DataDiskBuilder builder = new DataDiskBuilder(item);
            this._visitables.get("dataDisks").add(builder);
            this.dataDisks.add(builder);
        }
        return (A)this;
    }

    public A addToDataDisks(int index, DataDisk item) {
        if (this.dataDisks == null) {
            this.dataDisks = new ArrayList();
        }
        DataDiskBuilder builder = new DataDiskBuilder(item);
        if (index < 0 || index >= this.dataDisks.size()) {
            this._visitables.get("dataDisks").add(builder);
            this.dataDisks.add(builder);
        } else {
            this._visitables.get("dataDisks").add(builder);
            this.dataDisks.add(index, builder);
        }
        return (A)this;
    }

    public A addToZones(String ... items) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        for (String item : items) {
            this.zones.add(item);
        }
        return (A)this;
    }

    public A addToZones(int index, String item) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        this.zones.add(index, item);
        return (A)this;
    }

    public DataDisk buildDataDisk(int index) {
        return this.dataDisks.get(index).build();
    }

    public List<DataDisk> buildDataDisks() {
        return this.dataDisks != null ? MachinePoolFluent.build(this.dataDisks) : null;
    }

    public DataDisk buildFirstDataDisk() {
        return this.dataDisks.get(0).build();
    }

    public DataDisk buildLastDataDisk() {
        return this.dataDisks.get(this.dataDisks.size() - 1).build();
    }

    public DataDisk buildMatchingDataDisk(Predicate<DataDiskBuilder> predicate) {
        for (DataDiskBuilder item : this.dataDisks) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public OSDisk buildOsDisk() {
        return this.osDisk != null ? this.osDisk.build() : null;
    }

    protected void copyInstance(MachinePool instance) {
        MachinePool machinePool = instance = instance != null ? instance : new MachinePool();
        if (instance != null) {
            this.withCoresPerSocket(instance.getCoresPerSocket());
            this.withCpus(instance.getCpus());
            this.withDataDisks(instance.getDataDisks());
            this.withMemoryMB(instance.getMemoryMB());
            this.withOsDisk(instance.getOsDisk());
            this.withZones(instance.getZones());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public DataDisksNested<A> editDataDisk(int index) {
        if (this.dataDisks.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "dataDisks"));
        }
        return this.setNewDataDiskLike(index, this.buildDataDisk(index));
    }

    public DataDisksNested<A> editFirstDataDisk() {
        if (this.dataDisks.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "dataDisks"));
        }
        return this.setNewDataDiskLike(0, this.buildDataDisk(0));
    }

    public DataDisksNested<A> editLastDataDisk() {
        int index = this.dataDisks.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "dataDisks"));
        }
        return this.setNewDataDiskLike(index, this.buildDataDisk(index));
    }

    public DataDisksNested<A> editMatchingDataDisk(Predicate<DataDiskBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.dataDisks.size(); ++i) {
            if (!predicate.test(this.dataDisks.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "dataDisks"));
        }
        return this.setNewDataDiskLike(index, this.buildDataDisk(index));
    }

    public OsDiskNested<A> editOrNewOsDisk() {
        return this.withNewOsDiskLike(Optional.ofNullable(this.buildOsDisk()).orElse(new OSDiskBuilder().build()));
    }

    public OsDiskNested<A> editOrNewOsDiskLike(OSDisk item) {
        return this.withNewOsDiskLike(Optional.ofNullable(this.buildOsDisk()).orElse(item));
    }

    public OsDiskNested<A> editOsDisk() {
        return this.withNewOsDiskLike(Optional.ofNullable(this.buildOsDisk()).orElse(null));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachinePoolFluent that = (MachinePoolFluent)o;
        if (!Objects.equals(this.coresPerSocket, that.coresPerSocket)) {
            return false;
        }
        if (!Objects.equals(this.cpus, that.cpus)) {
            return false;
        }
        if (!Objects.equals(this.dataDisks, that.dataDisks)) {
            return false;
        }
        if (!Objects.equals(this.memoryMB, that.memoryMB)) {
            return false;
        }
        if (!Objects.equals(this.osDisk, that.osDisk)) {
            return false;
        }
        if (!Objects.equals(this.zones, that.zones)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Integer getCoresPerSocket() {
        return this.coresPerSocket;
    }

    public Integer getCpus() {
        return this.cpus;
    }

    public String getFirstZone() {
        return this.zones.get(0);
    }

    public String getLastZone() {
        return this.zones.get(this.zones.size() - 1);
    }

    public String getMatchingZone(Predicate<String> predicate) {
        for (String item : this.zones) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public Long getMemoryMB() {
        return this.memoryMB;
    }

    public String getZone(int index) {
        return this.zones.get(index);
    }

    public List<String> getZones() {
        return this.zones;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasCoresPerSocket() {
        return this.coresPerSocket != null;
    }

    public boolean hasCpus() {
        return this.cpus != null;
    }

    public boolean hasDataDisks() {
        return this.dataDisks != null && !this.dataDisks.isEmpty();
    }

    public boolean hasMatchingDataDisk(Predicate<DataDiskBuilder> predicate) {
        for (DataDiskBuilder item : this.dataDisks) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingZone(Predicate<String> predicate) {
        for (String item : this.zones) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMemoryMB() {
        return this.memoryMB != null;
    }

    public boolean hasOsDisk() {
        return this.osDisk != null;
    }

    public boolean hasZones() {
        return this.zones != null && !this.zones.isEmpty();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.coresPerSocket, this.cpus, this.dataDisks, this.memoryMB, this.osDisk, this.zones, this.additionalProperties);
    }

    public A removeAllFromDataDisks(Collection<DataDisk> items) {
        if (this.dataDisks == null) {
            return (A)this;
        }
        for (DataDisk item : items) {
            DataDiskBuilder builder = new DataDiskBuilder(item);
            this._visitables.get("dataDisks").remove(builder);
            this.dataDisks.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromZones(Collection<String> items) {
        if (this.zones == null) {
            return (A)this;
        }
        for (String item : items) {
            this.zones.remove(item);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public A removeFromDataDisks(DataDisk ... items) {
        if (this.dataDisks == null) {
            return (A)this;
        }
        for (DataDisk item : items) {
            DataDiskBuilder builder = new DataDiskBuilder(item);
            this._visitables.get("dataDisks").remove(builder);
            this.dataDisks.remove(builder);
        }
        return (A)this;
    }

    public A removeFromZones(String ... items) {
        if (this.zones == null) {
            return (A)this;
        }
        for (String item : items) {
            this.zones.remove(item);
        }
        return (A)this;
    }

    public A removeMatchingFromDataDisks(Predicate<DataDiskBuilder> predicate) {
        if (this.dataDisks == null) {
            return (A)this;
        }
        Iterator<DataDiskBuilder> each = this.dataDisks.iterator();
        Object visitables = this._visitables.get("dataDisks");
        while (each.hasNext()) {
            DataDiskBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public DataDisksNested<A> setNewDataDiskLike(int index, DataDisk item) {
        return new DataDisksNested(index, item);
    }

    public A setToDataDisks(int index, DataDisk item) {
        if (this.dataDisks == null) {
            this.dataDisks = new ArrayList();
        }
        DataDiskBuilder builder = new DataDiskBuilder(item);
        if (index < 0 || index >= this.dataDisks.size()) {
            this._visitables.get("dataDisks").add(builder);
            this.dataDisks.add(builder);
        } else {
            this._visitables.get("dataDisks").add(builder);
            this.dataDisks.set(index, builder);
        }
        return (A)this;
    }

    public A setToZones(int index, String item) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        this.zones.set(index, item);
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.coresPerSocket != null) {
            sb.append("coresPerSocket:");
            sb.append(this.coresPerSocket);
            sb.append(",");
        }
        if (this.cpus != null) {
            sb.append("cpus:");
            sb.append(this.cpus);
            sb.append(",");
        }
        if (this.dataDisks != null && !this.dataDisks.isEmpty()) {
            sb.append("dataDisks:");
            sb.append(this.dataDisks);
            sb.append(",");
        }
        if (this.memoryMB != null) {
            sb.append("memoryMB:");
            sb.append(this.memoryMB);
            sb.append(",");
        }
        if (this.osDisk != null) {
            sb.append("osDisk:");
            sb.append(this.osDisk);
            sb.append(",");
        }
        if (this.zones != null && !this.zones.isEmpty()) {
            sb.append("zones:");
            sb.append(this.zones);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withCoresPerSocket(Integer coresPerSocket) {
        this.coresPerSocket = coresPerSocket;
        return (A)this;
    }

    public A withCpus(Integer cpus) {
        this.cpus = cpus;
        return (A)this;
    }

    public A withDataDisks(List<DataDisk> dataDisks) {
        if (this.dataDisks != null) {
            this._visitables.get("dataDisks").clear();
        }
        if (dataDisks != null) {
            this.dataDisks = new ArrayList();
            for (DataDisk item : dataDisks) {
                this.addToDataDisks(item);
            }
        } else {
            this.dataDisks = null;
        }
        return (A)this;
    }

    public A withDataDisks(DataDisk ... dataDisks) {
        if (this.dataDisks != null) {
            this.dataDisks.clear();
            this._visitables.remove("dataDisks");
        }
        if (dataDisks != null) {
            for (DataDisk item : dataDisks) {
                this.addToDataDisks(item);
            }
        }
        return (A)this;
    }

    public A withMemoryMB(Long memoryMB) {
        this.memoryMB = memoryMB;
        return (A)this;
    }

    public OsDiskNested<A> withNewOsDisk() {
        return new OsDiskNested(null);
    }

    public A withNewOsDisk(Integer diskSizeGB) {
        return this.withOsDisk(new OSDisk(diskSizeGB));
    }

    public OsDiskNested<A> withNewOsDiskLike(OSDisk item) {
        return new OsDiskNested(item);
    }

    public A withOsDisk(OSDisk osDisk) {
        this._visitables.remove("osDisk");
        if (osDisk != null) {
            this.osDisk = new OSDiskBuilder(osDisk);
            this._visitables.get("osDisk").add(this.osDisk);
        } else {
            this.osDisk = null;
            this._visitables.get("osDisk").remove(this.osDisk);
        }
        return (A)this;
    }

    public A withZones(List<String> zones) {
        if (zones != null) {
            this.zones = new ArrayList<String>();
            for (String item : zones) {
                this.addToZones(item);
            }
        } else {
            this.zones = null;
        }
        return (A)this;
    }

    public A withZones(String ... zones) {
        if (this.zones != null) {
            this.zones.clear();
            this._visitables.remove("zones");
        }
        if (zones != null) {
            for (String item : zones) {
                this.addToZones(item);
            }
        }
        return (A)this;
    }

    public class OsDiskNested<N>
    extends OSDiskFluent<OsDiskNested<N>>
    implements Nested<N> {
        OSDiskBuilder builder;

        OsDiskNested(OSDisk item) {
            this.builder = new OSDiskBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)MachinePoolFluent.this.withOsDisk(this.builder.build());
        }

        public N endOsDisk() {
            return this.and();
        }
    }

    public class DataDisksNested<N>
    extends DataDiskFluent<DataDisksNested<N>>
    implements Nested<N> {
        DataDiskBuilder builder;
        int index;

        DataDisksNested(int index, DataDisk item) {
            this.index = index;
            this.builder = new DataDiskBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)MachinePoolFluent.this.setToDataDisks(this.index, this.builder.build());
        }

        public N endDataDisk() {
            return this.and();
        }
    }
}

