/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.powervs.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import io.fabric8.kubernetes.api.model.IntOrStringFluent;
import io.fabric8.openshift.api.model.installer.powervs.v1.MachinePool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class MachinePoolFluent<A extends MachinePoolFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private Integer memoryGiB;
    private String procType;
    private IntOrStringBuilder processors;
    private String smtLevel;
    private String sysType;
    private List<String> volumeIDs = new ArrayList<String>();

    public MachinePoolFluent() {
    }

    public MachinePoolFluent(MachinePool instance) {
        this.copyInstance(instance);
    }

    public A addAllToVolumeIDs(Collection<String> items) {
        if (this.volumeIDs == null) {
            this.volumeIDs = new ArrayList<String>();
        }
        for (String item : items) {
            this.volumeIDs.add(item);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToVolumeIDs(String ... items) {
        if (this.volumeIDs == null) {
            this.volumeIDs = new ArrayList<String>();
        }
        for (String item : items) {
            this.volumeIDs.add(item);
        }
        return (A)this;
    }

    public A addToVolumeIDs(int index, String item) {
        if (this.volumeIDs == null) {
            this.volumeIDs = new ArrayList<String>();
        }
        this.volumeIDs.add(index, item);
        return (A)this;
    }

    public IntOrString buildProcessors() {
        return this.processors != null ? this.processors.build() : null;
    }

    protected void copyInstance(MachinePool instance) {
        MachinePool machinePool = instance = instance != null ? instance : new MachinePool();
        if (instance != null) {
            this.withMemoryGiB(instance.getMemoryGiB());
            this.withProcType(instance.getProcType());
            this.withProcessors(instance.getProcessors());
            this.withSmtLevel(instance.getSmtLevel());
            this.withSysType(instance.getSysType());
            this.withVolumeIDs(instance.getVolumeIDs());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ProcessorsNested<A> editOrNewProcessors() {
        return this.withNewProcessorsLike(Optional.ofNullable(this.buildProcessors()).orElse(new IntOrStringBuilder().build()));
    }

    public ProcessorsNested<A> editOrNewProcessorsLike(IntOrString item) {
        return this.withNewProcessorsLike(Optional.ofNullable(this.buildProcessors()).orElse(item));
    }

    public ProcessorsNested<A> editProcessors() {
        return this.withNewProcessorsLike(Optional.ofNullable(this.buildProcessors()).orElse(null));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachinePoolFluent that = (MachinePoolFluent)o;
        if (!Objects.equals(this.memoryGiB, that.memoryGiB)) {
            return false;
        }
        if (!Objects.equals(this.procType, that.procType)) {
            return false;
        }
        if (!Objects.equals(this.processors, that.processors)) {
            return false;
        }
        if (!Objects.equals(this.smtLevel, that.smtLevel)) {
            return false;
        }
        if (!Objects.equals(this.sysType, that.sysType)) {
            return false;
        }
        if (!Objects.equals(this.volumeIDs, that.volumeIDs)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getFirstVolumeID() {
        return this.volumeIDs.get(0);
    }

    public String getLastVolumeID() {
        return this.volumeIDs.get(this.volumeIDs.size() - 1);
    }

    public String getMatchingVolumeID(Predicate<String> predicate) {
        for (String item : this.volumeIDs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public Integer getMemoryGiB() {
        return this.memoryGiB;
    }

    public String getProcType() {
        return this.procType;
    }

    public String getSmtLevel() {
        return this.smtLevel;
    }

    public String getSysType() {
        return this.sysType;
    }

    public String getVolumeID(int index) {
        return this.volumeIDs.get(index);
    }

    public List<String> getVolumeIDs() {
        return this.volumeIDs;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasMatchingVolumeID(Predicate<String> predicate) {
        for (String item : this.volumeIDs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMemoryGiB() {
        return this.memoryGiB != null;
    }

    public boolean hasProcType() {
        return this.procType != null;
    }

    public boolean hasProcessors() {
        return this.processors != null;
    }

    public boolean hasSmtLevel() {
        return this.smtLevel != null;
    }

    public boolean hasSysType() {
        return this.sysType != null;
    }

    public boolean hasVolumeIDs() {
        return this.volumeIDs != null && !this.volumeIDs.isEmpty();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.memoryGiB, this.procType, this.processors, this.smtLevel, this.sysType, this.volumeIDs, this.additionalProperties);
    }

    public A removeAllFromVolumeIDs(Collection<String> items) {
        if (this.volumeIDs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.volumeIDs.remove(item);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public A removeFromVolumeIDs(String ... items) {
        if (this.volumeIDs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.volumeIDs.remove(item);
        }
        return (A)this;
    }

    public A setToVolumeIDs(int index, String item) {
        if (this.volumeIDs == null) {
            this.volumeIDs = new ArrayList<String>();
        }
        this.volumeIDs.set(index, item);
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.memoryGiB != null) {
            sb.append("memoryGiB:");
            sb.append(this.memoryGiB);
            sb.append(",");
        }
        if (this.procType != null) {
            sb.append("procType:");
            sb.append(this.procType);
            sb.append(",");
        }
        if (this.processors != null) {
            sb.append("processors:");
            sb.append(this.processors);
            sb.append(",");
        }
        if (this.smtLevel != null) {
            sb.append("smtLevel:");
            sb.append(this.smtLevel);
            sb.append(",");
        }
        if (this.sysType != null) {
            sb.append("sysType:");
            sb.append(this.sysType);
            sb.append(",");
        }
        if (this.volumeIDs != null && !this.volumeIDs.isEmpty()) {
            sb.append("volumeIDs:");
            sb.append(this.volumeIDs);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withMemoryGiB(Integer memoryGiB) {
        this.memoryGiB = memoryGiB;
        return (A)this;
    }

    public ProcessorsNested<A> withNewProcessors() {
        return new ProcessorsNested(null);
    }

    public A withNewProcessors(Object value) {
        return this.withProcessors(new IntOrString(value));
    }

    public ProcessorsNested<A> withNewProcessorsLike(IntOrString item) {
        return new ProcessorsNested(item);
    }

    public A withProcType(String procType) {
        this.procType = procType;
        return (A)this;
    }

    public A withProcessors(IntOrString processors) {
        this._visitables.remove("processors");
        if (processors != null) {
            this.processors = new IntOrStringBuilder(processors);
            this._visitables.get("processors").add(this.processors);
        } else {
            this.processors = null;
            this._visitables.get("processors").remove(this.processors);
        }
        return (A)this;
    }

    public A withSmtLevel(String smtLevel) {
        this.smtLevel = smtLevel;
        return (A)this;
    }

    public A withSysType(String sysType) {
        this.sysType = sysType;
        return (A)this;
    }

    public A withVolumeIDs(List<String> volumeIDs) {
        if (volumeIDs != null) {
            this.volumeIDs = new ArrayList<String>();
            for (String item : volumeIDs) {
                this.addToVolumeIDs(item);
            }
        } else {
            this.volumeIDs = null;
        }
        return (A)this;
    }

    public A withVolumeIDs(String ... volumeIDs) {
        if (this.volumeIDs != null) {
            this.volumeIDs.clear();
            this._visitables.remove("volumeIDs");
        }
        if (volumeIDs != null) {
            for (String item : volumeIDs) {
                this.addToVolumeIDs(item);
            }
        }
        return (A)this;
    }

    public class ProcessorsNested<N>
    extends IntOrStringFluent<ProcessorsNested<N>>
    implements Nested<N> {
        IntOrStringBuilder builder;

        ProcessorsNested(IntOrString item) {
            this.builder = new IntOrStringBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)MachinePoolFluent.this.withProcessors(this.builder.build());
        }

        public N endProcessors() {
            return this.and();
        }
    }
}

