/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.gcp.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.installer.gcp.v1.Metadata;
import io.fabric8.openshift.api.model.installer.gcp.v1.PSCEndpoint;
import io.fabric8.openshift.api.model.installer.gcp.v1.PSCEndpointBuilder;
import io.fabric8.openshift.api.model.installer.gcp.v1.PSCEndpointFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class MetadataFluent<A extends MetadataFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private PSCEndpointBuilder endpoint;
    private String firewallRulesManagement;
    private String networkProjectID;
    private String privateZoneDomain;
    private String privateZoneProjectID;
    private String projectID;
    private String region;

    public MetadataFluent() {
    }

    public MetadataFluent(Metadata instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public PSCEndpoint buildEndpoint() {
        return this.endpoint != null ? this.endpoint.build() : null;
    }

    protected void copyInstance(Metadata instance) {
        Metadata metadata = instance = instance != null ? instance : new Metadata();
        if (instance != null) {
            this.withEndpoint(instance.getEndpoint());
            this.withFirewallRulesManagement(instance.getFirewallRulesManagement());
            this.withNetworkProjectID(instance.getNetworkProjectID());
            this.withPrivateZoneDomain(instance.getPrivateZoneDomain());
            this.withPrivateZoneProjectID(instance.getPrivateZoneProjectID());
            this.withProjectID(instance.getProjectID());
            this.withRegion(instance.getRegion());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public EndpointNested<A> editEndpoint() {
        return this.withNewEndpointLike(Optional.ofNullable(this.buildEndpoint()).orElse(null));
    }

    public EndpointNested<A> editOrNewEndpoint() {
        return this.withNewEndpointLike(Optional.ofNullable(this.buildEndpoint()).orElse(new PSCEndpointBuilder().build()));
    }

    public EndpointNested<A> editOrNewEndpointLike(PSCEndpoint item) {
        return this.withNewEndpointLike(Optional.ofNullable(this.buildEndpoint()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MetadataFluent that = (MetadataFluent)o;
        if (!Objects.equals(this.endpoint, that.endpoint)) {
            return false;
        }
        if (!Objects.equals(this.firewallRulesManagement, that.firewallRulesManagement)) {
            return false;
        }
        if (!Objects.equals(this.networkProjectID, that.networkProjectID)) {
            return false;
        }
        if (!Objects.equals(this.privateZoneDomain, that.privateZoneDomain)) {
            return false;
        }
        if (!Objects.equals(this.privateZoneProjectID, that.privateZoneProjectID)) {
            return false;
        }
        if (!Objects.equals(this.projectID, that.projectID)) {
            return false;
        }
        if (!Objects.equals(this.region, that.region)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getFirewallRulesManagement() {
        return this.firewallRulesManagement;
    }

    public String getNetworkProjectID() {
        return this.networkProjectID;
    }

    public String getPrivateZoneDomain() {
        return this.privateZoneDomain;
    }

    public String getPrivateZoneProjectID() {
        return this.privateZoneProjectID;
    }

    public String getProjectID() {
        return this.projectID;
    }

    public String getRegion() {
        return this.region;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasEndpoint() {
        return this.endpoint != null;
    }

    public boolean hasFirewallRulesManagement() {
        return this.firewallRulesManagement != null;
    }

    public boolean hasNetworkProjectID() {
        return this.networkProjectID != null;
    }

    public boolean hasPrivateZoneDomain() {
        return this.privateZoneDomain != null;
    }

    public boolean hasPrivateZoneProjectID() {
        return this.privateZoneProjectID != null;
    }

    public boolean hasProjectID() {
        return this.projectID != null;
    }

    public boolean hasRegion() {
        return this.region != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.endpoint, this.firewallRulesManagement, this.networkProjectID, this.privateZoneDomain, this.privateZoneProjectID, this.projectID, this.region, this.additionalProperties);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.endpoint != null) {
            sb.append("endpoint:");
            sb.append(this.endpoint);
            sb.append(",");
        }
        if (this.firewallRulesManagement != null) {
            sb.append("firewallRulesManagement:");
            sb.append(this.firewallRulesManagement);
            sb.append(",");
        }
        if (this.networkProjectID != null) {
            sb.append("networkProjectID:");
            sb.append(this.networkProjectID);
            sb.append(",");
        }
        if (this.privateZoneDomain != null) {
            sb.append("privateZoneDomain:");
            sb.append(this.privateZoneDomain);
            sb.append(",");
        }
        if (this.privateZoneProjectID != null) {
            sb.append("privateZoneProjectID:");
            sb.append(this.privateZoneProjectID);
            sb.append(",");
        }
        if (this.projectID != null) {
            sb.append("projectID:");
            sb.append(this.projectID);
            sb.append(",");
        }
        if (this.region != null) {
            sb.append("region:");
            sb.append(this.region);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withEndpoint(PSCEndpoint endpoint) {
        this._visitables.remove("endpoint");
        if (endpoint != null) {
            this.endpoint = new PSCEndpointBuilder(endpoint);
            this._visitables.get("endpoint").add(this.endpoint);
        } else {
            this.endpoint = null;
            this._visitables.get("endpoint").remove(this.endpoint);
        }
        return (A)this;
    }

    public A withFirewallRulesManagement(String firewallRulesManagement) {
        this.firewallRulesManagement = firewallRulesManagement;
        return (A)this;
    }

    public A withNetworkProjectID(String networkProjectID) {
        this.networkProjectID = networkProjectID;
        return (A)this;
    }

    public EndpointNested<A> withNewEndpoint() {
        return new EndpointNested(null);
    }

    public A withNewEndpoint(Boolean clusterUseOnly, String name, String region) {
        return this.withEndpoint(new PSCEndpoint(clusterUseOnly, name, region));
    }

    public EndpointNested<A> withNewEndpointLike(PSCEndpoint item) {
        return new EndpointNested(item);
    }

    public A withPrivateZoneDomain(String privateZoneDomain) {
        this.privateZoneDomain = privateZoneDomain;
        return (A)this;
    }

    public A withPrivateZoneProjectID(String privateZoneProjectID) {
        this.privateZoneProjectID = privateZoneProjectID;
        return (A)this;
    }

    public A withProjectID(String projectID) {
        this.projectID = projectID;
        return (A)this;
    }

    public A withRegion(String region) {
        this.region = region;
        return (A)this;
    }

    public class EndpointNested<N>
    extends PSCEndpointFluent<EndpointNested<N>>
    implements Nested<N> {
        PSCEndpointBuilder builder;

        EndpointNested(PSCEndpoint item) {
            this.builder = new PSCEndpointBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)MetadataFluent.this.withEndpoint(this.builder.build());
        }

        public N endEndpoint() {
            return this.and();
        }
    }
}

