/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.gcp.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.installer.gcp.v1.DNS;
import io.fabric8.openshift.api.model.installer.gcp.v1.DNSZone;
import io.fabric8.openshift.api.model.installer.gcp.v1.DNSZoneBuilder;
import io.fabric8.openshift.api.model.installer.gcp.v1.DNSZoneFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DNSFluent<A extends DNSFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private DNSZoneBuilder privateZone;

    public DNSFluent() {
    }

    public DNSFluent(DNS instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public DNSZone buildPrivateZone() {
        return this.privateZone != null ? this.privateZone.build() : null;
    }

    protected void copyInstance(DNS instance) {
        DNS dNS = instance = instance != null ? instance : new DNS();
        if (instance != null) {
            this.withPrivateZone(instance.getPrivateZone());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public PrivateZoneNested<A> editOrNewPrivateZone() {
        return this.withNewPrivateZoneLike(Optional.ofNullable(this.buildPrivateZone()).orElse(new DNSZoneBuilder().build()));
    }

    public PrivateZoneNested<A> editOrNewPrivateZoneLike(DNSZone item) {
        return this.withNewPrivateZoneLike(Optional.ofNullable(this.buildPrivateZone()).orElse(item));
    }

    public PrivateZoneNested<A> editPrivateZone() {
        return this.withNewPrivateZoneLike(Optional.ofNullable(this.buildPrivateZone()).orElse(null));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DNSFluent that = (DNSFluent)o;
        if (!Objects.equals(this.privateZone, that.privateZone)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasPrivateZone() {
        return this.privateZone != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.privateZone, this.additionalProperties);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.privateZone != null) {
            sb.append("privateZone:");
            sb.append(this.privateZone);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public PrivateZoneNested<A> withNewPrivateZone() {
        return new PrivateZoneNested(null);
    }

    public A withNewPrivateZone(String name, String projectID) {
        return this.withPrivateZone(new DNSZone(name, projectID));
    }

    public PrivateZoneNested<A> withNewPrivateZoneLike(DNSZone item) {
        return new PrivateZoneNested(item);
    }

    public A withPrivateZone(DNSZone privateZone) {
        this._visitables.remove("privateZone");
        if (privateZone != null) {
            this.privateZone = new DNSZoneBuilder(privateZone);
            this._visitables.get("privateZone").add(this.privateZone);
        } else {
            this.privateZone = null;
            this._visitables.get("privateZone").remove(this.privateZone);
        }
        return (A)this;
    }

    public class PrivateZoneNested<N>
    extends DNSZoneFluent<PrivateZoneNested<N>>
    implements Nested<N> {
        DNSZoneBuilder builder;

        PrivateZoneNested(DNSZone item) {
            this.builder = new DNSZoneBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)DNSFluent.this.withPrivateZone(this.builder.build());
        }

        public N endPrivateZone() {
            return this.and();
        }
    }
}

