/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.gcp.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.hive.gcp.v1.ServiceAttachment;
import io.fabric8.openshift.api.model.hive.gcp.v1.ServiceAttachmentSubnet;
import io.fabric8.openshift.api.model.hive.gcp.v1.ServiceAttachmentSubnetBuilder;
import io.fabric8.openshift.api.model.hive.gcp.v1.ServiceAttachmentSubnetFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ServiceAttachmentFluent<A extends ServiceAttachmentFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ServiceAttachmentSubnetBuilder subnet;

    public ServiceAttachmentFluent() {
    }

    public ServiceAttachmentFluent(ServiceAttachment instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public ServiceAttachmentSubnet buildSubnet() {
        return this.subnet != null ? this.subnet.build() : null;
    }

    protected void copyInstance(ServiceAttachment instance) {
        ServiceAttachment serviceAttachment = instance = instance != null ? instance : new ServiceAttachment();
        if (instance != null) {
            this.withSubnet(instance.getSubnet());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public SubnetNested<A> editOrNewSubnet() {
        return this.withNewSubnetLike(Optional.ofNullable(this.buildSubnet()).orElse(new ServiceAttachmentSubnetBuilder().build()));
    }

    public SubnetNested<A> editOrNewSubnetLike(ServiceAttachmentSubnet item) {
        return this.withNewSubnetLike(Optional.ofNullable(this.buildSubnet()).orElse(item));
    }

    public SubnetNested<A> editSubnet() {
        return this.withNewSubnetLike(Optional.ofNullable(this.buildSubnet()).orElse(null));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceAttachmentFluent that = (ServiceAttachmentFluent)o;
        if (!Objects.equals(this.subnet, that.subnet)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasSubnet() {
        return this.subnet != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.subnet, this.additionalProperties);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.subnet != null) {
            sb.append("subnet:");
            sb.append(this.subnet);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public SubnetNested<A> withNewSubnet() {
        return new SubnetNested(null);
    }

    public SubnetNested<A> withNewSubnetLike(ServiceAttachmentSubnet item) {
        return new SubnetNested(item);
    }

    public A withSubnet(ServiceAttachmentSubnet subnet) {
        this._visitables.remove("subnet");
        if (subnet != null) {
            this.subnet = new ServiceAttachmentSubnetBuilder(subnet);
            this._visitables.get("subnet").add(this.subnet);
        } else {
            this.subnet = null;
            this._visitables.get("subnet").remove(this.subnet);
        }
        return (A)this;
    }

    public class SubnetNested<N>
    extends ServiceAttachmentSubnetFluent<SubnetNested<N>>
    implements Nested<N> {
        ServiceAttachmentSubnetBuilder builder;

        SubnetNested(ServiceAttachmentSubnet item) {
            this.builder = new ServiceAttachmentSubnetBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ServiceAttachmentFluent.this.withSubnet(this.builder.build());
        }

        public N endSubnet() {
            return this.and();
        }
    }
}

