/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.gcp.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.hive.gcp.v1.PrivateServiceConnect;
import io.fabric8.openshift.api.model.hive.gcp.v1.ServiceAttachment;
import io.fabric8.openshift.api.model.hive.gcp.v1.ServiceAttachmentBuilder;
import io.fabric8.openshift.api.model.hive.gcp.v1.ServiceAttachmentFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PrivateServiceConnectFluent<A extends PrivateServiceConnectFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private Boolean enabled;
    private ServiceAttachmentBuilder serviceAttachment;

    public PrivateServiceConnectFluent() {
    }

    public PrivateServiceConnectFluent(PrivateServiceConnect instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public ServiceAttachment buildServiceAttachment() {
        return this.serviceAttachment != null ? this.serviceAttachment.build() : null;
    }

    protected void copyInstance(PrivateServiceConnect instance) {
        PrivateServiceConnect privateServiceConnect = instance = instance != null ? instance : new PrivateServiceConnect();
        if (instance != null) {
            this.withEnabled(instance.getEnabled());
            this.withServiceAttachment(instance.getServiceAttachment());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ServiceAttachmentNested<A> editOrNewServiceAttachment() {
        return this.withNewServiceAttachmentLike(Optional.ofNullable(this.buildServiceAttachment()).orElse(new ServiceAttachmentBuilder().build()));
    }

    public ServiceAttachmentNested<A> editOrNewServiceAttachmentLike(ServiceAttachment item) {
        return this.withNewServiceAttachmentLike(Optional.ofNullable(this.buildServiceAttachment()).orElse(item));
    }

    public ServiceAttachmentNested<A> editServiceAttachment() {
        return this.withNewServiceAttachmentLike(Optional.ofNullable(this.buildServiceAttachment()).orElse(null));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PrivateServiceConnectFluent that = (PrivateServiceConnectFluent)o;
        if (!Objects.equals(this.enabled, that.enabled)) {
            return false;
        }
        if (!Objects.equals(this.serviceAttachment, that.serviceAttachment)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasEnabled() {
        return this.enabled != null;
    }

    public boolean hasServiceAttachment() {
        return this.serviceAttachment != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.enabled, this.serviceAttachment, this.additionalProperties);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.enabled != null) {
            sb.append("enabled:");
            sb.append(this.enabled);
            sb.append(",");
        }
        if (this.serviceAttachment != null) {
            sb.append("serviceAttachment:");
            sb.append(this.serviceAttachment);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withEnabled() {
        return this.withEnabled(true);
    }

    public A withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return (A)this;
    }

    public ServiceAttachmentNested<A> withNewServiceAttachment() {
        return new ServiceAttachmentNested(null);
    }

    public ServiceAttachmentNested<A> withNewServiceAttachmentLike(ServiceAttachment item) {
        return new ServiceAttachmentNested(item);
    }

    public A withServiceAttachment(ServiceAttachment serviceAttachment) {
        this._visitables.remove("serviceAttachment");
        if (serviceAttachment != null) {
            this.serviceAttachment = new ServiceAttachmentBuilder(serviceAttachment);
            this._visitables.get("serviceAttachment").add(this.serviceAttachment);
        } else {
            this.serviceAttachment = null;
            this._visitables.get("serviceAttachment").remove(this.serviceAttachment);
        }
        return (A)this;
    }

    public class ServiceAttachmentNested<N>
    extends ServiceAttachmentFluent<ServiceAttachmentNested<N>>
    implements Nested<N> {
        ServiceAttachmentBuilder builder;

        ServiceAttachmentNested(ServiceAttachment item) {
            this.builder = new ServiceAttachmentBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PrivateServiceConnectFluent.this.withServiceAttachment(this.builder.build());
        }

        public N endServiceAttachment() {
            return this.and();
        }
    }
}

