/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.gcp.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.hive.gcp.v1.MachinePool;
import io.fabric8.openshift.api.model.hive.gcp.v1.OSDisk;
import io.fabric8.openshift.api.model.hive.gcp.v1.OSDiskBuilder;
import io.fabric8.openshift.api.model.hive.gcp.v1.OSDiskFluent;
import io.fabric8.openshift.api.model.hive.gcp.v1.UserTag;
import io.fabric8.openshift.api.model.hive.gcp.v1.UserTagBuilder;
import io.fabric8.openshift.api.model.hive.gcp.v1.UserTagFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class MachinePoolFluent<A extends MachinePoolFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String networkProjectID;
    private String onHostMaintenance;
    private OSDiskBuilder osDisk;
    private String secureBoot;
    private String serviceAccount;
    private String type;
    private ArrayList<UserTagBuilder> userTags = new ArrayList();
    private List<String> zones = new ArrayList<String>();

    public MachinePoolFluent() {
    }

    public MachinePoolFluent(MachinePool instance) {
        this.copyInstance(instance);
    }

    public A addAllToUserTags(Collection<UserTag> items) {
        if (this.userTags == null) {
            this.userTags = new ArrayList();
        }
        for (UserTag item : items) {
            UserTagBuilder builder = new UserTagBuilder(item);
            this._visitables.get("userTags").add(builder);
            this.userTags.add(builder);
        }
        return (A)this;
    }

    public A addAllToZones(Collection<String> items) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        for (String item : items) {
            this.zones.add(item);
        }
        return (A)this;
    }

    public UserTagsNested<A> addNewUserTag() {
        return new UserTagsNested(-1, null);
    }

    public A addNewUserTag(String key, String parentID, String value) {
        return this.addToUserTags(new UserTag(key, parentID, value));
    }

    public UserTagsNested<A> addNewUserTagLike(UserTag item) {
        return new UserTagsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToUserTags(UserTag ... items) {
        if (this.userTags == null) {
            this.userTags = new ArrayList();
        }
        for (UserTag item : items) {
            UserTagBuilder builder = new UserTagBuilder(item);
            this._visitables.get("userTags").add(builder);
            this.userTags.add(builder);
        }
        return (A)this;
    }

    public A addToUserTags(int index, UserTag item) {
        if (this.userTags == null) {
            this.userTags = new ArrayList();
        }
        UserTagBuilder builder = new UserTagBuilder(item);
        if (index < 0 || index >= this.userTags.size()) {
            this._visitables.get("userTags").add(builder);
            this.userTags.add(builder);
        } else {
            this._visitables.get("userTags").add(builder);
            this.userTags.add(index, builder);
        }
        return (A)this;
    }

    public A addToZones(String ... items) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        for (String item : items) {
            this.zones.add(item);
        }
        return (A)this;
    }

    public A addToZones(int index, String item) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        this.zones.add(index, item);
        return (A)this;
    }

    public UserTag buildFirstUserTag() {
        return this.userTags.get(0).build();
    }

    public UserTag buildLastUserTag() {
        return this.userTags.get(this.userTags.size() - 1).build();
    }

    public UserTag buildMatchingUserTag(Predicate<UserTagBuilder> predicate) {
        for (UserTagBuilder item : this.userTags) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public OSDisk buildOsDisk() {
        return this.osDisk != null ? this.osDisk.build() : null;
    }

    public UserTag buildUserTag(int index) {
        return this.userTags.get(index).build();
    }

    public List<UserTag> buildUserTags() {
        return this.userTags != null ? MachinePoolFluent.build(this.userTags) : null;
    }

    protected void copyInstance(MachinePool instance) {
        MachinePool machinePool = instance = instance != null ? instance : new MachinePool();
        if (instance != null) {
            this.withNetworkProjectID(instance.getNetworkProjectID());
            this.withOnHostMaintenance(instance.getOnHostMaintenance());
            this.withOsDisk(instance.getOsDisk());
            this.withSecureBoot(instance.getSecureBoot());
            this.withServiceAccount(instance.getServiceAccount());
            this.withType(instance.getType());
            this.withUserTags(instance.getUserTags());
            this.withZones(instance.getZones());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public UserTagsNested<A> editFirstUserTag() {
        if (this.userTags.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "userTags"));
        }
        return this.setNewUserTagLike(0, this.buildUserTag(0));
    }

    public UserTagsNested<A> editLastUserTag() {
        int index = this.userTags.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "userTags"));
        }
        return this.setNewUserTagLike(index, this.buildUserTag(index));
    }

    public UserTagsNested<A> editMatchingUserTag(Predicate<UserTagBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.userTags.size(); ++i) {
            if (!predicate.test(this.userTags.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "userTags"));
        }
        return this.setNewUserTagLike(index, this.buildUserTag(index));
    }

    public OsDiskNested<A> editOrNewOsDisk() {
        return this.withNewOsDiskLike(Optional.ofNullable(this.buildOsDisk()).orElse(new OSDiskBuilder().build()));
    }

    public OsDiskNested<A> editOrNewOsDiskLike(OSDisk item) {
        return this.withNewOsDiskLike(Optional.ofNullable(this.buildOsDisk()).orElse(item));
    }

    public OsDiskNested<A> editOsDisk() {
        return this.withNewOsDiskLike(Optional.ofNullable(this.buildOsDisk()).orElse(null));
    }

    public UserTagsNested<A> editUserTag(int index) {
        if (this.userTags.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "userTags"));
        }
        return this.setNewUserTagLike(index, this.buildUserTag(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachinePoolFluent that = (MachinePoolFluent)o;
        if (!Objects.equals(this.networkProjectID, that.networkProjectID)) {
            return false;
        }
        if (!Objects.equals(this.onHostMaintenance, that.onHostMaintenance)) {
            return false;
        }
        if (!Objects.equals(this.osDisk, that.osDisk)) {
            return false;
        }
        if (!Objects.equals(this.secureBoot, that.secureBoot)) {
            return false;
        }
        if (!Objects.equals(this.serviceAccount, that.serviceAccount)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        if (!Objects.equals(this.userTags, that.userTags)) {
            return false;
        }
        if (!Objects.equals(this.zones, that.zones)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getFirstZone() {
        return this.zones.get(0);
    }

    public String getLastZone() {
        return this.zones.get(this.zones.size() - 1);
    }

    public String getMatchingZone(Predicate<String> predicate) {
        for (String item : this.zones) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getNetworkProjectID() {
        return this.networkProjectID;
    }

    public String getOnHostMaintenance() {
        return this.onHostMaintenance;
    }

    public String getSecureBoot() {
        return this.secureBoot;
    }

    public String getServiceAccount() {
        return this.serviceAccount;
    }

    public String getType() {
        return this.type;
    }

    public String getZone(int index) {
        return this.zones.get(index);
    }

    public List<String> getZones() {
        return this.zones;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasMatchingUserTag(Predicate<UserTagBuilder> predicate) {
        for (UserTagBuilder item : this.userTags) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingZone(Predicate<String> predicate) {
        for (String item : this.zones) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNetworkProjectID() {
        return this.networkProjectID != null;
    }

    public boolean hasOnHostMaintenance() {
        return this.onHostMaintenance != null;
    }

    public boolean hasOsDisk() {
        return this.osDisk != null;
    }

    public boolean hasSecureBoot() {
        return this.secureBoot != null;
    }

    public boolean hasServiceAccount() {
        return this.serviceAccount != null;
    }

    public boolean hasType() {
        return this.type != null;
    }

    public boolean hasUserTags() {
        return this.userTags != null && !this.userTags.isEmpty();
    }

    public boolean hasZones() {
        return this.zones != null && !this.zones.isEmpty();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.networkProjectID, this.onHostMaintenance, this.osDisk, this.secureBoot, this.serviceAccount, this.type, this.userTags, this.zones, this.additionalProperties);
    }

    public A removeAllFromUserTags(Collection<UserTag> items) {
        if (this.userTags == null) {
            return (A)this;
        }
        for (UserTag item : items) {
            UserTagBuilder builder = new UserTagBuilder(item);
            this._visitables.get("userTags").remove(builder);
            this.userTags.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromZones(Collection<String> items) {
        if (this.zones == null) {
            return (A)this;
        }
        for (String item : items) {
            this.zones.remove(item);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public A removeFromUserTags(UserTag ... items) {
        if (this.userTags == null) {
            return (A)this;
        }
        for (UserTag item : items) {
            UserTagBuilder builder = new UserTagBuilder(item);
            this._visitables.get("userTags").remove(builder);
            this.userTags.remove(builder);
        }
        return (A)this;
    }

    public A removeFromZones(String ... items) {
        if (this.zones == null) {
            return (A)this;
        }
        for (String item : items) {
            this.zones.remove(item);
        }
        return (A)this;
    }

    public A removeMatchingFromUserTags(Predicate<UserTagBuilder> predicate) {
        if (this.userTags == null) {
            return (A)this;
        }
        Iterator<UserTagBuilder> each = this.userTags.iterator();
        Object visitables = this._visitables.get("userTags");
        while (each.hasNext()) {
            UserTagBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public UserTagsNested<A> setNewUserTagLike(int index, UserTag item) {
        return new UserTagsNested(index, item);
    }

    public A setToUserTags(int index, UserTag item) {
        if (this.userTags == null) {
            this.userTags = new ArrayList();
        }
        UserTagBuilder builder = new UserTagBuilder(item);
        if (index < 0 || index >= this.userTags.size()) {
            this._visitables.get("userTags").add(builder);
            this.userTags.add(builder);
        } else {
            this._visitables.get("userTags").add(builder);
            this.userTags.set(index, builder);
        }
        return (A)this;
    }

    public A setToZones(int index, String item) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        this.zones.set(index, item);
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.networkProjectID != null) {
            sb.append("networkProjectID:");
            sb.append(this.networkProjectID);
            sb.append(",");
        }
        if (this.onHostMaintenance != null) {
            sb.append("onHostMaintenance:");
            sb.append(this.onHostMaintenance);
            sb.append(",");
        }
        if (this.osDisk != null) {
            sb.append("osDisk:");
            sb.append(this.osDisk);
            sb.append(",");
        }
        if (this.secureBoot != null) {
            sb.append("secureBoot:");
            sb.append(this.secureBoot);
            sb.append(",");
        }
        if (this.serviceAccount != null) {
            sb.append("serviceAccount:");
            sb.append(this.serviceAccount);
            sb.append(",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type);
            sb.append(",");
        }
        if (this.userTags != null && !this.userTags.isEmpty()) {
            sb.append("userTags:");
            sb.append(this.userTags);
            sb.append(",");
        }
        if (this.zones != null && !this.zones.isEmpty()) {
            sb.append("zones:");
            sb.append(this.zones);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withNetworkProjectID(String networkProjectID) {
        this.networkProjectID = networkProjectID;
        return (A)this;
    }

    public OsDiskNested<A> withNewOsDisk() {
        return new OsDiskNested(null);
    }

    public OsDiskNested<A> withNewOsDiskLike(OSDisk item) {
        return new OsDiskNested(item);
    }

    public A withOnHostMaintenance(String onHostMaintenance) {
        this.onHostMaintenance = onHostMaintenance;
        return (A)this;
    }

    public A withOsDisk(OSDisk osDisk) {
        this._visitables.remove("osDisk");
        if (osDisk != null) {
            this.osDisk = new OSDiskBuilder(osDisk);
            this._visitables.get("osDisk").add(this.osDisk);
        } else {
            this.osDisk = null;
            this._visitables.get("osDisk").remove(this.osDisk);
        }
        return (A)this;
    }

    public A withSecureBoot(String secureBoot) {
        this.secureBoot = secureBoot;
        return (A)this;
    }

    public A withServiceAccount(String serviceAccount) {
        this.serviceAccount = serviceAccount;
        return (A)this;
    }

    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    public A withUserTags(List<UserTag> userTags) {
        if (this.userTags != null) {
            this._visitables.get("userTags").clear();
        }
        if (userTags != null) {
            this.userTags = new ArrayList();
            for (UserTag item : userTags) {
                this.addToUserTags(item);
            }
        } else {
            this.userTags = null;
        }
        return (A)this;
    }

    public A withUserTags(UserTag ... userTags) {
        if (this.userTags != null) {
            this.userTags.clear();
            this._visitables.remove("userTags");
        }
        if (userTags != null) {
            for (UserTag item : userTags) {
                this.addToUserTags(item);
            }
        }
        return (A)this;
    }

    public A withZones(List<String> zones) {
        if (zones != null) {
            this.zones = new ArrayList<String>();
            for (String item : zones) {
                this.addToZones(item);
            }
        } else {
            this.zones = null;
        }
        return (A)this;
    }

    public A withZones(String ... zones) {
        if (this.zones != null) {
            this.zones.clear();
            this._visitables.remove("zones");
        }
        if (zones != null) {
            for (String item : zones) {
                this.addToZones(item);
            }
        }
        return (A)this;
    }

    public class UserTagsNested<N>
    extends UserTagFluent<UserTagsNested<N>>
    implements Nested<N> {
        UserTagBuilder builder;
        int index;

        UserTagsNested(int index, UserTag item) {
            this.index = index;
            this.builder = new UserTagBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)MachinePoolFluent.this.setToUserTags(this.index, this.builder.build());
        }

        public N endUserTag() {
            return this.and();
        }
    }

    public class OsDiskNested<N>
    extends OSDiskFluent<OsDiskNested<N>>
    implements Nested<N> {
        OSDiskBuilder builder;

        OsDiskNested(OSDisk item) {
            this.builder = new OSDiskBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)MachinePoolFluent.this.withOsDisk(this.builder.build());
        }

        public N endOsDisk() {
            return this.and();
        }
    }
}

