/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.SecretNameReference;
import io.fabric8.openshift.api.model.config.v1.SecretNameReferenceBuilder;
import io.fabric8.openshift.api.model.config.v1.SecretNameReferenceFluent;
import io.fabric8.openshift.api.model.config.v1.WebhookTokenAuthenticator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class WebhookTokenAuthenticatorFluent<A extends WebhookTokenAuthenticatorFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private SecretNameReferenceBuilder kubeConfig;

    public WebhookTokenAuthenticatorFluent() {
    }

    public WebhookTokenAuthenticatorFluent(WebhookTokenAuthenticator instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public SecretNameReference buildKubeConfig() {
        return this.kubeConfig != null ? this.kubeConfig.build() : null;
    }

    protected void copyInstance(WebhookTokenAuthenticator instance) {
        WebhookTokenAuthenticator webhookTokenAuthenticator = instance = instance != null ? instance : new WebhookTokenAuthenticator();
        if (instance != null) {
            this.withKubeConfig(instance.getKubeConfig());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public KubeConfigNested<A> editKubeConfig() {
        return this.withNewKubeConfigLike(Optional.ofNullable(this.buildKubeConfig()).orElse(null));
    }

    public KubeConfigNested<A> editOrNewKubeConfig() {
        return this.withNewKubeConfigLike(Optional.ofNullable(this.buildKubeConfig()).orElse(new SecretNameReferenceBuilder().build()));
    }

    public KubeConfigNested<A> editOrNewKubeConfigLike(SecretNameReference item) {
        return this.withNewKubeConfigLike(Optional.ofNullable(this.buildKubeConfig()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WebhookTokenAuthenticatorFluent that = (WebhookTokenAuthenticatorFluent)o;
        if (!Objects.equals(this.kubeConfig, that.kubeConfig)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasKubeConfig() {
        return this.kubeConfig != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.kubeConfig, this.additionalProperties);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.kubeConfig != null) {
            sb.append("kubeConfig:");
            sb.append(this.kubeConfig);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withKubeConfig(SecretNameReference kubeConfig) {
        this._visitables.remove("kubeConfig");
        if (kubeConfig != null) {
            this.kubeConfig = new SecretNameReferenceBuilder(kubeConfig);
            this._visitables.get("kubeConfig").add(this.kubeConfig);
        } else {
            this.kubeConfig = null;
            this._visitables.get("kubeConfig").remove(this.kubeConfig);
        }
        return (A)this;
    }

    public KubeConfigNested<A> withNewKubeConfig() {
        return new KubeConfigNested(null);
    }

    public A withNewKubeConfig(String name) {
        return this.withKubeConfig(new SecretNameReference(name));
    }

    public KubeConfigNested<A> withNewKubeConfigLike(SecretNameReference item) {
        return new KubeConfigNested(item);
    }

    public class KubeConfigNested<N>
    extends SecretNameReferenceFluent<KubeConfigNested<N>>
    implements Nested<N> {
        SecretNameReferenceBuilder builder;

        KubeConfigNested(SecretNameReference item) {
            this.builder = new SecretNameReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)WebhookTokenAuthenticatorFluent.this.withKubeConfig(this.builder.build());
        }

        public N endKubeConfig() {
            return this.and();
        }
    }
}

