/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.VSpherePlatformFailureDomainSpec;
import io.fabric8.openshift.api.model.config.v1.VSpherePlatformFailureDomainSpecBuilder;
import io.fabric8.openshift.api.model.config.v1.VSpherePlatformFailureDomainSpecFluent;
import io.fabric8.openshift.api.model.config.v1.VSpherePlatformNodeNetworking;
import io.fabric8.openshift.api.model.config.v1.VSpherePlatformNodeNetworkingBuilder;
import io.fabric8.openshift.api.model.config.v1.VSpherePlatformNodeNetworkingFluent;
import io.fabric8.openshift.api.model.config.v1.VSpherePlatformSpec;
import io.fabric8.openshift.api.model.config.v1.VSpherePlatformVCenterSpec;
import io.fabric8.openshift.api.model.config.v1.VSpherePlatformVCenterSpecBuilder;
import io.fabric8.openshift.api.model.config.v1.VSpherePlatformVCenterSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class VSpherePlatformSpecFluent<A extends VSpherePlatformSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private List<String> apiServerInternalIPs = new ArrayList<String>();
    private ArrayList<VSpherePlatformFailureDomainSpecBuilder> failureDomains = new ArrayList();
    private List<String> ingressIPs = new ArrayList<String>();
    private List<String> machineNetworks = new ArrayList<String>();
    private VSpherePlatformNodeNetworkingBuilder nodeNetworking;
    private ArrayList<VSpherePlatformVCenterSpecBuilder> vcenters = new ArrayList();

    public VSpherePlatformSpecFluent() {
    }

    public VSpherePlatformSpecFluent(VSpherePlatformSpec instance) {
        this.copyInstance(instance);
    }

    public A addAllToApiServerInternalIPs(Collection<String> items) {
        if (this.apiServerInternalIPs == null) {
            this.apiServerInternalIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.apiServerInternalIPs.add(item);
        }
        return (A)this;
    }

    public A addAllToFailureDomains(Collection<VSpherePlatformFailureDomainSpec> items) {
        if (this.failureDomains == null) {
            this.failureDomains = new ArrayList();
        }
        for (VSpherePlatformFailureDomainSpec item : items) {
            VSpherePlatformFailureDomainSpecBuilder builder = new VSpherePlatformFailureDomainSpecBuilder(item);
            this._visitables.get("failureDomains").add(builder);
            this.failureDomains.add(builder);
        }
        return (A)this;
    }

    public A addAllToIngressIPs(Collection<String> items) {
        if (this.ingressIPs == null) {
            this.ingressIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.ingressIPs.add(item);
        }
        return (A)this;
    }

    public A addAllToMachineNetworks(Collection<String> items) {
        if (this.machineNetworks == null) {
            this.machineNetworks = new ArrayList<String>();
        }
        for (String item : items) {
            this.machineNetworks.add(item);
        }
        return (A)this;
    }

    public A addAllToVcenters(Collection<VSpherePlatformVCenterSpec> items) {
        if (this.vcenters == null) {
            this.vcenters = new ArrayList();
        }
        for (VSpherePlatformVCenterSpec item : items) {
            VSpherePlatformVCenterSpecBuilder builder = new VSpherePlatformVCenterSpecBuilder(item);
            this._visitables.get("vcenters").add(builder);
            this.vcenters.add(builder);
        }
        return (A)this;
    }

    public FailureDomainsNested<A> addNewFailureDomain() {
        return new FailureDomainsNested(-1, null);
    }

    public FailureDomainsNested<A> addNewFailureDomainLike(VSpherePlatformFailureDomainSpec item) {
        return new FailureDomainsNested(-1, item);
    }

    public VcentersNested<A> addNewVcenter() {
        return new VcentersNested(-1, null);
    }

    public VcentersNested<A> addNewVcenterLike(VSpherePlatformVCenterSpec item) {
        return new VcentersNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToApiServerInternalIPs(String ... items) {
        if (this.apiServerInternalIPs == null) {
            this.apiServerInternalIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.apiServerInternalIPs.add(item);
        }
        return (A)this;
    }

    public A addToApiServerInternalIPs(int index, String item) {
        if (this.apiServerInternalIPs == null) {
            this.apiServerInternalIPs = new ArrayList<String>();
        }
        this.apiServerInternalIPs.add(index, item);
        return (A)this;
    }

    public A addToFailureDomains(VSpherePlatformFailureDomainSpec ... items) {
        if (this.failureDomains == null) {
            this.failureDomains = new ArrayList();
        }
        for (VSpherePlatformFailureDomainSpec item : items) {
            VSpherePlatformFailureDomainSpecBuilder builder = new VSpherePlatformFailureDomainSpecBuilder(item);
            this._visitables.get("failureDomains").add(builder);
            this.failureDomains.add(builder);
        }
        return (A)this;
    }

    public A addToFailureDomains(int index, VSpherePlatformFailureDomainSpec item) {
        if (this.failureDomains == null) {
            this.failureDomains = new ArrayList();
        }
        VSpherePlatformFailureDomainSpecBuilder builder = new VSpherePlatformFailureDomainSpecBuilder(item);
        if (index < 0 || index >= this.failureDomains.size()) {
            this._visitables.get("failureDomains").add(builder);
            this.failureDomains.add(builder);
        } else {
            this._visitables.get("failureDomains").add(builder);
            this.failureDomains.add(index, builder);
        }
        return (A)this;
    }

    public A addToIngressIPs(String ... items) {
        if (this.ingressIPs == null) {
            this.ingressIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.ingressIPs.add(item);
        }
        return (A)this;
    }

    public A addToIngressIPs(int index, String item) {
        if (this.ingressIPs == null) {
            this.ingressIPs = new ArrayList<String>();
        }
        this.ingressIPs.add(index, item);
        return (A)this;
    }

    public A addToMachineNetworks(String ... items) {
        if (this.machineNetworks == null) {
            this.machineNetworks = new ArrayList<String>();
        }
        for (String item : items) {
            this.machineNetworks.add(item);
        }
        return (A)this;
    }

    public A addToMachineNetworks(int index, String item) {
        if (this.machineNetworks == null) {
            this.machineNetworks = new ArrayList<String>();
        }
        this.machineNetworks.add(index, item);
        return (A)this;
    }

    public A addToVcenters(VSpherePlatformVCenterSpec ... items) {
        if (this.vcenters == null) {
            this.vcenters = new ArrayList();
        }
        for (VSpherePlatformVCenterSpec item : items) {
            VSpherePlatformVCenterSpecBuilder builder = new VSpherePlatformVCenterSpecBuilder(item);
            this._visitables.get("vcenters").add(builder);
            this.vcenters.add(builder);
        }
        return (A)this;
    }

    public A addToVcenters(int index, VSpherePlatformVCenterSpec item) {
        if (this.vcenters == null) {
            this.vcenters = new ArrayList();
        }
        VSpherePlatformVCenterSpecBuilder builder = new VSpherePlatformVCenterSpecBuilder(item);
        if (index < 0 || index >= this.vcenters.size()) {
            this._visitables.get("vcenters").add(builder);
            this.vcenters.add(builder);
        } else {
            this._visitables.get("vcenters").add(builder);
            this.vcenters.add(index, builder);
        }
        return (A)this;
    }

    public VSpherePlatformFailureDomainSpec buildFailureDomain(int index) {
        return this.failureDomains.get(index).build();
    }

    public List<VSpherePlatformFailureDomainSpec> buildFailureDomains() {
        return this.failureDomains != null ? VSpherePlatformSpecFluent.build(this.failureDomains) : null;
    }

    public VSpherePlatformFailureDomainSpec buildFirstFailureDomain() {
        return this.failureDomains.get(0).build();
    }

    public VSpherePlatformVCenterSpec buildFirstVcenter() {
        return this.vcenters.get(0).build();
    }

    public VSpherePlatformFailureDomainSpec buildLastFailureDomain() {
        return this.failureDomains.get(this.failureDomains.size() - 1).build();
    }

    public VSpherePlatformVCenterSpec buildLastVcenter() {
        return this.vcenters.get(this.vcenters.size() - 1).build();
    }

    public VSpherePlatformFailureDomainSpec buildMatchingFailureDomain(Predicate<VSpherePlatformFailureDomainSpecBuilder> predicate) {
        for (VSpherePlatformFailureDomainSpecBuilder item : this.failureDomains) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public VSpherePlatformVCenterSpec buildMatchingVcenter(Predicate<VSpherePlatformVCenterSpecBuilder> predicate) {
        for (VSpherePlatformVCenterSpecBuilder item : this.vcenters) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public VSpherePlatformNodeNetworking buildNodeNetworking() {
        return this.nodeNetworking != null ? this.nodeNetworking.build() : null;
    }

    public VSpherePlatformVCenterSpec buildVcenter(int index) {
        return this.vcenters.get(index).build();
    }

    public List<VSpherePlatformVCenterSpec> buildVcenters() {
        return this.vcenters != null ? VSpherePlatformSpecFluent.build(this.vcenters) : null;
    }

    protected void copyInstance(VSpherePlatformSpec instance) {
        VSpherePlatformSpec vSpherePlatformSpec = instance = instance != null ? instance : new VSpherePlatformSpec();
        if (instance != null) {
            this.withApiServerInternalIPs(instance.getApiServerInternalIPs());
            this.withFailureDomains(instance.getFailureDomains());
            this.withIngressIPs(instance.getIngressIPs());
            this.withMachineNetworks(instance.getMachineNetworks());
            this.withNodeNetworking(instance.getNodeNetworking());
            this.withVcenters(instance.getVcenters());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public FailureDomainsNested<A> editFailureDomain(int index) {
        if (this.failureDomains.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "failureDomains"));
        }
        return this.setNewFailureDomainLike(index, this.buildFailureDomain(index));
    }

    public FailureDomainsNested<A> editFirstFailureDomain() {
        if (this.failureDomains.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "failureDomains"));
        }
        return this.setNewFailureDomainLike(0, this.buildFailureDomain(0));
    }

    public VcentersNested<A> editFirstVcenter() {
        if (this.vcenters.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "vcenters"));
        }
        return this.setNewVcenterLike(0, this.buildVcenter(0));
    }

    public FailureDomainsNested<A> editLastFailureDomain() {
        int index = this.failureDomains.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "failureDomains"));
        }
        return this.setNewFailureDomainLike(index, this.buildFailureDomain(index));
    }

    public VcentersNested<A> editLastVcenter() {
        int index = this.vcenters.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "vcenters"));
        }
        return this.setNewVcenterLike(index, this.buildVcenter(index));
    }

    public FailureDomainsNested<A> editMatchingFailureDomain(Predicate<VSpherePlatformFailureDomainSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.failureDomains.size(); ++i) {
            if (!predicate.test(this.failureDomains.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "failureDomains"));
        }
        return this.setNewFailureDomainLike(index, this.buildFailureDomain(index));
    }

    public VcentersNested<A> editMatchingVcenter(Predicate<VSpherePlatformVCenterSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.vcenters.size(); ++i) {
            if (!predicate.test(this.vcenters.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "vcenters"));
        }
        return this.setNewVcenterLike(index, this.buildVcenter(index));
    }

    public NodeNetworkingNested<A> editNodeNetworking() {
        return this.withNewNodeNetworkingLike(Optional.ofNullable(this.buildNodeNetworking()).orElse(null));
    }

    public NodeNetworkingNested<A> editOrNewNodeNetworking() {
        return this.withNewNodeNetworkingLike(Optional.ofNullable(this.buildNodeNetworking()).orElse(new VSpherePlatformNodeNetworkingBuilder().build()));
    }

    public NodeNetworkingNested<A> editOrNewNodeNetworkingLike(VSpherePlatformNodeNetworking item) {
        return this.withNewNodeNetworkingLike(Optional.ofNullable(this.buildNodeNetworking()).orElse(item));
    }

    public VcentersNested<A> editVcenter(int index) {
        if (this.vcenters.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "vcenters"));
        }
        return this.setNewVcenterLike(index, this.buildVcenter(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VSpherePlatformSpecFluent that = (VSpherePlatformSpecFluent)o;
        if (!Objects.equals(this.apiServerInternalIPs, that.apiServerInternalIPs)) {
            return false;
        }
        if (!Objects.equals(this.failureDomains, that.failureDomains)) {
            return false;
        }
        if (!Objects.equals(this.ingressIPs, that.ingressIPs)) {
            return false;
        }
        if (!Objects.equals(this.machineNetworks, that.machineNetworks)) {
            return false;
        }
        if (!Objects.equals(this.nodeNetworking, that.nodeNetworking)) {
            return false;
        }
        if (!Objects.equals(this.vcenters, that.vcenters)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getApiServerInternalIP(int index) {
        return this.apiServerInternalIPs.get(index);
    }

    public List<String> getApiServerInternalIPs() {
        return this.apiServerInternalIPs;
    }

    public String getFirstApiServerInternalIP() {
        return this.apiServerInternalIPs.get(0);
    }

    public String getFirstIngressIP() {
        return this.ingressIPs.get(0);
    }

    public String getFirstMachineNetwork() {
        return this.machineNetworks.get(0);
    }

    public String getIngressIP(int index) {
        return this.ingressIPs.get(index);
    }

    public List<String> getIngressIPs() {
        return this.ingressIPs;
    }

    public String getLastApiServerInternalIP() {
        return this.apiServerInternalIPs.get(this.apiServerInternalIPs.size() - 1);
    }

    public String getLastIngressIP() {
        return this.ingressIPs.get(this.ingressIPs.size() - 1);
    }

    public String getLastMachineNetwork() {
        return this.machineNetworks.get(this.machineNetworks.size() - 1);
    }

    public String getMachineNetwork(int index) {
        return this.machineNetworks.get(index);
    }

    public List<String> getMachineNetworks() {
        return this.machineNetworks;
    }

    public String getMatchingApiServerInternalIP(Predicate<String> predicate) {
        for (String item : this.apiServerInternalIPs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getMatchingIngressIP(Predicate<String> predicate) {
        for (String item : this.ingressIPs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getMatchingMachineNetwork(Predicate<String> predicate) {
        for (String item : this.machineNetworks) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasApiServerInternalIPs() {
        return this.apiServerInternalIPs != null && !this.apiServerInternalIPs.isEmpty();
    }

    public boolean hasFailureDomains() {
        return this.failureDomains != null && !this.failureDomains.isEmpty();
    }

    public boolean hasIngressIPs() {
        return this.ingressIPs != null && !this.ingressIPs.isEmpty();
    }

    public boolean hasMachineNetworks() {
        return this.machineNetworks != null && !this.machineNetworks.isEmpty();
    }

    public boolean hasMatchingApiServerInternalIP(Predicate<String> predicate) {
        for (String item : this.apiServerInternalIPs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingFailureDomain(Predicate<VSpherePlatformFailureDomainSpecBuilder> predicate) {
        for (VSpherePlatformFailureDomainSpecBuilder item : this.failureDomains) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingIngressIP(Predicate<String> predicate) {
        for (String item : this.ingressIPs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingMachineNetwork(Predicate<String> predicate) {
        for (String item : this.machineNetworks) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingVcenter(Predicate<VSpherePlatformVCenterSpecBuilder> predicate) {
        for (VSpherePlatformVCenterSpecBuilder item : this.vcenters) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNodeNetworking() {
        return this.nodeNetworking != null;
    }

    public boolean hasVcenters() {
        return this.vcenters != null && !this.vcenters.isEmpty();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiServerInternalIPs, this.failureDomains, this.ingressIPs, this.machineNetworks, this.nodeNetworking, this.vcenters, this.additionalProperties);
    }

    public A removeAllFromApiServerInternalIPs(Collection<String> items) {
        if (this.apiServerInternalIPs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.apiServerInternalIPs.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromFailureDomains(Collection<VSpherePlatformFailureDomainSpec> items) {
        if (this.failureDomains == null) {
            return (A)this;
        }
        for (VSpherePlatformFailureDomainSpec item : items) {
            VSpherePlatformFailureDomainSpecBuilder builder = new VSpherePlatformFailureDomainSpecBuilder(item);
            this._visitables.get("failureDomains").remove(builder);
            this.failureDomains.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromIngressIPs(Collection<String> items) {
        if (this.ingressIPs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.ingressIPs.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromMachineNetworks(Collection<String> items) {
        if (this.machineNetworks == null) {
            return (A)this;
        }
        for (String item : items) {
            this.machineNetworks.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromVcenters(Collection<VSpherePlatformVCenterSpec> items) {
        if (this.vcenters == null) {
            return (A)this;
        }
        for (VSpherePlatformVCenterSpec item : items) {
            VSpherePlatformVCenterSpecBuilder builder = new VSpherePlatformVCenterSpecBuilder(item);
            this._visitables.get("vcenters").remove(builder);
            this.vcenters.remove(builder);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public A removeFromApiServerInternalIPs(String ... items) {
        if (this.apiServerInternalIPs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.apiServerInternalIPs.remove(item);
        }
        return (A)this;
    }

    public A removeFromFailureDomains(VSpherePlatformFailureDomainSpec ... items) {
        if (this.failureDomains == null) {
            return (A)this;
        }
        for (VSpherePlatformFailureDomainSpec item : items) {
            VSpherePlatformFailureDomainSpecBuilder builder = new VSpherePlatformFailureDomainSpecBuilder(item);
            this._visitables.get("failureDomains").remove(builder);
            this.failureDomains.remove(builder);
        }
        return (A)this;
    }

    public A removeFromIngressIPs(String ... items) {
        if (this.ingressIPs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.ingressIPs.remove(item);
        }
        return (A)this;
    }

    public A removeFromMachineNetworks(String ... items) {
        if (this.machineNetworks == null) {
            return (A)this;
        }
        for (String item : items) {
            this.machineNetworks.remove(item);
        }
        return (A)this;
    }

    public A removeFromVcenters(VSpherePlatformVCenterSpec ... items) {
        if (this.vcenters == null) {
            return (A)this;
        }
        for (VSpherePlatformVCenterSpec item : items) {
            VSpherePlatformVCenterSpecBuilder builder = new VSpherePlatformVCenterSpecBuilder(item);
            this._visitables.get("vcenters").remove(builder);
            this.vcenters.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromFailureDomains(Predicate<VSpherePlatformFailureDomainSpecBuilder> predicate) {
        if (this.failureDomains == null) {
            return (A)this;
        }
        Iterator<VSpherePlatformFailureDomainSpecBuilder> each = this.failureDomains.iterator();
        Object visitables = this._visitables.get("failureDomains");
        while (each.hasNext()) {
            VSpherePlatformFailureDomainSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public A removeMatchingFromVcenters(Predicate<VSpherePlatformVCenterSpecBuilder> predicate) {
        if (this.vcenters == null) {
            return (A)this;
        }
        Iterator<VSpherePlatformVCenterSpecBuilder> each = this.vcenters.iterator();
        Object visitables = this._visitables.get("vcenters");
        while (each.hasNext()) {
            VSpherePlatformVCenterSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public FailureDomainsNested<A> setNewFailureDomainLike(int index, VSpherePlatformFailureDomainSpec item) {
        return new FailureDomainsNested(index, item);
    }

    public VcentersNested<A> setNewVcenterLike(int index, VSpherePlatformVCenterSpec item) {
        return new VcentersNested(index, item);
    }

    public A setToApiServerInternalIPs(int index, String item) {
        if (this.apiServerInternalIPs == null) {
            this.apiServerInternalIPs = new ArrayList<String>();
        }
        this.apiServerInternalIPs.set(index, item);
        return (A)this;
    }

    public A setToFailureDomains(int index, VSpherePlatformFailureDomainSpec item) {
        if (this.failureDomains == null) {
            this.failureDomains = new ArrayList();
        }
        VSpherePlatformFailureDomainSpecBuilder builder = new VSpherePlatformFailureDomainSpecBuilder(item);
        if (index < 0 || index >= this.failureDomains.size()) {
            this._visitables.get("failureDomains").add(builder);
            this.failureDomains.add(builder);
        } else {
            this._visitables.get("failureDomains").add(builder);
            this.failureDomains.set(index, builder);
        }
        return (A)this;
    }

    public A setToIngressIPs(int index, String item) {
        if (this.ingressIPs == null) {
            this.ingressIPs = new ArrayList<String>();
        }
        this.ingressIPs.set(index, item);
        return (A)this;
    }

    public A setToMachineNetworks(int index, String item) {
        if (this.machineNetworks == null) {
            this.machineNetworks = new ArrayList<String>();
        }
        this.machineNetworks.set(index, item);
        return (A)this;
    }

    public A setToVcenters(int index, VSpherePlatformVCenterSpec item) {
        if (this.vcenters == null) {
            this.vcenters = new ArrayList();
        }
        VSpherePlatformVCenterSpecBuilder builder = new VSpherePlatformVCenterSpecBuilder(item);
        if (index < 0 || index >= this.vcenters.size()) {
            this._visitables.get("vcenters").add(builder);
            this.vcenters.add(builder);
        } else {
            this._visitables.get("vcenters").add(builder);
            this.vcenters.set(index, builder);
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiServerInternalIPs != null && !this.apiServerInternalIPs.isEmpty()) {
            sb.append("apiServerInternalIPs:");
            sb.append(this.apiServerInternalIPs);
            sb.append(",");
        }
        if (this.failureDomains != null && !this.failureDomains.isEmpty()) {
            sb.append("failureDomains:");
            sb.append(this.failureDomains);
            sb.append(",");
        }
        if (this.ingressIPs != null && !this.ingressIPs.isEmpty()) {
            sb.append("ingressIPs:");
            sb.append(this.ingressIPs);
            sb.append(",");
        }
        if (this.machineNetworks != null && !this.machineNetworks.isEmpty()) {
            sb.append("machineNetworks:");
            sb.append(this.machineNetworks);
            sb.append(",");
        }
        if (this.nodeNetworking != null) {
            sb.append("nodeNetworking:");
            sb.append(this.nodeNetworking);
            sb.append(",");
        }
        if (this.vcenters != null && !this.vcenters.isEmpty()) {
            sb.append("vcenters:");
            sb.append(this.vcenters);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withApiServerInternalIPs(List<String> apiServerInternalIPs) {
        if (apiServerInternalIPs != null) {
            this.apiServerInternalIPs = new ArrayList<String>();
            for (String item : apiServerInternalIPs) {
                this.addToApiServerInternalIPs(item);
            }
        } else {
            this.apiServerInternalIPs = null;
        }
        return (A)this;
    }

    public A withApiServerInternalIPs(String ... apiServerInternalIPs) {
        if (this.apiServerInternalIPs != null) {
            this.apiServerInternalIPs.clear();
            this._visitables.remove("apiServerInternalIPs");
        }
        if (apiServerInternalIPs != null) {
            for (String item : apiServerInternalIPs) {
                this.addToApiServerInternalIPs(item);
            }
        }
        return (A)this;
    }

    public A withFailureDomains(List<VSpherePlatformFailureDomainSpec> failureDomains) {
        if (this.failureDomains != null) {
            this._visitables.get("failureDomains").clear();
        }
        if (failureDomains != null) {
            this.failureDomains = new ArrayList();
            for (VSpherePlatformFailureDomainSpec item : failureDomains) {
                this.addToFailureDomains(item);
            }
        } else {
            this.failureDomains = null;
        }
        return (A)this;
    }

    public A withFailureDomains(VSpherePlatformFailureDomainSpec ... failureDomains) {
        if (this.failureDomains != null) {
            this.failureDomains.clear();
            this._visitables.remove("failureDomains");
        }
        if (failureDomains != null) {
            for (VSpherePlatformFailureDomainSpec item : failureDomains) {
                this.addToFailureDomains(item);
            }
        }
        return (A)this;
    }

    public A withIngressIPs(List<String> ingressIPs) {
        if (ingressIPs != null) {
            this.ingressIPs = new ArrayList<String>();
            for (String item : ingressIPs) {
                this.addToIngressIPs(item);
            }
        } else {
            this.ingressIPs = null;
        }
        return (A)this;
    }

    public A withIngressIPs(String ... ingressIPs) {
        if (this.ingressIPs != null) {
            this.ingressIPs.clear();
            this._visitables.remove("ingressIPs");
        }
        if (ingressIPs != null) {
            for (String item : ingressIPs) {
                this.addToIngressIPs(item);
            }
        }
        return (A)this;
    }

    public A withMachineNetworks(List<String> machineNetworks) {
        if (machineNetworks != null) {
            this.machineNetworks = new ArrayList<String>();
            for (String item : machineNetworks) {
                this.addToMachineNetworks(item);
            }
        } else {
            this.machineNetworks = null;
        }
        return (A)this;
    }

    public A withMachineNetworks(String ... machineNetworks) {
        if (this.machineNetworks != null) {
            this.machineNetworks.clear();
            this._visitables.remove("machineNetworks");
        }
        if (machineNetworks != null) {
            for (String item : machineNetworks) {
                this.addToMachineNetworks(item);
            }
        }
        return (A)this;
    }

    public NodeNetworkingNested<A> withNewNodeNetworking() {
        return new NodeNetworkingNested(null);
    }

    public NodeNetworkingNested<A> withNewNodeNetworkingLike(VSpherePlatformNodeNetworking item) {
        return new NodeNetworkingNested(item);
    }

    public A withNodeNetworking(VSpherePlatformNodeNetworking nodeNetworking) {
        this._visitables.remove("nodeNetworking");
        if (nodeNetworking != null) {
            this.nodeNetworking = new VSpherePlatformNodeNetworkingBuilder(nodeNetworking);
            this._visitables.get("nodeNetworking").add(this.nodeNetworking);
        } else {
            this.nodeNetworking = null;
            this._visitables.get("nodeNetworking").remove(this.nodeNetworking);
        }
        return (A)this;
    }

    public A withVcenters(List<VSpherePlatformVCenterSpec> vcenters) {
        if (this.vcenters != null) {
            this._visitables.get("vcenters").clear();
        }
        if (vcenters != null) {
            this.vcenters = new ArrayList();
            for (VSpherePlatformVCenterSpec item : vcenters) {
                this.addToVcenters(item);
            }
        } else {
            this.vcenters = null;
        }
        return (A)this;
    }

    public A withVcenters(VSpherePlatformVCenterSpec ... vcenters) {
        if (this.vcenters != null) {
            this.vcenters.clear();
            this._visitables.remove("vcenters");
        }
        if (vcenters != null) {
            for (VSpherePlatformVCenterSpec item : vcenters) {
                this.addToVcenters(item);
            }
        }
        return (A)this;
    }

    public class VcentersNested<N>
    extends VSpherePlatformVCenterSpecFluent<VcentersNested<N>>
    implements Nested<N> {
        VSpherePlatformVCenterSpecBuilder builder;
        int index;

        VcentersNested(int index, VSpherePlatformVCenterSpec item) {
            this.index = index;
            this.builder = new VSpherePlatformVCenterSpecBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)VSpherePlatformSpecFluent.this.setToVcenters(this.index, this.builder.build());
        }

        public N endVcenter() {
            return this.and();
        }
    }

    public class NodeNetworkingNested<N>
    extends VSpherePlatformNodeNetworkingFluent<NodeNetworkingNested<N>>
    implements Nested<N> {
        VSpherePlatformNodeNetworkingBuilder builder;

        NodeNetworkingNested(VSpherePlatformNodeNetworking item) {
            this.builder = new VSpherePlatformNodeNetworkingBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)VSpherePlatformSpecFluent.this.withNodeNetworking(this.builder.build());
        }

        public N endNodeNetworking() {
            return this.and();
        }
    }

    public class FailureDomainsNested<N>
    extends VSpherePlatformFailureDomainSpecFluent<FailureDomainsNested<N>>
    implements Nested<N> {
        VSpherePlatformFailureDomainSpecBuilder builder;
        int index;

        FailureDomainsNested(int index, VSpherePlatformFailureDomainSpec item) {
            this.index = index;
            this.builder = new VSpherePlatformFailureDomainSpecBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)VSpherePlatformSpecFluent.this.setToFailureDomains(this.index, this.builder.build());
        }

        public N endFailureDomain() {
            return this.and();
        }
    }
}

