/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.PKI;
import io.fabric8.openshift.api.model.config.v1.PKICertificateSubject;
import io.fabric8.openshift.api.model.config.v1.PKICertificateSubjectBuilder;
import io.fabric8.openshift.api.model.config.v1.PKICertificateSubjectFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PKIFluent<A extends PKIFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String caIntermediatesData;
    private String caRootsData;
    private PKICertificateSubjectBuilder pkiCertificateSubject;

    public PKIFluent() {
    }

    public PKIFluent(PKI instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public PKICertificateSubject buildPkiCertificateSubject() {
        return this.pkiCertificateSubject != null ? this.pkiCertificateSubject.build() : null;
    }

    protected void copyInstance(PKI instance) {
        PKI pKI = instance = instance != null ? instance : new PKI();
        if (instance != null) {
            this.withCaIntermediatesData(instance.getCaIntermediatesData());
            this.withCaRootsData(instance.getCaRootsData());
            this.withPkiCertificateSubject(instance.getPkiCertificateSubject());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public PkiCertificateSubjectNested<A> editOrNewPkiCertificateSubject() {
        return this.withNewPkiCertificateSubjectLike(Optional.ofNullable(this.buildPkiCertificateSubject()).orElse(new PKICertificateSubjectBuilder().build()));
    }

    public PkiCertificateSubjectNested<A> editOrNewPkiCertificateSubjectLike(PKICertificateSubject item) {
        return this.withNewPkiCertificateSubjectLike(Optional.ofNullable(this.buildPkiCertificateSubject()).orElse(item));
    }

    public PkiCertificateSubjectNested<A> editPkiCertificateSubject() {
        return this.withNewPkiCertificateSubjectLike(Optional.ofNullable(this.buildPkiCertificateSubject()).orElse(null));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PKIFluent that = (PKIFluent)o;
        if (!Objects.equals(this.caIntermediatesData, that.caIntermediatesData)) {
            return false;
        }
        if (!Objects.equals(this.caRootsData, that.caRootsData)) {
            return false;
        }
        if (!Objects.equals(this.pkiCertificateSubject, that.pkiCertificateSubject)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getCaIntermediatesData() {
        return this.caIntermediatesData;
    }

    public String getCaRootsData() {
        return this.caRootsData;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasCaIntermediatesData() {
        return this.caIntermediatesData != null;
    }

    public boolean hasCaRootsData() {
        return this.caRootsData != null;
    }

    public boolean hasPkiCertificateSubject() {
        return this.pkiCertificateSubject != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.caIntermediatesData, this.caRootsData, this.pkiCertificateSubject, this.additionalProperties);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.caIntermediatesData != null) {
            sb.append("caIntermediatesData:");
            sb.append(this.caIntermediatesData);
            sb.append(",");
        }
        if (this.caRootsData != null) {
            sb.append("caRootsData:");
            sb.append(this.caRootsData);
            sb.append(",");
        }
        if (this.pkiCertificateSubject != null) {
            sb.append("pkiCertificateSubject:");
            sb.append(this.pkiCertificateSubject);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withCaIntermediatesData(String caIntermediatesData) {
        this.caIntermediatesData = caIntermediatesData;
        return (A)this;
    }

    public A withCaRootsData(String caRootsData) {
        this.caRootsData = caRootsData;
        return (A)this;
    }

    public PkiCertificateSubjectNested<A> withNewPkiCertificateSubject() {
        return new PkiCertificateSubjectNested(null);
    }

    public A withNewPkiCertificateSubject(String email, String hostname) {
        return this.withPkiCertificateSubject(new PKICertificateSubject(email, hostname));
    }

    public PkiCertificateSubjectNested<A> withNewPkiCertificateSubjectLike(PKICertificateSubject item) {
        return new PkiCertificateSubjectNested(item);
    }

    public A withPkiCertificateSubject(PKICertificateSubject pkiCertificateSubject) {
        this._visitables.remove("pkiCertificateSubject");
        if (pkiCertificateSubject != null) {
            this.pkiCertificateSubject = new PKICertificateSubjectBuilder(pkiCertificateSubject);
            this._visitables.get("pkiCertificateSubject").add(this.pkiCertificateSubject);
        } else {
            this.pkiCertificateSubject = null;
            this._visitables.get("pkiCertificateSubject").remove(this.pkiCertificateSubject);
        }
        return (A)this;
    }

    public class PkiCertificateSubjectNested<N>
    extends PKICertificateSubjectFluent<PkiCertificateSubjectNested<N>>
    implements Nested<N> {
        PKICertificateSubjectBuilder builder;

        PkiCertificateSubjectNested(PKICertificateSubject item) {
            this.builder = new PKICertificateSubjectBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PKIFluent.this.withPkiCertificateSubject(this.builder.build());
        }

        public N endPkiCertificateSubject() {
            return this.and();
        }
    }
}

