/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.OpenStackPlatformLoadBalancer;
import io.fabric8.openshift.api.model.config.v1.OpenStackPlatformLoadBalancerBuilder;
import io.fabric8.openshift.api.model.config.v1.OpenStackPlatformLoadBalancerFluent;
import io.fabric8.openshift.api.model.config.v1.OpenStackPlatformStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class OpenStackPlatformStatusFluent<A extends OpenStackPlatformStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String apiServerInternalIP;
    private List<String> apiServerInternalIPs = new ArrayList<String>();
    private String cloudName;
    private String ingressIP;
    private List<String> ingressIPs = new ArrayList<String>();
    private OpenStackPlatformLoadBalancerBuilder loadBalancer;
    private List<String> machineNetworks = new ArrayList<String>();
    private String nodeDNSIP;

    public OpenStackPlatformStatusFluent() {
    }

    public OpenStackPlatformStatusFluent(OpenStackPlatformStatus instance) {
        this.copyInstance(instance);
    }

    public A addAllToApiServerInternalIPs(Collection<String> items) {
        if (this.apiServerInternalIPs == null) {
            this.apiServerInternalIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.apiServerInternalIPs.add(item);
        }
        return (A)this;
    }

    public A addAllToIngressIPs(Collection<String> items) {
        if (this.ingressIPs == null) {
            this.ingressIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.ingressIPs.add(item);
        }
        return (A)this;
    }

    public A addAllToMachineNetworks(Collection<String> items) {
        if (this.machineNetworks == null) {
            this.machineNetworks = new ArrayList<String>();
        }
        for (String item : items) {
            this.machineNetworks.add(item);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToApiServerInternalIPs(String ... items) {
        if (this.apiServerInternalIPs == null) {
            this.apiServerInternalIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.apiServerInternalIPs.add(item);
        }
        return (A)this;
    }

    public A addToApiServerInternalIPs(int index, String item) {
        if (this.apiServerInternalIPs == null) {
            this.apiServerInternalIPs = new ArrayList<String>();
        }
        this.apiServerInternalIPs.add(index, item);
        return (A)this;
    }

    public A addToIngressIPs(String ... items) {
        if (this.ingressIPs == null) {
            this.ingressIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.ingressIPs.add(item);
        }
        return (A)this;
    }

    public A addToIngressIPs(int index, String item) {
        if (this.ingressIPs == null) {
            this.ingressIPs = new ArrayList<String>();
        }
        this.ingressIPs.add(index, item);
        return (A)this;
    }

    public A addToMachineNetworks(String ... items) {
        if (this.machineNetworks == null) {
            this.machineNetworks = new ArrayList<String>();
        }
        for (String item : items) {
            this.machineNetworks.add(item);
        }
        return (A)this;
    }

    public A addToMachineNetworks(int index, String item) {
        if (this.machineNetworks == null) {
            this.machineNetworks = new ArrayList<String>();
        }
        this.machineNetworks.add(index, item);
        return (A)this;
    }

    public OpenStackPlatformLoadBalancer buildLoadBalancer() {
        return this.loadBalancer != null ? this.loadBalancer.build() : null;
    }

    protected void copyInstance(OpenStackPlatformStatus instance) {
        OpenStackPlatformStatus openStackPlatformStatus = instance = instance != null ? instance : new OpenStackPlatformStatus();
        if (instance != null) {
            this.withApiServerInternalIP(instance.getApiServerInternalIP());
            this.withApiServerInternalIPs(instance.getApiServerInternalIPs());
            this.withCloudName(instance.getCloudName());
            this.withIngressIP(instance.getIngressIP());
            this.withIngressIPs(instance.getIngressIPs());
            this.withLoadBalancer(instance.getLoadBalancer());
            this.withMachineNetworks(instance.getMachineNetworks());
            this.withNodeDNSIP(instance.getNodeDNSIP());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public LoadBalancerNested<A> editLoadBalancer() {
        return this.withNewLoadBalancerLike(Optional.ofNullable(this.buildLoadBalancer()).orElse(null));
    }

    public LoadBalancerNested<A> editOrNewLoadBalancer() {
        return this.withNewLoadBalancerLike(Optional.ofNullable(this.buildLoadBalancer()).orElse(new OpenStackPlatformLoadBalancerBuilder().build()));
    }

    public LoadBalancerNested<A> editOrNewLoadBalancerLike(OpenStackPlatformLoadBalancer item) {
        return this.withNewLoadBalancerLike(Optional.ofNullable(this.buildLoadBalancer()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OpenStackPlatformStatusFluent that = (OpenStackPlatformStatusFluent)o;
        if (!Objects.equals(this.apiServerInternalIP, that.apiServerInternalIP)) {
            return false;
        }
        if (!Objects.equals(this.apiServerInternalIPs, that.apiServerInternalIPs)) {
            return false;
        }
        if (!Objects.equals(this.cloudName, that.cloudName)) {
            return false;
        }
        if (!Objects.equals(this.ingressIP, that.ingressIP)) {
            return false;
        }
        if (!Objects.equals(this.ingressIPs, that.ingressIPs)) {
            return false;
        }
        if (!Objects.equals(this.loadBalancer, that.loadBalancer)) {
            return false;
        }
        if (!Objects.equals(this.machineNetworks, that.machineNetworks)) {
            return false;
        }
        if (!Objects.equals(this.nodeDNSIP, that.nodeDNSIP)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getApiServerInternalIP() {
        return this.apiServerInternalIP;
    }

    public String getApiServerInternalIP(int index) {
        return this.apiServerInternalIPs.get(index);
    }

    public List<String> getApiServerInternalIPs() {
        return this.apiServerInternalIPs;
    }

    public String getCloudName() {
        return this.cloudName;
    }

    public String getFirstApiServerInternalIP() {
        return this.apiServerInternalIPs.get(0);
    }

    public String getFirstIngressIP() {
        return this.ingressIPs.get(0);
    }

    public String getFirstMachineNetwork() {
        return this.machineNetworks.get(0);
    }

    public String getIngressIP() {
        return this.ingressIP;
    }

    public String getIngressIP(int index) {
        return this.ingressIPs.get(index);
    }

    public List<String> getIngressIPs() {
        return this.ingressIPs;
    }

    public String getLastApiServerInternalIP() {
        return this.apiServerInternalIPs.get(this.apiServerInternalIPs.size() - 1);
    }

    public String getLastIngressIP() {
        return this.ingressIPs.get(this.ingressIPs.size() - 1);
    }

    public String getLastMachineNetwork() {
        return this.machineNetworks.get(this.machineNetworks.size() - 1);
    }

    public String getMachineNetwork(int index) {
        return this.machineNetworks.get(index);
    }

    public List<String> getMachineNetworks() {
        return this.machineNetworks;
    }

    public String getMatchingApiServerInternalIP(Predicate<String> predicate) {
        for (String item : this.apiServerInternalIPs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getMatchingIngressIP(Predicate<String> predicate) {
        for (String item : this.ingressIPs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getMatchingMachineNetwork(Predicate<String> predicate) {
        for (String item : this.machineNetworks) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getNodeDNSIP() {
        return this.nodeDNSIP;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasApiServerInternalIP() {
        return this.apiServerInternalIP != null;
    }

    public boolean hasApiServerInternalIPs() {
        return this.apiServerInternalIPs != null && !this.apiServerInternalIPs.isEmpty();
    }

    public boolean hasCloudName() {
        return this.cloudName != null;
    }

    public boolean hasIngressIP() {
        return this.ingressIP != null;
    }

    public boolean hasIngressIPs() {
        return this.ingressIPs != null && !this.ingressIPs.isEmpty();
    }

    public boolean hasLoadBalancer() {
        return this.loadBalancer != null;
    }

    public boolean hasMachineNetworks() {
        return this.machineNetworks != null && !this.machineNetworks.isEmpty();
    }

    public boolean hasMatchingApiServerInternalIP(Predicate<String> predicate) {
        for (String item : this.apiServerInternalIPs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingIngressIP(Predicate<String> predicate) {
        for (String item : this.ingressIPs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingMachineNetwork(Predicate<String> predicate) {
        for (String item : this.machineNetworks) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNodeDNSIP() {
        return this.nodeDNSIP != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiServerInternalIP, this.apiServerInternalIPs, this.cloudName, this.ingressIP, this.ingressIPs, this.loadBalancer, this.machineNetworks, this.nodeDNSIP, this.additionalProperties);
    }

    public A removeAllFromApiServerInternalIPs(Collection<String> items) {
        if (this.apiServerInternalIPs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.apiServerInternalIPs.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromIngressIPs(Collection<String> items) {
        if (this.ingressIPs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.ingressIPs.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromMachineNetworks(Collection<String> items) {
        if (this.machineNetworks == null) {
            return (A)this;
        }
        for (String item : items) {
            this.machineNetworks.remove(item);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public A removeFromApiServerInternalIPs(String ... items) {
        if (this.apiServerInternalIPs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.apiServerInternalIPs.remove(item);
        }
        return (A)this;
    }

    public A removeFromIngressIPs(String ... items) {
        if (this.ingressIPs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.ingressIPs.remove(item);
        }
        return (A)this;
    }

    public A removeFromMachineNetworks(String ... items) {
        if (this.machineNetworks == null) {
            return (A)this;
        }
        for (String item : items) {
            this.machineNetworks.remove(item);
        }
        return (A)this;
    }

    public A setToApiServerInternalIPs(int index, String item) {
        if (this.apiServerInternalIPs == null) {
            this.apiServerInternalIPs = new ArrayList<String>();
        }
        this.apiServerInternalIPs.set(index, item);
        return (A)this;
    }

    public A setToIngressIPs(int index, String item) {
        if (this.ingressIPs == null) {
            this.ingressIPs = new ArrayList<String>();
        }
        this.ingressIPs.set(index, item);
        return (A)this;
    }

    public A setToMachineNetworks(int index, String item) {
        if (this.machineNetworks == null) {
            this.machineNetworks = new ArrayList<String>();
        }
        this.machineNetworks.set(index, item);
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiServerInternalIP != null) {
            sb.append("apiServerInternalIP:");
            sb.append(this.apiServerInternalIP);
            sb.append(",");
        }
        if (this.apiServerInternalIPs != null && !this.apiServerInternalIPs.isEmpty()) {
            sb.append("apiServerInternalIPs:");
            sb.append(this.apiServerInternalIPs);
            sb.append(",");
        }
        if (this.cloudName != null) {
            sb.append("cloudName:");
            sb.append(this.cloudName);
            sb.append(",");
        }
        if (this.ingressIP != null) {
            sb.append("ingressIP:");
            sb.append(this.ingressIP);
            sb.append(",");
        }
        if (this.ingressIPs != null && !this.ingressIPs.isEmpty()) {
            sb.append("ingressIPs:");
            sb.append(this.ingressIPs);
            sb.append(",");
        }
        if (this.loadBalancer != null) {
            sb.append("loadBalancer:");
            sb.append(this.loadBalancer);
            sb.append(",");
        }
        if (this.machineNetworks != null && !this.machineNetworks.isEmpty()) {
            sb.append("machineNetworks:");
            sb.append(this.machineNetworks);
            sb.append(",");
        }
        if (this.nodeDNSIP != null) {
            sb.append("nodeDNSIP:");
            sb.append(this.nodeDNSIP);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withApiServerInternalIP(String apiServerInternalIP) {
        this.apiServerInternalIP = apiServerInternalIP;
        return (A)this;
    }

    public A withApiServerInternalIPs(List<String> apiServerInternalIPs) {
        if (apiServerInternalIPs != null) {
            this.apiServerInternalIPs = new ArrayList<String>();
            for (String item : apiServerInternalIPs) {
                this.addToApiServerInternalIPs(item);
            }
        } else {
            this.apiServerInternalIPs = null;
        }
        return (A)this;
    }

    public A withApiServerInternalIPs(String ... apiServerInternalIPs) {
        if (this.apiServerInternalIPs != null) {
            this.apiServerInternalIPs.clear();
            this._visitables.remove("apiServerInternalIPs");
        }
        if (apiServerInternalIPs != null) {
            for (String item : apiServerInternalIPs) {
                this.addToApiServerInternalIPs(item);
            }
        }
        return (A)this;
    }

    public A withCloudName(String cloudName) {
        this.cloudName = cloudName;
        return (A)this;
    }

    public A withIngressIP(String ingressIP) {
        this.ingressIP = ingressIP;
        return (A)this;
    }

    public A withIngressIPs(List<String> ingressIPs) {
        if (ingressIPs != null) {
            this.ingressIPs = new ArrayList<String>();
            for (String item : ingressIPs) {
                this.addToIngressIPs(item);
            }
        } else {
            this.ingressIPs = null;
        }
        return (A)this;
    }

    public A withIngressIPs(String ... ingressIPs) {
        if (this.ingressIPs != null) {
            this.ingressIPs.clear();
            this._visitables.remove("ingressIPs");
        }
        if (ingressIPs != null) {
            for (String item : ingressIPs) {
                this.addToIngressIPs(item);
            }
        }
        return (A)this;
    }

    public A withLoadBalancer(OpenStackPlatformLoadBalancer loadBalancer) {
        this._visitables.remove("loadBalancer");
        if (loadBalancer != null) {
            this.loadBalancer = new OpenStackPlatformLoadBalancerBuilder(loadBalancer);
            this._visitables.get("loadBalancer").add(this.loadBalancer);
        } else {
            this.loadBalancer = null;
            this._visitables.get("loadBalancer").remove(this.loadBalancer);
        }
        return (A)this;
    }

    public A withMachineNetworks(List<String> machineNetworks) {
        if (machineNetworks != null) {
            this.machineNetworks = new ArrayList<String>();
            for (String item : machineNetworks) {
                this.addToMachineNetworks(item);
            }
        } else {
            this.machineNetworks = null;
        }
        return (A)this;
    }

    public A withMachineNetworks(String ... machineNetworks) {
        if (this.machineNetworks != null) {
            this.machineNetworks.clear();
            this._visitables.remove("machineNetworks");
        }
        if (machineNetworks != null) {
            for (String item : machineNetworks) {
                this.addToMachineNetworks(item);
            }
        }
        return (A)this;
    }

    public LoadBalancerNested<A> withNewLoadBalancer() {
        return new LoadBalancerNested(null);
    }

    public A withNewLoadBalancer(String type) {
        return this.withLoadBalancer(new OpenStackPlatformLoadBalancer(type));
    }

    public LoadBalancerNested<A> withNewLoadBalancerLike(OpenStackPlatformLoadBalancer item) {
        return new LoadBalancerNested(item);
    }

    public A withNodeDNSIP(String nodeDNSIP) {
        this.nodeDNSIP = nodeDNSIP;
        return (A)this;
    }

    public class LoadBalancerNested<N>
    extends OpenStackPlatformLoadBalancerFluent<LoadBalancerNested<N>>
    implements Nested<N> {
        OpenStackPlatformLoadBalancerBuilder builder;

        LoadBalancerNested(OpenStackPlatformLoadBalancer item) {
            this.builder = new OpenStackPlatformLoadBalancerBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)OpenStackPlatformStatusFluent.this.withLoadBalancer(this.builder.build());
        }

        public N endLoadBalancer() {
            return this.and();
        }
    }
}

