/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.config.v1.OIDCClientReference;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class OIDCClientReferenceFluent<A extends OIDCClientReferenceFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String clientID;
    private String issuerURL;
    private String oidcProviderName;

    public OIDCClientReferenceFluent() {
    }

    public OIDCClientReferenceFluent(OIDCClientReference instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    protected void copyInstance(OIDCClientReference instance) {
        OIDCClientReference oIDCClientReference = instance = instance != null ? instance : new OIDCClientReference();
        if (instance != null) {
            this.withClientID(instance.getClientID());
            this.withIssuerURL(instance.getIssuerURL());
            this.withOidcProviderName(instance.getOidcProviderName());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OIDCClientReferenceFluent that = (OIDCClientReferenceFluent)o;
        if (!Objects.equals(this.clientID, that.clientID)) {
            return false;
        }
        if (!Objects.equals(this.issuerURL, that.issuerURL)) {
            return false;
        }
        if (!Objects.equals(this.oidcProviderName, that.oidcProviderName)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getClientID() {
        return this.clientID;
    }

    public String getIssuerURL() {
        return this.issuerURL;
    }

    public String getOidcProviderName() {
        return this.oidcProviderName;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasClientID() {
        return this.clientID != null;
    }

    public boolean hasIssuerURL() {
        return this.issuerURL != null;
    }

    public boolean hasOidcProviderName() {
        return this.oidcProviderName != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.clientID, this.issuerURL, this.oidcProviderName, this.additionalProperties);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clientID != null) {
            sb.append("clientID:");
            sb.append(this.clientID);
            sb.append(",");
        }
        if (this.issuerURL != null) {
            sb.append("issuerURL:");
            sb.append(this.issuerURL);
            sb.append(",");
        }
        if (this.oidcProviderName != null) {
            sb.append("oidcProviderName:");
            sb.append(this.oidcProviderName);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withClientID(String clientID) {
        this.clientID = clientID;
        return (A)this;
    }

    public A withIssuerURL(String issuerURL) {
        this.issuerURL = issuerURL;
        return (A)this;
    }

    public A withOidcProviderName(String oidcProviderName) {
        this.oidcProviderName = oidcProviderName;
        return (A)this;
    }
}

