/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.ClusterNetworkEntry;
import io.fabric8.openshift.api.model.config.v1.ClusterNetworkEntryBuilder;
import io.fabric8.openshift.api.model.config.v1.ClusterNetworkEntryFluent;
import io.fabric8.openshift.api.model.config.v1.ExternalIPConfig;
import io.fabric8.openshift.api.model.config.v1.ExternalIPConfigBuilder;
import io.fabric8.openshift.api.model.config.v1.ExternalIPConfigFluent;
import io.fabric8.openshift.api.model.config.v1.NetworkDiagnostics;
import io.fabric8.openshift.api.model.config.v1.NetworkDiagnosticsBuilder;
import io.fabric8.openshift.api.model.config.v1.NetworkDiagnosticsFluent;
import io.fabric8.openshift.api.model.config.v1.NetworkSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class NetworkSpecFluent<A extends NetworkSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ArrayList<ClusterNetworkEntryBuilder> clusterNetwork = new ArrayList();
    private ExternalIPConfigBuilder externalIP;
    private NetworkDiagnosticsBuilder networkDiagnostics;
    private String networkType;
    private List<String> serviceNetwork = new ArrayList<String>();
    private String serviceNodePortRange;

    public NetworkSpecFluent() {
    }

    public NetworkSpecFluent(NetworkSpec instance) {
        this.copyInstance(instance);
    }

    public A addAllToClusterNetwork(Collection<ClusterNetworkEntry> items) {
        if (this.clusterNetwork == null) {
            this.clusterNetwork = new ArrayList();
        }
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get("clusterNetwork").add(builder);
            this.clusterNetwork.add(builder);
        }
        return (A)this;
    }

    public A addAllToServiceNetwork(Collection<String> items) {
        if (this.serviceNetwork == null) {
            this.serviceNetwork = new ArrayList<String>();
        }
        for (String item : items) {
            this.serviceNetwork.add(item);
        }
        return (A)this;
    }

    public ClusterNetworkNested<A> addNewClusterNetwork() {
        return new ClusterNetworkNested(-1, null);
    }

    public A addNewClusterNetwork(String cidr, Long hostPrefix) {
        return this.addToClusterNetwork(new ClusterNetworkEntry(cidr, hostPrefix));
    }

    public ClusterNetworkNested<A> addNewClusterNetworkLike(ClusterNetworkEntry item) {
        return new ClusterNetworkNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToClusterNetwork(ClusterNetworkEntry ... items) {
        if (this.clusterNetwork == null) {
            this.clusterNetwork = new ArrayList();
        }
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get("clusterNetwork").add(builder);
            this.clusterNetwork.add(builder);
        }
        return (A)this;
    }

    public A addToClusterNetwork(int index, ClusterNetworkEntry item) {
        if (this.clusterNetwork == null) {
            this.clusterNetwork = new ArrayList();
        }
        ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
        if (index < 0 || index >= this.clusterNetwork.size()) {
            this._visitables.get("clusterNetwork").add(builder);
            this.clusterNetwork.add(builder);
        } else {
            this._visitables.get("clusterNetwork").add(builder);
            this.clusterNetwork.add(index, builder);
        }
        return (A)this;
    }

    public A addToServiceNetwork(String ... items) {
        if (this.serviceNetwork == null) {
            this.serviceNetwork = new ArrayList<String>();
        }
        for (String item : items) {
            this.serviceNetwork.add(item);
        }
        return (A)this;
    }

    public A addToServiceNetwork(int index, String item) {
        if (this.serviceNetwork == null) {
            this.serviceNetwork = new ArrayList<String>();
        }
        this.serviceNetwork.add(index, item);
        return (A)this;
    }

    public List<ClusterNetworkEntry> buildClusterNetwork() {
        return this.clusterNetwork != null ? NetworkSpecFluent.build(this.clusterNetwork) : null;
    }

    public ClusterNetworkEntry buildClusterNetwork(int index) {
        return this.clusterNetwork.get(index).build();
    }

    public ExternalIPConfig buildExternalIP() {
        return this.externalIP != null ? this.externalIP.build() : null;
    }

    public ClusterNetworkEntry buildFirstClusterNetwork() {
        return this.clusterNetwork.get(0).build();
    }

    public ClusterNetworkEntry buildLastClusterNetwork() {
        return this.clusterNetwork.get(this.clusterNetwork.size() - 1).build();
    }

    public ClusterNetworkEntry buildMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        for (ClusterNetworkEntryBuilder item : this.clusterNetwork) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public NetworkDiagnostics buildNetworkDiagnostics() {
        return this.networkDiagnostics != null ? this.networkDiagnostics.build() : null;
    }

    protected void copyInstance(NetworkSpec instance) {
        NetworkSpec networkSpec = instance = instance != null ? instance : new NetworkSpec();
        if (instance != null) {
            this.withClusterNetwork(instance.getClusterNetwork());
            this.withExternalIP(instance.getExternalIP());
            this.withNetworkDiagnostics(instance.getNetworkDiagnostics());
            this.withNetworkType(instance.getNetworkType());
            this.withServiceNetwork(instance.getServiceNetwork());
            this.withServiceNodePortRange(instance.getServiceNodePortRange());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ClusterNetworkNested<A> editClusterNetwork(int index) {
        if (this.clusterNetwork.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "clusterNetwork"));
        }
        return this.setNewClusterNetworkLike(index, this.buildClusterNetwork(index));
    }

    public ExternalIPNested<A> editExternalIP() {
        return this.withNewExternalIPLike(Optional.ofNullable(this.buildExternalIP()).orElse(null));
    }

    public ClusterNetworkNested<A> editFirstClusterNetwork() {
        if (this.clusterNetwork.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "clusterNetwork"));
        }
        return this.setNewClusterNetworkLike(0, this.buildClusterNetwork(0));
    }

    public ClusterNetworkNested<A> editLastClusterNetwork() {
        int index = this.clusterNetwork.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "clusterNetwork"));
        }
        return this.setNewClusterNetworkLike(index, this.buildClusterNetwork(index));
    }

    public ClusterNetworkNested<A> editMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.clusterNetwork.size(); ++i) {
            if (!predicate.test(this.clusterNetwork.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "clusterNetwork"));
        }
        return this.setNewClusterNetworkLike(index, this.buildClusterNetwork(index));
    }

    public NetworkDiagnosticsNested<A> editNetworkDiagnostics() {
        return this.withNewNetworkDiagnosticsLike(Optional.ofNullable(this.buildNetworkDiagnostics()).orElse(null));
    }

    public ExternalIPNested<A> editOrNewExternalIP() {
        return this.withNewExternalIPLike(Optional.ofNullable(this.buildExternalIP()).orElse(new ExternalIPConfigBuilder().build()));
    }

    public ExternalIPNested<A> editOrNewExternalIPLike(ExternalIPConfig item) {
        return this.withNewExternalIPLike(Optional.ofNullable(this.buildExternalIP()).orElse(item));
    }

    public NetworkDiagnosticsNested<A> editOrNewNetworkDiagnostics() {
        return this.withNewNetworkDiagnosticsLike(Optional.ofNullable(this.buildNetworkDiagnostics()).orElse(new NetworkDiagnosticsBuilder().build()));
    }

    public NetworkDiagnosticsNested<A> editOrNewNetworkDiagnosticsLike(NetworkDiagnostics item) {
        return this.withNewNetworkDiagnosticsLike(Optional.ofNullable(this.buildNetworkDiagnostics()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkSpecFluent that = (NetworkSpecFluent)o;
        if (!Objects.equals(this.clusterNetwork, that.clusterNetwork)) {
            return false;
        }
        if (!Objects.equals(this.externalIP, that.externalIP)) {
            return false;
        }
        if (!Objects.equals(this.networkDiagnostics, that.networkDiagnostics)) {
            return false;
        }
        if (!Objects.equals(this.networkType, that.networkType)) {
            return false;
        }
        if (!Objects.equals(this.serviceNetwork, that.serviceNetwork)) {
            return false;
        }
        if (!Objects.equals(this.serviceNodePortRange, that.serviceNodePortRange)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getFirstServiceNetwork() {
        return this.serviceNetwork.get(0);
    }

    public String getLastServiceNetwork() {
        return this.serviceNetwork.get(this.serviceNetwork.size() - 1);
    }

    public String getMatchingServiceNetwork(Predicate<String> predicate) {
        for (String item : this.serviceNetwork) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getNetworkType() {
        return this.networkType;
    }

    public List<String> getServiceNetwork() {
        return this.serviceNetwork;
    }

    public String getServiceNetwork(int index) {
        return this.serviceNetwork.get(index);
    }

    public String getServiceNodePortRange() {
        return this.serviceNodePortRange;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasClusterNetwork() {
        return this.clusterNetwork != null && !this.clusterNetwork.isEmpty();
    }

    public boolean hasExternalIP() {
        return this.externalIP != null;
    }

    public boolean hasMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        for (ClusterNetworkEntryBuilder item : this.clusterNetwork) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingServiceNetwork(Predicate<String> predicate) {
        for (String item : this.serviceNetwork) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNetworkDiagnostics() {
        return this.networkDiagnostics != null;
    }

    public boolean hasNetworkType() {
        return this.networkType != null;
    }

    public boolean hasServiceNetwork() {
        return this.serviceNetwork != null && !this.serviceNetwork.isEmpty();
    }

    public boolean hasServiceNodePortRange() {
        return this.serviceNodePortRange != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.clusterNetwork, this.externalIP, this.networkDiagnostics, this.networkType, this.serviceNetwork, this.serviceNodePortRange, this.additionalProperties);
    }

    public A removeAllFromClusterNetwork(Collection<ClusterNetworkEntry> items) {
        if (this.clusterNetwork == null) {
            return (A)this;
        }
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get("clusterNetwork").remove(builder);
            this.clusterNetwork.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromServiceNetwork(Collection<String> items) {
        if (this.serviceNetwork == null) {
            return (A)this;
        }
        for (String item : items) {
            this.serviceNetwork.remove(item);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public A removeFromClusterNetwork(ClusterNetworkEntry ... items) {
        if (this.clusterNetwork == null) {
            return (A)this;
        }
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get("clusterNetwork").remove(builder);
            this.clusterNetwork.remove(builder);
        }
        return (A)this;
    }

    public A removeFromServiceNetwork(String ... items) {
        if (this.serviceNetwork == null) {
            return (A)this;
        }
        for (String item : items) {
            this.serviceNetwork.remove(item);
        }
        return (A)this;
    }

    public A removeMatchingFromClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        if (this.clusterNetwork == null) {
            return (A)this;
        }
        Iterator<ClusterNetworkEntryBuilder> each = this.clusterNetwork.iterator();
        Object visitables = this._visitables.get("clusterNetwork");
        while (each.hasNext()) {
            ClusterNetworkEntryBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public ClusterNetworkNested<A> setNewClusterNetworkLike(int index, ClusterNetworkEntry item) {
        return new ClusterNetworkNested(index, item);
    }

    public A setToClusterNetwork(int index, ClusterNetworkEntry item) {
        if (this.clusterNetwork == null) {
            this.clusterNetwork = new ArrayList();
        }
        ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
        if (index < 0 || index >= this.clusterNetwork.size()) {
            this._visitables.get("clusterNetwork").add(builder);
            this.clusterNetwork.add(builder);
        } else {
            this._visitables.get("clusterNetwork").add(builder);
            this.clusterNetwork.set(index, builder);
        }
        return (A)this;
    }

    public A setToServiceNetwork(int index, String item) {
        if (this.serviceNetwork == null) {
            this.serviceNetwork = new ArrayList<String>();
        }
        this.serviceNetwork.set(index, item);
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterNetwork != null && !this.clusterNetwork.isEmpty()) {
            sb.append("clusterNetwork:");
            sb.append(this.clusterNetwork);
            sb.append(",");
        }
        if (this.externalIP != null) {
            sb.append("externalIP:");
            sb.append(this.externalIP);
            sb.append(",");
        }
        if (this.networkDiagnostics != null) {
            sb.append("networkDiagnostics:");
            sb.append(this.networkDiagnostics);
            sb.append(",");
        }
        if (this.networkType != null) {
            sb.append("networkType:");
            sb.append(this.networkType);
            sb.append(",");
        }
        if (this.serviceNetwork != null && !this.serviceNetwork.isEmpty()) {
            sb.append("serviceNetwork:");
            sb.append(this.serviceNetwork);
            sb.append(",");
        }
        if (this.serviceNodePortRange != null) {
            sb.append("serviceNodePortRange:");
            sb.append(this.serviceNodePortRange);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withClusterNetwork(List<ClusterNetworkEntry> clusterNetwork) {
        if (this.clusterNetwork != null) {
            this._visitables.get("clusterNetwork").clear();
        }
        if (clusterNetwork != null) {
            this.clusterNetwork = new ArrayList();
            for (ClusterNetworkEntry item : clusterNetwork) {
                this.addToClusterNetwork(item);
            }
        } else {
            this.clusterNetwork = null;
        }
        return (A)this;
    }

    public A withClusterNetwork(ClusterNetworkEntry ... clusterNetwork) {
        if (this.clusterNetwork != null) {
            this.clusterNetwork.clear();
            this._visitables.remove("clusterNetwork");
        }
        if (clusterNetwork != null) {
            for (ClusterNetworkEntry item : clusterNetwork) {
                this.addToClusterNetwork(item);
            }
        }
        return (A)this;
    }

    public A withExternalIP(ExternalIPConfig externalIP) {
        this._visitables.remove("externalIP");
        if (externalIP != null) {
            this.externalIP = new ExternalIPConfigBuilder(externalIP);
            this._visitables.get("externalIP").add(this.externalIP);
        } else {
            this.externalIP = null;
            this._visitables.get("externalIP").remove(this.externalIP);
        }
        return (A)this;
    }

    public A withNetworkDiagnostics(NetworkDiagnostics networkDiagnostics) {
        this._visitables.remove("networkDiagnostics");
        if (networkDiagnostics != null) {
            this.networkDiagnostics = new NetworkDiagnosticsBuilder(networkDiagnostics);
            this._visitables.get("networkDiagnostics").add(this.networkDiagnostics);
        } else {
            this.networkDiagnostics = null;
            this._visitables.get("networkDiagnostics").remove(this.networkDiagnostics);
        }
        return (A)this;
    }

    public A withNetworkType(String networkType) {
        this.networkType = networkType;
        return (A)this;
    }

    public ExternalIPNested<A> withNewExternalIP() {
        return new ExternalIPNested(null);
    }

    public ExternalIPNested<A> withNewExternalIPLike(ExternalIPConfig item) {
        return new ExternalIPNested(item);
    }

    public NetworkDiagnosticsNested<A> withNewNetworkDiagnostics() {
        return new NetworkDiagnosticsNested(null);
    }

    public NetworkDiagnosticsNested<A> withNewNetworkDiagnosticsLike(NetworkDiagnostics item) {
        return new NetworkDiagnosticsNested(item);
    }

    public A withServiceNetwork(List<String> serviceNetwork) {
        if (serviceNetwork != null) {
            this.serviceNetwork = new ArrayList<String>();
            for (String item : serviceNetwork) {
                this.addToServiceNetwork(item);
            }
        } else {
            this.serviceNetwork = null;
        }
        return (A)this;
    }

    public A withServiceNetwork(String ... serviceNetwork) {
        if (this.serviceNetwork != null) {
            this.serviceNetwork.clear();
            this._visitables.remove("serviceNetwork");
        }
        if (serviceNetwork != null) {
            for (String item : serviceNetwork) {
                this.addToServiceNetwork(item);
            }
        }
        return (A)this;
    }

    public A withServiceNodePortRange(String serviceNodePortRange) {
        this.serviceNodePortRange = serviceNodePortRange;
        return (A)this;
    }

    public class NetworkDiagnosticsNested<N>
    extends NetworkDiagnosticsFluent<NetworkDiagnosticsNested<N>>
    implements Nested<N> {
        NetworkDiagnosticsBuilder builder;

        NetworkDiagnosticsNested(NetworkDiagnostics item) {
            this.builder = new NetworkDiagnosticsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NetworkSpecFluent.this.withNetworkDiagnostics(this.builder.build());
        }

        public N endNetworkDiagnostics() {
            return this.and();
        }
    }

    public class ExternalIPNested<N>
    extends ExternalIPConfigFluent<ExternalIPNested<N>>
    implements Nested<N> {
        ExternalIPConfigBuilder builder;

        ExternalIPNested(ExternalIPConfig item) {
            this.builder = new ExternalIPConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NetworkSpecFluent.this.withExternalIP(this.builder.build());
        }

        public N endExternalIP() {
            return this.and();
        }
    }

    public class ClusterNetworkNested<N>
    extends ClusterNetworkEntryFluent<ClusterNetworkNested<N>>
    implements Nested<N> {
        ClusterNetworkEntryBuilder builder;
        int index;

        ClusterNetworkNested(int index, ClusterNetworkEntry item) {
            this.index = index;
            this.builder = new ClusterNetworkEntryBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NetworkSpecFluent.this.setToClusterNetwork(this.index, this.builder.build());
        }

        public N endClusterNetwork() {
            return this.and();
        }
    }
}

