/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.ImagePolicySpec;
import io.fabric8.openshift.api.model.config.v1.Policy;
import io.fabric8.openshift.api.model.config.v1.PolicyBuilder;
import io.fabric8.openshift.api.model.config.v1.PolicyFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ImagePolicySpecFluent<A extends ImagePolicySpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private PolicyBuilder policy;
    private List<String> scopes = new ArrayList<String>();

    public ImagePolicySpecFluent() {
    }

    public ImagePolicySpecFluent(ImagePolicySpec instance) {
        this.copyInstance(instance);
    }

    public A addAllToScopes(Collection<String> items) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        for (String item : items) {
            this.scopes.add(item);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToScopes(String ... items) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        for (String item : items) {
            this.scopes.add(item);
        }
        return (A)this;
    }

    public A addToScopes(int index, String item) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.add(index, item);
        return (A)this;
    }

    public Policy buildPolicy() {
        return this.policy != null ? this.policy.build() : null;
    }

    protected void copyInstance(ImagePolicySpec instance) {
        ImagePolicySpec imagePolicySpec = instance = instance != null ? instance : new ImagePolicySpec();
        if (instance != null) {
            this.withPolicy(instance.getPolicy());
            this.withScopes(instance.getScopes());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public PolicyNested<A> editOrNewPolicy() {
        return this.withNewPolicyLike(Optional.ofNullable(this.buildPolicy()).orElse(new PolicyBuilder().build()));
    }

    public PolicyNested<A> editOrNewPolicyLike(Policy item) {
        return this.withNewPolicyLike(Optional.ofNullable(this.buildPolicy()).orElse(item));
    }

    public PolicyNested<A> editPolicy() {
        return this.withNewPolicyLike(Optional.ofNullable(this.buildPolicy()).orElse(null));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImagePolicySpecFluent that = (ImagePolicySpecFluent)o;
        if (!Objects.equals(this.policy, that.policy)) {
            return false;
        }
        if (!Objects.equals(this.scopes, that.scopes)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getFirstScope() {
        return this.scopes.get(0);
    }

    public String getLastScope() {
        return this.scopes.get(this.scopes.size() - 1);
    }

    public String getMatchingScope(Predicate<String> predicate) {
        for (String item : this.scopes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getScope(int index) {
        return this.scopes.get(index);
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasMatchingScope(Predicate<String> predicate) {
        for (String item : this.scopes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPolicy() {
        return this.policy != null;
    }

    public boolean hasScopes() {
        return this.scopes != null && !this.scopes.isEmpty();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.policy, this.scopes, this.additionalProperties);
    }

    public A removeAllFromScopes(Collection<String> items) {
        if (this.scopes == null) {
            return (A)this;
        }
        for (String item : items) {
            this.scopes.remove(item);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public A removeFromScopes(String ... items) {
        if (this.scopes == null) {
            return (A)this;
        }
        for (String item : items) {
            this.scopes.remove(item);
        }
        return (A)this;
    }

    public A setToScopes(int index, String item) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.set(index, item);
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.policy != null) {
            sb.append("policy:");
            sb.append(this.policy);
            sb.append(",");
        }
        if (this.scopes != null && !this.scopes.isEmpty()) {
            sb.append("scopes:");
            sb.append(this.scopes);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public PolicyNested<A> withNewPolicy() {
        return new PolicyNested(null);
    }

    public PolicyNested<A> withNewPolicyLike(Policy item) {
        return new PolicyNested(item);
    }

    public A withPolicy(Policy policy) {
        this._visitables.remove("policy");
        if (policy != null) {
            this.policy = new PolicyBuilder(policy);
            this._visitables.get("policy").add(this.policy);
        } else {
            this.policy = null;
            this._visitables.get("policy").remove(this.policy);
        }
        return (A)this;
    }

    public A withScopes(List<String> scopes) {
        if (scopes != null) {
            this.scopes = new ArrayList<String>();
            for (String item : scopes) {
                this.addToScopes(item);
            }
        } else {
            this.scopes = null;
        }
        return (A)this;
    }

    public A withScopes(String ... scopes) {
        if (this.scopes != null) {
            this.scopes.clear();
            this._visitables.remove("scopes");
        }
        if (scopes != null) {
            for (String item : scopes) {
                this.addToScopes(item);
            }
        }
        return (A)this;
    }

    public class PolicyNested<N>
    extends PolicyFluent<PolicyNested<N>>
    implements Nested<N> {
        PolicyBuilder builder;

        PolicyNested(Policy item) {
            this.builder = new PolicyBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ImagePolicySpecFluent.this.withPolicy(this.builder.build());
        }

        public N endPolicy() {
            return this.and();
        }
    }
}

