/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.AuthenticationStatus;
import io.fabric8.openshift.api.model.config.v1.ConfigMapNameReference;
import io.fabric8.openshift.api.model.config.v1.ConfigMapNameReferenceBuilder;
import io.fabric8.openshift.api.model.config.v1.ConfigMapNameReferenceFluent;
import io.fabric8.openshift.api.model.config.v1.OIDCClientStatus;
import io.fabric8.openshift.api.model.config.v1.OIDCClientStatusBuilder;
import io.fabric8.openshift.api.model.config.v1.OIDCClientStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class AuthenticationStatusFluent<A extends AuthenticationStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ConfigMapNameReferenceBuilder integratedOAuthMetadata;
    private ArrayList<OIDCClientStatusBuilder> oidcClients = new ArrayList();

    public AuthenticationStatusFluent() {
    }

    public AuthenticationStatusFluent(AuthenticationStatus instance) {
        this.copyInstance(instance);
    }

    public A addAllToOidcClients(Collection<OIDCClientStatus> items) {
        if (this.oidcClients == null) {
            this.oidcClients = new ArrayList();
        }
        for (OIDCClientStatus item : items) {
            OIDCClientStatusBuilder builder = new OIDCClientStatusBuilder(item);
            this._visitables.get("oidcClients").add(builder);
            this.oidcClients.add(builder);
        }
        return (A)this;
    }

    public OidcClientsNested<A> addNewOidcClient() {
        return new OidcClientsNested(-1, null);
    }

    public OidcClientsNested<A> addNewOidcClientLike(OIDCClientStatus item) {
        return new OidcClientsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToOidcClients(OIDCClientStatus ... items) {
        if (this.oidcClients == null) {
            this.oidcClients = new ArrayList();
        }
        for (OIDCClientStatus item : items) {
            OIDCClientStatusBuilder builder = new OIDCClientStatusBuilder(item);
            this._visitables.get("oidcClients").add(builder);
            this.oidcClients.add(builder);
        }
        return (A)this;
    }

    public A addToOidcClients(int index, OIDCClientStatus item) {
        if (this.oidcClients == null) {
            this.oidcClients = new ArrayList();
        }
        OIDCClientStatusBuilder builder = new OIDCClientStatusBuilder(item);
        if (index < 0 || index >= this.oidcClients.size()) {
            this._visitables.get("oidcClients").add(builder);
            this.oidcClients.add(builder);
        } else {
            this._visitables.get("oidcClients").add(builder);
            this.oidcClients.add(index, builder);
        }
        return (A)this;
    }

    public OIDCClientStatus buildFirstOidcClient() {
        return this.oidcClients.get(0).build();
    }

    public ConfigMapNameReference buildIntegratedOAuthMetadata() {
        return this.integratedOAuthMetadata != null ? this.integratedOAuthMetadata.build() : null;
    }

    public OIDCClientStatus buildLastOidcClient() {
        return this.oidcClients.get(this.oidcClients.size() - 1).build();
    }

    public OIDCClientStatus buildMatchingOidcClient(Predicate<OIDCClientStatusBuilder> predicate) {
        for (OIDCClientStatusBuilder item : this.oidcClients) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public OIDCClientStatus buildOidcClient(int index) {
        return this.oidcClients.get(index).build();
    }

    public List<OIDCClientStatus> buildOidcClients() {
        return this.oidcClients != null ? AuthenticationStatusFluent.build(this.oidcClients) : null;
    }

    protected void copyInstance(AuthenticationStatus instance) {
        AuthenticationStatus authenticationStatus = instance = instance != null ? instance : new AuthenticationStatus();
        if (instance != null) {
            this.withIntegratedOAuthMetadata(instance.getIntegratedOAuthMetadata());
            this.withOidcClients(instance.getOidcClients());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public OidcClientsNested<A> editFirstOidcClient() {
        if (this.oidcClients.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "oidcClients"));
        }
        return this.setNewOidcClientLike(0, this.buildOidcClient(0));
    }

    public IntegratedOAuthMetadataNested<A> editIntegratedOAuthMetadata() {
        return this.withNewIntegratedOAuthMetadataLike(Optional.ofNullable(this.buildIntegratedOAuthMetadata()).orElse(null));
    }

    public OidcClientsNested<A> editLastOidcClient() {
        int index = this.oidcClients.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "oidcClients"));
        }
        return this.setNewOidcClientLike(index, this.buildOidcClient(index));
    }

    public OidcClientsNested<A> editMatchingOidcClient(Predicate<OIDCClientStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.oidcClients.size(); ++i) {
            if (!predicate.test(this.oidcClients.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "oidcClients"));
        }
        return this.setNewOidcClientLike(index, this.buildOidcClient(index));
    }

    public OidcClientsNested<A> editOidcClient(int index) {
        if (this.oidcClients.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "oidcClients"));
        }
        return this.setNewOidcClientLike(index, this.buildOidcClient(index));
    }

    public IntegratedOAuthMetadataNested<A> editOrNewIntegratedOAuthMetadata() {
        return this.withNewIntegratedOAuthMetadataLike(Optional.ofNullable(this.buildIntegratedOAuthMetadata()).orElse(new ConfigMapNameReferenceBuilder().build()));
    }

    public IntegratedOAuthMetadataNested<A> editOrNewIntegratedOAuthMetadataLike(ConfigMapNameReference item) {
        return this.withNewIntegratedOAuthMetadataLike(Optional.ofNullable(this.buildIntegratedOAuthMetadata()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AuthenticationStatusFluent that = (AuthenticationStatusFluent)o;
        if (!Objects.equals(this.integratedOAuthMetadata, that.integratedOAuthMetadata)) {
            return false;
        }
        if (!Objects.equals(this.oidcClients, that.oidcClients)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasIntegratedOAuthMetadata() {
        return this.integratedOAuthMetadata != null;
    }

    public boolean hasMatchingOidcClient(Predicate<OIDCClientStatusBuilder> predicate) {
        for (OIDCClientStatusBuilder item : this.oidcClients) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasOidcClients() {
        return this.oidcClients != null && !this.oidcClients.isEmpty();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.integratedOAuthMetadata, this.oidcClients, this.additionalProperties);
    }

    public A removeAllFromOidcClients(Collection<OIDCClientStatus> items) {
        if (this.oidcClients == null) {
            return (A)this;
        }
        for (OIDCClientStatus item : items) {
            OIDCClientStatusBuilder builder = new OIDCClientStatusBuilder(item);
            this._visitables.get("oidcClients").remove(builder);
            this.oidcClients.remove(builder);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public A removeFromOidcClients(OIDCClientStatus ... items) {
        if (this.oidcClients == null) {
            return (A)this;
        }
        for (OIDCClientStatus item : items) {
            OIDCClientStatusBuilder builder = new OIDCClientStatusBuilder(item);
            this._visitables.get("oidcClients").remove(builder);
            this.oidcClients.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromOidcClients(Predicate<OIDCClientStatusBuilder> predicate) {
        if (this.oidcClients == null) {
            return (A)this;
        }
        Iterator<OIDCClientStatusBuilder> each = this.oidcClients.iterator();
        Object visitables = this._visitables.get("oidcClients");
        while (each.hasNext()) {
            OIDCClientStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public OidcClientsNested<A> setNewOidcClientLike(int index, OIDCClientStatus item) {
        return new OidcClientsNested(index, item);
    }

    public A setToOidcClients(int index, OIDCClientStatus item) {
        if (this.oidcClients == null) {
            this.oidcClients = new ArrayList();
        }
        OIDCClientStatusBuilder builder = new OIDCClientStatusBuilder(item);
        if (index < 0 || index >= this.oidcClients.size()) {
            this._visitables.get("oidcClients").add(builder);
            this.oidcClients.add(builder);
        } else {
            this._visitables.get("oidcClients").add(builder);
            this.oidcClients.set(index, builder);
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.integratedOAuthMetadata != null) {
            sb.append("integratedOAuthMetadata:");
            sb.append(this.integratedOAuthMetadata);
            sb.append(",");
        }
        if (this.oidcClients != null && !this.oidcClients.isEmpty()) {
            sb.append("oidcClients:");
            sb.append(this.oidcClients);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withIntegratedOAuthMetadata(ConfigMapNameReference integratedOAuthMetadata) {
        this._visitables.remove("integratedOAuthMetadata");
        if (integratedOAuthMetadata != null) {
            this.integratedOAuthMetadata = new ConfigMapNameReferenceBuilder(integratedOAuthMetadata);
            this._visitables.get("integratedOAuthMetadata").add(this.integratedOAuthMetadata);
        } else {
            this.integratedOAuthMetadata = null;
            this._visitables.get("integratedOAuthMetadata").remove(this.integratedOAuthMetadata);
        }
        return (A)this;
    }

    public IntegratedOAuthMetadataNested<A> withNewIntegratedOAuthMetadata() {
        return new IntegratedOAuthMetadataNested(null);
    }

    public A withNewIntegratedOAuthMetadata(String name) {
        return this.withIntegratedOAuthMetadata(new ConfigMapNameReference(name));
    }

    public IntegratedOAuthMetadataNested<A> withNewIntegratedOAuthMetadataLike(ConfigMapNameReference item) {
        return new IntegratedOAuthMetadataNested(item);
    }

    public A withOidcClients(List<OIDCClientStatus> oidcClients) {
        if (this.oidcClients != null) {
            this._visitables.get("oidcClients").clear();
        }
        if (oidcClients != null) {
            this.oidcClients = new ArrayList();
            for (OIDCClientStatus item : oidcClients) {
                this.addToOidcClients(item);
            }
        } else {
            this.oidcClients = null;
        }
        return (A)this;
    }

    public A withOidcClients(OIDCClientStatus ... oidcClients) {
        if (this.oidcClients != null) {
            this.oidcClients.clear();
            this._visitables.remove("oidcClients");
        }
        if (oidcClients != null) {
            for (OIDCClientStatus item : oidcClients) {
                this.addToOidcClients(item);
            }
        }
        return (A)this;
    }

    public class OidcClientsNested<N>
    extends OIDCClientStatusFluent<OidcClientsNested<N>>
    implements Nested<N> {
        OIDCClientStatusBuilder builder;
        int index;

        OidcClientsNested(int index, OIDCClientStatus item) {
            this.index = index;
            this.builder = new OIDCClientStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AuthenticationStatusFluent.this.setToOidcClients(this.index, this.builder.build());
        }

        public N endOidcClient() {
            return this.and();
        }
    }

    public class IntegratedOAuthMetadataNested<N>
    extends ConfigMapNameReferenceFluent<IntegratedOAuthMetadataNested<N>>
    implements Nested<N> {
        ConfigMapNameReferenceBuilder builder;

        IntegratedOAuthMetadataNested(ConfigMapNameReference item) {
            this.builder = new ConfigMapNameReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AuthenticationStatusFluent.this.withIntegratedOAuthMetadata(this.builder.build());
        }

        public N endIntegratedOAuthMetadata() {
            return this.and();
        }
    }
}

