/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.PodSecurityPolicyReviewStatus;
import io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatus;
import io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatusBuilder;
import io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class PodSecurityPolicyReviewStatusFluent<A extends PodSecurityPolicyReviewStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ArrayList<ServiceAccountPodSecurityPolicyReviewStatusBuilder> allowedServiceAccounts = new ArrayList();

    public PodSecurityPolicyReviewStatusFluent() {
    }

    public PodSecurityPolicyReviewStatusFluent(PodSecurityPolicyReviewStatus instance) {
        this.copyInstance(instance);
    }

    public A addAllToAllowedServiceAccounts(Collection<ServiceAccountPodSecurityPolicyReviewStatus> items) {
        if (this.allowedServiceAccounts == null) {
            this.allowedServiceAccounts = new ArrayList();
        }
        for (ServiceAccountPodSecurityPolicyReviewStatus item : items) {
            ServiceAccountPodSecurityPolicyReviewStatusBuilder builder = new ServiceAccountPodSecurityPolicyReviewStatusBuilder(item);
            this._visitables.get("allowedServiceAccounts").add(builder);
            this.allowedServiceAccounts.add(builder);
        }
        return (A)this;
    }

    public AllowedServiceAccountsNested<A> addNewAllowedServiceAccount() {
        return new AllowedServiceAccountsNested(-1, null);
    }

    public AllowedServiceAccountsNested<A> addNewAllowedServiceAccountLike(ServiceAccountPodSecurityPolicyReviewStatus item) {
        return new AllowedServiceAccountsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAllowedServiceAccounts(ServiceAccountPodSecurityPolicyReviewStatus ... items) {
        if (this.allowedServiceAccounts == null) {
            this.allowedServiceAccounts = new ArrayList();
        }
        for (ServiceAccountPodSecurityPolicyReviewStatus item : items) {
            ServiceAccountPodSecurityPolicyReviewStatusBuilder builder = new ServiceAccountPodSecurityPolicyReviewStatusBuilder(item);
            this._visitables.get("allowedServiceAccounts").add(builder);
            this.allowedServiceAccounts.add(builder);
        }
        return (A)this;
    }

    public A addToAllowedServiceAccounts(int index, ServiceAccountPodSecurityPolicyReviewStatus item) {
        if (this.allowedServiceAccounts == null) {
            this.allowedServiceAccounts = new ArrayList();
        }
        ServiceAccountPodSecurityPolicyReviewStatusBuilder builder = new ServiceAccountPodSecurityPolicyReviewStatusBuilder(item);
        if (index < 0 || index >= this.allowedServiceAccounts.size()) {
            this._visitables.get("allowedServiceAccounts").add(builder);
            this.allowedServiceAccounts.add(builder);
        } else {
            this._visitables.get("allowedServiceAccounts").add(builder);
            this.allowedServiceAccounts.add(index, builder);
        }
        return (A)this;
    }

    public ServiceAccountPodSecurityPolicyReviewStatus buildAllowedServiceAccount(int index) {
        return this.allowedServiceAccounts.get(index).build();
    }

    public List<ServiceAccountPodSecurityPolicyReviewStatus> buildAllowedServiceAccounts() {
        return this.allowedServiceAccounts != null ? PodSecurityPolicyReviewStatusFluent.build(this.allowedServiceAccounts) : null;
    }

    public ServiceAccountPodSecurityPolicyReviewStatus buildFirstAllowedServiceAccount() {
        return this.allowedServiceAccounts.get(0).build();
    }

    public ServiceAccountPodSecurityPolicyReviewStatus buildLastAllowedServiceAccount() {
        return this.allowedServiceAccounts.get(this.allowedServiceAccounts.size() - 1).build();
    }

    public ServiceAccountPodSecurityPolicyReviewStatus buildMatchingAllowedServiceAccount(Predicate<ServiceAccountPodSecurityPolicyReviewStatusBuilder> predicate) {
        for (ServiceAccountPodSecurityPolicyReviewStatusBuilder item : this.allowedServiceAccounts) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    protected void copyInstance(PodSecurityPolicyReviewStatus instance) {
        PodSecurityPolicyReviewStatus podSecurityPolicyReviewStatus = instance = instance != null ? instance : new PodSecurityPolicyReviewStatus();
        if (instance != null) {
            this.withAllowedServiceAccounts(instance.getAllowedServiceAccounts());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public AllowedServiceAccountsNested<A> editAllowedServiceAccount(int index) {
        if (this.allowedServiceAccounts.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "allowedServiceAccounts"));
        }
        return this.setNewAllowedServiceAccountLike(index, this.buildAllowedServiceAccount(index));
    }

    public AllowedServiceAccountsNested<A> editFirstAllowedServiceAccount() {
        if (this.allowedServiceAccounts.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "allowedServiceAccounts"));
        }
        return this.setNewAllowedServiceAccountLike(0, this.buildAllowedServiceAccount(0));
    }

    public AllowedServiceAccountsNested<A> editLastAllowedServiceAccount() {
        int index = this.allowedServiceAccounts.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "allowedServiceAccounts"));
        }
        return this.setNewAllowedServiceAccountLike(index, this.buildAllowedServiceAccount(index));
    }

    public AllowedServiceAccountsNested<A> editMatchingAllowedServiceAccount(Predicate<ServiceAccountPodSecurityPolicyReviewStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.allowedServiceAccounts.size(); ++i) {
            if (!predicate.test(this.allowedServiceAccounts.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "allowedServiceAccounts"));
        }
        return this.setNewAllowedServiceAccountLike(index, this.buildAllowedServiceAccount(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodSecurityPolicyReviewStatusFluent that = (PodSecurityPolicyReviewStatusFluent)o;
        if (!Objects.equals(this.allowedServiceAccounts, that.allowedServiceAccounts)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAllowedServiceAccounts() {
        return this.allowedServiceAccounts != null && !this.allowedServiceAccounts.isEmpty();
    }

    public boolean hasMatchingAllowedServiceAccount(Predicate<ServiceAccountPodSecurityPolicyReviewStatusBuilder> predicate) {
        for (ServiceAccountPodSecurityPolicyReviewStatusBuilder item : this.allowedServiceAccounts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.allowedServiceAccounts, this.additionalProperties);
    }

    public A removeAllFromAllowedServiceAccounts(Collection<ServiceAccountPodSecurityPolicyReviewStatus> items) {
        if (this.allowedServiceAccounts == null) {
            return (A)this;
        }
        for (ServiceAccountPodSecurityPolicyReviewStatus item : items) {
            ServiceAccountPodSecurityPolicyReviewStatusBuilder builder = new ServiceAccountPodSecurityPolicyReviewStatusBuilder(item);
            this._visitables.get("allowedServiceAccounts").remove(builder);
            this.allowedServiceAccounts.remove(builder);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public A removeFromAllowedServiceAccounts(ServiceAccountPodSecurityPolicyReviewStatus ... items) {
        if (this.allowedServiceAccounts == null) {
            return (A)this;
        }
        for (ServiceAccountPodSecurityPolicyReviewStatus item : items) {
            ServiceAccountPodSecurityPolicyReviewStatusBuilder builder = new ServiceAccountPodSecurityPolicyReviewStatusBuilder(item);
            this._visitables.get("allowedServiceAccounts").remove(builder);
            this.allowedServiceAccounts.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromAllowedServiceAccounts(Predicate<ServiceAccountPodSecurityPolicyReviewStatusBuilder> predicate) {
        if (this.allowedServiceAccounts == null) {
            return (A)this;
        }
        Iterator<ServiceAccountPodSecurityPolicyReviewStatusBuilder> each = this.allowedServiceAccounts.iterator();
        Object visitables = this._visitables.get("allowedServiceAccounts");
        while (each.hasNext()) {
            ServiceAccountPodSecurityPolicyReviewStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public AllowedServiceAccountsNested<A> setNewAllowedServiceAccountLike(int index, ServiceAccountPodSecurityPolicyReviewStatus item) {
        return new AllowedServiceAccountsNested(index, item);
    }

    public A setToAllowedServiceAccounts(int index, ServiceAccountPodSecurityPolicyReviewStatus item) {
        if (this.allowedServiceAccounts == null) {
            this.allowedServiceAccounts = new ArrayList();
        }
        ServiceAccountPodSecurityPolicyReviewStatusBuilder builder = new ServiceAccountPodSecurityPolicyReviewStatusBuilder(item);
        if (index < 0 || index >= this.allowedServiceAccounts.size()) {
            this._visitables.get("allowedServiceAccounts").add(builder);
            this.allowedServiceAccounts.add(builder);
        } else {
            this._visitables.get("allowedServiceAccounts").add(builder);
            this.allowedServiceAccounts.set(index, builder);
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allowedServiceAccounts != null && !this.allowedServiceAccounts.isEmpty()) {
            sb.append("allowedServiceAccounts:");
            sb.append(this.allowedServiceAccounts);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withAllowedServiceAccounts(List<ServiceAccountPodSecurityPolicyReviewStatus> allowedServiceAccounts) {
        if (this.allowedServiceAccounts != null) {
            this._visitables.get("allowedServiceAccounts").clear();
        }
        if (allowedServiceAccounts != null) {
            this.allowedServiceAccounts = new ArrayList();
            for (ServiceAccountPodSecurityPolicyReviewStatus item : allowedServiceAccounts) {
                this.addToAllowedServiceAccounts(item);
            }
        } else {
            this.allowedServiceAccounts = null;
        }
        return (A)this;
    }

    public A withAllowedServiceAccounts(ServiceAccountPodSecurityPolicyReviewStatus ... allowedServiceAccounts) {
        if (this.allowedServiceAccounts != null) {
            this.allowedServiceAccounts.clear();
            this._visitables.remove("allowedServiceAccounts");
        }
        if (allowedServiceAccounts != null) {
            for (ServiceAccountPodSecurityPolicyReviewStatus item : allowedServiceAccounts) {
                this.addToAllowedServiceAccounts(item);
            }
        }
        return (A)this;
    }

    public class AllowedServiceAccountsNested<N>
    extends ServiceAccountPodSecurityPolicyReviewStatusFluent<AllowedServiceAccountsNested<N>>
    implements Nested<N> {
        ServiceAccountPodSecurityPolicyReviewStatusBuilder builder;
        int index;

        AllowedServiceAccountsNested(int index, ServiceAccountPodSecurityPolicyReviewStatus item) {
            this.index = index;
            this.builder = new ServiceAccountPodSecurityPolicyReviewStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodSecurityPolicyReviewStatusFluent.this.setToAllowedServiceAccounts(this.index, this.builder.build());
        }

        public N endAllowedServiceAccount() {
            return this.and();
        }
    }
}

