/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.ImageChangeTriggerStatus;
import io.fabric8.openshift.api.model.ImageStreamTagReference;
import io.fabric8.openshift.api.model.ImageStreamTagReferenceBuilder;
import io.fabric8.openshift.api.model.ImageStreamTagReferenceFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ImageChangeTriggerStatusFluent<A extends ImageChangeTriggerStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ImageStreamTagReferenceBuilder from;
    private String lastTriggerTime;
    private String lastTriggeredImageID;

    public ImageChangeTriggerStatusFluent() {
    }

    public ImageChangeTriggerStatusFluent(ImageChangeTriggerStatus instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public ImageStreamTagReference buildFrom() {
        return this.from != null ? this.from.build() : null;
    }

    protected void copyInstance(ImageChangeTriggerStatus instance) {
        ImageChangeTriggerStatus imageChangeTriggerStatus = instance = instance != null ? instance : new ImageChangeTriggerStatus();
        if (instance != null) {
            this.withFrom(instance.getFrom());
            this.withLastTriggerTime(instance.getLastTriggerTime());
            this.withLastTriggeredImageID(instance.getLastTriggeredImageID());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public FromNested<A> editFrom() {
        return this.withNewFromLike(Optional.ofNullable(this.buildFrom()).orElse(null));
    }

    public FromNested<A> editOrNewFrom() {
        return this.withNewFromLike(Optional.ofNullable(this.buildFrom()).orElse(new ImageStreamTagReferenceBuilder().build()));
    }

    public FromNested<A> editOrNewFromLike(ImageStreamTagReference item) {
        return this.withNewFromLike(Optional.ofNullable(this.buildFrom()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageChangeTriggerStatusFluent that = (ImageChangeTriggerStatusFluent)o;
        if (!Objects.equals(this.from, that.from)) {
            return false;
        }
        if (!Objects.equals(this.lastTriggerTime, that.lastTriggerTime)) {
            return false;
        }
        if (!Objects.equals(this.lastTriggeredImageID, that.lastTriggeredImageID)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getLastTriggerTime() {
        return this.lastTriggerTime;
    }

    public String getLastTriggeredImageID() {
        return this.lastTriggeredImageID;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasFrom() {
        return this.from != null;
    }

    public boolean hasLastTriggerTime() {
        return this.lastTriggerTime != null;
    }

    public boolean hasLastTriggeredImageID() {
        return this.lastTriggeredImageID != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.from, this.lastTriggerTime, this.lastTriggeredImageID, this.additionalProperties);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.from != null) {
            sb.append("from:");
            sb.append(this.from);
            sb.append(",");
        }
        if (this.lastTriggerTime != null) {
            sb.append("lastTriggerTime:");
            sb.append(this.lastTriggerTime);
            sb.append(",");
        }
        if (this.lastTriggeredImageID != null) {
            sb.append("lastTriggeredImageID:");
            sb.append(this.lastTriggeredImageID);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withFrom(ImageStreamTagReference from) {
        this._visitables.remove("from");
        if (from != null) {
            this.from = new ImageStreamTagReferenceBuilder(from);
            this._visitables.get("from").add(this.from);
        } else {
            this.from = null;
            this._visitables.get("from").remove(this.from);
        }
        return (A)this;
    }

    public A withLastTriggerTime(String lastTriggerTime) {
        this.lastTriggerTime = lastTriggerTime;
        return (A)this;
    }

    public A withLastTriggeredImageID(String lastTriggeredImageID) {
        this.lastTriggeredImageID = lastTriggeredImageID;
        return (A)this;
    }

    public FromNested<A> withNewFrom() {
        return new FromNested(null);
    }

    public A withNewFrom(String name, String namespace) {
        return this.withFrom(new ImageStreamTagReference(name, namespace));
    }

    public FromNested<A> withNewFromLike(ImageStreamTagReference item) {
        return new FromNested(item);
    }

    public class FromNested<N>
    extends ImageStreamTagReferenceFluent<FromNested<N>>
    implements Nested<N> {
        ImageStreamTagReferenceBuilder builder;

        FromNested(ImageStreamTagReference item) {
            this.builder = new ImageStreamTagReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ImageChangeTriggerStatusFluent.this.withFrom(this.builder.build());
        }

        public N endFrom() {
            return this.and();
        }
    }
}

