/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.server.mock;

import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import io.fabric8.kubernetes.client.server.mock.EnableKubernetesMockClient;
import io.fabric8.kubernetes.client.server.mock.KubernetesMixedDispatcher;
import io.fabric8.kubernetes.client.server.mock.KubernetesMockServer;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.MockWebServer;
import io.fabric8.mockwebserver.ServerRequest;
import io.fabric8.mockwebserver.ServerResponse;
import io.fabric8.mockwebserver.internal.MockDispatcher;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Queue;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class KubernetesMockServerExtension
implements AfterEachCallback,
AfterAllCallback,
BeforeEachCallback,
BeforeAllCallback {
    private KubernetesMockServer staticMock;
    private NamespacedKubernetesClient staticClient;
    private KubernetesMockServer instantMock;
    private NamespacedKubernetesClient instantClient;

    public void afterEach(ExtensionContext context) {
        this.destroy();
    }

    public void afterAll(ExtensionContext context) {
        this.destroyStatic();
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        context.getTestClass().ifPresent(testClass -> this.initializeKubernetesClientAndMockServer((Class<?>)testClass, false));
        for (Object testInstance : context.getRequiredTestInstances().getAllInstances()) {
            for (Field field : KubernetesMockServerExtension.extractFields(context, Client.class, f -> !Modifier.isStatic(f.getModifiers()))) {
                if (!field.getDeclaringClass().isAssignableFrom(testInstance.getClass())) continue;
                KubernetesMockServerExtension.setFieldValue(field, testInstance, this.instantClient.adapt(field.getType()));
            }
            for (Field field : KubernetesMockServerExtension.extractFields(context, KubernetesMockServer.class, f -> !Modifier.isStatic(f.getModifiers()))) {
                if (!field.getDeclaringClass().isAssignableFrom(testInstance.getClass())) continue;
                KubernetesMockServerExtension.setFieldValue(field, testInstance, this.instantMock);
            }
        }
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        context.getTestClass().ifPresent(testClass -> this.initializeKubernetesClientAndMockServer((Class<?>)testClass, true));
        for (Field field : KubernetesMockServerExtension.extractFields(context, Client.class, f -> Modifier.isStatic(f.getModifiers()))) {
            KubernetesMockServerExtension.setFieldValue(field, null, this.staticClient.adapt(field.getType()));
        }
        for (Field field : KubernetesMockServerExtension.extractFields(context, KubernetesMockServer.class, f -> Modifier.isStatic(f.getModifiers()))) {
            KubernetesMockServerExtension.setFieldValue(field, null, this.staticMock);
        }
    }

    protected void initializeKubernetesClientAndMockServer(Class<?> testClass, boolean isStatic) {
        EnableKubernetesMockClient a = KubernetesMockServerExtension.extractEnabledKubernetesMockClient(testClass);
        if (a == null) {
            return;
        }
        HashMap<ServerRequest, Queue<ServerResponse>> responses = new HashMap<ServerRequest, Queue<ServerResponse>>();
        KubernetesMixedDispatcher dispatcher = a.crud() ? new KubernetesMixedDispatcher(responses) : new MockDispatcher(responses);
        KubernetesMockServer mock = new KubernetesMockServer(new Context(Serialization.jsonMapper()), new MockWebServer(), responses, dispatcher, a.https());
        mock.init();
        if (isStatic) {
            this.staticMock = mock;
        } else {
            this.instantMock = mock;
        }
        try {
            NamespacedKubernetesClient client = mock.createClient(a.kubernetesClientBuilderCustomizer().getConstructor(new Class[0]).newInstance(new Object[0]));
            if (isStatic) {
                this.staticClient = client;
            } else {
                this.instantClient = client;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The provided kubernetesClientBuilder is invalid", e);
        }
    }

    private static EnableKubernetesMockClient extractEnabledKubernetesMockClient(Class<?> testClass) {
        EnableKubernetesMockClient a = testClass.getAnnotation(EnableKubernetesMockClient.class);
        Class<?> enclosingClass = testClass;
        while (a == null && enclosingClass.getEnclosingClass() != null) {
            enclosingClass = enclosingClass.getEnclosingClass();
            a = enclosingClass.getAnnotation(EnableKubernetesMockClient.class);
        }
        for (Class<?> superClass = testClass; a == null && superClass.getSuperclass() != null && superClass != Object.class; superClass = superClass.getSuperclass()) {
            a = superClass.getAnnotation(EnableKubernetesMockClient.class);
        }
        return a;
    }

    protected void destroy() {
        if (this.instantMock != null) {
            this.instantMock.destroy();
        }
        if (this.instantClient != null) {
            this.instantClient.close();
        }
    }

    protected void destroyStatic() {
        this.staticMock.destroy();
        this.staticClient.close();
    }

    private static Field[] extractFields(ExtensionContext context, Class<?> clazz, Predicate<Field> ... predicates) {
        ArrayList<Field> fields = new ArrayList<Field>();
        if (context.getTestClass().isPresent()) {
            Class<Object> testClass = context.getTestClass().orElse(Object.class);
            fields.addAll(KubernetesMockServerExtension.extractFields(testClass, clazz, predicates));
            for (Class<?> enclosingTestClass = testClass.getEnclosingClass(); enclosingTestClass != null; enclosingTestClass = enclosingTestClass.getEnclosingClass()) {
                fields.addAll(KubernetesMockServerExtension.extractFields(enclosingTestClass, clazz, predicates));
            }
        }
        return fields.toArray(new Field[0]);
    }

    private static List<Field> extractFields(Class<?> testClass, Class<?> clazz, Predicate<Field> ... predicates) {
        ArrayList<Field> fields = new ArrayList<Field>();
        do {
            fields.addAll(KubernetesMockServerExtension.extractFieldsFromClass(testClass, clazz, predicates));
        } while ((testClass = testClass.getSuperclass()) != Object.class);
        return fields;
    }

    private static List<Field> extractFieldsFromClass(Class<?> classWhereFieldIs, Class<?> fieldType, Predicate<Field> ... predicates) {
        if (classWhereFieldIs != null && classWhereFieldIs != Object.class) {
            Stream<Field> fieldStream = Arrays.stream(classWhereFieldIs.getDeclaredFields()).filter(f -> fieldType.isAssignableFrom(f.getType()));
            for (Predicate<Field> p : predicates) {
                fieldStream = fieldStream.filter(p);
            }
            return fieldStream.collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static void setFieldValue(Field field, Object entity, Object value) throws IllegalAccessException {
        boolean isAccessible = field.isAccessible();
        field.setAccessible(true);
        field.set(entity, value);
        field.setAccessible(isAccessible);
    }
}

