/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.gatewayapi.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.GRPCBackendRef;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.GRPCRouteFilter;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.GRPCRouteFilterBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.GRPCRouteFilterFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class GRPCBackendRefFluent<A extends GRPCBackendRefFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ArrayList<GRPCRouteFilterBuilder> filters = new ArrayList();
    private String group;
    private String kind;
    private String name;
    private String namespace;
    private Integer port;
    private Integer weight;

    public GRPCBackendRefFluent() {
    }

    public GRPCBackendRefFluent(GRPCBackendRef instance) {
        this.copyInstance(instance);
    }

    public A addAllToFilters(Collection<GRPCRouteFilter> items) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        for (GRPCRouteFilter item : items) {
            GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);
            this._visitables.get("filters").add(builder);
            this.filters.add(builder);
        }
        return (A)this;
    }

    public FiltersNested<A> addNewFilter() {
        return new FiltersNested(-1, null);
    }

    public FiltersNested<A> addNewFilterLike(GRPCRouteFilter item) {
        return new FiltersNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToFilters(GRPCRouteFilter ... items) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        for (GRPCRouteFilter item : items) {
            GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);
            this._visitables.get("filters").add(builder);
            this.filters.add(builder);
        }
        return (A)this;
    }

    public A addToFilters(int index, GRPCRouteFilter item) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);
        if (index < 0 || index >= this.filters.size()) {
            this._visitables.get("filters").add(builder);
            this.filters.add(builder);
        } else {
            this._visitables.get("filters").add(builder);
            this.filters.add(index, builder);
        }
        return (A)this;
    }

    public GRPCRouteFilter buildFilter(int index) {
        return this.filters.get(index).build();
    }

    public List<GRPCRouteFilter> buildFilters() {
        return this.filters != null ? GRPCBackendRefFluent.build(this.filters) : null;
    }

    public GRPCRouteFilter buildFirstFilter() {
        return this.filters.get(0).build();
    }

    public GRPCRouteFilter buildLastFilter() {
        return this.filters.get(this.filters.size() - 1).build();
    }

    public GRPCRouteFilter buildMatchingFilter(Predicate<GRPCRouteFilterBuilder> predicate) {
        for (GRPCRouteFilterBuilder item : this.filters) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    protected void copyInstance(GRPCBackendRef instance) {
        GRPCBackendRef gRPCBackendRef = instance = instance != null ? instance : new GRPCBackendRef();
        if (instance != null) {
            this.withFilters(instance.getFilters());
            this.withGroup(instance.getGroup());
            this.withKind(instance.getKind());
            this.withName(instance.getName());
            this.withNamespace(instance.getNamespace());
            this.withPort(instance.getPort());
            this.withWeight(instance.getWeight());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public FiltersNested<A> editFilter(int index) {
        if (this.filters.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "filters"));
        }
        return this.setNewFilterLike(index, this.buildFilter(index));
    }

    public FiltersNested<A> editFirstFilter() {
        if (this.filters.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "filters"));
        }
        return this.setNewFilterLike(0, this.buildFilter(0));
    }

    public FiltersNested<A> editLastFilter() {
        int index = this.filters.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "filters"));
        }
        return this.setNewFilterLike(index, this.buildFilter(index));
    }

    public FiltersNested<A> editMatchingFilter(Predicate<GRPCRouteFilterBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.filters.size(); ++i) {
            if (!predicate.test(this.filters.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "filters"));
        }
        return this.setNewFilterLike(index, this.buildFilter(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GRPCBackendRefFluent that = (GRPCBackendRefFluent)o;
        if (!Objects.equals(this.filters, that.filters)) {
            return false;
        }
        if (!Objects.equals(this.group, that.group)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.namespace, that.namespace)) {
            return false;
        }
        if (!Objects.equals(this.port, that.port)) {
            return false;
        }
        if (!Objects.equals(this.weight, that.weight)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getGroup() {
        return this.group;
    }

    public String getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Integer getPort() {
        return this.port;
    }

    public Integer getWeight() {
        return this.weight;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasFilters() {
        return this.filters != null && !this.filters.isEmpty();
    }

    public boolean hasGroup() {
        return this.group != null;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public boolean hasMatchingFilter(Predicate<GRPCRouteFilterBuilder> predicate) {
        for (GRPCRouteFilterBuilder item : this.filters) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean hasNamespace() {
        return this.namespace != null;
    }

    public boolean hasPort() {
        return this.port != null;
    }

    public boolean hasWeight() {
        return this.weight != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.filters, this.group, this.kind, this.name, this.namespace, this.port, this.weight, this.additionalProperties);
    }

    public A removeAllFromFilters(Collection<GRPCRouteFilter> items) {
        if (this.filters == null) {
            return (A)this;
        }
        for (GRPCRouteFilter item : items) {
            GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);
            this._visitables.get("filters").remove(builder);
            this.filters.remove(builder);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public A removeFromFilters(GRPCRouteFilter ... items) {
        if (this.filters == null) {
            return (A)this;
        }
        for (GRPCRouteFilter item : items) {
            GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);
            this._visitables.get("filters").remove(builder);
            this.filters.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromFilters(Predicate<GRPCRouteFilterBuilder> predicate) {
        if (this.filters == null) {
            return (A)this;
        }
        Iterator<GRPCRouteFilterBuilder> each = this.filters.iterator();
        Object visitables = this._visitables.get("filters");
        while (each.hasNext()) {
            GRPCRouteFilterBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public FiltersNested<A> setNewFilterLike(int index, GRPCRouteFilter item) {
        return new FiltersNested(index, item);
    }

    public A setToFilters(int index, GRPCRouteFilter item) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);
        if (index < 0 || index >= this.filters.size()) {
            this._visitables.get("filters").add(builder);
            this.filters.add(builder);
        } else {
            this._visitables.get("filters").add(builder);
            this.filters.set(index, builder);
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.filters != null && !this.filters.isEmpty()) {
            sb.append("filters:");
            sb.append(this.filters);
            sb.append(",");
        }
        if (this.group != null) {
            sb.append("group:");
            sb.append(this.group);
            sb.append(",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind);
            sb.append(",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name);
            sb.append(",");
        }
        if (this.namespace != null) {
            sb.append("namespace:");
            sb.append(this.namespace);
            sb.append(",");
        }
        if (this.port != null) {
            sb.append("port:");
            sb.append(this.port);
            sb.append(",");
        }
        if (this.weight != null) {
            sb.append("weight:");
            sb.append(this.weight);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withFilters(List<GRPCRouteFilter> filters) {
        if (this.filters != null) {
            this._visitables.get("filters").clear();
        }
        if (filters != null) {
            this.filters = new ArrayList();
            for (GRPCRouteFilter item : filters) {
                this.addToFilters(item);
            }
        } else {
            this.filters = null;
        }
        return (A)this;
    }

    public A withFilters(GRPCRouteFilter ... filters) {
        if (this.filters != null) {
            this.filters.clear();
            this._visitables.remove("filters");
        }
        if (filters != null) {
            for (GRPCRouteFilter item : filters) {
                this.addToFilters(item);
            }
        }
        return (A)this;
    }

    public A withGroup(String group) {
        this.group = group;
        return (A)this;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)this;
    }

    public A withPort(Integer port) {
        this.port = port;
        return (A)this;
    }

    public A withWeight(Integer weight) {
        this.weight = weight;
        return (A)this;
    }

    public class FiltersNested<N>
    extends GRPCRouteFilterFluent<FiltersNested<N>>
    implements Nested<N> {
        GRPCRouteFilterBuilder builder;
        int index;

        FiltersNested(int index, GRPCRouteFilter item) {
            this.index = index;
            this.builder = new GRPCRouteFilterBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)GRPCBackendRefFluent.this.setToFilters(this.index, this.builder.build());
        }

        public N endFilter() {
            return this.and();
        }
    }
}

