/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.discovery.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.discovery.v1beta1.Endpoint;
import io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointBuilder;
import io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointFluent;
import io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPort;
import io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPortBuilder;
import io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointPortFluent;
import io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSlice;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class EndpointSliceFluent<A extends EndpointSliceFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String addressType;
    private String apiVersion;
    private ArrayList<EndpointBuilder> endpoints = new ArrayList();
    private String kind;
    private ObjectMetaBuilder metadata;
    private ArrayList<EndpointPortBuilder> ports = new ArrayList();

    public EndpointSliceFluent() {
    }

    public EndpointSliceFluent(EndpointSlice instance) {
        this.copyInstance(instance);
    }

    public A addAllToEndpoints(Collection<Endpoint> items) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList();
        }
        for (Endpoint item : items) {
            EndpointBuilder builder = new EndpointBuilder(item);
            this._visitables.get("endpoints").add(builder);
            this.endpoints.add(builder);
        }
        return (A)this;
    }

    public A addAllToPorts(Collection<EndpointPort> items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (EndpointPort item : items) {
            EndpointPortBuilder builder = new EndpointPortBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    public EndpointsNested<A> addNewEndpoint() {
        return new EndpointsNested(-1, null);
    }

    public EndpointsNested<A> addNewEndpointLike(Endpoint item) {
        return new EndpointsNested(-1, item);
    }

    public PortsNested<A> addNewPort() {
        return new PortsNested(-1, null);
    }

    public A addNewPort(String appProtocol, String name, Integer port, String protocol) {
        return this.addToPorts(new EndpointPort(appProtocol, name, port, protocol));
    }

    public PortsNested<A> addNewPortLike(EndpointPort item) {
        return new PortsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToEndpoints(Endpoint ... items) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList();
        }
        for (Endpoint item : items) {
            EndpointBuilder builder = new EndpointBuilder(item);
            this._visitables.get("endpoints").add(builder);
            this.endpoints.add(builder);
        }
        return (A)this;
    }

    public A addToEndpoints(int index, Endpoint item) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList();
        }
        EndpointBuilder builder = new EndpointBuilder(item);
        if (index < 0 || index >= this.endpoints.size()) {
            this._visitables.get("endpoints").add(builder);
            this.endpoints.add(builder);
        } else {
            this._visitables.get("endpoints").add(builder);
            this.endpoints.add(index, builder);
        }
        return (A)this;
    }

    public A addToPorts(EndpointPort ... items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (EndpointPort item : items) {
            EndpointPortBuilder builder = new EndpointPortBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    public A addToPorts(int index, EndpointPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        EndpointPortBuilder builder = new EndpointPortBuilder(item);
        if (index < 0 || index >= this.ports.size()) {
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        } else {
            this._visitables.get("ports").add(builder);
            this.ports.add(index, builder);
        }
        return (A)this;
    }

    public Endpoint buildEndpoint(int index) {
        return this.endpoints.get(index).build();
    }

    public List<Endpoint> buildEndpoints() {
        return this.endpoints != null ? EndpointSliceFluent.build(this.endpoints) : null;
    }

    public Endpoint buildFirstEndpoint() {
        return this.endpoints.get(0).build();
    }

    public EndpointPort buildFirstPort() {
        return this.ports.get(0).build();
    }

    public Endpoint buildLastEndpoint() {
        return this.endpoints.get(this.endpoints.size() - 1).build();
    }

    public EndpointPort buildLastPort() {
        return this.ports.get(this.ports.size() - 1).build();
    }

    public Endpoint buildMatchingEndpoint(Predicate<EndpointBuilder> predicate) {
        for (EndpointBuilder item : this.endpoints) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public EndpointPort buildMatchingPort(Predicate<EndpointPortBuilder> predicate) {
        for (EndpointPortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public EndpointPort buildPort(int index) {
        return this.ports.get(index).build();
    }

    public List<EndpointPort> buildPorts() {
        return this.ports != null ? EndpointSliceFluent.build(this.ports) : null;
    }

    protected void copyInstance(EndpointSlice instance) {
        EndpointSlice endpointSlice = instance = instance != null ? instance : new EndpointSlice();
        if (instance != null) {
            this.withAddressType(instance.getAddressType());
            this.withApiVersion(instance.getApiVersion());
            this.withEndpoints(instance.getEndpoints());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withPorts(instance.getPorts());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public EndpointsNested<A> editEndpoint(int index) {
        if (this.endpoints.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "endpoints"));
        }
        return this.setNewEndpointLike(index, this.buildEndpoint(index));
    }

    public EndpointsNested<A> editFirstEndpoint() {
        if (this.endpoints.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "endpoints"));
        }
        return this.setNewEndpointLike(0, this.buildEndpoint(0));
    }

    public PortsNested<A> editFirstPort() {
        if (this.ports.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "ports"));
        }
        return this.setNewPortLike(0, this.buildPort(0));
    }

    public EndpointsNested<A> editLastEndpoint() {
        int index = this.endpoints.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "endpoints"));
        }
        return this.setNewEndpointLike(index, this.buildEndpoint(index));
    }

    public PortsNested<A> editLastPort() {
        int index = this.ports.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "ports"));
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public EndpointsNested<A> editMatchingEndpoint(Predicate<EndpointBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.endpoints.size(); ++i) {
            if (!predicate.test(this.endpoints.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "endpoints"));
        }
        return this.setNewEndpointLike(index, this.buildEndpoint(index));
    }

    public PortsNested<A> editMatchingPort(Predicate<EndpointPortBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!predicate.test(this.ports.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "ports"));
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public PortsNested<A> editPort(int index) {
        if (this.ports.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "ports"));
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EndpointSliceFluent that = (EndpointSliceFluent)o;
        if (!Objects.equals(this.addressType, that.addressType)) {
            return false;
        }
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.endpoints, that.endpoints)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.ports, that.ports)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getAddressType() {
        return this.addressType;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getKind() {
        return this.kind;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAddressType() {
        return this.addressType != null;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public boolean hasEndpoints() {
        return this.endpoints != null && !this.endpoints.isEmpty();
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public boolean hasMatchingEndpoint(Predicate<EndpointBuilder> predicate) {
        for (EndpointBuilder item : this.endpoints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingPort(Predicate<EndpointPortBuilder> predicate) {
        for (EndpointPortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.addressType, this.apiVersion, this.endpoints, this.kind, this.metadata, this.ports, this.additionalProperties);
    }

    public A removeAllFromEndpoints(Collection<Endpoint> items) {
        if (this.endpoints == null) {
            return (A)this;
        }
        for (Endpoint item : items) {
            EndpointBuilder builder = new EndpointBuilder(item);
            this._visitables.get("endpoints").remove(builder);
            this.endpoints.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromPorts(Collection<EndpointPort> items) {
        if (this.ports == null) {
            return (A)this;
        }
        for (EndpointPort item : items) {
            EndpointPortBuilder builder = new EndpointPortBuilder(item);
            this._visitables.get("ports").remove(builder);
            this.ports.remove(builder);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public A removeFromEndpoints(Endpoint ... items) {
        if (this.endpoints == null) {
            return (A)this;
        }
        for (Endpoint item : items) {
            EndpointBuilder builder = new EndpointBuilder(item);
            this._visitables.get("endpoints").remove(builder);
            this.endpoints.remove(builder);
        }
        return (A)this;
    }

    public A removeFromPorts(EndpointPort ... items) {
        if (this.ports == null) {
            return (A)this;
        }
        for (EndpointPort item : items) {
            EndpointPortBuilder builder = new EndpointPortBuilder(item);
            this._visitables.get("ports").remove(builder);
            this.ports.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromEndpoints(Predicate<EndpointBuilder> predicate) {
        if (this.endpoints == null) {
            return (A)this;
        }
        Iterator<EndpointBuilder> each = this.endpoints.iterator();
        Object visitables = this._visitables.get("endpoints");
        while (each.hasNext()) {
            EndpointBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public A removeMatchingFromPorts(Predicate<EndpointPortBuilder> predicate) {
        if (this.ports == null) {
            return (A)this;
        }
        Iterator<EndpointPortBuilder> each = this.ports.iterator();
        Object visitables = this._visitables.get("ports");
        while (each.hasNext()) {
            EndpointPortBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public EndpointsNested<A> setNewEndpointLike(int index, Endpoint item) {
        return new EndpointsNested(index, item);
    }

    public PortsNested<A> setNewPortLike(int index, EndpointPort item) {
        return new PortsNested(index, item);
    }

    public A setToEndpoints(int index, Endpoint item) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList();
        }
        EndpointBuilder builder = new EndpointBuilder(item);
        if (index < 0 || index >= this.endpoints.size()) {
            this._visitables.get("endpoints").add(builder);
            this.endpoints.add(builder);
        } else {
            this._visitables.get("endpoints").add(builder);
            this.endpoints.set(index, builder);
        }
        return (A)this;
    }

    public A setToPorts(int index, EndpointPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        EndpointPortBuilder builder = new EndpointPortBuilder(item);
        if (index < 0 || index >= this.ports.size()) {
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        } else {
            this._visitables.get("ports").add(builder);
            this.ports.set(index, builder);
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.addressType != null) {
            sb.append("addressType:");
            sb.append(this.addressType);
            sb.append(",");
        }
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion);
            sb.append(",");
        }
        if (this.endpoints != null && !this.endpoints.isEmpty()) {
            sb.append("endpoints:");
            sb.append(this.endpoints);
            sb.append(",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind);
            sb.append(",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata);
            sb.append(",");
        }
        if (this.ports != null && !this.ports.isEmpty()) {
            sb.append("ports:");
            sb.append(this.ports);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withAddressType(String addressType) {
        this.addressType = addressType;
        return (A)this;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public A withEndpoints(List<Endpoint> endpoints) {
        if (this.endpoints != null) {
            this._visitables.get("endpoints").clear();
        }
        if (endpoints != null) {
            this.endpoints = new ArrayList();
            for (Endpoint item : endpoints) {
                this.addToEndpoints(item);
            }
        } else {
            this.endpoints = null;
        }
        return (A)this;
    }

    public A withEndpoints(Endpoint ... endpoints) {
        if (this.endpoints != null) {
            this.endpoints.clear();
            this._visitables.remove("endpoints");
        }
        if (endpoints != null) {
            for (Endpoint item : endpoints) {
                this.addToEndpoints(item);
            }
        }
        return (A)this;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove("metadata");
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public A withPorts(List<EndpointPort> ports) {
        if (this.ports != null) {
            this._visitables.get("ports").clear();
        }
        if (ports != null) {
            this.ports = new ArrayList();
            for (EndpointPort item : ports) {
                this.addToPorts(item);
            }
        } else {
            this.ports = null;
        }
        return (A)this;
    }

    public A withPorts(EndpointPort ... ports) {
        if (this.ports != null) {
            this.ports.clear();
            this._visitables.remove("ports");
        }
        if (ports != null) {
            for (EndpointPort item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    public class PortsNested<N>
    extends EndpointPortFluent<PortsNested<N>>
    implements Nested<N> {
        EndpointPortBuilder builder;
        int index;

        PortsNested(int index, EndpointPort item) {
            this.index = index;
            this.builder = new EndpointPortBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)EndpointSliceFluent.this.setToPorts(this.index, this.builder.build());
        }

        public N endPort() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)EndpointSliceFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class EndpointsNested<N>
    extends EndpointFluent<EndpointsNested<N>>
    implements Nested<N> {
        EndpointBuilder builder;
        int index;

        EndpointsNested(int index, Endpoint item) {
            this.index = index;
            this.builder = new EndpointBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)EndpointSliceFluent.this.setToEndpoints(this.index, this.builder.build());
        }

        public N endEndpoint() {
            return this.and();
        }
    }
}

