/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.batch.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.batch.v1.CronJobStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class CronJobStatusFluent<A extends CronJobStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<ObjectReferenceBuilder> active = new ArrayList();
    private Map<String, Object> additionalProperties;
    private String lastScheduleTime;
    private String lastSuccessfulTime;

    public CronJobStatusFluent() {
    }

    public CronJobStatusFluent(CronJobStatus instance) {
        this.copyInstance(instance);
    }

    public A addAllToActive(Collection<ObjectReference> items) {
        if (this.active == null) {
            this.active = new ArrayList();
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get("active").add(builder);
            this.active.add(builder);
        }
        return (A)this;
    }

    public ActiveNested<A> addNewActive() {
        return new ActiveNested(-1, null);
    }

    public ActiveNested<A> addNewActiveLike(ObjectReference item) {
        return new ActiveNested(-1, item);
    }

    public A addToActive(ObjectReference ... items) {
        if (this.active == null) {
            this.active = new ArrayList();
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get("active").add(builder);
            this.active.add(builder);
        }
        return (A)this;
    }

    public A addToActive(int index, ObjectReference item) {
        if (this.active == null) {
            this.active = new ArrayList();
        }
        ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
        if (index < 0 || index >= this.active.size()) {
            this._visitables.get("active").add(builder);
            this.active.add(builder);
        } else {
            this._visitables.get("active").add(builder);
            this.active.add(index, builder);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public List<ObjectReference> buildActive() {
        return this.active != null ? CronJobStatusFluent.build(this.active) : null;
    }

    public ObjectReference buildActive(int index) {
        return this.active.get(index).build();
    }

    public ObjectReference buildFirstActive() {
        return this.active.get(0).build();
    }

    public ObjectReference buildLastActive() {
        return this.active.get(this.active.size() - 1).build();
    }

    public ObjectReference buildMatchingActive(Predicate<ObjectReferenceBuilder> predicate) {
        for (ObjectReferenceBuilder item : this.active) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    protected void copyInstance(CronJobStatus instance) {
        CronJobStatus cronJobStatus = instance = instance != null ? instance : new CronJobStatus();
        if (instance != null) {
            this.withActive(instance.getActive());
            this.withLastScheduleTime(instance.getLastScheduleTime());
            this.withLastSuccessfulTime(instance.getLastSuccessfulTime());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ActiveNested<A> editActive(int index) {
        if (this.active.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "active"));
        }
        return this.setNewActiveLike(index, this.buildActive(index));
    }

    public ActiveNested<A> editFirstActive() {
        if (this.active.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "active"));
        }
        return this.setNewActiveLike(0, this.buildActive(0));
    }

    public ActiveNested<A> editLastActive() {
        int index = this.active.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "active"));
        }
        return this.setNewActiveLike(index, this.buildActive(index));
    }

    public ActiveNested<A> editMatchingActive(Predicate<ObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.active.size(); ++i) {
            if (!predicate.test(this.active.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "active"));
        }
        return this.setNewActiveLike(index, this.buildActive(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CronJobStatusFluent that = (CronJobStatusFluent)o;
        if (!Objects.equals(this.active, that.active)) {
            return false;
        }
        if (!Objects.equals(this.lastScheduleTime, that.lastScheduleTime)) {
            return false;
        }
        if (!Objects.equals(this.lastSuccessfulTime, that.lastSuccessfulTime)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getLastScheduleTime() {
        return this.lastScheduleTime;
    }

    public String getLastSuccessfulTime() {
        return this.lastSuccessfulTime;
    }

    public boolean hasActive() {
        return this.active != null && !this.active.isEmpty();
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasLastScheduleTime() {
        return this.lastScheduleTime != null;
    }

    public boolean hasLastSuccessfulTime() {
        return this.lastSuccessfulTime != null;
    }

    public boolean hasMatchingActive(Predicate<ObjectReferenceBuilder> predicate) {
        for (ObjectReferenceBuilder item : this.active) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.active, this.lastScheduleTime, this.lastSuccessfulTime, this.additionalProperties);
    }

    public A removeAllFromActive(Collection<ObjectReference> items) {
        if (this.active == null) {
            return (A)this;
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get("active").remove(builder);
            this.active.remove(builder);
        }
        return (A)this;
    }

    public A removeFromActive(ObjectReference ... items) {
        if (this.active == null) {
            return (A)this;
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get("active").remove(builder);
            this.active.remove(builder);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public A removeMatchingFromActive(Predicate<ObjectReferenceBuilder> predicate) {
        if (this.active == null) {
            return (A)this;
        }
        Iterator<ObjectReferenceBuilder> each = this.active.iterator();
        Object visitables = this._visitables.get("active");
        while (each.hasNext()) {
            ObjectReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public ActiveNested<A> setNewActiveLike(int index, ObjectReference item) {
        return new ActiveNested(index, item);
    }

    public A setToActive(int index, ObjectReference item) {
        if (this.active == null) {
            this.active = new ArrayList();
        }
        ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
        if (index < 0 || index >= this.active.size()) {
            this._visitables.get("active").add(builder);
            this.active.add(builder);
        } else {
            this._visitables.get("active").add(builder);
            this.active.set(index, builder);
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.active != null && !this.active.isEmpty()) {
            sb.append("active:");
            sb.append(this.active);
            sb.append(",");
        }
        if (this.lastScheduleTime != null) {
            sb.append("lastScheduleTime:");
            sb.append(this.lastScheduleTime);
            sb.append(",");
        }
        if (this.lastSuccessfulTime != null) {
            sb.append("lastSuccessfulTime:");
            sb.append(this.lastSuccessfulTime);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withActive(List<ObjectReference> active) {
        if (this.active != null) {
            this._visitables.get("active").clear();
        }
        if (active != null) {
            this.active = new ArrayList();
            for (ObjectReference item : active) {
                this.addToActive(item);
            }
        } else {
            this.active = null;
        }
        return (A)this;
    }

    public A withActive(ObjectReference ... active) {
        if (this.active != null) {
            this.active.clear();
            this._visitables.remove("active");
        }
        if (active != null) {
            for (ObjectReference item : active) {
                this.addToActive(item);
            }
        }
        return (A)this;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withLastScheduleTime(String lastScheduleTime) {
        this.lastScheduleTime = lastScheduleTime;
        return (A)this;
    }

    public A withLastSuccessfulTime(String lastSuccessfulTime) {
        this.lastSuccessfulTime = lastSuccessfulTime;
        return (A)this;
    }

    public class ActiveNested<N>
    extends ObjectReferenceFluent<ActiveNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;
        int index;

        ActiveNested(int index, ObjectReference item) {
            this.index = index;
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)CronJobStatusFluent.this.setToActive(this.index, this.builder.build());
        }

        public N endActive() {
            return this.and();
        }
    }
}

