/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.autoscaling.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerStatus;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class HorizontalPodAutoscalerStatusFluent<A extends HorizontalPodAutoscalerStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private Integer currentCPUUtilizationPercentage;
    private Integer currentReplicas;
    private Integer desiredReplicas;
    private String lastScaleTime;
    private Long observedGeneration;

    public HorizontalPodAutoscalerStatusFluent() {
    }

    public HorizontalPodAutoscalerStatusFluent(HorizontalPodAutoscalerStatus instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    protected void copyInstance(HorizontalPodAutoscalerStatus instance) {
        HorizontalPodAutoscalerStatus horizontalPodAutoscalerStatus = instance = instance != null ? instance : new HorizontalPodAutoscalerStatus();
        if (instance != null) {
            this.withCurrentCPUUtilizationPercentage(instance.getCurrentCPUUtilizationPercentage());
            this.withCurrentReplicas(instance.getCurrentReplicas());
            this.withDesiredReplicas(instance.getDesiredReplicas());
            this.withLastScaleTime(instance.getLastScaleTime());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HorizontalPodAutoscalerStatusFluent that = (HorizontalPodAutoscalerStatusFluent)o;
        if (!Objects.equals(this.currentCPUUtilizationPercentage, that.currentCPUUtilizationPercentage)) {
            return false;
        }
        if (!Objects.equals(this.currentReplicas, that.currentReplicas)) {
            return false;
        }
        if (!Objects.equals(this.desiredReplicas, that.desiredReplicas)) {
            return false;
        }
        if (!Objects.equals(this.lastScaleTime, that.lastScaleTime)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Integer getCurrentCPUUtilizationPercentage() {
        return this.currentCPUUtilizationPercentage;
    }

    public Integer getCurrentReplicas() {
        return this.currentReplicas;
    }

    public Integer getDesiredReplicas() {
        return this.desiredReplicas;
    }

    public String getLastScaleTime() {
        return this.lastScaleTime;
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasCurrentCPUUtilizationPercentage() {
        return this.currentCPUUtilizationPercentage != null;
    }

    public boolean hasCurrentReplicas() {
        return this.currentReplicas != null;
    }

    public boolean hasDesiredReplicas() {
        return this.desiredReplicas != null;
    }

    public boolean hasLastScaleTime() {
        return this.lastScaleTime != null;
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.currentCPUUtilizationPercentage, this.currentReplicas, this.desiredReplicas, this.lastScaleTime, this.observedGeneration, this.additionalProperties);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.currentCPUUtilizationPercentage != null) {
            sb.append("currentCPUUtilizationPercentage:");
            sb.append(this.currentCPUUtilizationPercentage);
            sb.append(",");
        }
        if (this.currentReplicas != null) {
            sb.append("currentReplicas:");
            sb.append(this.currentReplicas);
            sb.append(",");
        }
        if (this.desiredReplicas != null) {
            sb.append("desiredReplicas:");
            sb.append(this.desiredReplicas);
            sb.append(",");
        }
        if (this.lastScaleTime != null) {
            sb.append("lastScaleTime:");
            sb.append(this.lastScaleTime);
            sb.append(",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withCurrentCPUUtilizationPercentage(Integer currentCPUUtilizationPercentage) {
        this.currentCPUUtilizationPercentage = currentCPUUtilizationPercentage;
        return (A)this;
    }

    public A withCurrentReplicas(Integer currentReplicas) {
        this.currentReplicas = currentReplicas;
        return (A)this;
    }

    public A withDesiredReplicas(Integer desiredReplicas) {
        this.desiredReplicas = desiredReplicas;
        return (A)this;
    }

    public A withLastScaleTime(String lastScaleTime) {
        this.lastScaleTime = lastScaleTime;
        return (A)this;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }
}

