/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.authorization.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.authorization.v1.FieldSelectorAttributes;
import io.fabric8.kubernetes.api.model.authorization.v1.FieldSelectorAttributesBuilder;
import io.fabric8.kubernetes.api.model.authorization.v1.FieldSelectorAttributesFluent;
import io.fabric8.kubernetes.api.model.authorization.v1.LabelSelectorAttributes;
import io.fabric8.kubernetes.api.model.authorization.v1.LabelSelectorAttributesBuilder;
import io.fabric8.kubernetes.api.model.authorization.v1.LabelSelectorAttributesFluent;
import io.fabric8.kubernetes.api.model.authorization.v1.ResourceAttributes;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ResourceAttributesFluent<A extends ResourceAttributesFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private FieldSelectorAttributesBuilder fieldSelector;
    private String group;
    private LabelSelectorAttributesBuilder labelSelector;
    private String name;
    private String namespace;
    private String resource;
    private String subresource;
    private String verb;
    private String version;

    public ResourceAttributesFluent() {
    }

    public ResourceAttributesFluent(ResourceAttributes instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public FieldSelectorAttributes buildFieldSelector() {
        return this.fieldSelector != null ? this.fieldSelector.build() : null;
    }

    public LabelSelectorAttributes buildLabelSelector() {
        return this.labelSelector != null ? this.labelSelector.build() : null;
    }

    protected void copyInstance(ResourceAttributes instance) {
        ResourceAttributes resourceAttributes = instance = instance != null ? instance : new ResourceAttributes();
        if (instance != null) {
            this.withFieldSelector(instance.getFieldSelector());
            this.withGroup(instance.getGroup());
            this.withLabelSelector(instance.getLabelSelector());
            this.withName(instance.getName());
            this.withNamespace(instance.getNamespace());
            this.withResource(instance.getResource());
            this.withSubresource(instance.getSubresource());
            this.withVerb(instance.getVerb());
            this.withVersion(instance.getVersion());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public FieldSelectorNested<A> editFieldSelector() {
        return this.withNewFieldSelectorLike(Optional.ofNullable(this.buildFieldSelector()).orElse(null));
    }

    public LabelSelectorNested<A> editLabelSelector() {
        return this.withNewLabelSelectorLike(Optional.ofNullable(this.buildLabelSelector()).orElse(null));
    }

    public FieldSelectorNested<A> editOrNewFieldSelector() {
        return this.withNewFieldSelectorLike(Optional.ofNullable(this.buildFieldSelector()).orElse(new FieldSelectorAttributesBuilder().build()));
    }

    public FieldSelectorNested<A> editOrNewFieldSelectorLike(FieldSelectorAttributes item) {
        return this.withNewFieldSelectorLike(Optional.ofNullable(this.buildFieldSelector()).orElse(item));
    }

    public LabelSelectorNested<A> editOrNewLabelSelector() {
        return this.withNewLabelSelectorLike(Optional.ofNullable(this.buildLabelSelector()).orElse(new LabelSelectorAttributesBuilder().build()));
    }

    public LabelSelectorNested<A> editOrNewLabelSelectorLike(LabelSelectorAttributes item) {
        return this.withNewLabelSelectorLike(Optional.ofNullable(this.buildLabelSelector()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceAttributesFluent that = (ResourceAttributesFluent)o;
        if (!Objects.equals(this.fieldSelector, that.fieldSelector)) {
            return false;
        }
        if (!Objects.equals(this.group, that.group)) {
            return false;
        }
        if (!Objects.equals(this.labelSelector, that.labelSelector)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.namespace, that.namespace)) {
            return false;
        }
        if (!Objects.equals(this.resource, that.resource)) {
            return false;
        }
        if (!Objects.equals(this.subresource, that.subresource)) {
            return false;
        }
        if (!Objects.equals(this.verb, that.verb)) {
            return false;
        }
        if (!Objects.equals(this.version, that.version)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getResource() {
        return this.resource;
    }

    public String getSubresource() {
        return this.subresource;
    }

    public String getVerb() {
        return this.verb;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasFieldSelector() {
        return this.fieldSelector != null;
    }

    public boolean hasGroup() {
        return this.group != null;
    }

    public boolean hasLabelSelector() {
        return this.labelSelector != null;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean hasNamespace() {
        return this.namespace != null;
    }

    public boolean hasResource() {
        return this.resource != null;
    }

    public boolean hasSubresource() {
        return this.subresource != null;
    }

    public boolean hasVerb() {
        return this.verb != null;
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fieldSelector, this.group, this.labelSelector, this.name, this.namespace, this.resource, this.subresource, this.verb, this.version, this.additionalProperties);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.fieldSelector != null) {
            sb.append("fieldSelector:");
            sb.append(this.fieldSelector);
            sb.append(",");
        }
        if (this.group != null) {
            sb.append("group:");
            sb.append(this.group);
            sb.append(",");
        }
        if (this.labelSelector != null) {
            sb.append("labelSelector:");
            sb.append(this.labelSelector);
            sb.append(",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name);
            sb.append(",");
        }
        if (this.namespace != null) {
            sb.append("namespace:");
            sb.append(this.namespace);
            sb.append(",");
        }
        if (this.resource != null) {
            sb.append("resource:");
            sb.append(this.resource);
            sb.append(",");
        }
        if (this.subresource != null) {
            sb.append("subresource:");
            sb.append(this.subresource);
            sb.append(",");
        }
        if (this.verb != null) {
            sb.append("verb:");
            sb.append(this.verb);
            sb.append(",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withFieldSelector(FieldSelectorAttributes fieldSelector) {
        this._visitables.remove("fieldSelector");
        if (fieldSelector != null) {
            this.fieldSelector = new FieldSelectorAttributesBuilder(fieldSelector);
            this._visitables.get("fieldSelector").add(this.fieldSelector);
        } else {
            this.fieldSelector = null;
            this._visitables.get("fieldSelector").remove(this.fieldSelector);
        }
        return (A)this;
    }

    public A withGroup(String group) {
        this.group = group;
        return (A)this;
    }

    public A withLabelSelector(LabelSelectorAttributes labelSelector) {
        this._visitables.remove("labelSelector");
        if (labelSelector != null) {
            this.labelSelector = new LabelSelectorAttributesBuilder(labelSelector);
            this._visitables.get("labelSelector").add(this.labelSelector);
        } else {
            this.labelSelector = null;
            this._visitables.get("labelSelector").remove(this.labelSelector);
        }
        return (A)this;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)this;
    }

    public FieldSelectorNested<A> withNewFieldSelector() {
        return new FieldSelectorNested(null);
    }

    public FieldSelectorNested<A> withNewFieldSelectorLike(FieldSelectorAttributes item) {
        return new FieldSelectorNested(item);
    }

    public LabelSelectorNested<A> withNewLabelSelector() {
        return new LabelSelectorNested(null);
    }

    public LabelSelectorNested<A> withNewLabelSelectorLike(LabelSelectorAttributes item) {
        return new LabelSelectorNested(item);
    }

    public A withResource(String resource) {
        this.resource = resource;
        return (A)this;
    }

    public A withSubresource(String subresource) {
        this.subresource = subresource;
        return (A)this;
    }

    public A withVerb(String verb) {
        this.verb = verb;
        return (A)this;
    }

    public A withVersion(String version) {
        this.version = version;
        return (A)this;
    }

    public class LabelSelectorNested<N>
    extends LabelSelectorAttributesFluent<LabelSelectorNested<N>>
    implements Nested<N> {
        LabelSelectorAttributesBuilder builder;

        LabelSelectorNested(LabelSelectorAttributes item) {
            this.builder = new LabelSelectorAttributesBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ResourceAttributesFluent.this.withLabelSelector(this.builder.build());
        }

        public N endLabelSelector() {
            return this.and();
        }
    }

    public class FieldSelectorNested<N>
    extends FieldSelectorAttributesFluent<FieldSelectorNested<N>>
    implements Nested<N> {
        FieldSelectorAttributesBuilder builder;

        FieldSelectorNested(FieldSelectorAttributes item) {
            this.builder = new FieldSelectorAttributesBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ResourceAttributesFluent.this.withFieldSelector(this.builder.build());
        }

        public N endFieldSelector() {
            return this.and();
        }
    }
}

