/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.apiextensions.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceConversion;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceConversionBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceConversionFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionNames;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionNamesBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionNamesFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionSpec;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionVersion;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionVersionBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionVersionFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class CustomResourceDefinitionSpecFluent<A extends CustomResourceDefinitionSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private CustomResourceConversionBuilder conversion;
    private String group;
    private CustomResourceDefinitionNamesBuilder names;
    private Boolean preserveUnknownFields;
    private String scope;
    private ArrayList<CustomResourceDefinitionVersionBuilder> versions = new ArrayList();

    public CustomResourceDefinitionSpecFluent() {
    }

    public CustomResourceDefinitionSpecFluent(CustomResourceDefinitionSpec instance) {
        this.copyInstance(instance);
    }

    public A addAllToVersions(Collection<CustomResourceDefinitionVersion> items) {
        if (this.versions == null) {
            this.versions = new ArrayList();
        }
        for (CustomResourceDefinitionVersion item : items) {
            CustomResourceDefinitionVersionBuilder builder = new CustomResourceDefinitionVersionBuilder(item);
            this._visitables.get("versions").add(builder);
            this.versions.add(builder);
        }
        return (A)this;
    }

    public VersionsNested<A> addNewVersion() {
        return new VersionsNested(-1, null);
    }

    public VersionsNested<A> addNewVersionLike(CustomResourceDefinitionVersion item) {
        return new VersionsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToVersions(CustomResourceDefinitionVersion ... items) {
        if (this.versions == null) {
            this.versions = new ArrayList();
        }
        for (CustomResourceDefinitionVersion item : items) {
            CustomResourceDefinitionVersionBuilder builder = new CustomResourceDefinitionVersionBuilder(item);
            this._visitables.get("versions").add(builder);
            this.versions.add(builder);
        }
        return (A)this;
    }

    public A addToVersions(int index, CustomResourceDefinitionVersion item) {
        if (this.versions == null) {
            this.versions = new ArrayList();
        }
        CustomResourceDefinitionVersionBuilder builder = new CustomResourceDefinitionVersionBuilder(item);
        if (index < 0 || index >= this.versions.size()) {
            this._visitables.get("versions").add(builder);
            this.versions.add(builder);
        } else {
            this._visitables.get("versions").add(builder);
            this.versions.add(index, builder);
        }
        return (A)this;
    }

    public CustomResourceConversion buildConversion() {
        return this.conversion != null ? this.conversion.build() : null;
    }

    public CustomResourceDefinitionVersion buildFirstVersion() {
        return this.versions.get(0).build();
    }

    public CustomResourceDefinitionVersion buildLastVersion() {
        return this.versions.get(this.versions.size() - 1).build();
    }

    public CustomResourceDefinitionVersion buildMatchingVersion(Predicate<CustomResourceDefinitionVersionBuilder> predicate) {
        for (CustomResourceDefinitionVersionBuilder item : this.versions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public CustomResourceDefinitionNames buildNames() {
        return this.names != null ? this.names.build() : null;
    }

    public CustomResourceDefinitionVersion buildVersion(int index) {
        return this.versions.get(index).build();
    }

    public List<CustomResourceDefinitionVersion> buildVersions() {
        return this.versions != null ? CustomResourceDefinitionSpecFluent.build(this.versions) : null;
    }

    protected void copyInstance(CustomResourceDefinitionSpec instance) {
        CustomResourceDefinitionSpec customResourceDefinitionSpec = instance = instance != null ? instance : new CustomResourceDefinitionSpec();
        if (instance != null) {
            this.withConversion(instance.getConversion());
            this.withGroup(instance.getGroup());
            this.withNames(instance.getNames());
            this.withPreserveUnknownFields(instance.getPreserveUnknownFields());
            this.withScope(instance.getScope());
            this.withVersions(instance.getVersions());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ConversionNested<A> editConversion() {
        return this.withNewConversionLike(Optional.ofNullable(this.buildConversion()).orElse(null));
    }

    public VersionsNested<A> editFirstVersion() {
        if (this.versions.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "versions"));
        }
        return this.setNewVersionLike(0, this.buildVersion(0));
    }

    public VersionsNested<A> editLastVersion() {
        int index = this.versions.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "versions"));
        }
        return this.setNewVersionLike(index, this.buildVersion(index));
    }

    public VersionsNested<A> editMatchingVersion(Predicate<CustomResourceDefinitionVersionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.versions.size(); ++i) {
            if (!predicate.test(this.versions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "versions"));
        }
        return this.setNewVersionLike(index, this.buildVersion(index));
    }

    public NamesNested<A> editNames() {
        return this.withNewNamesLike(Optional.ofNullable(this.buildNames()).orElse(null));
    }

    public ConversionNested<A> editOrNewConversion() {
        return this.withNewConversionLike(Optional.ofNullable(this.buildConversion()).orElse(new CustomResourceConversionBuilder().build()));
    }

    public ConversionNested<A> editOrNewConversionLike(CustomResourceConversion item) {
        return this.withNewConversionLike(Optional.ofNullable(this.buildConversion()).orElse(item));
    }

    public NamesNested<A> editOrNewNames() {
        return this.withNewNamesLike(Optional.ofNullable(this.buildNames()).orElse(new CustomResourceDefinitionNamesBuilder().build()));
    }

    public NamesNested<A> editOrNewNamesLike(CustomResourceDefinitionNames item) {
        return this.withNewNamesLike(Optional.ofNullable(this.buildNames()).orElse(item));
    }

    public VersionsNested<A> editVersion(int index) {
        if (this.versions.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "versions"));
        }
        return this.setNewVersionLike(index, this.buildVersion(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CustomResourceDefinitionSpecFluent that = (CustomResourceDefinitionSpecFluent)o;
        if (!Objects.equals(this.conversion, that.conversion)) {
            return false;
        }
        if (!Objects.equals(this.group, that.group)) {
            return false;
        }
        if (!Objects.equals(this.names, that.names)) {
            return false;
        }
        if (!Objects.equals(this.preserveUnknownFields, that.preserveUnknownFields)) {
            return false;
        }
        if (!Objects.equals(this.scope, that.scope)) {
            return false;
        }
        if (!Objects.equals(this.versions, that.versions)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getGroup() {
        return this.group;
    }

    public Boolean getPreserveUnknownFields() {
        return this.preserveUnknownFields;
    }

    public String getScope() {
        return this.scope;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasConversion() {
        return this.conversion != null;
    }

    public boolean hasGroup() {
        return this.group != null;
    }

    public boolean hasMatchingVersion(Predicate<CustomResourceDefinitionVersionBuilder> predicate) {
        for (CustomResourceDefinitionVersionBuilder item : this.versions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNames() {
        return this.names != null;
    }

    public boolean hasPreserveUnknownFields() {
        return this.preserveUnknownFields != null;
    }

    public boolean hasScope() {
        return this.scope != null;
    }

    public boolean hasVersions() {
        return this.versions != null && !this.versions.isEmpty();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.conversion, this.group, this.names, this.preserveUnknownFields, this.scope, this.versions, this.additionalProperties);
    }

    public A removeAllFromVersions(Collection<CustomResourceDefinitionVersion> items) {
        if (this.versions == null) {
            return (A)this;
        }
        for (CustomResourceDefinitionVersion item : items) {
            CustomResourceDefinitionVersionBuilder builder = new CustomResourceDefinitionVersionBuilder(item);
            this._visitables.get("versions").remove(builder);
            this.versions.remove(builder);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public A removeFromVersions(CustomResourceDefinitionVersion ... items) {
        if (this.versions == null) {
            return (A)this;
        }
        for (CustomResourceDefinitionVersion item : items) {
            CustomResourceDefinitionVersionBuilder builder = new CustomResourceDefinitionVersionBuilder(item);
            this._visitables.get("versions").remove(builder);
            this.versions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromVersions(Predicate<CustomResourceDefinitionVersionBuilder> predicate) {
        if (this.versions == null) {
            return (A)this;
        }
        Iterator<CustomResourceDefinitionVersionBuilder> each = this.versions.iterator();
        Object visitables = this._visitables.get("versions");
        while (each.hasNext()) {
            CustomResourceDefinitionVersionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public VersionsNested<A> setNewVersionLike(int index, CustomResourceDefinitionVersion item) {
        return new VersionsNested(index, item);
    }

    public A setToVersions(int index, CustomResourceDefinitionVersion item) {
        if (this.versions == null) {
            this.versions = new ArrayList();
        }
        CustomResourceDefinitionVersionBuilder builder = new CustomResourceDefinitionVersionBuilder(item);
        if (index < 0 || index >= this.versions.size()) {
            this._visitables.get("versions").add(builder);
            this.versions.add(builder);
        } else {
            this._visitables.get("versions").add(builder);
            this.versions.set(index, builder);
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conversion != null) {
            sb.append("conversion:");
            sb.append(this.conversion);
            sb.append(",");
        }
        if (this.group != null) {
            sb.append("group:");
            sb.append(this.group);
            sb.append(",");
        }
        if (this.names != null) {
            sb.append("names:");
            sb.append(this.names);
            sb.append(",");
        }
        if (this.preserveUnknownFields != null) {
            sb.append("preserveUnknownFields:");
            sb.append(this.preserveUnknownFields);
            sb.append(",");
        }
        if (this.scope != null) {
            sb.append("scope:");
            sb.append(this.scope);
            sb.append(",");
        }
        if (this.versions != null && !this.versions.isEmpty()) {
            sb.append("versions:");
            sb.append(this.versions);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withConversion(CustomResourceConversion conversion) {
        this._visitables.remove("conversion");
        if (conversion != null) {
            this.conversion = new CustomResourceConversionBuilder(conversion);
            this._visitables.get("conversion").add(this.conversion);
        } else {
            this.conversion = null;
            this._visitables.get("conversion").remove(this.conversion);
        }
        return (A)this;
    }

    public A withGroup(String group) {
        this.group = group;
        return (A)this;
    }

    public A withNames(CustomResourceDefinitionNames names) {
        this._visitables.remove("names");
        if (names != null) {
            this.names = new CustomResourceDefinitionNamesBuilder(names);
            this._visitables.get("names").add(this.names);
        } else {
            this.names = null;
            this._visitables.get("names").remove(this.names);
        }
        return (A)this;
    }

    public ConversionNested<A> withNewConversion() {
        return new ConversionNested(null);
    }

    public ConversionNested<A> withNewConversionLike(CustomResourceConversion item) {
        return new ConversionNested(item);
    }

    public NamesNested<A> withNewNames() {
        return new NamesNested(null);
    }

    public NamesNested<A> withNewNamesLike(CustomResourceDefinitionNames item) {
        return new NamesNested(item);
    }

    public A withPreserveUnknownFields() {
        return this.withPreserveUnknownFields(true);
    }

    public A withPreserveUnknownFields(Boolean preserveUnknownFields) {
        this.preserveUnknownFields = preserveUnknownFields;
        return (A)this;
    }

    public A withScope(String scope) {
        this.scope = scope;
        return (A)this;
    }

    public A withVersions(List<CustomResourceDefinitionVersion> versions) {
        if (this.versions != null) {
            this._visitables.get("versions").clear();
        }
        if (versions != null) {
            this.versions = new ArrayList();
            for (CustomResourceDefinitionVersion item : versions) {
                this.addToVersions(item);
            }
        } else {
            this.versions = null;
        }
        return (A)this;
    }

    public A withVersions(CustomResourceDefinitionVersion ... versions) {
        if (this.versions != null) {
            this.versions.clear();
            this._visitables.remove("versions");
        }
        if (versions != null) {
            for (CustomResourceDefinitionVersion item : versions) {
                this.addToVersions(item);
            }
        }
        return (A)this;
    }

    public class VersionsNested<N>
    extends CustomResourceDefinitionVersionFluent<VersionsNested<N>>
    implements Nested<N> {
        CustomResourceDefinitionVersionBuilder builder;
        int index;

        VersionsNested(int index, CustomResourceDefinitionVersion item) {
            this.index = index;
            this.builder = new CustomResourceDefinitionVersionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)CustomResourceDefinitionSpecFluent.this.setToVersions(this.index, this.builder.build());
        }

        public N endVersion() {
            return this.and();
        }
    }

    public class NamesNested<N>
    extends CustomResourceDefinitionNamesFluent<NamesNested<N>>
    implements Nested<N> {
        CustomResourceDefinitionNamesBuilder builder;

        NamesNested(CustomResourceDefinitionNames item) {
            this.builder = new CustomResourceDefinitionNamesBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)CustomResourceDefinitionSpecFluent.this.withNames(this.builder.build());
        }

        public N endNames() {
            return this.and();
        }
    }

    public class ConversionNested<N>
    extends CustomResourceConversionFluent<ConversionNested<N>>
    implements Nested<N> {
        CustomResourceConversionBuilder builder;

        ConversionNested(CustomResourceConversion item) {
            this.builder = new CustomResourceConversionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)CustomResourceDefinitionSpecFluent.this.withConversion(this.builder.build());
        }

        public N endConversion() {
            return this.and();
        }
    }
}

