/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ScaleIOVolumeSource;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ScaleIOVolumeSourceFluent<A extends ScaleIOVolumeSourceFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String fsType;
    private String gateway;
    private String protectionDomain;
    private Boolean readOnly;
    private LocalObjectReferenceBuilder secretRef;
    private Boolean sslEnabled;
    private String storageMode;
    private String storagePool;
    private String system;
    private String volumeName;

    public ScaleIOVolumeSourceFluent() {
    }

    public ScaleIOVolumeSourceFluent(ScaleIOVolumeSource instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public LocalObjectReference buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    protected void copyInstance(ScaleIOVolumeSource instance) {
        ScaleIOVolumeSource scaleIOVolumeSource = instance = instance != null ? instance : new ScaleIOVolumeSource();
        if (instance != null) {
            this.withFsType(instance.getFsType());
            this.withGateway(instance.getGateway());
            this.withProtectionDomain(instance.getProtectionDomain());
            this.withReadOnly(instance.getReadOnly());
            this.withSecretRef(instance.getSecretRef());
            this.withSslEnabled(instance.getSslEnabled());
            this.withStorageMode(instance.getStorageMode());
            this.withStoragePool(instance.getStoragePool());
            this.withSystem(instance.getSystem());
            this.withVolumeName(instance.getVolumeName());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public SecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(new LocalObjectReferenceBuilder().build()));
    }

    public SecretRefNested<A> editOrNewSecretRefLike(LocalObjectReference item) {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(item));
    }

    public SecretRefNested<A> editSecretRef() {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(null));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ScaleIOVolumeSourceFluent that = (ScaleIOVolumeSourceFluent)o;
        if (!Objects.equals(this.fsType, that.fsType)) {
            return false;
        }
        if (!Objects.equals(this.gateway, that.gateway)) {
            return false;
        }
        if (!Objects.equals(this.protectionDomain, that.protectionDomain)) {
            return false;
        }
        if (!Objects.equals(this.readOnly, that.readOnly)) {
            return false;
        }
        if (!Objects.equals(this.secretRef, that.secretRef)) {
            return false;
        }
        if (!Objects.equals(this.sslEnabled, that.sslEnabled)) {
            return false;
        }
        if (!Objects.equals(this.storageMode, that.storageMode)) {
            return false;
        }
        if (!Objects.equals(this.storagePool, that.storagePool)) {
            return false;
        }
        if (!Objects.equals(this.system, that.system)) {
            return false;
        }
        if (!Objects.equals(this.volumeName, that.volumeName)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getFsType() {
        return this.fsType;
    }

    public String getGateway() {
        return this.gateway;
    }

    public String getProtectionDomain() {
        return this.protectionDomain;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public Boolean getSslEnabled() {
        return this.sslEnabled;
    }

    public String getStorageMode() {
        return this.storageMode;
    }

    public String getStoragePool() {
        return this.storagePool;
    }

    public String getSystem() {
        return this.system;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasFsType() {
        return this.fsType != null;
    }

    public boolean hasGateway() {
        return this.gateway != null;
    }

    public boolean hasProtectionDomain() {
        return this.protectionDomain != null;
    }

    public boolean hasReadOnly() {
        return this.readOnly != null;
    }

    public boolean hasSecretRef() {
        return this.secretRef != null;
    }

    public boolean hasSslEnabled() {
        return this.sslEnabled != null;
    }

    public boolean hasStorageMode() {
        return this.storageMode != null;
    }

    public boolean hasStoragePool() {
        return this.storagePool != null;
    }

    public boolean hasSystem() {
        return this.system != null;
    }

    public boolean hasVolumeName() {
        return this.volumeName != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fsType, this.gateway, this.protectionDomain, this.readOnly, this.secretRef, this.sslEnabled, this.storageMode, this.storagePool, this.system, this.volumeName, this.additionalProperties);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.fsType != null) {
            sb.append("fsType:");
            sb.append(this.fsType);
            sb.append(",");
        }
        if (this.gateway != null) {
            sb.append("gateway:");
            sb.append(this.gateway);
            sb.append(",");
        }
        if (this.protectionDomain != null) {
            sb.append("protectionDomain:");
            sb.append(this.protectionDomain);
            sb.append(",");
        }
        if (this.readOnly != null) {
            sb.append("readOnly:");
            sb.append(this.readOnly);
            sb.append(",");
        }
        if (this.secretRef != null) {
            sb.append("secretRef:");
            sb.append(this.secretRef);
            sb.append(",");
        }
        if (this.sslEnabled != null) {
            sb.append("sslEnabled:");
            sb.append(this.sslEnabled);
            sb.append(",");
        }
        if (this.storageMode != null) {
            sb.append("storageMode:");
            sb.append(this.storageMode);
            sb.append(",");
        }
        if (this.storagePool != null) {
            sb.append("storagePool:");
            sb.append(this.storagePool);
            sb.append(",");
        }
        if (this.system != null) {
            sb.append("system:");
            sb.append(this.system);
            sb.append(",");
        }
        if (this.volumeName != null) {
            sb.append("volumeName:");
            sb.append(this.volumeName);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withFsType(String fsType) {
        this.fsType = fsType;
        return (A)this;
    }

    public A withGateway(String gateway) {
        this.gateway = gateway;
        return (A)this;
    }

    public SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNested(null);
    }

    public A withNewSecretRef(String name) {
        return this.withSecretRef(new LocalObjectReference(name));
    }

    public SecretRefNested<A> withNewSecretRefLike(LocalObjectReference item) {
        return new SecretRefNested(item);
    }

    public A withProtectionDomain(String protectionDomain) {
        this.protectionDomain = protectionDomain;
        return (A)this;
    }

    public A withReadOnly() {
        return this.withReadOnly(true);
    }

    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)this;
    }

    public A withSecretRef(LocalObjectReference secretRef) {
        this._visitables.remove("secretRef");
        if (secretRef != null) {
            this.secretRef = new LocalObjectReferenceBuilder(secretRef);
            this._visitables.get("secretRef").add(this.secretRef);
        } else {
            this.secretRef = null;
            this._visitables.get("secretRef").remove(this.secretRef);
        }
        return (A)this;
    }

    public A withSslEnabled() {
        return this.withSslEnabled(true);
    }

    public A withSslEnabled(Boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
        return (A)this;
    }

    public A withStorageMode(String storageMode) {
        this.storageMode = storageMode;
        return (A)this;
    }

    public A withStoragePool(String storagePool) {
        this.storagePool = storagePool;
        return (A)this;
    }

    public A withSystem(String system) {
        this.system = system;
        return (A)this;
    }

    public A withVolumeName(String volumeName) {
        this.volumeName = volumeName;
        return (A)this;
    }

    public class SecretRefNested<N>
    extends LocalObjectReferenceFluent<SecretRefNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;

        SecretRefNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ScaleIOVolumeSourceFluent.this.withSecretRef(this.builder.build());
        }

        public N endSecretRef() {
            return this.and();
        }
    }
}

