/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.APIServiceSpec;
import io.fabric8.kubernetes.api.model.ServiceReference;
import io.fabric8.kubernetes.api.model.ServiceReferenceBuilder;
import io.fabric8.kubernetes.api.model.ServiceReferenceFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class APIServiceSpecFluent<A extends APIServiceSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String caBundle;
    private String group;
    private Integer groupPriorityMinimum;
    private Boolean insecureSkipTLSVerify;
    private ServiceReferenceBuilder service;
    private String version;
    private Integer versionPriority;

    public APIServiceSpecFluent() {
    }

    public APIServiceSpecFluent(APIServiceSpec instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public ServiceReference buildService() {
        return this.service != null ? this.service.build() : null;
    }

    protected void copyInstance(APIServiceSpec instance) {
        APIServiceSpec aPIServiceSpec = instance = instance != null ? instance : new APIServiceSpec();
        if (instance != null) {
            this.withCaBundle(instance.getCaBundle());
            this.withGroup(instance.getGroup());
            this.withGroupPriorityMinimum(instance.getGroupPriorityMinimum());
            this.withInsecureSkipTLSVerify(instance.getInsecureSkipTLSVerify());
            this.withService(instance.getService());
            this.withVersion(instance.getVersion());
            this.withVersionPriority(instance.getVersionPriority());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ServiceNested<A> editOrNewService() {
        return this.withNewServiceLike(Optional.ofNullable(this.buildService()).orElse(new ServiceReferenceBuilder().build()));
    }

    public ServiceNested<A> editOrNewServiceLike(ServiceReference item) {
        return this.withNewServiceLike(Optional.ofNullable(this.buildService()).orElse(item));
    }

    public ServiceNested<A> editService() {
        return this.withNewServiceLike(Optional.ofNullable(this.buildService()).orElse(null));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        APIServiceSpecFluent that = (APIServiceSpecFluent)o;
        if (!Objects.equals(this.caBundle, that.caBundle)) {
            return false;
        }
        if (!Objects.equals(this.group, that.group)) {
            return false;
        }
        if (!Objects.equals(this.groupPriorityMinimum, that.groupPriorityMinimum)) {
            return false;
        }
        if (!Objects.equals(this.insecureSkipTLSVerify, that.insecureSkipTLSVerify)) {
            return false;
        }
        if (!Objects.equals(this.service, that.service)) {
            return false;
        }
        if (!Objects.equals(this.version, that.version)) {
            return false;
        }
        if (!Objects.equals(this.versionPriority, that.versionPriority)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getCaBundle() {
        return this.caBundle;
    }

    public String getGroup() {
        return this.group;
    }

    public Integer getGroupPriorityMinimum() {
        return this.groupPriorityMinimum;
    }

    public Boolean getInsecureSkipTLSVerify() {
        return this.insecureSkipTLSVerify;
    }

    public String getVersion() {
        return this.version;
    }

    public Integer getVersionPriority() {
        return this.versionPriority;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasCaBundle() {
        return this.caBundle != null;
    }

    public boolean hasGroup() {
        return this.group != null;
    }

    public boolean hasGroupPriorityMinimum() {
        return this.groupPriorityMinimum != null;
    }

    public boolean hasInsecureSkipTLSVerify() {
        return this.insecureSkipTLSVerify != null;
    }

    public boolean hasService() {
        return this.service != null;
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public boolean hasVersionPriority() {
        return this.versionPriority != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.caBundle, this.group, this.groupPriorityMinimum, this.insecureSkipTLSVerify, this.service, this.version, this.versionPriority, this.additionalProperties);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.caBundle != null) {
            sb.append("caBundle:");
            sb.append(this.caBundle);
            sb.append(",");
        }
        if (this.group != null) {
            sb.append("group:");
            sb.append(this.group);
            sb.append(",");
        }
        if (this.groupPriorityMinimum != null) {
            sb.append("groupPriorityMinimum:");
            sb.append(this.groupPriorityMinimum);
            sb.append(",");
        }
        if (this.insecureSkipTLSVerify != null) {
            sb.append("insecureSkipTLSVerify:");
            sb.append(this.insecureSkipTLSVerify);
            sb.append(",");
        }
        if (this.service != null) {
            sb.append("service:");
            sb.append(this.service);
            sb.append(",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version);
            sb.append(",");
        }
        if (this.versionPriority != null) {
            sb.append("versionPriority:");
            sb.append(this.versionPriority);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withCaBundle(String caBundle) {
        this.caBundle = caBundle;
        return (A)this;
    }

    public A withGroup(String group) {
        this.group = group;
        return (A)this;
    }

    public A withGroupPriorityMinimum(Integer groupPriorityMinimum) {
        this.groupPriorityMinimum = groupPriorityMinimum;
        return (A)this;
    }

    public A withInsecureSkipTLSVerify() {
        return this.withInsecureSkipTLSVerify(true);
    }

    public A withInsecureSkipTLSVerify(Boolean insecureSkipTLSVerify) {
        this.insecureSkipTLSVerify = insecureSkipTLSVerify;
        return (A)this;
    }

    public ServiceNested<A> withNewService() {
        return new ServiceNested(null);
    }

    public A withNewService(String name, String namespace, Integer port) {
        return this.withService(new ServiceReference(name, namespace, port));
    }

    public ServiceNested<A> withNewServiceLike(ServiceReference item) {
        return new ServiceNested(item);
    }

    public A withService(ServiceReference service) {
        this._visitables.remove("service");
        if (service != null) {
            this.service = new ServiceReferenceBuilder(service);
            this._visitables.get("service").add(this.service);
        } else {
            this.service = null;
            this._visitables.get("service").remove(this.service);
        }
        return (A)this;
    }

    public A withVersion(String version) {
        this.version = version;
        return (A)this;
    }

    public A withVersionPriority(Integer versionPriority) {
        this.versionPriority = versionPriority;
        return (A)this;
    }

    public class ServiceNested<N>
    extends ServiceReferenceFluent<ServiceNested<N>>
    implements Nested<N> {
        ServiceReferenceBuilder builder;

        ServiceNested(ServiceReference item) {
            this.builder = new ServiceReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)APIServiceSpecFluent.this.withService(this.builder.build());
        }

        public N endService() {
            return this.and();
        }
    }
}

