/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.rbac.PolicyRule;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.StrategyDeploymentPermissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class StrategyDeploymentPermissionsFluent<A extends StrategyDeploymentPermissionsFluent<A>>
extends BaseFluent<A> {
    private List<PolicyRule> rules = new ArrayList<PolicyRule>();
    private String serviceAccountName;
    private Map<String, Object> additionalProperties;

    public StrategyDeploymentPermissionsFluent() {
    }

    public StrategyDeploymentPermissionsFluent(StrategyDeploymentPermissions instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(StrategyDeploymentPermissions instance) {
        StrategyDeploymentPermissions strategyDeploymentPermissions = instance = instance != null ? instance : new StrategyDeploymentPermissions();
        if (instance != null) {
            this.withRules(instance.getRules());
            this.withServiceAccountName(instance.getServiceAccountName());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToRules(int index, PolicyRule item) {
        if (this.rules == null) {
            this.rules = new ArrayList<PolicyRule>();
        }
        this.rules.add(index, item);
        return (A)this;
    }

    public A setToRules(int index, PolicyRule item) {
        if (this.rules == null) {
            this.rules = new ArrayList<PolicyRule>();
        }
        this.rules.set(index, item);
        return (A)this;
    }

    public A addToRules(PolicyRule ... items) {
        if (this.rules == null) {
            this.rules = new ArrayList<PolicyRule>();
        }
        for (PolicyRule item : items) {
            this.rules.add(item);
        }
        return (A)this;
    }

    public A addAllToRules(Collection<PolicyRule> items) {
        if (this.rules == null) {
            this.rules = new ArrayList<PolicyRule>();
        }
        for (PolicyRule item : items) {
            this.rules.add(item);
        }
        return (A)this;
    }

    public A removeFromRules(PolicyRule ... items) {
        if (this.rules == null) {
            return (A)this;
        }
        for (PolicyRule item : items) {
            this.rules.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromRules(Collection<PolicyRule> items) {
        if (this.rules == null) {
            return (A)this;
        }
        for (PolicyRule item : items) {
            this.rules.remove(item);
        }
        return (A)this;
    }

    public List<PolicyRule> getRules() {
        return this.rules;
    }

    public PolicyRule getRule(int index) {
        return this.rules.get(index);
    }

    public PolicyRule getFirstRule() {
        return this.rules.get(0);
    }

    public PolicyRule getLastRule() {
        return this.rules.get(this.rules.size() - 1);
    }

    public PolicyRule getMatchingRule(Predicate<PolicyRule> predicate) {
        for (PolicyRule item : this.rules) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingRule(Predicate<PolicyRule> predicate) {
        for (PolicyRule item : this.rules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRules(List<PolicyRule> rules) {
        if (rules != null) {
            this.rules = new ArrayList<PolicyRule>();
            for (PolicyRule item : rules) {
                this.addToRules(item);
            }
        } else {
            this.rules = null;
        }
        return (A)this;
    }

    public A withRules(PolicyRule ... rules) {
        if (this.rules != null) {
            this.rules.clear();
            this._visitables.remove("rules");
        }
        if (rules != null) {
            for (PolicyRule item : rules) {
                this.addToRules(item);
            }
        }
        return (A)this;
    }

    public boolean hasRules() {
        return this.rules != null && !this.rules.isEmpty();
    }

    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    public A withServiceAccountName(String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
        return (A)this;
    }

    public boolean hasServiceAccountName() {
        return this.serviceAccountName != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StrategyDeploymentPermissionsFluent that = (StrategyDeploymentPermissionsFluent)o;
        if (!Objects.equals(this.rules, that.rules)) {
            return false;
        }
        if (!Objects.equals(this.serviceAccountName, that.serviceAccountName)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.rules, this.serviceAccountName, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.rules != null && !this.rules.isEmpty()) {
            sb.append("rules:");
            sb.append(String.valueOf(this.rules) + ",");
        }
        if (this.serviceAccountName != null) {
            sb.append("serviceAccountName:");
            sb.append(this.serviceAccountName + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

