/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operator.v1.GatherStatus;
import io.fabric8.openshift.api.model.operator.v1.GathererStatus;
import io.fabric8.openshift.api.model.operator.v1.GathererStatusBuilder;
import io.fabric8.openshift.api.model.operator.v1.GathererStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class GatherStatusFluent<A extends GatherStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<GathererStatusBuilder> gatherers = new ArrayList();
    private String lastGatherDuration;
    private String lastGatherTime;
    private Map<String, Object> additionalProperties;

    public GatherStatusFluent() {
    }

    public GatherStatusFluent(GatherStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(GatherStatus instance) {
        GatherStatus gatherStatus = instance = instance != null ? instance : new GatherStatus();
        if (instance != null) {
            this.withGatherers(instance.getGatherers());
            this.withLastGatherDuration(instance.getLastGatherDuration());
            this.withLastGatherTime(instance.getLastGatherTime());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToGatherers(int index, GathererStatus item) {
        if (this.gatherers == null) {
            this.gatherers = new ArrayList();
        }
        GathererStatusBuilder builder = new GathererStatusBuilder(item);
        if (index < 0 || index >= this.gatherers.size()) {
            this._visitables.get("gatherers").add(builder);
            this.gatherers.add(builder);
        } else {
            this._visitables.get("gatherers").add(builder);
            this.gatherers.add(index, builder);
        }
        return (A)this;
    }

    public A setToGatherers(int index, GathererStatus item) {
        if (this.gatherers == null) {
            this.gatherers = new ArrayList();
        }
        GathererStatusBuilder builder = new GathererStatusBuilder(item);
        if (index < 0 || index >= this.gatherers.size()) {
            this._visitables.get("gatherers").add(builder);
            this.gatherers.add(builder);
        } else {
            this._visitables.get("gatherers").add(builder);
            this.gatherers.set(index, builder);
        }
        return (A)this;
    }

    public A addToGatherers(GathererStatus ... items) {
        if (this.gatherers == null) {
            this.gatherers = new ArrayList();
        }
        for (GathererStatus item : items) {
            GathererStatusBuilder builder = new GathererStatusBuilder(item);
            this._visitables.get("gatherers").add(builder);
            this.gatherers.add(builder);
        }
        return (A)this;
    }

    public A addAllToGatherers(Collection<GathererStatus> items) {
        if (this.gatherers == null) {
            this.gatherers = new ArrayList();
        }
        for (GathererStatus item : items) {
            GathererStatusBuilder builder = new GathererStatusBuilder(item);
            this._visitables.get("gatherers").add(builder);
            this.gatherers.add(builder);
        }
        return (A)this;
    }

    public A removeFromGatherers(GathererStatus ... items) {
        if (this.gatherers == null) {
            return (A)this;
        }
        for (GathererStatus item : items) {
            GathererStatusBuilder builder = new GathererStatusBuilder(item);
            this._visitables.get("gatherers").remove(builder);
            this.gatherers.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromGatherers(Collection<GathererStatus> items) {
        if (this.gatherers == null) {
            return (A)this;
        }
        for (GathererStatus item : items) {
            GathererStatusBuilder builder = new GathererStatusBuilder(item);
            this._visitables.get("gatherers").remove(builder);
            this.gatherers.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromGatherers(Predicate<GathererStatusBuilder> predicate) {
        if (this.gatherers == null) {
            return (A)this;
        }
        Iterator<GathererStatusBuilder> each = this.gatherers.iterator();
        Object visitables = this._visitables.get("gatherers");
        while (each.hasNext()) {
            GathererStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<GathererStatus> buildGatherers() {
        return this.gatherers != null ? GatherStatusFluent.build(this.gatherers) : null;
    }

    public GathererStatus buildGatherer(int index) {
        return this.gatherers.get(index).build();
    }

    public GathererStatus buildFirstGatherer() {
        return this.gatherers.get(0).build();
    }

    public GathererStatus buildLastGatherer() {
        return this.gatherers.get(this.gatherers.size() - 1).build();
    }

    public GathererStatus buildMatchingGatherer(Predicate<GathererStatusBuilder> predicate) {
        for (GathererStatusBuilder item : this.gatherers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingGatherer(Predicate<GathererStatusBuilder> predicate) {
        for (GathererStatusBuilder item : this.gatherers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withGatherers(List<GathererStatus> gatherers) {
        if (this.gatherers != null) {
            this._visitables.get("gatherers").clear();
        }
        if (gatherers != null) {
            this.gatherers = new ArrayList();
            for (GathererStatus item : gatherers) {
                this.addToGatherers(item);
            }
        } else {
            this.gatherers = null;
        }
        return (A)this;
    }

    public A withGatherers(GathererStatus ... gatherers) {
        if (this.gatherers != null) {
            this.gatherers.clear();
            this._visitables.remove("gatherers");
        }
        if (gatherers != null) {
            for (GathererStatus item : gatherers) {
                this.addToGatherers(item);
            }
        }
        return (A)this;
    }

    public boolean hasGatherers() {
        return this.gatherers != null && !this.gatherers.isEmpty();
    }

    public GatherersNested<A> addNewGatherer() {
        return new GatherersNested(-1, null);
    }

    public GatherersNested<A> addNewGathererLike(GathererStatus item) {
        return new GatherersNested(-1, item);
    }

    public GatherersNested<A> setNewGathererLike(int index, GathererStatus item) {
        return new GatherersNested(index, item);
    }

    public GatherersNested<A> editGatherer(int index) {
        if (this.gatherers.size() <= index) {
            throw new RuntimeException("Can't edit gatherers. Index exceeds size.");
        }
        return this.setNewGathererLike(index, this.buildGatherer(index));
    }

    public GatherersNested<A> editFirstGatherer() {
        if (this.gatherers.size() == 0) {
            throw new RuntimeException("Can't edit first gatherers. The list is empty.");
        }
        return this.setNewGathererLike(0, this.buildGatherer(0));
    }

    public GatherersNested<A> editLastGatherer() {
        int index = this.gatherers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last gatherers. The list is empty.");
        }
        return this.setNewGathererLike(index, this.buildGatherer(index));
    }

    public GatherersNested<A> editMatchingGatherer(Predicate<GathererStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.gatherers.size(); ++i) {
            if (!predicate.test(this.gatherers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching gatherers. No match found.");
        }
        return this.setNewGathererLike(index, this.buildGatherer(index));
    }

    public String getLastGatherDuration() {
        return this.lastGatherDuration;
    }

    public A withLastGatherDuration(String lastGatherDuration) {
        this.lastGatherDuration = lastGatherDuration;
        return (A)this;
    }

    public boolean hasLastGatherDuration() {
        return this.lastGatherDuration != null;
    }

    public String getLastGatherTime() {
        return this.lastGatherTime;
    }

    public A withLastGatherTime(String lastGatherTime) {
        this.lastGatherTime = lastGatherTime;
        return (A)this;
    }

    public boolean hasLastGatherTime() {
        return this.lastGatherTime != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GatherStatusFluent that = (GatherStatusFluent)o;
        if (!Objects.equals(this.gatherers, that.gatherers)) {
            return false;
        }
        if (!Objects.equals(this.lastGatherDuration, that.lastGatherDuration)) {
            return false;
        }
        if (!Objects.equals(this.lastGatherTime, that.lastGatherTime)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.gatherers, this.lastGatherDuration, this.lastGatherTime, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.gatherers != null && !this.gatherers.isEmpty()) {
            sb.append("gatherers:");
            sb.append(String.valueOf(this.gatherers) + ",");
        }
        if (this.lastGatherDuration != null) {
            sb.append("lastGatherDuration:");
            sb.append(this.lastGatherDuration + ",");
        }
        if (this.lastGatherTime != null) {
            sb.append("lastGatherTime:");
            sb.append(this.lastGatherTime + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class GatherersNested<N>
    extends GathererStatusFluent<GatherersNested<N>>
    implements Nested<N> {
        GathererStatusBuilder builder;
        int index;

        GatherersNested(int index, GathererStatus item) {
            this.index = index;
            this.builder = new GathererStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)GatherStatusFluent.this.setToGatherers(this.index, this.builder.build());
        }

        public N endGatherer() {
            return this.and();
        }
    }
}

