/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.DiscordConfig;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfig;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DiscordConfigFluent<A extends DiscordConfigFluent<A>>
extends BaseFluent<A> {
    private SecretKeySelector apiURL;
    private String avatarURL;
    private String content;
    private HTTPConfigBuilder httpConfig;
    private String message;
    private Boolean sendResolved;
    private String title;
    private String username;
    private Map<String, Object> additionalProperties;

    public DiscordConfigFluent() {
    }

    public DiscordConfigFluent(DiscordConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(DiscordConfig instance) {
        DiscordConfig discordConfig = instance = instance != null ? instance : new DiscordConfig();
        if (instance != null) {
            this.withApiURL(instance.getApiURL());
            this.withAvatarURL(instance.getAvatarURL());
            this.withContent(instance.getContent());
            this.withHttpConfig(instance.getHttpConfig());
            this.withMessage(instance.getMessage());
            this.withSendResolved(instance.getSendResolved());
            this.withTitle(instance.getTitle());
            this.withUsername(instance.getUsername());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public SecretKeySelector getApiURL() {
        return this.apiURL;
    }

    public A withApiURL(SecretKeySelector apiURL) {
        this.apiURL = apiURL;
        return (A)this;
    }

    public boolean hasApiURL() {
        return this.apiURL != null;
    }

    public A withNewApiURL(String key, String name, Boolean optional) {
        return this.withApiURL(new SecretKeySelector(key, name, optional));
    }

    public String getAvatarURL() {
        return this.avatarURL;
    }

    public A withAvatarURL(String avatarURL) {
        this.avatarURL = avatarURL;
        return (A)this;
    }

    public boolean hasAvatarURL() {
        return this.avatarURL != null;
    }

    public String getContent() {
        return this.content;
    }

    public A withContent(String content) {
        this.content = content;
        return (A)this;
    }

    public boolean hasContent() {
        return this.content != null;
    }

    public HTTPConfig buildHttpConfig() {
        return this.httpConfig != null ? this.httpConfig.build() : null;
    }

    public A withHttpConfig(HTTPConfig httpConfig) {
        this._visitables.remove("httpConfig");
        if (httpConfig != null) {
            this.httpConfig = new HTTPConfigBuilder(httpConfig);
            this._visitables.get("httpConfig").add(this.httpConfig);
        } else {
            this.httpConfig = null;
            this._visitables.get("httpConfig").remove(this.httpConfig);
        }
        return (A)this;
    }

    public boolean hasHttpConfig() {
        return this.httpConfig != null;
    }

    public HttpConfigNested<A> withNewHttpConfig() {
        return new HttpConfigNested(null);
    }

    public HttpConfigNested<A> withNewHttpConfigLike(HTTPConfig item) {
        return new HttpConfigNested(item);
    }

    public HttpConfigNested<A> editHttpConfig() {
        return this.withNewHttpConfigLike(Optional.ofNullable(this.buildHttpConfig()).orElse(null));
    }

    public HttpConfigNested<A> editOrNewHttpConfig() {
        return this.withNewHttpConfigLike(Optional.ofNullable(this.buildHttpConfig()).orElse(new HTTPConfigBuilder().build()));
    }

    public HttpConfigNested<A> editOrNewHttpConfigLike(HTTPConfig item) {
        return this.withNewHttpConfigLike(Optional.ofNullable(this.buildHttpConfig()).orElse(item));
    }

    public String getMessage() {
        return this.message;
    }

    public A withMessage(String message) {
        this.message = message;
        return (A)this;
    }

    public boolean hasMessage() {
        return this.message != null;
    }

    public Boolean getSendResolved() {
        return this.sendResolved;
    }

    public A withSendResolved(Boolean sendResolved) {
        this.sendResolved = sendResolved;
        return (A)this;
    }

    public boolean hasSendResolved() {
        return this.sendResolved != null;
    }

    public String getTitle() {
        return this.title;
    }

    public A withTitle(String title) {
        this.title = title;
        return (A)this;
    }

    public boolean hasTitle() {
        return this.title != null;
    }

    public String getUsername() {
        return this.username;
    }

    public A withUsername(String username) {
        this.username = username;
        return (A)this;
    }

    public boolean hasUsername() {
        return this.username != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DiscordConfigFluent that = (DiscordConfigFluent)o;
        if (!Objects.equals(this.apiURL, that.apiURL)) {
            return false;
        }
        if (!Objects.equals(this.avatarURL, that.avatarURL)) {
            return false;
        }
        if (!Objects.equals(this.content, that.content)) {
            return false;
        }
        if (!Objects.equals(this.httpConfig, that.httpConfig)) {
            return false;
        }
        if (!Objects.equals(this.message, that.message)) {
            return false;
        }
        if (!Objects.equals(this.sendResolved, that.sendResolved)) {
            return false;
        }
        if (!Objects.equals(this.title, that.title)) {
            return false;
        }
        if (!Objects.equals(this.username, that.username)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiURL, this.avatarURL, this.content, this.httpConfig, this.message, this.sendResolved, this.title, this.username, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiURL != null) {
            sb.append("apiURL:");
            sb.append(String.valueOf(this.apiURL) + ",");
        }
        if (this.avatarURL != null) {
            sb.append("avatarURL:");
            sb.append(this.avatarURL + ",");
        }
        if (this.content != null) {
            sb.append("content:");
            sb.append(this.content + ",");
        }
        if (this.httpConfig != null) {
            sb.append("httpConfig:");
            sb.append(String.valueOf(this.httpConfig) + ",");
        }
        if (this.message != null) {
            sb.append("message:");
            sb.append(this.message + ",");
        }
        if (this.sendResolved != null) {
            sb.append("sendResolved:");
            sb.append(this.sendResolved + ",");
        }
        if (this.title != null) {
            sb.append("title:");
            sb.append(this.title + ",");
        }
        if (this.username != null) {
            sb.append("username:");
            sb.append(this.username + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withSendResolved() {
        return this.withSendResolved(true);
    }

    public class HttpConfigNested<N>
    extends HTTPConfigFluent<HttpConfigNested<N>>
    implements Nested<N> {
        HTTPConfigBuilder builder;

        HttpConfigNested(HTTPConfig item) {
            this.builder = new HTTPConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)DiscordConfigFluent.this.withHttpConfig(this.builder.build());
        }

        public N endHttpConfig() {
            return this.and();
        }
    }
}

