/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerGlobalConfig;
import io.fabric8.openshift.api.model.monitoring.v1.GlobalJiraConfig;
import io.fabric8.openshift.api.model.monitoring.v1.GlobalJiraConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.GlobalJiraConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1.GlobalRocketChatConfig;
import io.fabric8.openshift.api.model.monitoring.v1.GlobalRocketChatConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.GlobalRocketChatConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1.GlobalSMTPConfig;
import io.fabric8.openshift.api.model.monitoring.v1.GlobalSMTPConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.GlobalSMTPConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1.GlobalTelegramConfig;
import io.fabric8.openshift.api.model.monitoring.v1.GlobalTelegramConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.GlobalTelegramConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1.GlobalVictorOpsConfig;
import io.fabric8.openshift.api.model.monitoring.v1.GlobalVictorOpsConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.GlobalVictorOpsConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1.GlobalWeChatConfig;
import io.fabric8.openshift.api.model.monitoring.v1.GlobalWeChatConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.GlobalWeChatConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1.GlobalWebexConfig;
import io.fabric8.openshift.api.model.monitoring.v1.GlobalWebexConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.GlobalWebexConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1.HTTPConfig;
import io.fabric8.openshift.api.model.monitoring.v1.HTTPConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.HTTPConfigFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class AlertmanagerGlobalConfigFluent<A extends AlertmanagerGlobalConfigFluent<A>>
extends BaseFluent<A> {
    private HTTPConfigBuilder httpConfig;
    private GlobalJiraConfigBuilder jira;
    private SecretKeySelector opsGenieApiKey;
    private SecretKeySelector opsGenieApiUrl;
    private String pagerdutyUrl;
    private String resolveTimeout;
    private GlobalRocketChatConfigBuilder rocketChat;
    private SecretKeySelector slackApiUrl;
    private GlobalSMTPConfigBuilder smtp;
    private GlobalTelegramConfigBuilder telegram;
    private GlobalVictorOpsConfigBuilder victorops;
    private GlobalWebexConfigBuilder webex;
    private GlobalWeChatConfigBuilder wechat;
    private Map<String, Object> additionalProperties;

    public AlertmanagerGlobalConfigFluent() {
    }

    public AlertmanagerGlobalConfigFluent(AlertmanagerGlobalConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(AlertmanagerGlobalConfig instance) {
        AlertmanagerGlobalConfig alertmanagerGlobalConfig = instance = instance != null ? instance : new AlertmanagerGlobalConfig();
        if (instance != null) {
            this.withHttpConfig(instance.getHttpConfig());
            this.withJira(instance.getJira());
            this.withOpsGenieApiKey(instance.getOpsGenieApiKey());
            this.withOpsGenieApiUrl(instance.getOpsGenieApiUrl());
            this.withPagerdutyUrl(instance.getPagerdutyUrl());
            this.withResolveTimeout(instance.getResolveTimeout());
            this.withRocketChat(instance.getRocketChat());
            this.withSlackApiUrl(instance.getSlackApiUrl());
            this.withSmtp(instance.getSmtp());
            this.withTelegram(instance.getTelegram());
            this.withVictorops(instance.getVictorops());
            this.withWebex(instance.getWebex());
            this.withWechat(instance.getWechat());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public HTTPConfig buildHttpConfig() {
        return this.httpConfig != null ? this.httpConfig.build() : null;
    }

    public A withHttpConfig(HTTPConfig httpConfig) {
        this._visitables.remove("httpConfig");
        if (httpConfig != null) {
            this.httpConfig = new HTTPConfigBuilder(httpConfig);
            this._visitables.get("httpConfig").add(this.httpConfig);
        } else {
            this.httpConfig = null;
            this._visitables.get("httpConfig").remove(this.httpConfig);
        }
        return (A)this;
    }

    public boolean hasHttpConfig() {
        return this.httpConfig != null;
    }

    public HttpConfigNested<A> withNewHttpConfig() {
        return new HttpConfigNested(null);
    }

    public HttpConfigNested<A> withNewHttpConfigLike(HTTPConfig item) {
        return new HttpConfigNested(item);
    }

    public HttpConfigNested<A> editHttpConfig() {
        return this.withNewHttpConfigLike(Optional.ofNullable(this.buildHttpConfig()).orElse(null));
    }

    public HttpConfigNested<A> editOrNewHttpConfig() {
        return this.withNewHttpConfigLike(Optional.ofNullable(this.buildHttpConfig()).orElse(new HTTPConfigBuilder().build()));
    }

    public HttpConfigNested<A> editOrNewHttpConfigLike(HTTPConfig item) {
        return this.withNewHttpConfigLike(Optional.ofNullable(this.buildHttpConfig()).orElse(item));
    }

    public GlobalJiraConfig buildJira() {
        return this.jira != null ? this.jira.build() : null;
    }

    public A withJira(GlobalJiraConfig jira) {
        this._visitables.remove("jira");
        if (jira != null) {
            this.jira = new GlobalJiraConfigBuilder(jira);
            this._visitables.get("jira").add(this.jira);
        } else {
            this.jira = null;
            this._visitables.get("jira").remove(this.jira);
        }
        return (A)this;
    }

    public boolean hasJira() {
        return this.jira != null;
    }

    public A withNewJira(String apiURL) {
        return this.withJira(new GlobalJiraConfig(apiURL));
    }

    public JiraNested<A> withNewJira() {
        return new JiraNested(null);
    }

    public JiraNested<A> withNewJiraLike(GlobalJiraConfig item) {
        return new JiraNested(item);
    }

    public JiraNested<A> editJira() {
        return this.withNewJiraLike(Optional.ofNullable(this.buildJira()).orElse(null));
    }

    public JiraNested<A> editOrNewJira() {
        return this.withNewJiraLike(Optional.ofNullable(this.buildJira()).orElse(new GlobalJiraConfigBuilder().build()));
    }

    public JiraNested<A> editOrNewJiraLike(GlobalJiraConfig item) {
        return this.withNewJiraLike(Optional.ofNullable(this.buildJira()).orElse(item));
    }

    public SecretKeySelector getOpsGenieApiKey() {
        return this.opsGenieApiKey;
    }

    public A withOpsGenieApiKey(SecretKeySelector opsGenieApiKey) {
        this.opsGenieApiKey = opsGenieApiKey;
        return (A)this;
    }

    public boolean hasOpsGenieApiKey() {
        return this.opsGenieApiKey != null;
    }

    public A withNewOpsGenieApiKey(String key, String name, Boolean optional) {
        return this.withOpsGenieApiKey(new SecretKeySelector(key, name, optional));
    }

    public SecretKeySelector getOpsGenieApiUrl() {
        return this.opsGenieApiUrl;
    }

    public A withOpsGenieApiUrl(SecretKeySelector opsGenieApiUrl) {
        this.opsGenieApiUrl = opsGenieApiUrl;
        return (A)this;
    }

    public boolean hasOpsGenieApiUrl() {
        return this.opsGenieApiUrl != null;
    }

    public A withNewOpsGenieApiUrl(String key, String name, Boolean optional) {
        return this.withOpsGenieApiUrl(new SecretKeySelector(key, name, optional));
    }

    public String getPagerdutyUrl() {
        return this.pagerdutyUrl;
    }

    public A withPagerdutyUrl(String pagerdutyUrl) {
        this.pagerdutyUrl = pagerdutyUrl;
        return (A)this;
    }

    public boolean hasPagerdutyUrl() {
        return this.pagerdutyUrl != null;
    }

    public String getResolveTimeout() {
        return this.resolveTimeout;
    }

    public A withResolveTimeout(String resolveTimeout) {
        this.resolveTimeout = resolveTimeout;
        return (A)this;
    }

    public boolean hasResolveTimeout() {
        return this.resolveTimeout != null;
    }

    public GlobalRocketChatConfig buildRocketChat() {
        return this.rocketChat != null ? this.rocketChat.build() : null;
    }

    public A withRocketChat(GlobalRocketChatConfig rocketChat) {
        this._visitables.remove("rocketChat");
        if (rocketChat != null) {
            this.rocketChat = new GlobalRocketChatConfigBuilder(rocketChat);
            this._visitables.get("rocketChat").add(this.rocketChat);
        } else {
            this.rocketChat = null;
            this._visitables.get("rocketChat").remove(this.rocketChat);
        }
        return (A)this;
    }

    public boolean hasRocketChat() {
        return this.rocketChat != null;
    }

    public RocketChatNested<A> withNewRocketChat() {
        return new RocketChatNested(null);
    }

    public RocketChatNested<A> withNewRocketChatLike(GlobalRocketChatConfig item) {
        return new RocketChatNested(item);
    }

    public RocketChatNested<A> editRocketChat() {
        return this.withNewRocketChatLike(Optional.ofNullable(this.buildRocketChat()).orElse(null));
    }

    public RocketChatNested<A> editOrNewRocketChat() {
        return this.withNewRocketChatLike(Optional.ofNullable(this.buildRocketChat()).orElse(new GlobalRocketChatConfigBuilder().build()));
    }

    public RocketChatNested<A> editOrNewRocketChatLike(GlobalRocketChatConfig item) {
        return this.withNewRocketChatLike(Optional.ofNullable(this.buildRocketChat()).orElse(item));
    }

    public SecretKeySelector getSlackApiUrl() {
        return this.slackApiUrl;
    }

    public A withSlackApiUrl(SecretKeySelector slackApiUrl) {
        this.slackApiUrl = slackApiUrl;
        return (A)this;
    }

    public boolean hasSlackApiUrl() {
        return this.slackApiUrl != null;
    }

    public A withNewSlackApiUrl(String key, String name, Boolean optional) {
        return this.withSlackApiUrl(new SecretKeySelector(key, name, optional));
    }

    public GlobalSMTPConfig buildSmtp() {
        return this.smtp != null ? this.smtp.build() : null;
    }

    public A withSmtp(GlobalSMTPConfig smtp) {
        this._visitables.remove("smtp");
        if (smtp != null) {
            this.smtp = new GlobalSMTPConfigBuilder(smtp);
            this._visitables.get("smtp").add(this.smtp);
        } else {
            this.smtp = null;
            this._visitables.get("smtp").remove(this.smtp);
        }
        return (A)this;
    }

    public boolean hasSmtp() {
        return this.smtp != null;
    }

    public SmtpNested<A> withNewSmtp() {
        return new SmtpNested(null);
    }

    public SmtpNested<A> withNewSmtpLike(GlobalSMTPConfig item) {
        return new SmtpNested(item);
    }

    public SmtpNested<A> editSmtp() {
        return this.withNewSmtpLike(Optional.ofNullable(this.buildSmtp()).orElse(null));
    }

    public SmtpNested<A> editOrNewSmtp() {
        return this.withNewSmtpLike(Optional.ofNullable(this.buildSmtp()).orElse(new GlobalSMTPConfigBuilder().build()));
    }

    public SmtpNested<A> editOrNewSmtpLike(GlobalSMTPConfig item) {
        return this.withNewSmtpLike(Optional.ofNullable(this.buildSmtp()).orElse(item));
    }

    public GlobalTelegramConfig buildTelegram() {
        return this.telegram != null ? this.telegram.build() : null;
    }

    public A withTelegram(GlobalTelegramConfig telegram) {
        this._visitables.remove("telegram");
        if (telegram != null) {
            this.telegram = new GlobalTelegramConfigBuilder(telegram);
            this._visitables.get("telegram").add(this.telegram);
        } else {
            this.telegram = null;
            this._visitables.get("telegram").remove(this.telegram);
        }
        return (A)this;
    }

    public boolean hasTelegram() {
        return this.telegram != null;
    }

    public A withNewTelegram(String apiURL) {
        return this.withTelegram(new GlobalTelegramConfig(apiURL));
    }

    public TelegramNested<A> withNewTelegram() {
        return new TelegramNested(null);
    }

    public TelegramNested<A> withNewTelegramLike(GlobalTelegramConfig item) {
        return new TelegramNested(item);
    }

    public TelegramNested<A> editTelegram() {
        return this.withNewTelegramLike(Optional.ofNullable(this.buildTelegram()).orElse(null));
    }

    public TelegramNested<A> editOrNewTelegram() {
        return this.withNewTelegramLike(Optional.ofNullable(this.buildTelegram()).orElse(new GlobalTelegramConfigBuilder().build()));
    }

    public TelegramNested<A> editOrNewTelegramLike(GlobalTelegramConfig item) {
        return this.withNewTelegramLike(Optional.ofNullable(this.buildTelegram()).orElse(item));
    }

    public GlobalVictorOpsConfig buildVictorops() {
        return this.victorops != null ? this.victorops.build() : null;
    }

    public A withVictorops(GlobalVictorOpsConfig victorops) {
        this._visitables.remove("victorops");
        if (victorops != null) {
            this.victorops = new GlobalVictorOpsConfigBuilder(victorops);
            this._visitables.get("victorops").add(this.victorops);
        } else {
            this.victorops = null;
            this._visitables.get("victorops").remove(this.victorops);
        }
        return (A)this;
    }

    public boolean hasVictorops() {
        return this.victorops != null;
    }

    public VictoropsNested<A> withNewVictorops() {
        return new VictoropsNested(null);
    }

    public VictoropsNested<A> withNewVictoropsLike(GlobalVictorOpsConfig item) {
        return new VictoropsNested(item);
    }

    public VictoropsNested<A> editVictorops() {
        return this.withNewVictoropsLike(Optional.ofNullable(this.buildVictorops()).orElse(null));
    }

    public VictoropsNested<A> editOrNewVictorops() {
        return this.withNewVictoropsLike(Optional.ofNullable(this.buildVictorops()).orElse(new GlobalVictorOpsConfigBuilder().build()));
    }

    public VictoropsNested<A> editOrNewVictoropsLike(GlobalVictorOpsConfig item) {
        return this.withNewVictoropsLike(Optional.ofNullable(this.buildVictorops()).orElse(item));
    }

    public GlobalWebexConfig buildWebex() {
        return this.webex != null ? this.webex.build() : null;
    }

    public A withWebex(GlobalWebexConfig webex) {
        this._visitables.remove("webex");
        if (webex != null) {
            this.webex = new GlobalWebexConfigBuilder(webex);
            this._visitables.get("webex").add(this.webex);
        } else {
            this.webex = null;
            this._visitables.get("webex").remove(this.webex);
        }
        return (A)this;
    }

    public boolean hasWebex() {
        return this.webex != null;
    }

    public A withNewWebex(String apiURL) {
        return this.withWebex(new GlobalWebexConfig(apiURL));
    }

    public WebexNested<A> withNewWebex() {
        return new WebexNested(null);
    }

    public WebexNested<A> withNewWebexLike(GlobalWebexConfig item) {
        return new WebexNested(item);
    }

    public WebexNested<A> editWebex() {
        return this.withNewWebexLike(Optional.ofNullable(this.buildWebex()).orElse(null));
    }

    public WebexNested<A> editOrNewWebex() {
        return this.withNewWebexLike(Optional.ofNullable(this.buildWebex()).orElse(new GlobalWebexConfigBuilder().build()));
    }

    public WebexNested<A> editOrNewWebexLike(GlobalWebexConfig item) {
        return this.withNewWebexLike(Optional.ofNullable(this.buildWebex()).orElse(item));
    }

    public GlobalWeChatConfig buildWechat() {
        return this.wechat != null ? this.wechat.build() : null;
    }

    public A withWechat(GlobalWeChatConfig wechat) {
        this._visitables.remove("wechat");
        if (wechat != null) {
            this.wechat = new GlobalWeChatConfigBuilder(wechat);
            this._visitables.get("wechat").add(this.wechat);
        } else {
            this.wechat = null;
            this._visitables.get("wechat").remove(this.wechat);
        }
        return (A)this;
    }

    public boolean hasWechat() {
        return this.wechat != null;
    }

    public WechatNested<A> withNewWechat() {
        return new WechatNested(null);
    }

    public WechatNested<A> withNewWechatLike(GlobalWeChatConfig item) {
        return new WechatNested(item);
    }

    public WechatNested<A> editWechat() {
        return this.withNewWechatLike(Optional.ofNullable(this.buildWechat()).orElse(null));
    }

    public WechatNested<A> editOrNewWechat() {
        return this.withNewWechatLike(Optional.ofNullable(this.buildWechat()).orElse(new GlobalWeChatConfigBuilder().build()));
    }

    public WechatNested<A> editOrNewWechatLike(GlobalWeChatConfig item) {
        return this.withNewWechatLike(Optional.ofNullable(this.buildWechat()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AlertmanagerGlobalConfigFluent that = (AlertmanagerGlobalConfigFluent)o;
        if (!Objects.equals(this.httpConfig, that.httpConfig)) {
            return false;
        }
        if (!Objects.equals(this.jira, that.jira)) {
            return false;
        }
        if (!Objects.equals(this.opsGenieApiKey, that.opsGenieApiKey)) {
            return false;
        }
        if (!Objects.equals(this.opsGenieApiUrl, that.opsGenieApiUrl)) {
            return false;
        }
        if (!Objects.equals(this.pagerdutyUrl, that.pagerdutyUrl)) {
            return false;
        }
        if (!Objects.equals(this.resolveTimeout, that.resolveTimeout)) {
            return false;
        }
        if (!Objects.equals(this.rocketChat, that.rocketChat)) {
            return false;
        }
        if (!Objects.equals(this.slackApiUrl, that.slackApiUrl)) {
            return false;
        }
        if (!Objects.equals(this.smtp, that.smtp)) {
            return false;
        }
        if (!Objects.equals(this.telegram, that.telegram)) {
            return false;
        }
        if (!Objects.equals(this.victorops, that.victorops)) {
            return false;
        }
        if (!Objects.equals(this.webex, that.webex)) {
            return false;
        }
        if (!Objects.equals(this.wechat, that.wechat)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.httpConfig, this.jira, this.opsGenieApiKey, this.opsGenieApiUrl, this.pagerdutyUrl, this.resolveTimeout, this.rocketChat, this.slackApiUrl, this.smtp, this.telegram, this.victorops, this.webex, this.wechat, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.httpConfig != null) {
            sb.append("httpConfig:");
            sb.append(String.valueOf(this.httpConfig) + ",");
        }
        if (this.jira != null) {
            sb.append("jira:");
            sb.append(String.valueOf(this.jira) + ",");
        }
        if (this.opsGenieApiKey != null) {
            sb.append("opsGenieApiKey:");
            sb.append(String.valueOf(this.opsGenieApiKey) + ",");
        }
        if (this.opsGenieApiUrl != null) {
            sb.append("opsGenieApiUrl:");
            sb.append(String.valueOf(this.opsGenieApiUrl) + ",");
        }
        if (this.pagerdutyUrl != null) {
            sb.append("pagerdutyUrl:");
            sb.append(this.pagerdutyUrl + ",");
        }
        if (this.resolveTimeout != null) {
            sb.append("resolveTimeout:");
            sb.append(this.resolveTimeout + ",");
        }
        if (this.rocketChat != null) {
            sb.append("rocketChat:");
            sb.append(String.valueOf(this.rocketChat) + ",");
        }
        if (this.slackApiUrl != null) {
            sb.append("slackApiUrl:");
            sb.append(String.valueOf(this.slackApiUrl) + ",");
        }
        if (this.smtp != null) {
            sb.append("smtp:");
            sb.append(String.valueOf(this.smtp) + ",");
        }
        if (this.telegram != null) {
            sb.append("telegram:");
            sb.append(String.valueOf(this.telegram) + ",");
        }
        if (this.victorops != null) {
            sb.append("victorops:");
            sb.append(String.valueOf(this.victorops) + ",");
        }
        if (this.webex != null) {
            sb.append("webex:");
            sb.append(String.valueOf(this.webex) + ",");
        }
        if (this.wechat != null) {
            sb.append("wechat:");
            sb.append(String.valueOf(this.wechat) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class WechatNested<N>
    extends GlobalWeChatConfigFluent<WechatNested<N>>
    implements Nested<N> {
        GlobalWeChatConfigBuilder builder;

        WechatNested(GlobalWeChatConfig item) {
            this.builder = new GlobalWeChatConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AlertmanagerGlobalConfigFluent.this.withWechat(this.builder.build());
        }

        public N endWechat() {
            return this.and();
        }
    }

    public class WebexNested<N>
    extends GlobalWebexConfigFluent<WebexNested<N>>
    implements Nested<N> {
        GlobalWebexConfigBuilder builder;

        WebexNested(GlobalWebexConfig item) {
            this.builder = new GlobalWebexConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AlertmanagerGlobalConfigFluent.this.withWebex(this.builder.build());
        }

        public N endWebex() {
            return this.and();
        }
    }

    public class VictoropsNested<N>
    extends GlobalVictorOpsConfigFluent<VictoropsNested<N>>
    implements Nested<N> {
        GlobalVictorOpsConfigBuilder builder;

        VictoropsNested(GlobalVictorOpsConfig item) {
            this.builder = new GlobalVictorOpsConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AlertmanagerGlobalConfigFluent.this.withVictorops(this.builder.build());
        }

        public N endVictorops() {
            return this.and();
        }
    }

    public class TelegramNested<N>
    extends GlobalTelegramConfigFluent<TelegramNested<N>>
    implements Nested<N> {
        GlobalTelegramConfigBuilder builder;

        TelegramNested(GlobalTelegramConfig item) {
            this.builder = new GlobalTelegramConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AlertmanagerGlobalConfigFluent.this.withTelegram(this.builder.build());
        }

        public N endTelegram() {
            return this.and();
        }
    }

    public class SmtpNested<N>
    extends GlobalSMTPConfigFluent<SmtpNested<N>>
    implements Nested<N> {
        GlobalSMTPConfigBuilder builder;

        SmtpNested(GlobalSMTPConfig item) {
            this.builder = new GlobalSMTPConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AlertmanagerGlobalConfigFluent.this.withSmtp(this.builder.build());
        }

        public N endSmtp() {
            return this.and();
        }
    }

    public class RocketChatNested<N>
    extends GlobalRocketChatConfigFluent<RocketChatNested<N>>
    implements Nested<N> {
        GlobalRocketChatConfigBuilder builder;

        RocketChatNested(GlobalRocketChatConfig item) {
            this.builder = new GlobalRocketChatConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AlertmanagerGlobalConfigFluent.this.withRocketChat(this.builder.build());
        }

        public N endRocketChat() {
            return this.and();
        }
    }

    public class JiraNested<N>
    extends GlobalJiraConfigFluent<JiraNested<N>>
    implements Nested<N> {
        GlobalJiraConfigBuilder builder;

        JiraNested(GlobalJiraConfig item) {
            this.builder = new GlobalJiraConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AlertmanagerGlobalConfigFluent.this.withJira(this.builder.build());
        }

        public N endJira() {
            return this.and();
        }
    }

    public class HttpConfigNested<N>
    extends HTTPConfigFluent<HttpConfigNested<N>>
    implements Nested<N> {
        HTTPConfigBuilder builder;

        HttpConfigNested(HTTPConfig item) {
            this.builder = new HTTPConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AlertmanagerGlobalConfigFluent.this.withHttpConfig(this.builder.build());
        }

        public N endHttpConfig() {
            return this.and();
        }
    }
}

