/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.network.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.openshift.api.model.miscellaneous.network.v1alpha1.DNSNameResolverResolvedAddress;
import io.fabric8.openshift.api.model.miscellaneous.network.v1alpha1.DNSNameResolverResolvedAddressBuilder;
import io.fabric8.openshift.api.model.miscellaneous.network.v1alpha1.DNSNameResolverResolvedAddressFluent;
import io.fabric8.openshift.api.model.miscellaneous.network.v1alpha1.DNSNameResolverResolvedName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class DNSNameResolverResolvedNameFluent<A extends DNSNameResolverResolvedNameFluent<A>>
extends BaseFluent<A> {
    private List<Condition> conditions = new ArrayList<Condition>();
    private String dnsName;
    private Integer resolutionFailures;
    private ArrayList<DNSNameResolverResolvedAddressBuilder> resolvedAddresses = new ArrayList();
    private Map<String, Object> additionalProperties;

    public DNSNameResolverResolvedNameFluent() {
    }

    public DNSNameResolverResolvedNameFluent(DNSNameResolverResolvedName instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(DNSNameResolverResolvedName instance) {
        DNSNameResolverResolvedName dNSNameResolverResolvedName = instance = instance != null ? instance : new DNSNameResolverResolvedName();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withDnsName(instance.getDnsName());
            this.withResolutionFailures(instance.getResolutionFailures());
            this.withResolvedAddresses(instance.getResolvedAddresses());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)this;
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)this;
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)this;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public Condition getCondition(int index) {
        return this.conditions.get(index);
    }

    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public String getDnsName() {
        return this.dnsName;
    }

    public A withDnsName(String dnsName) {
        this.dnsName = dnsName;
        return (A)this;
    }

    public boolean hasDnsName() {
        return this.dnsName != null;
    }

    public Integer getResolutionFailures() {
        return this.resolutionFailures;
    }

    public A withResolutionFailures(Integer resolutionFailures) {
        this.resolutionFailures = resolutionFailures;
        return (A)this;
    }

    public boolean hasResolutionFailures() {
        return this.resolutionFailures != null;
    }

    public A addToResolvedAddresses(int index, DNSNameResolverResolvedAddress item) {
        if (this.resolvedAddresses == null) {
            this.resolvedAddresses = new ArrayList();
        }
        DNSNameResolverResolvedAddressBuilder builder = new DNSNameResolverResolvedAddressBuilder(item);
        if (index < 0 || index >= this.resolvedAddresses.size()) {
            this._visitables.get("resolvedAddresses").add(builder);
            this.resolvedAddresses.add(builder);
        } else {
            this._visitables.get("resolvedAddresses").add(builder);
            this.resolvedAddresses.add(index, builder);
        }
        return (A)this;
    }

    public A setToResolvedAddresses(int index, DNSNameResolverResolvedAddress item) {
        if (this.resolvedAddresses == null) {
            this.resolvedAddresses = new ArrayList();
        }
        DNSNameResolverResolvedAddressBuilder builder = new DNSNameResolverResolvedAddressBuilder(item);
        if (index < 0 || index >= this.resolvedAddresses.size()) {
            this._visitables.get("resolvedAddresses").add(builder);
            this.resolvedAddresses.add(builder);
        } else {
            this._visitables.get("resolvedAddresses").add(builder);
            this.resolvedAddresses.set(index, builder);
        }
        return (A)this;
    }

    public A addToResolvedAddresses(DNSNameResolverResolvedAddress ... items) {
        if (this.resolvedAddresses == null) {
            this.resolvedAddresses = new ArrayList();
        }
        for (DNSNameResolverResolvedAddress item : items) {
            DNSNameResolverResolvedAddressBuilder builder = new DNSNameResolverResolvedAddressBuilder(item);
            this._visitables.get("resolvedAddresses").add(builder);
            this.resolvedAddresses.add(builder);
        }
        return (A)this;
    }

    public A addAllToResolvedAddresses(Collection<DNSNameResolverResolvedAddress> items) {
        if (this.resolvedAddresses == null) {
            this.resolvedAddresses = new ArrayList();
        }
        for (DNSNameResolverResolvedAddress item : items) {
            DNSNameResolverResolvedAddressBuilder builder = new DNSNameResolverResolvedAddressBuilder(item);
            this._visitables.get("resolvedAddresses").add(builder);
            this.resolvedAddresses.add(builder);
        }
        return (A)this;
    }

    public A removeFromResolvedAddresses(DNSNameResolverResolvedAddress ... items) {
        if (this.resolvedAddresses == null) {
            return (A)this;
        }
        for (DNSNameResolverResolvedAddress item : items) {
            DNSNameResolverResolvedAddressBuilder builder = new DNSNameResolverResolvedAddressBuilder(item);
            this._visitables.get("resolvedAddresses").remove(builder);
            this.resolvedAddresses.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromResolvedAddresses(Collection<DNSNameResolverResolvedAddress> items) {
        if (this.resolvedAddresses == null) {
            return (A)this;
        }
        for (DNSNameResolverResolvedAddress item : items) {
            DNSNameResolverResolvedAddressBuilder builder = new DNSNameResolverResolvedAddressBuilder(item);
            this._visitables.get("resolvedAddresses").remove(builder);
            this.resolvedAddresses.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromResolvedAddresses(Predicate<DNSNameResolverResolvedAddressBuilder> predicate) {
        if (this.resolvedAddresses == null) {
            return (A)this;
        }
        Iterator<DNSNameResolverResolvedAddressBuilder> each = this.resolvedAddresses.iterator();
        Object visitables = this._visitables.get("resolvedAddresses");
        while (each.hasNext()) {
            DNSNameResolverResolvedAddressBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<DNSNameResolverResolvedAddress> buildResolvedAddresses() {
        return this.resolvedAddresses != null ? DNSNameResolverResolvedNameFluent.build(this.resolvedAddresses) : null;
    }

    public DNSNameResolverResolvedAddress buildResolvedAddress(int index) {
        return this.resolvedAddresses.get(index).build();
    }

    public DNSNameResolverResolvedAddress buildFirstResolvedAddress() {
        return this.resolvedAddresses.get(0).build();
    }

    public DNSNameResolverResolvedAddress buildLastResolvedAddress() {
        return this.resolvedAddresses.get(this.resolvedAddresses.size() - 1).build();
    }

    public DNSNameResolverResolvedAddress buildMatchingResolvedAddress(Predicate<DNSNameResolverResolvedAddressBuilder> predicate) {
        for (DNSNameResolverResolvedAddressBuilder item : this.resolvedAddresses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingResolvedAddress(Predicate<DNSNameResolverResolvedAddressBuilder> predicate) {
        for (DNSNameResolverResolvedAddressBuilder item : this.resolvedAddresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withResolvedAddresses(List<DNSNameResolverResolvedAddress> resolvedAddresses) {
        if (this.resolvedAddresses != null) {
            this._visitables.get("resolvedAddresses").clear();
        }
        if (resolvedAddresses != null) {
            this.resolvedAddresses = new ArrayList();
            for (DNSNameResolverResolvedAddress item : resolvedAddresses) {
                this.addToResolvedAddresses(item);
            }
        } else {
            this.resolvedAddresses = null;
        }
        return (A)this;
    }

    public A withResolvedAddresses(DNSNameResolverResolvedAddress ... resolvedAddresses) {
        if (this.resolvedAddresses != null) {
            this.resolvedAddresses.clear();
            this._visitables.remove("resolvedAddresses");
        }
        if (resolvedAddresses != null) {
            for (DNSNameResolverResolvedAddress item : resolvedAddresses) {
                this.addToResolvedAddresses(item);
            }
        }
        return (A)this;
    }

    public boolean hasResolvedAddresses() {
        return this.resolvedAddresses != null && !this.resolvedAddresses.isEmpty();
    }

    public A addNewResolvedAddress(String ip, String lastLookupTime, Integer ttlSeconds) {
        return this.addToResolvedAddresses(new DNSNameResolverResolvedAddress(ip, lastLookupTime, ttlSeconds));
    }

    public ResolvedAddressesNested<A> addNewResolvedAddress() {
        return new ResolvedAddressesNested(-1, null);
    }

    public ResolvedAddressesNested<A> addNewResolvedAddressLike(DNSNameResolverResolvedAddress item) {
        return new ResolvedAddressesNested(-1, item);
    }

    public ResolvedAddressesNested<A> setNewResolvedAddressLike(int index, DNSNameResolverResolvedAddress item) {
        return new ResolvedAddressesNested(index, item);
    }

    public ResolvedAddressesNested<A> editResolvedAddress(int index) {
        if (this.resolvedAddresses.size() <= index) {
            throw new RuntimeException("Can't edit resolvedAddresses. Index exceeds size.");
        }
        return this.setNewResolvedAddressLike(index, this.buildResolvedAddress(index));
    }

    public ResolvedAddressesNested<A> editFirstResolvedAddress() {
        if (this.resolvedAddresses.size() == 0) {
            throw new RuntimeException("Can't edit first resolvedAddresses. The list is empty.");
        }
        return this.setNewResolvedAddressLike(0, this.buildResolvedAddress(0));
    }

    public ResolvedAddressesNested<A> editLastResolvedAddress() {
        int index = this.resolvedAddresses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last resolvedAddresses. The list is empty.");
        }
        return this.setNewResolvedAddressLike(index, this.buildResolvedAddress(index));
    }

    public ResolvedAddressesNested<A> editMatchingResolvedAddress(Predicate<DNSNameResolverResolvedAddressBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.resolvedAddresses.size(); ++i) {
            if (!predicate.test(this.resolvedAddresses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching resolvedAddresses. No match found.");
        }
        return this.setNewResolvedAddressLike(index, this.buildResolvedAddress(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DNSNameResolverResolvedNameFluent that = (DNSNameResolverResolvedNameFluent)o;
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.dnsName, that.dnsName)) {
            return false;
        }
        if (!Objects.equals(this.resolutionFailures, that.resolutionFailures)) {
            return false;
        }
        if (!Objects.equals(this.resolvedAddresses, that.resolvedAddresses)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.conditions, this.dnsName, this.resolutionFailures, this.resolvedAddresses, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(String.valueOf(this.conditions) + ",");
        }
        if (this.dnsName != null) {
            sb.append("dnsName:");
            sb.append(this.dnsName + ",");
        }
        if (this.resolutionFailures != null) {
            sb.append("resolutionFailures:");
            sb.append(this.resolutionFailures + ",");
        }
        if (this.resolvedAddresses != null && !this.resolvedAddresses.isEmpty()) {
            sb.append("resolvedAddresses:");
            sb.append(String.valueOf(this.resolvedAddresses) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ResolvedAddressesNested<N>
    extends DNSNameResolverResolvedAddressFluent<ResolvedAddressesNested<N>>
    implements Nested<N> {
        DNSNameResolverResolvedAddressBuilder builder;
        int index;

        ResolvedAddressesNested(int index, DNSNameResolverResolvedAddress item) {
            this.index = index;
            this.builder = new DNSNameResolverResolvedAddressBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)DNSNameResolverResolvedNameFluent.this.setToResolvedAddresses(this.index, this.builder.build());
        }

        public N endResolvedAddress() {
            return this.and();
        }
    }
}

