/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machineconfiguration.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.MCOObjectReference;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.MCOObjectReferenceBuilder;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.MCOObjectReferenceFluent;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.MachineConfigNodeSpec;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.MachineConfigNodeSpecMachineConfigVersion;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.MachineConfigNodeSpecMachineConfigVersionBuilder;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.MachineConfigNodeSpecMachineConfigVersionFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class MachineConfigNodeSpecFluent<A extends MachineConfigNodeSpecFluent<A>>
extends BaseFluent<A> {
    private MachineConfigNodeSpecMachineConfigVersionBuilder configVersion;
    private MCOObjectReferenceBuilder node;
    private MCOObjectReferenceBuilder pool;
    private Map<String, Object> additionalProperties;

    public MachineConfigNodeSpecFluent() {
    }

    public MachineConfigNodeSpecFluent(MachineConfigNodeSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(MachineConfigNodeSpec instance) {
        MachineConfigNodeSpec machineConfigNodeSpec = instance = instance != null ? instance : new MachineConfigNodeSpec();
        if (instance != null) {
            this.withConfigVersion(instance.getConfigVersion());
            this.withNode(instance.getNode());
            this.withPool(instance.getPool());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public MachineConfigNodeSpecMachineConfigVersion buildConfigVersion() {
        return this.configVersion != null ? this.configVersion.build() : null;
    }

    public A withConfigVersion(MachineConfigNodeSpecMachineConfigVersion configVersion) {
        this._visitables.remove("configVersion");
        if (configVersion != null) {
            this.configVersion = new MachineConfigNodeSpecMachineConfigVersionBuilder(configVersion);
            this._visitables.get("configVersion").add(this.configVersion);
        } else {
            this.configVersion = null;
            this._visitables.get("configVersion").remove(this.configVersion);
        }
        return (A)this;
    }

    public boolean hasConfigVersion() {
        return this.configVersion != null;
    }

    public A withNewConfigVersion(String desired) {
        return this.withConfigVersion(new MachineConfigNodeSpecMachineConfigVersion(desired));
    }

    public ConfigVersionNested<A> withNewConfigVersion() {
        return new ConfigVersionNested(null);
    }

    public ConfigVersionNested<A> withNewConfigVersionLike(MachineConfigNodeSpecMachineConfigVersion item) {
        return new ConfigVersionNested(item);
    }

    public ConfigVersionNested<A> editConfigVersion() {
        return this.withNewConfigVersionLike(Optional.ofNullable(this.buildConfigVersion()).orElse(null));
    }

    public ConfigVersionNested<A> editOrNewConfigVersion() {
        return this.withNewConfigVersionLike(Optional.ofNullable(this.buildConfigVersion()).orElse(new MachineConfigNodeSpecMachineConfigVersionBuilder().build()));
    }

    public ConfigVersionNested<A> editOrNewConfigVersionLike(MachineConfigNodeSpecMachineConfigVersion item) {
        return this.withNewConfigVersionLike(Optional.ofNullable(this.buildConfigVersion()).orElse(item));
    }

    public MCOObjectReference buildNode() {
        return this.node != null ? this.node.build() : null;
    }

    public A withNode(MCOObjectReference node) {
        this._visitables.remove("node");
        if (node != null) {
            this.node = new MCOObjectReferenceBuilder(node);
            this._visitables.get("node").add(this.node);
        } else {
            this.node = null;
            this._visitables.get("node").remove(this.node);
        }
        return (A)this;
    }

    public boolean hasNode() {
        return this.node != null;
    }

    public A withNewNode(String name) {
        return this.withNode(new MCOObjectReference(name));
    }

    public NodeNested<A> withNewNode() {
        return new NodeNested(null);
    }

    public NodeNested<A> withNewNodeLike(MCOObjectReference item) {
        return new NodeNested(item);
    }

    public NodeNested<A> editNode() {
        return this.withNewNodeLike(Optional.ofNullable(this.buildNode()).orElse(null));
    }

    public NodeNested<A> editOrNewNode() {
        return this.withNewNodeLike(Optional.ofNullable(this.buildNode()).orElse(new MCOObjectReferenceBuilder().build()));
    }

    public NodeNested<A> editOrNewNodeLike(MCOObjectReference item) {
        return this.withNewNodeLike(Optional.ofNullable(this.buildNode()).orElse(item));
    }

    public MCOObjectReference buildPool() {
        return this.pool != null ? this.pool.build() : null;
    }

    public A withPool(MCOObjectReference pool) {
        this._visitables.remove("pool");
        if (pool != null) {
            this.pool = new MCOObjectReferenceBuilder(pool);
            this._visitables.get("pool").add(this.pool);
        } else {
            this.pool = null;
            this._visitables.get("pool").remove(this.pool);
        }
        return (A)this;
    }

    public boolean hasPool() {
        return this.pool != null;
    }

    public A withNewPool(String name) {
        return this.withPool(new MCOObjectReference(name));
    }

    public PoolNested<A> withNewPool() {
        return new PoolNested(null);
    }

    public PoolNested<A> withNewPoolLike(MCOObjectReference item) {
        return new PoolNested(item);
    }

    public PoolNested<A> editPool() {
        return this.withNewPoolLike(Optional.ofNullable(this.buildPool()).orElse(null));
    }

    public PoolNested<A> editOrNewPool() {
        return this.withNewPoolLike(Optional.ofNullable(this.buildPool()).orElse(new MCOObjectReferenceBuilder().build()));
    }

    public PoolNested<A> editOrNewPoolLike(MCOObjectReference item) {
        return this.withNewPoolLike(Optional.ofNullable(this.buildPool()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachineConfigNodeSpecFluent that = (MachineConfigNodeSpecFluent)o;
        if (!Objects.equals(this.configVersion, that.configVersion)) {
            return false;
        }
        if (!Objects.equals(this.node, that.node)) {
            return false;
        }
        if (!Objects.equals(this.pool, that.pool)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.configVersion, this.node, this.pool, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configVersion != null) {
            sb.append("configVersion:");
            sb.append(String.valueOf(this.configVersion) + ",");
        }
        if (this.node != null) {
            sb.append("node:");
            sb.append(String.valueOf(this.node) + ",");
        }
        if (this.pool != null) {
            sb.append("pool:");
            sb.append(String.valueOf(this.pool) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PoolNested<N>
    extends MCOObjectReferenceFluent<PoolNested<N>>
    implements Nested<N> {
        MCOObjectReferenceBuilder builder;

        PoolNested(MCOObjectReference item) {
            this.builder = new MCOObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)MachineConfigNodeSpecFluent.this.withPool(this.builder.build());
        }

        public N endPool() {
            return this.and();
        }
    }

    public class NodeNested<N>
    extends MCOObjectReferenceFluent<NodeNested<N>>
    implements Nested<N> {
        MCOObjectReferenceBuilder builder;

        NodeNested(MCOObjectReference item) {
            this.builder = new MCOObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)MachineConfigNodeSpecFluent.this.withNode(this.builder.build());
        }

        public N endNode() {
            return this.and();
        }
    }

    public class ConfigVersionNested<N>
    extends MachineConfigNodeSpecMachineConfigVersionFluent<ConfigVersionNested<N>>
    implements Nested<N> {
        MachineConfigNodeSpecMachineConfigVersionBuilder builder;

        ConfigVersionNested(MachineConfigNodeSpecMachineConfigVersion item) {
            this.builder = new MachineConfigNodeSpecMachineConfigVersionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)MachineConfigNodeSpecFluent.this.withConfigVersion(this.builder.build());
        }

        public N endConfigVersion() {
            return this.and();
        }
    }
}

