/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.nutanix.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.NutanixPlatformLoadBalancer;
import io.fabric8.openshift.api.model.installer.nutanix.v1.FailureDomain;
import io.fabric8.openshift.api.model.installer.nutanix.v1.FailureDomainBuilder;
import io.fabric8.openshift.api.model.installer.nutanix.v1.FailureDomainFluent;
import io.fabric8.openshift.api.model.installer.nutanix.v1.MachinePool;
import io.fabric8.openshift.api.model.installer.nutanix.v1.MachinePoolBuilder;
import io.fabric8.openshift.api.model.installer.nutanix.v1.MachinePoolFluent;
import io.fabric8.openshift.api.model.installer.nutanix.v1.Platform;
import io.fabric8.openshift.api.model.installer.nutanix.v1.PrismCentral;
import io.fabric8.openshift.api.model.installer.nutanix.v1.PrismCentralBuilder;
import io.fabric8.openshift.api.model.installer.nutanix.v1.PrismCentralFluent;
import io.fabric8.openshift.api.model.installer.nutanix.v1.PrismElement;
import io.fabric8.openshift.api.model.installer.nutanix.v1.PrismElementBuilder;
import io.fabric8.openshift.api.model.installer.nutanix.v1.PrismElementFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class PlatformFluent<A extends PlatformFluent<A>>
extends BaseFluent<A> {
    private String apiVIP;
    private List<String> apiVIPs = new ArrayList<String>();
    private String clusterOSImage;
    private MachinePoolBuilder defaultMachinePlatform;
    private ArrayList<FailureDomainBuilder> failureDomains = new ArrayList();
    private String ingressVIP;
    private List<String> ingressVIPs = new ArrayList<String>();
    private NutanixPlatformLoadBalancer loadBalancer;
    private String preloadedOSImageName;
    private Integer prismAPICallTimeout;
    private PrismCentralBuilder prismCentral;
    private ArrayList<PrismElementBuilder> prismElements = new ArrayList();
    private List<String> subnetUUIDs = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public PlatformFluent() {
    }

    public PlatformFluent(Platform instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Platform instance) {
        Platform platform = instance = instance != null ? instance : new Platform();
        if (instance != null) {
            this.withApiVIP(instance.getApiVIP());
            this.withApiVIPs(instance.getApiVIPs());
            this.withClusterOSImage(instance.getClusterOSImage());
            this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
            this.withFailureDomains(instance.getFailureDomains());
            this.withIngressVIP(instance.getIngressVIP());
            this.withIngressVIPs(instance.getIngressVIPs());
            this.withLoadBalancer(instance.getLoadBalancer());
            this.withPreloadedOSImageName(instance.getPreloadedOSImageName());
            this.withPrismAPICallTimeout(instance.getPrismAPICallTimeout());
            this.withPrismCentral(instance.getPrismCentral());
            this.withPrismElements(instance.getPrismElements());
            this.withSubnetUUIDs(instance.getSubnetUUIDs());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVIP() {
        return this.apiVIP;
    }

    public A withApiVIP(String apiVIP) {
        this.apiVIP = apiVIP;
        return (A)this;
    }

    public boolean hasApiVIP() {
        return this.apiVIP != null;
    }

    public A addToApiVIPs(int index, String item) {
        if (this.apiVIPs == null) {
            this.apiVIPs = new ArrayList<String>();
        }
        this.apiVIPs.add(index, item);
        return (A)this;
    }

    public A setToApiVIPs(int index, String item) {
        if (this.apiVIPs == null) {
            this.apiVIPs = new ArrayList<String>();
        }
        this.apiVIPs.set(index, item);
        return (A)this;
    }

    public A addToApiVIPs(String ... items) {
        if (this.apiVIPs == null) {
            this.apiVIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.apiVIPs.add(item);
        }
        return (A)this;
    }

    public A addAllToApiVIPs(Collection<String> items) {
        if (this.apiVIPs == null) {
            this.apiVIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.apiVIPs.add(item);
        }
        return (A)this;
    }

    public A removeFromApiVIPs(String ... items) {
        if (this.apiVIPs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.apiVIPs.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromApiVIPs(Collection<String> items) {
        if (this.apiVIPs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.apiVIPs.remove(item);
        }
        return (A)this;
    }

    public List<String> getApiVIPs() {
        return this.apiVIPs;
    }

    public String getApiVIP(int index) {
        return this.apiVIPs.get(index);
    }

    public String getFirstApiVIP() {
        return this.apiVIPs.get(0);
    }

    public String getLastApiVIP() {
        return this.apiVIPs.get(this.apiVIPs.size() - 1);
    }

    public String getMatchingApiVIP(Predicate<String> predicate) {
        for (String item : this.apiVIPs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingApiVIP(Predicate<String> predicate) {
        for (String item : this.apiVIPs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withApiVIPs(List<String> apiVIPs) {
        if (apiVIPs != null) {
            this.apiVIPs = new ArrayList<String>();
            for (String item : apiVIPs) {
                this.addToApiVIPs(item);
            }
        } else {
            this.apiVIPs = null;
        }
        return (A)this;
    }

    public A withApiVIPs(String ... apiVIPs) {
        if (this.apiVIPs != null) {
            this.apiVIPs.clear();
            this._visitables.remove("apiVIPs");
        }
        if (apiVIPs != null) {
            for (String item : apiVIPs) {
                this.addToApiVIPs(item);
            }
        }
        return (A)this;
    }

    public boolean hasApiVIPs() {
        return this.apiVIPs != null && !this.apiVIPs.isEmpty();
    }

    public String getClusterOSImage() {
        return this.clusterOSImage;
    }

    public A withClusterOSImage(String clusterOSImage) {
        this.clusterOSImage = clusterOSImage;
        return (A)this;
    }

    public boolean hasClusterOSImage() {
        return this.clusterOSImage != null;
    }

    public MachinePool buildDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null ? this.defaultMachinePlatform.build() : null;
    }

    public A withDefaultMachinePlatform(MachinePool defaultMachinePlatform) {
        this._visitables.remove("defaultMachinePlatform");
        if (defaultMachinePlatform != null) {
            this.defaultMachinePlatform = new MachinePoolBuilder(defaultMachinePlatform);
            this._visitables.get("defaultMachinePlatform").add(this.defaultMachinePlatform);
        } else {
            this.defaultMachinePlatform = null;
            this._visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform);
        }
        return (A)this;
    }

    public boolean hasDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null;
    }

    public DefaultMachinePlatformNested<A> withNewDefaultMachinePlatform() {
        return new DefaultMachinePlatformNested(null);
    }

    public DefaultMachinePlatformNested<A> withNewDefaultMachinePlatformLike(MachinePool item) {
        return new DefaultMachinePlatformNested(item);
    }

    public DefaultMachinePlatformNested<A> editDefaultMachinePlatform() {
        return this.withNewDefaultMachinePlatformLike(Optional.ofNullable(this.buildDefaultMachinePlatform()).orElse(null));
    }

    public DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatform() {
        return this.withNewDefaultMachinePlatformLike(Optional.ofNullable(this.buildDefaultMachinePlatform()).orElse(new MachinePoolBuilder().build()));
    }

    public DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatformLike(MachinePool item) {
        return this.withNewDefaultMachinePlatformLike(Optional.ofNullable(this.buildDefaultMachinePlatform()).orElse(item));
    }

    public A addToFailureDomains(int index, FailureDomain item) {
        if (this.failureDomains == null) {
            this.failureDomains = new ArrayList();
        }
        FailureDomainBuilder builder = new FailureDomainBuilder(item);
        if (index < 0 || index >= this.failureDomains.size()) {
            this._visitables.get("failureDomains").add(builder);
            this.failureDomains.add(builder);
        } else {
            this._visitables.get("failureDomains").add(builder);
            this.failureDomains.add(index, builder);
        }
        return (A)this;
    }

    public A setToFailureDomains(int index, FailureDomain item) {
        if (this.failureDomains == null) {
            this.failureDomains = new ArrayList();
        }
        FailureDomainBuilder builder = new FailureDomainBuilder(item);
        if (index < 0 || index >= this.failureDomains.size()) {
            this._visitables.get("failureDomains").add(builder);
            this.failureDomains.add(builder);
        } else {
            this._visitables.get("failureDomains").add(builder);
            this.failureDomains.set(index, builder);
        }
        return (A)this;
    }

    public A addToFailureDomains(FailureDomain ... items) {
        if (this.failureDomains == null) {
            this.failureDomains = new ArrayList();
        }
        for (FailureDomain item : items) {
            FailureDomainBuilder builder = new FailureDomainBuilder(item);
            this._visitables.get("failureDomains").add(builder);
            this.failureDomains.add(builder);
        }
        return (A)this;
    }

    public A addAllToFailureDomains(Collection<FailureDomain> items) {
        if (this.failureDomains == null) {
            this.failureDomains = new ArrayList();
        }
        for (FailureDomain item : items) {
            FailureDomainBuilder builder = new FailureDomainBuilder(item);
            this._visitables.get("failureDomains").add(builder);
            this.failureDomains.add(builder);
        }
        return (A)this;
    }

    public A removeFromFailureDomains(FailureDomain ... items) {
        if (this.failureDomains == null) {
            return (A)this;
        }
        for (FailureDomain item : items) {
            FailureDomainBuilder builder = new FailureDomainBuilder(item);
            this._visitables.get("failureDomains").remove(builder);
            this.failureDomains.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromFailureDomains(Collection<FailureDomain> items) {
        if (this.failureDomains == null) {
            return (A)this;
        }
        for (FailureDomain item : items) {
            FailureDomainBuilder builder = new FailureDomainBuilder(item);
            this._visitables.get("failureDomains").remove(builder);
            this.failureDomains.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromFailureDomains(Predicate<FailureDomainBuilder> predicate) {
        if (this.failureDomains == null) {
            return (A)this;
        }
        Iterator<FailureDomainBuilder> each = this.failureDomains.iterator();
        Object visitables = this._visitables.get("failureDomains");
        while (each.hasNext()) {
            FailureDomainBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<FailureDomain> buildFailureDomains() {
        return this.failureDomains != null ? PlatformFluent.build(this.failureDomains) : null;
    }

    public FailureDomain buildFailureDomain(int index) {
        return this.failureDomains.get(index).build();
    }

    public FailureDomain buildFirstFailureDomain() {
        return this.failureDomains.get(0).build();
    }

    public FailureDomain buildLastFailureDomain() {
        return this.failureDomains.get(this.failureDomains.size() - 1).build();
    }

    public FailureDomain buildMatchingFailureDomain(Predicate<FailureDomainBuilder> predicate) {
        for (FailureDomainBuilder item : this.failureDomains) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingFailureDomain(Predicate<FailureDomainBuilder> predicate) {
        for (FailureDomainBuilder item : this.failureDomains) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withFailureDomains(List<FailureDomain> failureDomains) {
        if (this.failureDomains != null) {
            this._visitables.get("failureDomains").clear();
        }
        if (failureDomains != null) {
            this.failureDomains = new ArrayList();
            for (FailureDomain item : failureDomains) {
                this.addToFailureDomains(item);
            }
        } else {
            this.failureDomains = null;
        }
        return (A)this;
    }

    public A withFailureDomains(FailureDomain ... failureDomains) {
        if (this.failureDomains != null) {
            this.failureDomains.clear();
            this._visitables.remove("failureDomains");
        }
        if (failureDomains != null) {
            for (FailureDomain item : failureDomains) {
                this.addToFailureDomains(item);
            }
        }
        return (A)this;
    }

    public boolean hasFailureDomains() {
        return this.failureDomains != null && !this.failureDomains.isEmpty();
    }

    public FailureDomainsNested<A> addNewFailureDomain() {
        return new FailureDomainsNested(-1, null);
    }

    public FailureDomainsNested<A> addNewFailureDomainLike(FailureDomain item) {
        return new FailureDomainsNested(-1, item);
    }

    public FailureDomainsNested<A> setNewFailureDomainLike(int index, FailureDomain item) {
        return new FailureDomainsNested(index, item);
    }

    public FailureDomainsNested<A> editFailureDomain(int index) {
        if (this.failureDomains.size() <= index) {
            throw new RuntimeException("Can't edit failureDomains. Index exceeds size.");
        }
        return this.setNewFailureDomainLike(index, this.buildFailureDomain(index));
    }

    public FailureDomainsNested<A> editFirstFailureDomain() {
        if (this.failureDomains.size() == 0) {
            throw new RuntimeException("Can't edit first failureDomains. The list is empty.");
        }
        return this.setNewFailureDomainLike(0, this.buildFailureDomain(0));
    }

    public FailureDomainsNested<A> editLastFailureDomain() {
        int index = this.failureDomains.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last failureDomains. The list is empty.");
        }
        return this.setNewFailureDomainLike(index, this.buildFailureDomain(index));
    }

    public FailureDomainsNested<A> editMatchingFailureDomain(Predicate<FailureDomainBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.failureDomains.size(); ++i) {
            if (!predicate.test(this.failureDomains.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching failureDomains. No match found.");
        }
        return this.setNewFailureDomainLike(index, this.buildFailureDomain(index));
    }

    public String getIngressVIP() {
        return this.ingressVIP;
    }

    public A withIngressVIP(String ingressVIP) {
        this.ingressVIP = ingressVIP;
        return (A)this;
    }

    public boolean hasIngressVIP() {
        return this.ingressVIP != null;
    }

    public A addToIngressVIPs(int index, String item) {
        if (this.ingressVIPs == null) {
            this.ingressVIPs = new ArrayList<String>();
        }
        this.ingressVIPs.add(index, item);
        return (A)this;
    }

    public A setToIngressVIPs(int index, String item) {
        if (this.ingressVIPs == null) {
            this.ingressVIPs = new ArrayList<String>();
        }
        this.ingressVIPs.set(index, item);
        return (A)this;
    }

    public A addToIngressVIPs(String ... items) {
        if (this.ingressVIPs == null) {
            this.ingressVIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.ingressVIPs.add(item);
        }
        return (A)this;
    }

    public A addAllToIngressVIPs(Collection<String> items) {
        if (this.ingressVIPs == null) {
            this.ingressVIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.ingressVIPs.add(item);
        }
        return (A)this;
    }

    public A removeFromIngressVIPs(String ... items) {
        if (this.ingressVIPs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.ingressVIPs.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromIngressVIPs(Collection<String> items) {
        if (this.ingressVIPs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.ingressVIPs.remove(item);
        }
        return (A)this;
    }

    public List<String> getIngressVIPs() {
        return this.ingressVIPs;
    }

    public String getIngressVIP(int index) {
        return this.ingressVIPs.get(index);
    }

    public String getFirstIngressVIP() {
        return this.ingressVIPs.get(0);
    }

    public String getLastIngressVIP() {
        return this.ingressVIPs.get(this.ingressVIPs.size() - 1);
    }

    public String getMatchingIngressVIP(Predicate<String> predicate) {
        for (String item : this.ingressVIPs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingIngressVIP(Predicate<String> predicate) {
        for (String item : this.ingressVIPs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withIngressVIPs(List<String> ingressVIPs) {
        if (ingressVIPs != null) {
            this.ingressVIPs = new ArrayList<String>();
            for (String item : ingressVIPs) {
                this.addToIngressVIPs(item);
            }
        } else {
            this.ingressVIPs = null;
        }
        return (A)this;
    }

    public A withIngressVIPs(String ... ingressVIPs) {
        if (this.ingressVIPs != null) {
            this.ingressVIPs.clear();
            this._visitables.remove("ingressVIPs");
        }
        if (ingressVIPs != null) {
            for (String item : ingressVIPs) {
                this.addToIngressVIPs(item);
            }
        }
        return (A)this;
    }

    public boolean hasIngressVIPs() {
        return this.ingressVIPs != null && !this.ingressVIPs.isEmpty();
    }

    public NutanixPlatformLoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public A withLoadBalancer(NutanixPlatformLoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
        return (A)this;
    }

    public boolean hasLoadBalancer() {
        return this.loadBalancer != null;
    }

    public A withNewLoadBalancer(String type) {
        return this.withLoadBalancer(new NutanixPlatformLoadBalancer(type));
    }

    public String getPreloadedOSImageName() {
        return this.preloadedOSImageName;
    }

    public A withPreloadedOSImageName(String preloadedOSImageName) {
        this.preloadedOSImageName = preloadedOSImageName;
        return (A)this;
    }

    public boolean hasPreloadedOSImageName() {
        return this.preloadedOSImageName != null;
    }

    public Integer getPrismAPICallTimeout() {
        return this.prismAPICallTimeout;
    }

    public A withPrismAPICallTimeout(Integer prismAPICallTimeout) {
        this.prismAPICallTimeout = prismAPICallTimeout;
        return (A)this;
    }

    public boolean hasPrismAPICallTimeout() {
        return this.prismAPICallTimeout != null;
    }

    public PrismCentral buildPrismCentral() {
        return this.prismCentral != null ? this.prismCentral.build() : null;
    }

    public A withPrismCentral(PrismCentral prismCentral) {
        this._visitables.remove("prismCentral");
        if (prismCentral != null) {
            this.prismCentral = new PrismCentralBuilder(prismCentral);
            this._visitables.get("prismCentral").add(this.prismCentral);
        } else {
            this.prismCentral = null;
            this._visitables.get("prismCentral").remove(this.prismCentral);
        }
        return (A)this;
    }

    public boolean hasPrismCentral() {
        return this.prismCentral != null;
    }

    public PrismCentralNested<A> withNewPrismCentral() {
        return new PrismCentralNested(null);
    }

    public PrismCentralNested<A> withNewPrismCentralLike(PrismCentral item) {
        return new PrismCentralNested(item);
    }

    public PrismCentralNested<A> editPrismCentral() {
        return this.withNewPrismCentralLike(Optional.ofNullable(this.buildPrismCentral()).orElse(null));
    }

    public PrismCentralNested<A> editOrNewPrismCentral() {
        return this.withNewPrismCentralLike(Optional.ofNullable(this.buildPrismCentral()).orElse(new PrismCentralBuilder().build()));
    }

    public PrismCentralNested<A> editOrNewPrismCentralLike(PrismCentral item) {
        return this.withNewPrismCentralLike(Optional.ofNullable(this.buildPrismCentral()).orElse(item));
    }

    public A addToPrismElements(int index, PrismElement item) {
        if (this.prismElements == null) {
            this.prismElements = new ArrayList();
        }
        PrismElementBuilder builder = new PrismElementBuilder(item);
        if (index < 0 || index >= this.prismElements.size()) {
            this._visitables.get("prismElements").add(builder);
            this.prismElements.add(builder);
        } else {
            this._visitables.get("prismElements").add(builder);
            this.prismElements.add(index, builder);
        }
        return (A)this;
    }

    public A setToPrismElements(int index, PrismElement item) {
        if (this.prismElements == null) {
            this.prismElements = new ArrayList();
        }
        PrismElementBuilder builder = new PrismElementBuilder(item);
        if (index < 0 || index >= this.prismElements.size()) {
            this._visitables.get("prismElements").add(builder);
            this.prismElements.add(builder);
        } else {
            this._visitables.get("prismElements").add(builder);
            this.prismElements.set(index, builder);
        }
        return (A)this;
    }

    public A addToPrismElements(PrismElement ... items) {
        if (this.prismElements == null) {
            this.prismElements = new ArrayList();
        }
        for (PrismElement item : items) {
            PrismElementBuilder builder = new PrismElementBuilder(item);
            this._visitables.get("prismElements").add(builder);
            this.prismElements.add(builder);
        }
        return (A)this;
    }

    public A addAllToPrismElements(Collection<PrismElement> items) {
        if (this.prismElements == null) {
            this.prismElements = new ArrayList();
        }
        for (PrismElement item : items) {
            PrismElementBuilder builder = new PrismElementBuilder(item);
            this._visitables.get("prismElements").add(builder);
            this.prismElements.add(builder);
        }
        return (A)this;
    }

    public A removeFromPrismElements(PrismElement ... items) {
        if (this.prismElements == null) {
            return (A)this;
        }
        for (PrismElement item : items) {
            PrismElementBuilder builder = new PrismElementBuilder(item);
            this._visitables.get("prismElements").remove(builder);
            this.prismElements.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromPrismElements(Collection<PrismElement> items) {
        if (this.prismElements == null) {
            return (A)this;
        }
        for (PrismElement item : items) {
            PrismElementBuilder builder = new PrismElementBuilder(item);
            this._visitables.get("prismElements").remove(builder);
            this.prismElements.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromPrismElements(Predicate<PrismElementBuilder> predicate) {
        if (this.prismElements == null) {
            return (A)this;
        }
        Iterator<PrismElementBuilder> each = this.prismElements.iterator();
        Object visitables = this._visitables.get("prismElements");
        while (each.hasNext()) {
            PrismElementBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<PrismElement> buildPrismElements() {
        return this.prismElements != null ? PlatformFluent.build(this.prismElements) : null;
    }

    public PrismElement buildPrismElement(int index) {
        return this.prismElements.get(index).build();
    }

    public PrismElement buildFirstPrismElement() {
        return this.prismElements.get(0).build();
    }

    public PrismElement buildLastPrismElement() {
        return this.prismElements.get(this.prismElements.size() - 1).build();
    }

    public PrismElement buildMatchingPrismElement(Predicate<PrismElementBuilder> predicate) {
        for (PrismElementBuilder item : this.prismElements) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPrismElement(Predicate<PrismElementBuilder> predicate) {
        for (PrismElementBuilder item : this.prismElements) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPrismElements(List<PrismElement> prismElements) {
        if (this.prismElements != null) {
            this._visitables.get("prismElements").clear();
        }
        if (prismElements != null) {
            this.prismElements = new ArrayList();
            for (PrismElement item : prismElements) {
                this.addToPrismElements(item);
            }
        } else {
            this.prismElements = null;
        }
        return (A)this;
    }

    public A withPrismElements(PrismElement ... prismElements) {
        if (this.prismElements != null) {
            this.prismElements.clear();
            this._visitables.remove("prismElements");
        }
        if (prismElements != null) {
            for (PrismElement item : prismElements) {
                this.addToPrismElements(item);
            }
        }
        return (A)this;
    }

    public boolean hasPrismElements() {
        return this.prismElements != null && !this.prismElements.isEmpty();
    }

    public PrismElementsNested<A> addNewPrismElement() {
        return new PrismElementsNested(-1, null);
    }

    public PrismElementsNested<A> addNewPrismElementLike(PrismElement item) {
        return new PrismElementsNested(-1, item);
    }

    public PrismElementsNested<A> setNewPrismElementLike(int index, PrismElement item) {
        return new PrismElementsNested(index, item);
    }

    public PrismElementsNested<A> editPrismElement(int index) {
        if (this.prismElements.size() <= index) {
            throw new RuntimeException("Can't edit prismElements. Index exceeds size.");
        }
        return this.setNewPrismElementLike(index, this.buildPrismElement(index));
    }

    public PrismElementsNested<A> editFirstPrismElement() {
        if (this.prismElements.size() == 0) {
            throw new RuntimeException("Can't edit first prismElements. The list is empty.");
        }
        return this.setNewPrismElementLike(0, this.buildPrismElement(0));
    }

    public PrismElementsNested<A> editLastPrismElement() {
        int index = this.prismElements.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last prismElements. The list is empty.");
        }
        return this.setNewPrismElementLike(index, this.buildPrismElement(index));
    }

    public PrismElementsNested<A> editMatchingPrismElement(Predicate<PrismElementBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.prismElements.size(); ++i) {
            if (!predicate.test(this.prismElements.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching prismElements. No match found.");
        }
        return this.setNewPrismElementLike(index, this.buildPrismElement(index));
    }

    public A addToSubnetUUIDs(int index, String item) {
        if (this.subnetUUIDs == null) {
            this.subnetUUIDs = new ArrayList<String>();
        }
        this.subnetUUIDs.add(index, item);
        return (A)this;
    }

    public A setToSubnetUUIDs(int index, String item) {
        if (this.subnetUUIDs == null) {
            this.subnetUUIDs = new ArrayList<String>();
        }
        this.subnetUUIDs.set(index, item);
        return (A)this;
    }

    public A addToSubnetUUIDs(String ... items) {
        if (this.subnetUUIDs == null) {
            this.subnetUUIDs = new ArrayList<String>();
        }
        for (String item : items) {
            this.subnetUUIDs.add(item);
        }
        return (A)this;
    }

    public A addAllToSubnetUUIDs(Collection<String> items) {
        if (this.subnetUUIDs == null) {
            this.subnetUUIDs = new ArrayList<String>();
        }
        for (String item : items) {
            this.subnetUUIDs.add(item);
        }
        return (A)this;
    }

    public A removeFromSubnetUUIDs(String ... items) {
        if (this.subnetUUIDs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.subnetUUIDs.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromSubnetUUIDs(Collection<String> items) {
        if (this.subnetUUIDs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.subnetUUIDs.remove(item);
        }
        return (A)this;
    }

    public List<String> getSubnetUUIDs() {
        return this.subnetUUIDs;
    }

    public String getSubnetUUID(int index) {
        return this.subnetUUIDs.get(index);
    }

    public String getFirstSubnetUUID() {
        return this.subnetUUIDs.get(0);
    }

    public String getLastSubnetUUID() {
        return this.subnetUUIDs.get(this.subnetUUIDs.size() - 1);
    }

    public String getMatchingSubnetUUID(Predicate<String> predicate) {
        for (String item : this.subnetUUIDs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingSubnetUUID(Predicate<String> predicate) {
        for (String item : this.subnetUUIDs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSubnetUUIDs(List<String> subnetUUIDs) {
        if (subnetUUIDs != null) {
            this.subnetUUIDs = new ArrayList<String>();
            for (String item : subnetUUIDs) {
                this.addToSubnetUUIDs(item);
            }
        } else {
            this.subnetUUIDs = null;
        }
        return (A)this;
    }

    public A withSubnetUUIDs(String ... subnetUUIDs) {
        if (this.subnetUUIDs != null) {
            this.subnetUUIDs.clear();
            this._visitables.remove("subnetUUIDs");
        }
        if (subnetUUIDs != null) {
            for (String item : subnetUUIDs) {
                this.addToSubnetUUIDs(item);
            }
        }
        return (A)this;
    }

    public boolean hasSubnetUUIDs() {
        return this.subnetUUIDs != null && !this.subnetUUIDs.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PlatformFluent that = (PlatformFluent)o;
        if (!Objects.equals(this.apiVIP, that.apiVIP)) {
            return false;
        }
        if (!Objects.equals(this.apiVIPs, that.apiVIPs)) {
            return false;
        }
        if (!Objects.equals(this.clusterOSImage, that.clusterOSImage)) {
            return false;
        }
        if (!Objects.equals(this.defaultMachinePlatform, that.defaultMachinePlatform)) {
            return false;
        }
        if (!Objects.equals(this.failureDomains, that.failureDomains)) {
            return false;
        }
        if (!Objects.equals(this.ingressVIP, that.ingressVIP)) {
            return false;
        }
        if (!Objects.equals(this.ingressVIPs, that.ingressVIPs)) {
            return false;
        }
        if (!Objects.equals(this.loadBalancer, that.loadBalancer)) {
            return false;
        }
        if (!Objects.equals(this.preloadedOSImageName, that.preloadedOSImageName)) {
            return false;
        }
        if (!Objects.equals(this.prismAPICallTimeout, that.prismAPICallTimeout)) {
            return false;
        }
        if (!Objects.equals(this.prismCentral, that.prismCentral)) {
            return false;
        }
        if (!Objects.equals(this.prismElements, that.prismElements)) {
            return false;
        }
        if (!Objects.equals(this.subnetUUIDs, that.subnetUUIDs)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVIP, this.apiVIPs, this.clusterOSImage, this.defaultMachinePlatform, this.failureDomains, this.ingressVIP, this.ingressVIPs, this.loadBalancer, this.preloadedOSImageName, this.prismAPICallTimeout, this.prismCentral, this.prismElements, this.subnetUUIDs, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVIP != null) {
            sb.append("apiVIP:");
            sb.append(this.apiVIP + ",");
        }
        if (this.apiVIPs != null && !this.apiVIPs.isEmpty()) {
            sb.append("apiVIPs:");
            sb.append(String.valueOf(this.apiVIPs) + ",");
        }
        if (this.clusterOSImage != null) {
            sb.append("clusterOSImage:");
            sb.append(this.clusterOSImage + ",");
        }
        if (this.defaultMachinePlatform != null) {
            sb.append("defaultMachinePlatform:");
            sb.append(String.valueOf(this.defaultMachinePlatform) + ",");
        }
        if (this.failureDomains != null && !this.failureDomains.isEmpty()) {
            sb.append("failureDomains:");
            sb.append(String.valueOf(this.failureDomains) + ",");
        }
        if (this.ingressVIP != null) {
            sb.append("ingressVIP:");
            sb.append(this.ingressVIP + ",");
        }
        if (this.ingressVIPs != null && !this.ingressVIPs.isEmpty()) {
            sb.append("ingressVIPs:");
            sb.append(String.valueOf(this.ingressVIPs) + ",");
        }
        if (this.loadBalancer != null) {
            sb.append("loadBalancer:");
            sb.append(String.valueOf(this.loadBalancer) + ",");
        }
        if (this.preloadedOSImageName != null) {
            sb.append("preloadedOSImageName:");
            sb.append(this.preloadedOSImageName + ",");
        }
        if (this.prismAPICallTimeout != null) {
            sb.append("prismAPICallTimeout:");
            sb.append(this.prismAPICallTimeout + ",");
        }
        if (this.prismCentral != null) {
            sb.append("prismCentral:");
            sb.append(String.valueOf(this.prismCentral) + ",");
        }
        if (this.prismElements != null && !this.prismElements.isEmpty()) {
            sb.append("prismElements:");
            sb.append(String.valueOf(this.prismElements) + ",");
        }
        if (this.subnetUUIDs != null && !this.subnetUUIDs.isEmpty()) {
            sb.append("subnetUUIDs:");
            sb.append(String.valueOf(this.subnetUUIDs) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PrismElementsNested<N>
    extends PrismElementFluent<PrismElementsNested<N>>
    implements Nested<N> {
        PrismElementBuilder builder;
        int index;

        PrismElementsNested(int index, PrismElement item) {
            this.index = index;
            this.builder = new PrismElementBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PlatformFluent.this.setToPrismElements(this.index, this.builder.build());
        }

        public N endPrismElement() {
            return this.and();
        }
    }

    public class PrismCentralNested<N>
    extends PrismCentralFluent<PrismCentralNested<N>>
    implements Nested<N> {
        PrismCentralBuilder builder;

        PrismCentralNested(PrismCentral item) {
            this.builder = new PrismCentralBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PlatformFluent.this.withPrismCentral(this.builder.build());
        }

        public N endPrismCentral() {
            return this.and();
        }
    }

    public class FailureDomainsNested<N>
    extends FailureDomainFluent<FailureDomainsNested<N>>
    implements Nested<N> {
        FailureDomainBuilder builder;
        int index;

        FailureDomainsNested(int index, FailureDomain item) {
            this.index = index;
            this.builder = new FailureDomainBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PlatformFluent.this.setToFailureDomains(this.index, this.builder.build());
        }

        public N endFailureDomain() {
            return this.and();
        }
    }

    public class DefaultMachinePlatformNested<N>
    extends MachinePoolFluent<DefaultMachinePlatformNested<N>>
    implements Nested<N> {
        MachinePoolBuilder builder;

        DefaultMachinePlatformNested(MachinePool item) {
            this.builder = new MachinePoolBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PlatformFluent.this.withDefaultMachinePlatform(this.builder.build());
        }

        public N endDefaultMachinePlatform() {
            return this.and();
        }
    }
}

