/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.azure.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.installer.azure.v1.UserAssignedIdentity;
import io.fabric8.openshift.api.model.installer.azure.v1.UserAssignedIdentityBuilder;
import io.fabric8.openshift.api.model.installer.azure.v1.UserAssignedIdentityFluent;
import io.fabric8.openshift.api.model.installer.azure.v1.VMIdentity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class VMIdentityFluent<A extends VMIdentityFluent<A>>
extends BaseFluent<A> {
    private String type;
    private ArrayList<UserAssignedIdentityBuilder> userAssignedIdentities = new ArrayList();
    private Map<String, Object> additionalProperties;

    public VMIdentityFluent() {
    }

    public VMIdentityFluent(VMIdentity instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(VMIdentity instance) {
        VMIdentity vMIdentity = instance = instance != null ? instance : new VMIdentity();
        if (instance != null) {
            this.withType(instance.getType());
            this.withUserAssignedIdentities(instance.getUserAssignedIdentities());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    public boolean hasType() {
        return this.type != null;
    }

    public A addToUserAssignedIdentities(int index, UserAssignedIdentity item) {
        if (this.userAssignedIdentities == null) {
            this.userAssignedIdentities = new ArrayList();
        }
        UserAssignedIdentityBuilder builder = new UserAssignedIdentityBuilder(item);
        if (index < 0 || index >= this.userAssignedIdentities.size()) {
            this._visitables.get("userAssignedIdentities").add(builder);
            this.userAssignedIdentities.add(builder);
        } else {
            this._visitables.get("userAssignedIdentities").add(builder);
            this.userAssignedIdentities.add(index, builder);
        }
        return (A)this;
    }

    public A setToUserAssignedIdentities(int index, UserAssignedIdentity item) {
        if (this.userAssignedIdentities == null) {
            this.userAssignedIdentities = new ArrayList();
        }
        UserAssignedIdentityBuilder builder = new UserAssignedIdentityBuilder(item);
        if (index < 0 || index >= this.userAssignedIdentities.size()) {
            this._visitables.get("userAssignedIdentities").add(builder);
            this.userAssignedIdentities.add(builder);
        } else {
            this._visitables.get("userAssignedIdentities").add(builder);
            this.userAssignedIdentities.set(index, builder);
        }
        return (A)this;
    }

    public A addToUserAssignedIdentities(UserAssignedIdentity ... items) {
        if (this.userAssignedIdentities == null) {
            this.userAssignedIdentities = new ArrayList();
        }
        for (UserAssignedIdentity item : items) {
            UserAssignedIdentityBuilder builder = new UserAssignedIdentityBuilder(item);
            this._visitables.get("userAssignedIdentities").add(builder);
            this.userAssignedIdentities.add(builder);
        }
        return (A)this;
    }

    public A addAllToUserAssignedIdentities(Collection<UserAssignedIdentity> items) {
        if (this.userAssignedIdentities == null) {
            this.userAssignedIdentities = new ArrayList();
        }
        for (UserAssignedIdentity item : items) {
            UserAssignedIdentityBuilder builder = new UserAssignedIdentityBuilder(item);
            this._visitables.get("userAssignedIdentities").add(builder);
            this.userAssignedIdentities.add(builder);
        }
        return (A)this;
    }

    public A removeFromUserAssignedIdentities(UserAssignedIdentity ... items) {
        if (this.userAssignedIdentities == null) {
            return (A)this;
        }
        for (UserAssignedIdentity item : items) {
            UserAssignedIdentityBuilder builder = new UserAssignedIdentityBuilder(item);
            this._visitables.get("userAssignedIdentities").remove(builder);
            this.userAssignedIdentities.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromUserAssignedIdentities(Collection<UserAssignedIdentity> items) {
        if (this.userAssignedIdentities == null) {
            return (A)this;
        }
        for (UserAssignedIdentity item : items) {
            UserAssignedIdentityBuilder builder = new UserAssignedIdentityBuilder(item);
            this._visitables.get("userAssignedIdentities").remove(builder);
            this.userAssignedIdentities.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromUserAssignedIdentities(Predicate<UserAssignedIdentityBuilder> predicate) {
        if (this.userAssignedIdentities == null) {
            return (A)this;
        }
        Iterator<UserAssignedIdentityBuilder> each = this.userAssignedIdentities.iterator();
        Object visitables = this._visitables.get("userAssignedIdentities");
        while (each.hasNext()) {
            UserAssignedIdentityBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<UserAssignedIdentity> buildUserAssignedIdentities() {
        return this.userAssignedIdentities != null ? VMIdentityFluent.build(this.userAssignedIdentities) : null;
    }

    public UserAssignedIdentity buildUserAssignedIdentity(int index) {
        return this.userAssignedIdentities.get(index).build();
    }

    public UserAssignedIdentity buildFirstUserAssignedIdentity() {
        return this.userAssignedIdentities.get(0).build();
    }

    public UserAssignedIdentity buildLastUserAssignedIdentity() {
        return this.userAssignedIdentities.get(this.userAssignedIdentities.size() - 1).build();
    }

    public UserAssignedIdentity buildMatchingUserAssignedIdentity(Predicate<UserAssignedIdentityBuilder> predicate) {
        for (UserAssignedIdentityBuilder item : this.userAssignedIdentities) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingUserAssignedIdentity(Predicate<UserAssignedIdentityBuilder> predicate) {
        for (UserAssignedIdentityBuilder item : this.userAssignedIdentities) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withUserAssignedIdentities(List<UserAssignedIdentity> userAssignedIdentities) {
        if (this.userAssignedIdentities != null) {
            this._visitables.get("userAssignedIdentities").clear();
        }
        if (userAssignedIdentities != null) {
            this.userAssignedIdentities = new ArrayList();
            for (UserAssignedIdentity item : userAssignedIdentities) {
                this.addToUserAssignedIdentities(item);
            }
        } else {
            this.userAssignedIdentities = null;
        }
        return (A)this;
    }

    public A withUserAssignedIdentities(UserAssignedIdentity ... userAssignedIdentities) {
        if (this.userAssignedIdentities != null) {
            this.userAssignedIdentities.clear();
            this._visitables.remove("userAssignedIdentities");
        }
        if (userAssignedIdentities != null) {
            for (UserAssignedIdentity item : userAssignedIdentities) {
                this.addToUserAssignedIdentities(item);
            }
        }
        return (A)this;
    }

    public boolean hasUserAssignedIdentities() {
        return this.userAssignedIdentities != null && !this.userAssignedIdentities.isEmpty();
    }

    public A addNewUserAssignedIdentity(String name, String resourceGroup, String subscription) {
        return this.addToUserAssignedIdentities(new UserAssignedIdentity(name, resourceGroup, subscription));
    }

    public UserAssignedIdentitiesNested<A> addNewUserAssignedIdentity() {
        return new UserAssignedIdentitiesNested(-1, null);
    }

    public UserAssignedIdentitiesNested<A> addNewUserAssignedIdentityLike(UserAssignedIdentity item) {
        return new UserAssignedIdentitiesNested(-1, item);
    }

    public UserAssignedIdentitiesNested<A> setNewUserAssignedIdentityLike(int index, UserAssignedIdentity item) {
        return new UserAssignedIdentitiesNested(index, item);
    }

    public UserAssignedIdentitiesNested<A> editUserAssignedIdentity(int index) {
        if (this.userAssignedIdentities.size() <= index) {
            throw new RuntimeException("Can't edit userAssignedIdentities. Index exceeds size.");
        }
        return this.setNewUserAssignedIdentityLike(index, this.buildUserAssignedIdentity(index));
    }

    public UserAssignedIdentitiesNested<A> editFirstUserAssignedIdentity() {
        if (this.userAssignedIdentities.size() == 0) {
            throw new RuntimeException("Can't edit first userAssignedIdentities. The list is empty.");
        }
        return this.setNewUserAssignedIdentityLike(0, this.buildUserAssignedIdentity(0));
    }

    public UserAssignedIdentitiesNested<A> editLastUserAssignedIdentity() {
        int index = this.userAssignedIdentities.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last userAssignedIdentities. The list is empty.");
        }
        return this.setNewUserAssignedIdentityLike(index, this.buildUserAssignedIdentity(index));
    }

    public UserAssignedIdentitiesNested<A> editMatchingUserAssignedIdentity(Predicate<UserAssignedIdentityBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.userAssignedIdentities.size(); ++i) {
            if (!predicate.test(this.userAssignedIdentities.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching userAssignedIdentities. No match found.");
        }
        return this.setNewUserAssignedIdentityLike(index, this.buildUserAssignedIdentity(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VMIdentityFluent that = (VMIdentityFluent)o;
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        if (!Objects.equals(this.userAssignedIdentities, that.userAssignedIdentities)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type, this.userAssignedIdentities, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type + ",");
        }
        if (this.userAssignedIdentities != null && !this.userAssignedIdentities.isEmpty()) {
            sb.append("userAssignedIdentities:");
            sb.append(String.valueOf(this.userAssignedIdentities) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class UserAssignedIdentitiesNested<N>
    extends UserAssignedIdentityFluent<UserAssignedIdentitiesNested<N>>
    implements Nested<N> {
        UserAssignedIdentityBuilder builder;
        int index;

        UserAssignedIdentitiesNested(int index, UserAssignedIdentity item) {
            this.index = index;
            this.builder = new UserAssignedIdentityBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)VMIdentityFluent.this.setToUserAssignedIdentities(this.index, this.builder.build());
        }

        public N endUserAssignedIdentity() {
            return this.and();
        }
    }
}

