/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.PowerVSPlatformStatus;
import io.fabric8.openshift.api.model.config.v1.PowerVSServiceEndpoint;
import io.fabric8.openshift.api.model.config.v1.PowerVSServiceEndpointBuilder;
import io.fabric8.openshift.api.model.config.v1.PowerVSServiceEndpointFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class PowerVSPlatformStatusFluent<A extends PowerVSPlatformStatusFluent<A>>
extends BaseFluent<A> {
    private String cisInstanceCRN;
    private String dnsInstanceCRN;
    private String region;
    private String resourceGroup;
    private ArrayList<PowerVSServiceEndpointBuilder> serviceEndpoints = new ArrayList();
    private String zone;
    private Map<String, Object> additionalProperties;

    public PowerVSPlatformStatusFluent() {
    }

    public PowerVSPlatformStatusFluent(PowerVSPlatformStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PowerVSPlatformStatus instance) {
        PowerVSPlatformStatus powerVSPlatformStatus = instance = instance != null ? instance : new PowerVSPlatformStatus();
        if (instance != null) {
            this.withCisInstanceCRN(instance.getCisInstanceCRN());
            this.withDnsInstanceCRN(instance.getDnsInstanceCRN());
            this.withRegion(instance.getRegion());
            this.withResourceGroup(instance.getResourceGroup());
            this.withServiceEndpoints(instance.getServiceEndpoints());
            this.withZone(instance.getZone());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getCisInstanceCRN() {
        return this.cisInstanceCRN;
    }

    public A withCisInstanceCRN(String cisInstanceCRN) {
        this.cisInstanceCRN = cisInstanceCRN;
        return (A)this;
    }

    public boolean hasCisInstanceCRN() {
        return this.cisInstanceCRN != null;
    }

    public String getDnsInstanceCRN() {
        return this.dnsInstanceCRN;
    }

    public A withDnsInstanceCRN(String dnsInstanceCRN) {
        this.dnsInstanceCRN = dnsInstanceCRN;
        return (A)this;
    }

    public boolean hasDnsInstanceCRN() {
        return this.dnsInstanceCRN != null;
    }

    public String getRegion() {
        return this.region;
    }

    public A withRegion(String region) {
        this.region = region;
        return (A)this;
    }

    public boolean hasRegion() {
        return this.region != null;
    }

    public String getResourceGroup() {
        return this.resourceGroup;
    }

    public A withResourceGroup(String resourceGroup) {
        this.resourceGroup = resourceGroup;
        return (A)this;
    }

    public boolean hasResourceGroup() {
        return this.resourceGroup != null;
    }

    public A addToServiceEndpoints(int index, PowerVSServiceEndpoint item) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList();
        }
        PowerVSServiceEndpointBuilder builder = new PowerVSServiceEndpointBuilder(item);
        if (index < 0 || index >= this.serviceEndpoints.size()) {
            this._visitables.get("serviceEndpoints").add(builder);
            this.serviceEndpoints.add(builder);
        } else {
            this._visitables.get("serviceEndpoints").add(builder);
            this.serviceEndpoints.add(index, builder);
        }
        return (A)this;
    }

    public A setToServiceEndpoints(int index, PowerVSServiceEndpoint item) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList();
        }
        PowerVSServiceEndpointBuilder builder = new PowerVSServiceEndpointBuilder(item);
        if (index < 0 || index >= this.serviceEndpoints.size()) {
            this._visitables.get("serviceEndpoints").add(builder);
            this.serviceEndpoints.add(builder);
        } else {
            this._visitables.get("serviceEndpoints").add(builder);
            this.serviceEndpoints.set(index, builder);
        }
        return (A)this;
    }

    public A addToServiceEndpoints(PowerVSServiceEndpoint ... items) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList();
        }
        for (PowerVSServiceEndpoint item : items) {
            PowerVSServiceEndpointBuilder builder = new PowerVSServiceEndpointBuilder(item);
            this._visitables.get("serviceEndpoints").add(builder);
            this.serviceEndpoints.add(builder);
        }
        return (A)this;
    }

    public A addAllToServiceEndpoints(Collection<PowerVSServiceEndpoint> items) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList();
        }
        for (PowerVSServiceEndpoint item : items) {
            PowerVSServiceEndpointBuilder builder = new PowerVSServiceEndpointBuilder(item);
            this._visitables.get("serviceEndpoints").add(builder);
            this.serviceEndpoints.add(builder);
        }
        return (A)this;
    }

    public A removeFromServiceEndpoints(PowerVSServiceEndpoint ... items) {
        if (this.serviceEndpoints == null) {
            return (A)this;
        }
        for (PowerVSServiceEndpoint item : items) {
            PowerVSServiceEndpointBuilder builder = new PowerVSServiceEndpointBuilder(item);
            this._visitables.get("serviceEndpoints").remove(builder);
            this.serviceEndpoints.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromServiceEndpoints(Collection<PowerVSServiceEndpoint> items) {
        if (this.serviceEndpoints == null) {
            return (A)this;
        }
        for (PowerVSServiceEndpoint item : items) {
            PowerVSServiceEndpointBuilder builder = new PowerVSServiceEndpointBuilder(item);
            this._visitables.get("serviceEndpoints").remove(builder);
            this.serviceEndpoints.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromServiceEndpoints(Predicate<PowerVSServiceEndpointBuilder> predicate) {
        if (this.serviceEndpoints == null) {
            return (A)this;
        }
        Iterator<PowerVSServiceEndpointBuilder> each = this.serviceEndpoints.iterator();
        Object visitables = this._visitables.get("serviceEndpoints");
        while (each.hasNext()) {
            PowerVSServiceEndpointBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<PowerVSServiceEndpoint> buildServiceEndpoints() {
        return this.serviceEndpoints != null ? PowerVSPlatformStatusFluent.build(this.serviceEndpoints) : null;
    }

    public PowerVSServiceEndpoint buildServiceEndpoint(int index) {
        return this.serviceEndpoints.get(index).build();
    }

    public PowerVSServiceEndpoint buildFirstServiceEndpoint() {
        return this.serviceEndpoints.get(0).build();
    }

    public PowerVSServiceEndpoint buildLastServiceEndpoint() {
        return this.serviceEndpoints.get(this.serviceEndpoints.size() - 1).build();
    }

    public PowerVSServiceEndpoint buildMatchingServiceEndpoint(Predicate<PowerVSServiceEndpointBuilder> predicate) {
        for (PowerVSServiceEndpointBuilder item : this.serviceEndpoints) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingServiceEndpoint(Predicate<PowerVSServiceEndpointBuilder> predicate) {
        for (PowerVSServiceEndpointBuilder item : this.serviceEndpoints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withServiceEndpoints(List<PowerVSServiceEndpoint> serviceEndpoints) {
        if (this.serviceEndpoints != null) {
            this._visitables.get("serviceEndpoints").clear();
        }
        if (serviceEndpoints != null) {
            this.serviceEndpoints = new ArrayList();
            for (PowerVSServiceEndpoint item : serviceEndpoints) {
                this.addToServiceEndpoints(item);
            }
        } else {
            this.serviceEndpoints = null;
        }
        return (A)this;
    }

    public A withServiceEndpoints(PowerVSServiceEndpoint ... serviceEndpoints) {
        if (this.serviceEndpoints != null) {
            this.serviceEndpoints.clear();
            this._visitables.remove("serviceEndpoints");
        }
        if (serviceEndpoints != null) {
            for (PowerVSServiceEndpoint item : serviceEndpoints) {
                this.addToServiceEndpoints(item);
            }
        }
        return (A)this;
    }

    public boolean hasServiceEndpoints() {
        return this.serviceEndpoints != null && !this.serviceEndpoints.isEmpty();
    }

    public A addNewServiceEndpoint(String name, String url) {
        return this.addToServiceEndpoints(new PowerVSServiceEndpoint(name, url));
    }

    public ServiceEndpointsNested<A> addNewServiceEndpoint() {
        return new ServiceEndpointsNested(-1, null);
    }

    public ServiceEndpointsNested<A> addNewServiceEndpointLike(PowerVSServiceEndpoint item) {
        return new ServiceEndpointsNested(-1, item);
    }

    public ServiceEndpointsNested<A> setNewServiceEndpointLike(int index, PowerVSServiceEndpoint item) {
        return new ServiceEndpointsNested(index, item);
    }

    public ServiceEndpointsNested<A> editServiceEndpoint(int index) {
        if (this.serviceEndpoints.size() <= index) {
            throw new RuntimeException("Can't edit serviceEndpoints. Index exceeds size.");
        }
        return this.setNewServiceEndpointLike(index, this.buildServiceEndpoint(index));
    }

    public ServiceEndpointsNested<A> editFirstServiceEndpoint() {
        if (this.serviceEndpoints.size() == 0) {
            throw new RuntimeException("Can't edit first serviceEndpoints. The list is empty.");
        }
        return this.setNewServiceEndpointLike(0, this.buildServiceEndpoint(0));
    }

    public ServiceEndpointsNested<A> editLastServiceEndpoint() {
        int index = this.serviceEndpoints.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last serviceEndpoints. The list is empty.");
        }
        return this.setNewServiceEndpointLike(index, this.buildServiceEndpoint(index));
    }

    public ServiceEndpointsNested<A> editMatchingServiceEndpoint(Predicate<PowerVSServiceEndpointBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.serviceEndpoints.size(); ++i) {
            if (!predicate.test(this.serviceEndpoints.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching serviceEndpoints. No match found.");
        }
        return this.setNewServiceEndpointLike(index, this.buildServiceEndpoint(index));
    }

    public String getZone() {
        return this.zone;
    }

    public A withZone(String zone) {
        this.zone = zone;
        return (A)this;
    }

    public boolean hasZone() {
        return this.zone != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PowerVSPlatformStatusFluent that = (PowerVSPlatformStatusFluent)o;
        if (!Objects.equals(this.cisInstanceCRN, that.cisInstanceCRN)) {
            return false;
        }
        if (!Objects.equals(this.dnsInstanceCRN, that.dnsInstanceCRN)) {
            return false;
        }
        if (!Objects.equals(this.region, that.region)) {
            return false;
        }
        if (!Objects.equals(this.resourceGroup, that.resourceGroup)) {
            return false;
        }
        if (!Objects.equals(this.serviceEndpoints, that.serviceEndpoints)) {
            return false;
        }
        if (!Objects.equals(this.zone, that.zone)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.cisInstanceCRN, this.dnsInstanceCRN, this.region, this.resourceGroup, this.serviceEndpoints, this.zone, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cisInstanceCRN != null) {
            sb.append("cisInstanceCRN:");
            sb.append(this.cisInstanceCRN + ",");
        }
        if (this.dnsInstanceCRN != null) {
            sb.append("dnsInstanceCRN:");
            sb.append(this.dnsInstanceCRN + ",");
        }
        if (this.region != null) {
            sb.append("region:");
            sb.append(this.region + ",");
        }
        if (this.resourceGroup != null) {
            sb.append("resourceGroup:");
            sb.append(this.resourceGroup + ",");
        }
        if (this.serviceEndpoints != null && !this.serviceEndpoints.isEmpty()) {
            sb.append("serviceEndpoints:");
            sb.append(String.valueOf(this.serviceEndpoints) + ",");
        }
        if (this.zone != null) {
            sb.append("zone:");
            sb.append(this.zone + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ServiceEndpointsNested<N>
    extends PowerVSServiceEndpointFluent<ServiceEndpointsNested<N>>
    implements Nested<N> {
        PowerVSServiceEndpointBuilder builder;
        int index;

        ServiceEndpointsNested(int index, PowerVSServiceEndpoint item) {
            this.index = index;
            this.builder = new PowerVSServiceEndpointBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PowerVSPlatformStatusFluent.this.setToServiceEndpoints(this.index, this.builder.build());
        }

        public N endServiceEndpoint() {
            return this.and();
        }
    }
}

