/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.NutanixFailureDomain;
import io.fabric8.openshift.api.model.config.v1.NutanixResourceIdentifier;
import io.fabric8.openshift.api.model.config.v1.NutanixResourceIdentifierBuilder;
import io.fabric8.openshift.api.model.config.v1.NutanixResourceIdentifierFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class NutanixFailureDomainFluent<A extends NutanixFailureDomainFluent<A>>
extends BaseFluent<A> {
    private NutanixResourceIdentifierBuilder cluster;
    private String name;
    private ArrayList<NutanixResourceIdentifierBuilder> subnets = new ArrayList();
    private Map<String, Object> additionalProperties;

    public NutanixFailureDomainFluent() {
    }

    public NutanixFailureDomainFluent(NutanixFailureDomain instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NutanixFailureDomain instance) {
        NutanixFailureDomain nutanixFailureDomain = instance = instance != null ? instance : new NutanixFailureDomain();
        if (instance != null) {
            this.withCluster(instance.getCluster());
            this.withName(instance.getName());
            this.withSubnets(instance.getSubnets());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public NutanixResourceIdentifier buildCluster() {
        return this.cluster != null ? this.cluster.build() : null;
    }

    public A withCluster(NutanixResourceIdentifier cluster) {
        this._visitables.remove("cluster");
        if (cluster != null) {
            this.cluster = new NutanixResourceIdentifierBuilder(cluster);
            this._visitables.get("cluster").add(this.cluster);
        } else {
            this.cluster = null;
            this._visitables.get("cluster").remove(this.cluster);
        }
        return (A)this;
    }

    public boolean hasCluster() {
        return this.cluster != null;
    }

    public A withNewCluster(String name, String type, String uuid) {
        return this.withCluster(new NutanixResourceIdentifier(name, type, uuid));
    }

    public ClusterNested<A> withNewCluster() {
        return new ClusterNested(null);
    }

    public ClusterNested<A> withNewClusterLike(NutanixResourceIdentifier item) {
        return new ClusterNested(item);
    }

    public ClusterNested<A> editCluster() {
        return this.withNewClusterLike(Optional.ofNullable(this.buildCluster()).orElse(null));
    }

    public ClusterNested<A> editOrNewCluster() {
        return this.withNewClusterLike(Optional.ofNullable(this.buildCluster()).orElse(new NutanixResourceIdentifierBuilder().build()));
    }

    public ClusterNested<A> editOrNewClusterLike(NutanixResourceIdentifier item) {
        return this.withNewClusterLike(Optional.ofNullable(this.buildCluster()).orElse(item));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public A addToSubnets(int index, NutanixResourceIdentifier item) {
        if (this.subnets == null) {
            this.subnets = new ArrayList();
        }
        NutanixResourceIdentifierBuilder builder = new NutanixResourceIdentifierBuilder(item);
        if (index < 0 || index >= this.subnets.size()) {
            this._visitables.get("subnets").add(builder);
            this.subnets.add(builder);
        } else {
            this._visitables.get("subnets").add(builder);
            this.subnets.add(index, builder);
        }
        return (A)this;
    }

    public A setToSubnets(int index, NutanixResourceIdentifier item) {
        if (this.subnets == null) {
            this.subnets = new ArrayList();
        }
        NutanixResourceIdentifierBuilder builder = new NutanixResourceIdentifierBuilder(item);
        if (index < 0 || index >= this.subnets.size()) {
            this._visitables.get("subnets").add(builder);
            this.subnets.add(builder);
        } else {
            this._visitables.get("subnets").add(builder);
            this.subnets.set(index, builder);
        }
        return (A)this;
    }

    public A addToSubnets(NutanixResourceIdentifier ... items) {
        if (this.subnets == null) {
            this.subnets = new ArrayList();
        }
        for (NutanixResourceIdentifier item : items) {
            NutanixResourceIdentifierBuilder builder = new NutanixResourceIdentifierBuilder(item);
            this._visitables.get("subnets").add(builder);
            this.subnets.add(builder);
        }
        return (A)this;
    }

    public A addAllToSubnets(Collection<NutanixResourceIdentifier> items) {
        if (this.subnets == null) {
            this.subnets = new ArrayList();
        }
        for (NutanixResourceIdentifier item : items) {
            NutanixResourceIdentifierBuilder builder = new NutanixResourceIdentifierBuilder(item);
            this._visitables.get("subnets").add(builder);
            this.subnets.add(builder);
        }
        return (A)this;
    }

    public A removeFromSubnets(NutanixResourceIdentifier ... items) {
        if (this.subnets == null) {
            return (A)this;
        }
        for (NutanixResourceIdentifier item : items) {
            NutanixResourceIdentifierBuilder builder = new NutanixResourceIdentifierBuilder(item);
            this._visitables.get("subnets").remove(builder);
            this.subnets.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromSubnets(Collection<NutanixResourceIdentifier> items) {
        if (this.subnets == null) {
            return (A)this;
        }
        for (NutanixResourceIdentifier item : items) {
            NutanixResourceIdentifierBuilder builder = new NutanixResourceIdentifierBuilder(item);
            this._visitables.get("subnets").remove(builder);
            this.subnets.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromSubnets(Predicate<NutanixResourceIdentifierBuilder> predicate) {
        if (this.subnets == null) {
            return (A)this;
        }
        Iterator<NutanixResourceIdentifierBuilder> each = this.subnets.iterator();
        Object visitables = this._visitables.get("subnets");
        while (each.hasNext()) {
            NutanixResourceIdentifierBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<NutanixResourceIdentifier> buildSubnets() {
        return this.subnets != null ? NutanixFailureDomainFluent.build(this.subnets) : null;
    }

    public NutanixResourceIdentifier buildSubnet(int index) {
        return this.subnets.get(index).build();
    }

    public NutanixResourceIdentifier buildFirstSubnet() {
        return this.subnets.get(0).build();
    }

    public NutanixResourceIdentifier buildLastSubnet() {
        return this.subnets.get(this.subnets.size() - 1).build();
    }

    public NutanixResourceIdentifier buildMatchingSubnet(Predicate<NutanixResourceIdentifierBuilder> predicate) {
        for (NutanixResourceIdentifierBuilder item : this.subnets) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSubnet(Predicate<NutanixResourceIdentifierBuilder> predicate) {
        for (NutanixResourceIdentifierBuilder item : this.subnets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSubnets(List<NutanixResourceIdentifier> subnets) {
        if (this.subnets != null) {
            this._visitables.get("subnets").clear();
        }
        if (subnets != null) {
            this.subnets = new ArrayList();
            for (NutanixResourceIdentifier item : subnets) {
                this.addToSubnets(item);
            }
        } else {
            this.subnets = null;
        }
        return (A)this;
    }

    public A withSubnets(NutanixResourceIdentifier ... subnets) {
        if (this.subnets != null) {
            this.subnets.clear();
            this._visitables.remove("subnets");
        }
        if (subnets != null) {
            for (NutanixResourceIdentifier item : subnets) {
                this.addToSubnets(item);
            }
        }
        return (A)this;
    }

    public boolean hasSubnets() {
        return this.subnets != null && !this.subnets.isEmpty();
    }

    public A addNewSubnet(String name, String type, String uuid) {
        return this.addToSubnets(new NutanixResourceIdentifier(name, type, uuid));
    }

    public SubnetsNested<A> addNewSubnet() {
        return new SubnetsNested(-1, null);
    }

    public SubnetsNested<A> addNewSubnetLike(NutanixResourceIdentifier item) {
        return new SubnetsNested(-1, item);
    }

    public SubnetsNested<A> setNewSubnetLike(int index, NutanixResourceIdentifier item) {
        return new SubnetsNested(index, item);
    }

    public SubnetsNested<A> editSubnet(int index) {
        if (this.subnets.size() <= index) {
            throw new RuntimeException("Can't edit subnets. Index exceeds size.");
        }
        return this.setNewSubnetLike(index, this.buildSubnet(index));
    }

    public SubnetsNested<A> editFirstSubnet() {
        if (this.subnets.size() == 0) {
            throw new RuntimeException("Can't edit first subnets. The list is empty.");
        }
        return this.setNewSubnetLike(0, this.buildSubnet(0));
    }

    public SubnetsNested<A> editLastSubnet() {
        int index = this.subnets.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last subnets. The list is empty.");
        }
        return this.setNewSubnetLike(index, this.buildSubnet(index));
    }

    public SubnetsNested<A> editMatchingSubnet(Predicate<NutanixResourceIdentifierBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.subnets.size(); ++i) {
            if (!predicate.test(this.subnets.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching subnets. No match found.");
        }
        return this.setNewSubnetLike(index, this.buildSubnet(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NutanixFailureDomainFluent that = (NutanixFailureDomainFluent)o;
        if (!Objects.equals(this.cluster, that.cluster)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.subnets, that.subnets)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.cluster, this.name, this.subnets, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cluster != null) {
            sb.append("cluster:");
            sb.append(String.valueOf(this.cluster) + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.subnets != null && !this.subnets.isEmpty()) {
            sb.append("subnets:");
            sb.append(String.valueOf(this.subnets) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SubnetsNested<N>
    extends NutanixResourceIdentifierFluent<SubnetsNested<N>>
    implements Nested<N> {
        NutanixResourceIdentifierBuilder builder;
        int index;

        SubnetsNested(int index, NutanixResourceIdentifier item) {
            this.index = index;
            this.builder = new NutanixResourceIdentifierBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NutanixFailureDomainFluent.this.setToSubnets(this.index, this.builder.build());
        }

        public N endSubnet() {
            return this.and();
        }
    }

    public class ClusterNested<N>
    extends NutanixResourceIdentifierFluent<ClusterNested<N>>
    implements Nested<N> {
        NutanixResourceIdentifierBuilder builder;

        ClusterNested(NutanixResourceIdentifier item) {
            this.builder = new NutanixResourceIdentifierBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NutanixFailureDomainFluent.this.withCluster(this.builder.build());
        }

        public N endCluster() {
            return this.and();
        }
    }
}

