/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.APIServerEncryption;
import io.fabric8.openshift.api.model.config.v1.KMSConfig;
import io.fabric8.openshift.api.model.config.v1.KMSConfigBuilder;
import io.fabric8.openshift.api.model.config.v1.KMSConfigFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class APIServerEncryptionFluent<A extends APIServerEncryptionFluent<A>>
extends BaseFluent<A> {
    private KMSConfigBuilder kms;
    private String type;
    private Map<String, Object> additionalProperties;

    public APIServerEncryptionFluent() {
    }

    public APIServerEncryptionFluent(APIServerEncryption instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(APIServerEncryption instance) {
        APIServerEncryption aPIServerEncryption = instance = instance != null ? instance : new APIServerEncryption();
        if (instance != null) {
            this.withKms(instance.getKms());
            this.withType(instance.getType());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public KMSConfig buildKms() {
        return this.kms != null ? this.kms.build() : null;
    }

    public A withKms(KMSConfig kms) {
        this._visitables.remove("kms");
        if (kms != null) {
            this.kms = new KMSConfigBuilder(kms);
            this._visitables.get("kms").add(this.kms);
        } else {
            this.kms = null;
            this._visitables.get("kms").remove(this.kms);
        }
        return (A)this;
    }

    public boolean hasKms() {
        return this.kms != null;
    }

    public KmsNested<A> withNewKms() {
        return new KmsNested(null);
    }

    public KmsNested<A> withNewKmsLike(KMSConfig item) {
        return new KmsNested(item);
    }

    public KmsNested<A> editKms() {
        return this.withNewKmsLike(Optional.ofNullable(this.buildKms()).orElse(null));
    }

    public KmsNested<A> editOrNewKms() {
        return this.withNewKmsLike(Optional.ofNullable(this.buildKms()).orElse(new KMSConfigBuilder().build()));
    }

    public KmsNested<A> editOrNewKmsLike(KMSConfig item) {
        return this.withNewKmsLike(Optional.ofNullable(this.buildKms()).orElse(item));
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    public boolean hasType() {
        return this.type != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        APIServerEncryptionFluent that = (APIServerEncryptionFluent)o;
        if (!Objects.equals(this.kms, that.kms)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.kms, this.type, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.kms != null) {
            sb.append("kms:");
            sb.append(String.valueOf(this.kms) + ",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class KmsNested<N>
    extends KMSConfigFluent<KmsNested<N>>
    implements Nested<N> {
        KMSConfigBuilder builder;

        KmsNested(KMSConfig item) {
            this.builder = new KMSConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)APIServerEncryptionFluent.this.withKms(this.builder.build());
        }

        public N endKms() {
            return this.and();
        }
    }
}

