/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.ServiceAccountReference;
import io.fabric8.openshift.api.model.ServiceAccountReferenceBuilder;
import io.fabric8.openshift.api.model.ServiceAccountReferenceFluent;
import io.fabric8.openshift.api.model.ServiceAccountRestriction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ServiceAccountRestrictionFluent<A extends ServiceAccountRestrictionFluent<A>>
extends BaseFluent<A> {
    private List<String> namespaces = new ArrayList<String>();
    private ArrayList<ServiceAccountReferenceBuilder> serviceaccounts = new ArrayList();
    private Map<String, Object> additionalProperties;

    public ServiceAccountRestrictionFluent() {
    }

    public ServiceAccountRestrictionFluent(ServiceAccountRestriction instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ServiceAccountRestriction instance) {
        ServiceAccountRestriction serviceAccountRestriction = instance = instance != null ? instance : new ServiceAccountRestriction();
        if (instance != null) {
            this.withNamespaces(instance.getNamespaces());
            this.withServiceaccounts(instance.getServiceaccounts());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToNamespaces(int index, String item) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        this.namespaces.add(index, item);
        return (A)this;
    }

    public A setToNamespaces(int index, String item) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        this.namespaces.set(index, item);
        return (A)this;
    }

    public A addToNamespaces(String ... items) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        for (String item : items) {
            this.namespaces.add(item);
        }
        return (A)this;
    }

    public A addAllToNamespaces(Collection<String> items) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        for (String item : items) {
            this.namespaces.add(item);
        }
        return (A)this;
    }

    public A removeFromNamespaces(String ... items) {
        if (this.namespaces == null) {
            return (A)this;
        }
        for (String item : items) {
            this.namespaces.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromNamespaces(Collection<String> items) {
        if (this.namespaces == null) {
            return (A)this;
        }
        for (String item : items) {
            this.namespaces.remove(item);
        }
        return (A)this;
    }

    public List<String> getNamespaces() {
        return this.namespaces;
    }

    public String getNamespace(int index) {
        return this.namespaces.get(index);
    }

    public String getFirstNamespace() {
        return this.namespaces.get(0);
    }

    public String getLastNamespace() {
        return this.namespaces.get(this.namespaces.size() - 1);
    }

    public String getMatchingNamespace(Predicate<String> predicate) {
        for (String item : this.namespaces) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingNamespace(Predicate<String> predicate) {
        for (String item : this.namespaces) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withNamespaces(List<String> namespaces) {
        if (namespaces != null) {
            this.namespaces = new ArrayList<String>();
            for (String item : namespaces) {
                this.addToNamespaces(item);
            }
        } else {
            this.namespaces = null;
        }
        return (A)this;
    }

    public A withNamespaces(String ... namespaces) {
        if (this.namespaces != null) {
            this.namespaces.clear();
            this._visitables.remove("namespaces");
        }
        if (namespaces != null) {
            for (String item : namespaces) {
                this.addToNamespaces(item);
            }
        }
        return (A)this;
    }

    public boolean hasNamespaces() {
        return this.namespaces != null && !this.namespaces.isEmpty();
    }

    public A addToServiceaccounts(int index, ServiceAccountReference item) {
        if (this.serviceaccounts == null) {
            this.serviceaccounts = new ArrayList();
        }
        ServiceAccountReferenceBuilder builder = new ServiceAccountReferenceBuilder(item);
        if (index < 0 || index >= this.serviceaccounts.size()) {
            this._visitables.get("serviceaccounts").add(builder);
            this.serviceaccounts.add(builder);
        } else {
            this._visitables.get("serviceaccounts").add(builder);
            this.serviceaccounts.add(index, builder);
        }
        return (A)this;
    }

    public A setToServiceaccounts(int index, ServiceAccountReference item) {
        if (this.serviceaccounts == null) {
            this.serviceaccounts = new ArrayList();
        }
        ServiceAccountReferenceBuilder builder = new ServiceAccountReferenceBuilder(item);
        if (index < 0 || index >= this.serviceaccounts.size()) {
            this._visitables.get("serviceaccounts").add(builder);
            this.serviceaccounts.add(builder);
        } else {
            this._visitables.get("serviceaccounts").add(builder);
            this.serviceaccounts.set(index, builder);
        }
        return (A)this;
    }

    public A addToServiceaccounts(ServiceAccountReference ... items) {
        if (this.serviceaccounts == null) {
            this.serviceaccounts = new ArrayList();
        }
        for (ServiceAccountReference item : items) {
            ServiceAccountReferenceBuilder builder = new ServiceAccountReferenceBuilder(item);
            this._visitables.get("serviceaccounts").add(builder);
            this.serviceaccounts.add(builder);
        }
        return (A)this;
    }

    public A addAllToServiceaccounts(Collection<ServiceAccountReference> items) {
        if (this.serviceaccounts == null) {
            this.serviceaccounts = new ArrayList();
        }
        for (ServiceAccountReference item : items) {
            ServiceAccountReferenceBuilder builder = new ServiceAccountReferenceBuilder(item);
            this._visitables.get("serviceaccounts").add(builder);
            this.serviceaccounts.add(builder);
        }
        return (A)this;
    }

    public A removeFromServiceaccounts(ServiceAccountReference ... items) {
        if (this.serviceaccounts == null) {
            return (A)this;
        }
        for (ServiceAccountReference item : items) {
            ServiceAccountReferenceBuilder builder = new ServiceAccountReferenceBuilder(item);
            this._visitables.get("serviceaccounts").remove(builder);
            this.serviceaccounts.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromServiceaccounts(Collection<ServiceAccountReference> items) {
        if (this.serviceaccounts == null) {
            return (A)this;
        }
        for (ServiceAccountReference item : items) {
            ServiceAccountReferenceBuilder builder = new ServiceAccountReferenceBuilder(item);
            this._visitables.get("serviceaccounts").remove(builder);
            this.serviceaccounts.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromServiceaccounts(Predicate<ServiceAccountReferenceBuilder> predicate) {
        if (this.serviceaccounts == null) {
            return (A)this;
        }
        Iterator<ServiceAccountReferenceBuilder> each = this.serviceaccounts.iterator();
        Object visitables = this._visitables.get("serviceaccounts");
        while (each.hasNext()) {
            ServiceAccountReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<ServiceAccountReference> buildServiceaccounts() {
        return this.serviceaccounts != null ? ServiceAccountRestrictionFluent.build(this.serviceaccounts) : null;
    }

    public ServiceAccountReference buildServiceaccount(int index) {
        return this.serviceaccounts.get(index).build();
    }

    public ServiceAccountReference buildFirstServiceaccount() {
        return this.serviceaccounts.get(0).build();
    }

    public ServiceAccountReference buildLastServiceaccount() {
        return this.serviceaccounts.get(this.serviceaccounts.size() - 1).build();
    }

    public ServiceAccountReference buildMatchingServiceaccount(Predicate<ServiceAccountReferenceBuilder> predicate) {
        for (ServiceAccountReferenceBuilder item : this.serviceaccounts) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingServiceaccount(Predicate<ServiceAccountReferenceBuilder> predicate) {
        for (ServiceAccountReferenceBuilder item : this.serviceaccounts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withServiceaccounts(List<ServiceAccountReference> serviceaccounts) {
        if (this.serviceaccounts != null) {
            this._visitables.get("serviceaccounts").clear();
        }
        if (serviceaccounts != null) {
            this.serviceaccounts = new ArrayList();
            for (ServiceAccountReference item : serviceaccounts) {
                this.addToServiceaccounts(item);
            }
        } else {
            this.serviceaccounts = null;
        }
        return (A)this;
    }

    public A withServiceaccounts(ServiceAccountReference ... serviceaccounts) {
        if (this.serviceaccounts != null) {
            this.serviceaccounts.clear();
            this._visitables.remove("serviceaccounts");
        }
        if (serviceaccounts != null) {
            for (ServiceAccountReference item : serviceaccounts) {
                this.addToServiceaccounts(item);
            }
        }
        return (A)this;
    }

    public boolean hasServiceaccounts() {
        return this.serviceaccounts != null && !this.serviceaccounts.isEmpty();
    }

    public A addNewServiceaccount(String name, String namespace) {
        return this.addToServiceaccounts(new ServiceAccountReference(name, namespace));
    }

    public ServiceaccountsNested<A> addNewServiceaccount() {
        return new ServiceaccountsNested(-1, null);
    }

    public ServiceaccountsNested<A> addNewServiceaccountLike(ServiceAccountReference item) {
        return new ServiceaccountsNested(-1, item);
    }

    public ServiceaccountsNested<A> setNewServiceaccountLike(int index, ServiceAccountReference item) {
        return new ServiceaccountsNested(index, item);
    }

    public ServiceaccountsNested<A> editServiceaccount(int index) {
        if (this.serviceaccounts.size() <= index) {
            throw new RuntimeException("Can't edit serviceaccounts. Index exceeds size.");
        }
        return this.setNewServiceaccountLike(index, this.buildServiceaccount(index));
    }

    public ServiceaccountsNested<A> editFirstServiceaccount() {
        if (this.serviceaccounts.size() == 0) {
            throw new RuntimeException("Can't edit first serviceaccounts. The list is empty.");
        }
        return this.setNewServiceaccountLike(0, this.buildServiceaccount(0));
    }

    public ServiceaccountsNested<A> editLastServiceaccount() {
        int index = this.serviceaccounts.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last serviceaccounts. The list is empty.");
        }
        return this.setNewServiceaccountLike(index, this.buildServiceaccount(index));
    }

    public ServiceaccountsNested<A> editMatchingServiceaccount(Predicate<ServiceAccountReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.serviceaccounts.size(); ++i) {
            if (!predicate.test(this.serviceaccounts.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching serviceaccounts. No match found.");
        }
        return this.setNewServiceaccountLike(index, this.buildServiceaccount(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceAccountRestrictionFluent that = (ServiceAccountRestrictionFluent)o;
        if (!Objects.equals(this.namespaces, that.namespaces)) {
            return false;
        }
        if (!Objects.equals(this.serviceaccounts, that.serviceaccounts)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.namespaces, this.serviceaccounts, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.namespaces != null && !this.namespaces.isEmpty()) {
            sb.append("namespaces:");
            sb.append(String.valueOf(this.namespaces) + ",");
        }
        if (this.serviceaccounts != null && !this.serviceaccounts.isEmpty()) {
            sb.append("serviceaccounts:");
            sb.append(String.valueOf(this.serviceaccounts) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ServiceaccountsNested<N>
    extends ServiceAccountReferenceFluent<ServiceaccountsNested<N>>
    implements Nested<N> {
        ServiceAccountReferenceBuilder builder;
        int index;

        ServiceaccountsNested(int index, ServiceAccountReference item) {
            this.index = index;
            this.builder = new ServiceAccountReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ServiceAccountRestrictionFluent.this.setToServiceaccounts(this.index, this.builder.build());
        }

        public N endServiceaccount() {
            return this.and();
        }
    }
}

