/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.ClusterRole;
import io.fabric8.openshift.api.model.ClusterRoleBuilder;
import io.fabric8.openshift.api.model.ClusterRoleFluent;
import io.fabric8.openshift.api.model.NamedClusterRole;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class NamedClusterRoleFluent<A extends NamedClusterRoleFluent<A>>
extends BaseFluent<A> {
    private String name;
    private ClusterRoleBuilder role;
    private Map<String, Object> additionalProperties;

    public NamedClusterRoleFluent() {
    }

    public NamedClusterRoleFluent(NamedClusterRole instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NamedClusterRole instance) {
        NamedClusterRole namedClusterRole = instance = instance != null ? instance : new NamedClusterRole();
        if (instance != null) {
            this.withName(instance.getName());
            this.withRole(instance.getRole());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public ClusterRole buildRole() {
        return this.role != null ? this.role.build() : null;
    }

    public A withRole(ClusterRole role) {
        this._visitables.remove("role");
        if (role != null) {
            this.role = new ClusterRoleBuilder(role);
            this._visitables.get("role").add(this.role);
        } else {
            this.role = null;
            this._visitables.get("role").remove(this.role);
        }
        return (A)this;
    }

    public boolean hasRole() {
        return this.role != null;
    }

    public RoleNested<A> withNewRole() {
        return new RoleNested(null);
    }

    public RoleNested<A> withNewRoleLike(ClusterRole item) {
        return new RoleNested(item);
    }

    public RoleNested<A> editRole() {
        return this.withNewRoleLike(Optional.ofNullable(this.buildRole()).orElse(null));
    }

    public RoleNested<A> editOrNewRole() {
        return this.withNewRoleLike(Optional.ofNullable(this.buildRole()).orElse(new ClusterRoleBuilder().build()));
    }

    public RoleNested<A> editOrNewRoleLike(ClusterRole item) {
        return this.withNewRoleLike(Optional.ofNullable(this.buildRole()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamedClusterRoleFluent that = (NamedClusterRoleFluent)o;
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.role, that.role)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.role, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.role != null) {
            sb.append("role:");
            sb.append(String.valueOf(this.role) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RoleNested<N>
    extends ClusterRoleFluent<RoleNested<N>>
    implements Nested<N> {
        ClusterRoleBuilder builder;

        RoleNested(ClusterRole item) {
            this.builder = new ClusterRoleBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NamedClusterRoleFluent.this.withRole(this.builder.build());
        }

        public N endRole() {
            return this.and();
        }
    }
}

