/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ExecAction;
import io.fabric8.kubernetes.api.model.ExecActionBuilder;
import io.fabric8.kubernetes.api.model.ExecActionFluent;
import io.fabric8.kubernetes.api.model.GRPCAction;
import io.fabric8.kubernetes.api.model.GRPCActionBuilder;
import io.fabric8.kubernetes.api.model.GRPCActionFluent;
import io.fabric8.kubernetes.api.model.HTTPGetAction;
import io.fabric8.kubernetes.api.model.HTTPGetActionBuilder;
import io.fabric8.kubernetes.api.model.HTTPGetActionFluent;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.TCPSocketAction;
import io.fabric8.kubernetes.api.model.TCPSocketActionBuilder;
import io.fabric8.kubernetes.api.model.TCPSocketActionFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ProbeFluent<A extends ProbeFluent<A>>
extends BaseFluent<A> {
    private ExecActionBuilder exec;
    private Integer failureThreshold;
    private GRPCActionBuilder grpc;
    private HTTPGetActionBuilder httpGet;
    private Integer initialDelaySeconds;
    private Integer periodSeconds;
    private Integer successThreshold;
    private TCPSocketActionBuilder tcpSocket;
    private Long terminationGracePeriodSeconds;
    private Integer timeoutSeconds;
    private Map<String, Object> additionalProperties;

    public ProbeFluent() {
    }

    public ProbeFluent(Probe instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Probe instance) {
        Probe probe = instance = instance != null ? instance : new Probe();
        if (instance != null) {
            this.withExec(instance.getExec());
            this.withFailureThreshold(instance.getFailureThreshold());
            this.withGrpc(instance.getGrpc());
            this.withHttpGet(instance.getHttpGet());
            this.withInitialDelaySeconds(instance.getInitialDelaySeconds());
            this.withPeriodSeconds(instance.getPeriodSeconds());
            this.withSuccessThreshold(instance.getSuccessThreshold());
            this.withTcpSocket(instance.getTcpSocket());
            this.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds());
            this.withTimeoutSeconds(instance.getTimeoutSeconds());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ExecAction buildExec() {
        return this.exec != null ? this.exec.build() : null;
    }

    public A withExec(ExecAction exec) {
        this._visitables.remove("exec");
        if (exec != null) {
            this.exec = new ExecActionBuilder(exec);
            this._visitables.get("exec").add(this.exec);
        } else {
            this.exec = null;
            this._visitables.get("exec").remove(this.exec);
        }
        return (A)this;
    }

    public boolean hasExec() {
        return this.exec != null;
    }

    public ExecNested<A> withNewExec() {
        return new ExecNested(null);
    }

    public ExecNested<A> withNewExecLike(ExecAction item) {
        return new ExecNested(item);
    }

    public ExecNested<A> editExec() {
        return this.withNewExecLike(Optional.ofNullable(this.buildExec()).orElse(null));
    }

    public ExecNested<A> editOrNewExec() {
        return this.withNewExecLike(Optional.ofNullable(this.buildExec()).orElse(new ExecActionBuilder().build()));
    }

    public ExecNested<A> editOrNewExecLike(ExecAction item) {
        return this.withNewExecLike(Optional.ofNullable(this.buildExec()).orElse(item));
    }

    public Integer getFailureThreshold() {
        return this.failureThreshold;
    }

    public A withFailureThreshold(Integer failureThreshold) {
        this.failureThreshold = failureThreshold;
        return (A)this;
    }

    public boolean hasFailureThreshold() {
        return this.failureThreshold != null;
    }

    public GRPCAction buildGrpc() {
        return this.grpc != null ? this.grpc.build() : null;
    }

    public A withGrpc(GRPCAction grpc) {
        this._visitables.remove("grpc");
        if (grpc != null) {
            this.grpc = new GRPCActionBuilder(grpc);
            this._visitables.get("grpc").add(this.grpc);
        } else {
            this.grpc = null;
            this._visitables.get("grpc").remove(this.grpc);
        }
        return (A)this;
    }

    public boolean hasGrpc() {
        return this.grpc != null;
    }

    public A withNewGrpc(Integer port, String service) {
        return this.withGrpc(new GRPCAction(port, service));
    }

    public GrpcNested<A> withNewGrpc() {
        return new GrpcNested(null);
    }

    public GrpcNested<A> withNewGrpcLike(GRPCAction item) {
        return new GrpcNested(item);
    }

    public GrpcNested<A> editGrpc() {
        return this.withNewGrpcLike(Optional.ofNullable(this.buildGrpc()).orElse(null));
    }

    public GrpcNested<A> editOrNewGrpc() {
        return this.withNewGrpcLike(Optional.ofNullable(this.buildGrpc()).orElse(new GRPCActionBuilder().build()));
    }

    public GrpcNested<A> editOrNewGrpcLike(GRPCAction item) {
        return this.withNewGrpcLike(Optional.ofNullable(this.buildGrpc()).orElse(item));
    }

    public HTTPGetAction buildHttpGet() {
        return this.httpGet != null ? this.httpGet.build() : null;
    }

    public A withHttpGet(HTTPGetAction httpGet) {
        this._visitables.remove("httpGet");
        if (httpGet != null) {
            this.httpGet = new HTTPGetActionBuilder(httpGet);
            this._visitables.get("httpGet").add(this.httpGet);
        } else {
            this.httpGet = null;
            this._visitables.get("httpGet").remove(this.httpGet);
        }
        return (A)this;
    }

    public boolean hasHttpGet() {
        return this.httpGet != null;
    }

    public HttpGetNested<A> withNewHttpGet() {
        return new HttpGetNested(null);
    }

    public HttpGetNested<A> withNewHttpGetLike(HTTPGetAction item) {
        return new HttpGetNested(item);
    }

    public HttpGetNested<A> editHttpGet() {
        return this.withNewHttpGetLike(Optional.ofNullable(this.buildHttpGet()).orElse(null));
    }

    public HttpGetNested<A> editOrNewHttpGet() {
        return this.withNewHttpGetLike(Optional.ofNullable(this.buildHttpGet()).orElse(new HTTPGetActionBuilder().build()));
    }

    public HttpGetNested<A> editOrNewHttpGetLike(HTTPGetAction item) {
        return this.withNewHttpGetLike(Optional.ofNullable(this.buildHttpGet()).orElse(item));
    }

    public Integer getInitialDelaySeconds() {
        return this.initialDelaySeconds;
    }

    public A withInitialDelaySeconds(Integer initialDelaySeconds) {
        this.initialDelaySeconds = initialDelaySeconds;
        return (A)this;
    }

    public boolean hasInitialDelaySeconds() {
        return this.initialDelaySeconds != null;
    }

    public Integer getPeriodSeconds() {
        return this.periodSeconds;
    }

    public A withPeriodSeconds(Integer periodSeconds) {
        this.periodSeconds = periodSeconds;
        return (A)this;
    }

    public boolean hasPeriodSeconds() {
        return this.periodSeconds != null;
    }

    public Integer getSuccessThreshold() {
        return this.successThreshold;
    }

    public A withSuccessThreshold(Integer successThreshold) {
        this.successThreshold = successThreshold;
        return (A)this;
    }

    public boolean hasSuccessThreshold() {
        return this.successThreshold != null;
    }

    public TCPSocketAction buildTcpSocket() {
        return this.tcpSocket != null ? this.tcpSocket.build() : null;
    }

    public A withTcpSocket(TCPSocketAction tcpSocket) {
        this._visitables.remove("tcpSocket");
        if (tcpSocket != null) {
            this.tcpSocket = new TCPSocketActionBuilder(tcpSocket);
            this._visitables.get("tcpSocket").add(this.tcpSocket);
        } else {
            this.tcpSocket = null;
            this._visitables.get("tcpSocket").remove(this.tcpSocket);
        }
        return (A)this;
    }

    public boolean hasTcpSocket() {
        return this.tcpSocket != null;
    }

    public TcpSocketNested<A> withNewTcpSocket() {
        return new TcpSocketNested(null);
    }

    public TcpSocketNested<A> withNewTcpSocketLike(TCPSocketAction item) {
        return new TcpSocketNested(item);
    }

    public TcpSocketNested<A> editTcpSocket() {
        return this.withNewTcpSocketLike(Optional.ofNullable(this.buildTcpSocket()).orElse(null));
    }

    public TcpSocketNested<A> editOrNewTcpSocket() {
        return this.withNewTcpSocketLike(Optional.ofNullable(this.buildTcpSocket()).orElse(new TCPSocketActionBuilder().build()));
    }

    public TcpSocketNested<A> editOrNewTcpSocketLike(TCPSocketAction item) {
        return this.withNewTcpSocketLike(Optional.ofNullable(this.buildTcpSocket()).orElse(item));
    }

    public Long getTerminationGracePeriodSeconds() {
        return this.terminationGracePeriodSeconds;
    }

    public A withTerminationGracePeriodSeconds(Long terminationGracePeriodSeconds) {
        this.terminationGracePeriodSeconds = terminationGracePeriodSeconds;
        return (A)this;
    }

    public boolean hasTerminationGracePeriodSeconds() {
        return this.terminationGracePeriodSeconds != null;
    }

    public Integer getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public A withTimeoutSeconds(Integer timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
        return (A)this;
    }

    public boolean hasTimeoutSeconds() {
        return this.timeoutSeconds != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProbeFluent that = (ProbeFluent)o;
        if (!Objects.equals(this.exec, that.exec)) {
            return false;
        }
        if (!Objects.equals(this.failureThreshold, that.failureThreshold)) {
            return false;
        }
        if (!Objects.equals(this.grpc, that.grpc)) {
            return false;
        }
        if (!Objects.equals(this.httpGet, that.httpGet)) {
            return false;
        }
        if (!Objects.equals(this.initialDelaySeconds, that.initialDelaySeconds)) {
            return false;
        }
        if (!Objects.equals(this.periodSeconds, that.periodSeconds)) {
            return false;
        }
        if (!Objects.equals(this.successThreshold, that.successThreshold)) {
            return false;
        }
        if (!Objects.equals(this.tcpSocket, that.tcpSocket)) {
            return false;
        }
        if (!Objects.equals(this.terminationGracePeriodSeconds, that.terminationGracePeriodSeconds)) {
            return false;
        }
        if (!Objects.equals(this.timeoutSeconds, that.timeoutSeconds)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.exec, this.failureThreshold, this.grpc, this.httpGet, this.initialDelaySeconds, this.periodSeconds, this.successThreshold, this.tcpSocket, this.terminationGracePeriodSeconds, this.timeoutSeconds, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.exec != null) {
            sb.append("exec:");
            sb.append(String.valueOf(this.exec) + ",");
        }
        if (this.failureThreshold != null) {
            sb.append("failureThreshold:");
            sb.append(this.failureThreshold + ",");
        }
        if (this.grpc != null) {
            sb.append("grpc:");
            sb.append(String.valueOf(this.grpc) + ",");
        }
        if (this.httpGet != null) {
            sb.append("httpGet:");
            sb.append(String.valueOf(this.httpGet) + ",");
        }
        if (this.initialDelaySeconds != null) {
            sb.append("initialDelaySeconds:");
            sb.append(this.initialDelaySeconds + ",");
        }
        if (this.periodSeconds != null) {
            sb.append("periodSeconds:");
            sb.append(this.periodSeconds + ",");
        }
        if (this.successThreshold != null) {
            sb.append("successThreshold:");
            sb.append(this.successThreshold + ",");
        }
        if (this.tcpSocket != null) {
            sb.append("tcpSocket:");
            sb.append(String.valueOf(this.tcpSocket) + ",");
        }
        if (this.terminationGracePeriodSeconds != null) {
            sb.append("terminationGracePeriodSeconds:");
            sb.append(this.terminationGracePeriodSeconds + ",");
        }
        if (this.timeoutSeconds != null) {
            sb.append("timeoutSeconds:");
            sb.append(this.timeoutSeconds + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TcpSocketNested<N>
    extends TCPSocketActionFluent<TcpSocketNested<N>>
    implements Nested<N> {
        TCPSocketActionBuilder builder;

        TcpSocketNested(TCPSocketAction item) {
            this.builder = new TCPSocketActionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ProbeFluent.this.withTcpSocket(this.builder.build());
        }

        public N endTcpSocket() {
            return this.and();
        }
    }

    public class HttpGetNested<N>
    extends HTTPGetActionFluent<HttpGetNested<N>>
    implements Nested<N> {
        HTTPGetActionBuilder builder;

        HttpGetNested(HTTPGetAction item) {
            this.builder = new HTTPGetActionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ProbeFluent.this.withHttpGet(this.builder.build());
        }

        public N endHttpGet() {
            return this.and();
        }
    }

    public class GrpcNested<N>
    extends GRPCActionFluent<GrpcNested<N>>
    implements Nested<N> {
        GRPCActionBuilder builder;

        GrpcNested(GRPCAction item) {
            this.builder = new GRPCActionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ProbeFluent.this.withGrpc(this.builder.build());
        }

        public N endGrpc() {
            return this.and();
        }
    }

    public class ExecNested<N>
    extends ExecActionFluent<ExecNested<N>>
    implements Nested<N> {
        ExecActionBuilder builder;

        ExecNested(ExecAction item) {
            this.builder = new ExecActionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ProbeFluent.this.withExec(this.builder.build());
        }

        public N endExec() {
            return this.and();
        }
    }
}

